package com.mycompany.commerce.project.facade.server.services.dataaccess.bom.mediator;
/*
 *-----------------------------------------------------------------
 * IBM Confidential
 *
 * OCO Source Materials
 *
 * WebSphere Commerce
 *
 * (C) Copyright IBM Corp. 2008
 *
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has
 * been deposited with the U.S. Copyright Office.
 *-----------------------------------------------------------------
 */
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.ibm.commerce.foundation.client.util.oagis.RelationalExpression;
import com.ibm.commerce.foundation.common.datatypes.DescriptionType;
import com.ibm.commerce.foundation.common.exception.AbstractApplicationException;
import com.ibm.commerce.foundation.common.exception.ApplicationError;
import com.ibm.commerce.foundation.common.util.logging.LoggingHelper;
import com.ibm.commerce.foundation.server.services.dataaccess.DataServiceFacade;
import com.ibm.commerce.foundation.server.services.dataaccess.PhysicalDataContainer;
import com.ibm.commerce.foundation.server.services.dataaccess.SelectionCriteria;
import com.ibm.commerce.foundation.server.services.dataaccess.bom.mediator.AbstractChangeBusinessObjectPartMediatorImpl;
import com.ibm.commerce.foundation.server.services.dataaccess.exception.DataMediatorException;
import com.mycompany.commerce.project.facade.ProjectFacadeConstants;
import com.mycompany.commerce.project.facade.datatypes.ProjectInstructionType;
import com.mycompany.commerce.project.facade.datatypes.ProjectType;
import com.mycompany.commerce.project.facade.server.entity.datatypes.Xprjins;
import com.mycompany.commerce.project.facade.server.entity.datatypes.Xprjinsdes;
import com.mycompany.commerce.project.logging.ProjectApplicationMessageKeys;

/**
 * Update operation on the logical noun for Project
 */
public class ChangeProjectInstructionPartMediator extends
		AbstractChangeBusinessObjectPartMediatorImpl {

	private static final String CLASSNAME = ChangeProjectInstructionPartMediator.class
			.getName();

	private static final Logger LOGGER = LoggingHelper
			.getLogger(ChangeProjectInstructionPartMediator.class);

	public static final String CHANGE_PROJECT_Instruction_ACCESS_PROFILE = "MyCompany_ProjectInstruction_Update";

	private static final String UNIQUE_ID = "UniqueID";

	/**
	 * Initialize the physical data container for this mediator. Obtain the
	 * physical entities that correspond to this logical entity. The data from
	 * noun present in the list will be used to fetch the physical entities with
	 * the help of queries configured with DSL
	 * 
	 * @throws DataMediatorException
	 * @see com.ibm.commerce.foundation.server.services.dataaccess.bom.mediator.AbstractChangeBusinessObjectPartMediatorImpl#initializePhysicalDataContainer(java.util.List)
	 */
	protected PhysicalDataContainer initializePhysicalDataContainer(
			Map aMapNounPart) throws DataMediatorException {
		final String METHODNAME = "initializePhysicalDataContainer";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME,
					new Object[] { aMapNounPart });
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}

		PhysicalDataContainer physicalEntites = null;

		List projectIds = new ArrayList();
		Iterator projectIter = aMapNounPart.keySet().iterator();
		while (projectIter.hasNext()) {
			ProjectType aProject = (ProjectType) projectIter.next();
			String uniqueId = aProject.getProjectIdentifier().getUniqueID();
			if (uniqueId != null && uniqueId.length() > 0) {
				projectIds.add(uniqueId);
			}
		}

		if (!projectIds.isEmpty()) {
			SelectionCriteria anExpression = new SelectionCriteria();
			anExpression.setXPathKey(ProjectFacadeConstants.XPATH_PROJECT_UID
					+ ProjectFacadeConstants.DOUBLE_CLOSE_XPATH);
			;
			anExpression
					.setAccessProfile(CHANGE_PROJECT_Instruction_ACCESS_PROFILE);
			anExpression.setXPathParameter(new RelationalExpression(UNIQUE_ID,
					projectIds));

			physicalEntites = DataServiceFacade.getInstance(
					ProjectFacadeConstants.COMPONENT_NAME)
					.getPhysicalDataContainer(anExpression);

		} else {
			physicalEntites = DataServiceFacade.getInstance(
					ProjectFacadeConstants.COMPONENT_NAME)
					.getEmptyPhysicalDataContainer();

		}

		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}
		return physicalEntites;
	}
	/**
	 * This method performs no actions as the resolve is done by the
	 * <code>ChangeProjectMediator</code>.
	 * 
	 * @param aNoun
	 *            The logical <code>ProjectType</code> SDO business object.
	 * @param aNounPart
	 *            The logical <code>ProjectType</code> SDO business object.
	 * @return This method returns false.
	 */
	protected boolean resolveByExternalIdentifier(Object arg0, Object arg1)
			throws Exception {

		return false;
	}

	/**
	 * Checks the object to be created . If there are errors then a validation
	 * error will be added to the return list
	 * 
	 * @param aNoun
	 *            The noun that is being requested to be changed
	 * @param aNounPart
	 *            The noun part that is being requested to be changed
	 * @return List of errors; null if there are no errors
	 * @throws DataMediatorException
	 * 
	 * @see com.ibm.commerce.foundation.server.services.dataaccess.bom.mediator.ChangeBusinessObjectPartMediator#validateCreate(java.lang.Object)
	 */
	public List validateCreate(Object aNoun, Object aNounPart)
			throws DataMediatorException {

		final String METHODNAME = "validateCreate";
		boolean traceEnabled = LoggingHelper.isTraceEnabled(LOGGER);
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME, new Object[] { aNoun,
					aNounPart });
		}
		List validationErrors = new ArrayList();
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME, validationErrors);
		}
		return validationErrors;
	}

	/**
	 * This method checks if the logical <code>ProjectType</code> noun can be
	 * updated. It checks that the noun exists in the physical data container If
	 * the noun cannot be updated, the appropriate error exception is added to
	 * the list of exceptions to be returned to the caller.
	 * 
	 * @param aNoun
	 *            The logical <code>ProjectType</code> SDO business object to
	 *            validate.
	 * @param aNounPart
	 *            The logical <code>ProjectInstructionType</code> SDO business
	 *            object.
	 * @return This method returns a list of <code>ApplicationError</code> if
	 *         there are any errors, otherwise the list will be empty.
	 * @throws DataMediatorException
	 */
	public List validateChange(Object aNoun, Object aNounPart)
			throws DataMediatorException {

		final String METHODNAME = "validateChange";
		boolean traceEnabled = LoggingHelper.isTraceEnabled(LOGGER);
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME, new Object[] { aNoun,
					aNounPart });
		}
		List validationErrors = new ArrayList();

		Xprjins existingProject = (Xprjins) findPhysicalEntity(aNoun, aNounPart);
		ProjectInstructionType aLogicalDescription = (ProjectInstructionType) aNounPart;
		if (existingProject == null) {
			ApplicationError validateError = new ApplicationError(
					ApplicationError.TYPE_GENERIC_ERROR,
					ProjectApplicationMessageKeys._APP_PROJECT_INSTRUCTION_NOT_FOUND,
					new Object[] { aNoun }, LOGGER.getResourceBundleName());
			validationErrors.add(validateError);
		}
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME, validationErrors);
		}
		return validationErrors;
	}

	/**
	 * This method checks if the logical <code>ProjectType</code> noun can be
	 * deleted. It checks that the noun exists in the physical data container If
	 * the noun cannot be deleted, the appropriate error exception is added to
	 * the list of exceptions to be returned to the caller.
	 * 
	 * @param aNoun
	 *            The logical <code>ProjectType</code> SDO business object to
	 *            validate.
	 * @param aNounPart
	 *            The logical <code>ProjectInstructionType</code> SDO business
	 *            object.
	 * @return This method returns a list of <code>ApplicationError</code> if
	 *         there are any errors, otherwise the list will be empty.
	 * @throws DataMediatorException
	 */
	public List validateDelete(Object aNoun, Object aNounPart)
			throws DataMediatorException {

		final String METHODNAME = "validateDelete";
		boolean traceEnabled = LoggingHelper.isTraceEnabled(LOGGER);
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME, new Object[] { aNoun,
					aNounPart });
		}
		List validationErrors = new ArrayList();

		Xprjins existingProject = (Xprjins) findPhysicalEntity(aNoun, aNounPart);
		ProjectInstructionType aLogicalDescription = (ProjectInstructionType) aNounPart;
		if (existingProject == null) {
			ApplicationError validateError = new ApplicationError(
					ApplicationError.TYPE_GENERIC_ERROR,
					ProjectApplicationMessageKeys._APP_PROJECT_INSTRUCTION_NOT_FOUND,
					new Object[] { aNoun }, LOGGER.getResourceBundleName());
			validationErrors.add(validateError);
		}
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME, validationErrors);
		}
		return validationErrors;
	}

	/**
	 * Creates the physical entities corresponding to the logical noun part and
	 * adds to the root physical entity
	 * 
	 * @param aNoun
	 *            (ProjectType) The logical noun that contains the noun part
	 * @param aNounPart
	 *            (ProjectInstructionType) The noun part for which the
	 *            corresponding physical entities needs to be created
	 * @throws AbstractApplicationException
	 *             Error during create
	 */
	public void create(Object aNoun, Object aNounPart)
			throws AbstractApplicationException {
		final String METHODNAME = "create";

		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME, new Object[] { aNoun,
					aNounPart });

		}

		ProjectType aLogicalProject = (ProjectType) aNoun;

		ProjectInstructionType aLogicalProjectInstruction = (ProjectInstructionType) aNounPart;

		PhysicalDataContainer pdc = getPhysicalDataContainer();
		//		 get thd next available uid and then insert into the physical
		// dataobject
		Long uid = pdc.getNextPrimaryKey(Xprjins.class);
		Integer aProjectId = Integer.valueOf(aLogicalProject
				.getProjectIdentifier().getUniqueID());

		Xprjins aPhysicalPrjins = (Xprjins) getPhysicalDataContainer()
				.createPhysicalObject(null, Xprjins.class);
		aPhysicalPrjins.setXprjins_id(uid.longValue());
		aPhysicalPrjins.setSeq(new Integer(new Double(
				aLogicalProjectInstruction.getDisplaySequence()).intValue()));
		if (aLogicalProjectInstruction.isOptional()) {
			aPhysicalPrjins.setIsoptional(new Integer(1));
		} else {
			aPhysicalPrjins.setIsoptional(new Integer(0));
		}
		aPhysicalPrjins.setXproject_id(aProjectId.intValue());
//		set instruction UID back to SDO.
		aLogicalProjectInstruction.setUniqueID(
				uid.toString());
		//create description

		List descList = aLogicalProjectInstruction
				.getProjectInstructionDescription();
		if (descList != null && descList.size() > 0) {
			for (int i = 0; i < descList.size(); i++) {

				DescriptionType logicalDesc = (DescriptionType) descList.get(i);
				Xprjinsdes aPhysicalPrjinsdes = (Xprjinsdes) getPhysicalDataContainer()
						.createPhysicalObject(null, Xprjinsdes.class);

				Integer languageId  = Integer.valueOf(logicalDesc.getLanguage());				

				aPhysicalPrjinsdes.setLanguage_id(languageId.intValue());
				aPhysicalPrjinsdes.setXprjins_id(uid.longValue());
				aPhysicalPrjinsdes.setShortdesc(logicalDesc.getValue());
			}
		}
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {

			LOGGER.exiting(CLASSNAME, METHODNAME);
		}

	}

	/**
	 * This method updates the physical data container with the modified
	 * <code>Project</code> object.
	 * 
	 * @param aNoun
	 *            The logical <code>ProjectType</code> SDO business object to
	 *            update.
	 * @param aNounPart
	 *            The logical <code>ProjectInstructionType</code> SDO business
	 *            object to update.
	 * @throws AbstractApplicationException
	 */
	public void update(Object aNoun, Object aNounPart)
			throws AbstractApplicationException {
		final String METHODNAME = "update";

		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME, new Object[] { aNoun,
					aNounPart });
		}

		Xprjins aPhysicalEntity = (Xprjins) findPhysicalEntity(aNoun, aNounPart);

		ProjectInstructionType aLogicalProjectInstruction = (ProjectInstructionType) aNounPart;

		if (aPhysicalEntity != null) {
			if (aLogicalProjectInstruction.isSetDisplaySequence()) {
				aPhysicalEntity.setSeq(new Integer(new Double(
						aLogicalProjectInstruction.getDisplaySequence()).intValue()));

			}

			if (aLogicalProjectInstruction.isSetOptional()) {
				if (aLogicalProjectInstruction.isOptional())
					aPhysicalEntity.setIsoptional(new Integer(1));
				else
					aPhysicalEntity.setIsoptional(new Integer(0));
			}
			//Update description
			List descList = aLogicalProjectInstruction
					.getProjectInstructionDescription();

			if (descList != null && descList.size() > 0) {
				for (int i = 0; i < descList.size(); i++) {
					DescriptionType logicalDesc = (DescriptionType) descList
							.get(i);

					Integer languageId = Integer.valueOf(logicalDesc.getLanguage());
					
					List pysicalDescList = aPhysicalEntity
							.getXprjinsdesForXprjins();
					if (pysicalDescList != null) {
						for (int j = 0; j < pysicalDescList.size(); j++) {
							Xprjinsdes aPhysicalPrjinsdes = (Xprjinsdes) pysicalDescList
									.get(j);
							if (languageId.intValue() == aPhysicalPrjinsdes
									.getLanguage_id()) {
								aPhysicalPrjinsdes.setShortdesc(logicalDesc
										.getValue());
								break;
							}

						}

					} else {
						Xprjinsdes aPhysicalPrjinsdes = (Xprjinsdes) getPhysicalDataContainer()
								.createPhysicalObject(null, Xprjinsdes.class);

						aPhysicalPrjinsdes
								.setLanguage_id(languageId.intValue());
						aPhysicalPrjinsdes.setXprjins_id(Long
								.parseLong(aLogicalProjectInstruction
										.getUniqueID()));
						aPhysicalPrjinsdes.setShortdesc(logicalDesc.getValue());
					}

				}

			}
		}

		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}

	}

	/**
	 * This method deletes the physical data container with the modified
	 * <code>Project</code> object.
	 * 
	 * @param aNoun
	 *            The logical <code>ProjectType</code> SDO business object to
	 *            update.
	 * @param aNounPart
	 *            The logical <code>ProjectInstructionType</code> SDO business
	 *            object to update.
	 * @throws AbstractApplicationException
	 */
	public void delete(Object aNoun, Object aNounPart)
			throws AbstractApplicationException {
		final String METHODNAME = "delete";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME, new Object[] { aNoun,
					aNounPart });

		}

		Xprjins aPhysicalEntity = (Xprjins) findPhysicalEntity(aNoun, aNounPart);

		if (aPhysicalEntity != null) {

			List listChild = aPhysicalEntity.getXprjinsdesForXprjins();
			if (listChild != null) {
				for (int i = 0; i < listChild.size(); i++) {

					getPhysicalDataContainer().removePhysicalObject(
							listChild.get(i));
				}

			}
			getPhysicalDataContainer().removePhysicalObject(aPhysicalEntity);

		}

		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {

			LOGGER.exiting(CLASSNAME, METHODNAME);
		}

	}

	/**
	 * This method returns the <code>Xprjins</code> physical SDO from the
	 * <code>PhysicalDataContainer</code> that was created in the
	 * <code>ChangeProjectInstructionMediator</code> mediator.
	 * 
	 * @param aNoun
	 *            The logical <code>ProjectType</code> SDO.
	 * @param aNounPart
	 *            The logical <code>ProjectInstructionType</code> SDO.
	 * @return This method returns the <code>Xprjins</code> object if it is
	 *         found, otherwise it returns null.
	 * @throws DataMediatorException
	 */
	public Object findPhysicalEntity(Object aNoun, Object aNounPart)
			throws DataMediatorException {
		final String METHODNAME = "findPhysicalEntity";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME, new Object[] { aNoun });
		}

		Xprjins aPhysicalEntity = null;
		PhysicalDataContainer pdc = getPhysicalDataContainer();

		// if the PhysicalDataContainer is not null, loop it and compare the uid
		// to find the DataObject
		if (pdc != null) {
			ProjectType aLogicalProject = (ProjectType) aNoun;
			ProjectInstructionType aLogicalProjectInstruction = (ProjectInstructionType) aNounPart;
			if (aLogicalProjectInstruction.getUniqueID() != null
					&& !aLogicalProjectInstruction.getUniqueID().equals("")) {
				long instructionId = Long.parseLong(aLogicalProjectInstruction
						.getUniqueID());

				if (aLogicalProject.getProjectIdentifier().getUniqueID() != null) {
					long projectId = Long.parseLong(aLogicalProject
							.getProjectIdentifier().getUniqueID());
					if (LoggingHelper.isTraceEnabled(LOGGER)) {
						LOGGER.logp(Level.FINE, CLASSNAME, METHODNAME,
								"Find Project: " + projectId);
					}

					List projectList = pdc.getPhysicalObjects();
					if (projectList != null && projectList.size() > 0) {
						Iterator projectIter = projectList.iterator();
						while (projectIter.hasNext()) {
							Xprjins tempPhysicalEntity = (Xprjins) projectIter
									.next();
							// compare id to get the Physical DataObject
							if (tempPhysicalEntity.getXproject_id() == projectId
									&& tempPhysicalEntity.getXprjins_id() == instructionId) {
								
								aPhysicalEntity = tempPhysicalEntity;
								break;
							}
						}
					}

				}
			}
		}

		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME, aPhysicalEntity);
		}

		return aPhysicalEntity;
	}

	/**
	 * This method gets the xpath for the main noun part.
	 * 
	 * @return The xpath for the main noun part.
	 */
	public String[] getNounPartXPaths() {

		return XPATH;
	}

	private static final String[] XPATH = new String[] { "/Instruction[]" };

}
