package com.mycompany.commerce.project.facade.server.services.dataaccess.bom.mediator;

/*
 *-----------------------------------------------------------------
 * IBM Confidential
 *
 * OCO Source Materials
 *
 * WebSphere Commerce
 *
 * (C) Copyright IBM Corp. 2008
 *
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has
 * been deposited with the U.S. Copyright Office.
 *-----------------------------------------------------------------
 *//*
 *-------------------------------------------------------------------
 * IBM Confidential
 * OCO Source Materials
 *
 * WebSphere Commerce
 *
 * (c) Copyright International Business Machines Corporation.
 *     2006
 *     All rights reserved.
 *
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has been
 * deposited with the US Copyright Office.
 *-------------------------------------------------------------------
 */

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.ibm.commerce.foundation.client.util.oagis.RelationalExpression;
import com.ibm.commerce.foundation.common.exception.ApplicationError;
import com.ibm.commerce.foundation.common.util.logging.LoggingHelper;
import com.ibm.commerce.foundation.server.services.dataaccess.PhysicalDataContainer;
import com.ibm.commerce.foundation.server.services.dataaccess.SelectionCriteria;
import com.ibm.commerce.foundation.server.services.dataaccess.bom.config.BusinessObjectMediatorConfig;
import com.ibm.commerce.foundation.server.services.dataaccess.bom.exception.BusinessObjectMediatorException;
import com.ibm.commerce.foundation.server.services.dataaccess.bom.mediator.AbstractChangeBusinessObjectPartMediatorImpl;
import com.ibm.commerce.foundation.server.services.dataaccess.exception.DataMediatorException;
import com.ibm.commerce.foundation.common.exception.AbstractApplicationException;

import com.mycompany.commerce.project.facade.ProjectFacadeConstants;
import com.mycompany.commerce.project.facade.server.entity.datatypes.Xprjcol;
import com.mycompany.commerce.project.facade.server.metadata.ProjectMetadata;
import com.mycompany.commerce.project.logging.ProjectApplicationMessageKeys;

import com.mycompany.commerce.project.facade.datatypes.ProjectCollectionType;

/**
 * Update operation on the logical noun for ProjectCollection
 */
public class ChangeProjectCollectionBasePartMediator extends
		AbstractChangeBusinessObjectPartMediatorImpl {

	private static final String CLASSNAME = ChangeProjectCollectionBasePartMediator.class
			.getName();

	private static final Logger LOGGER = LoggingHelper
			.getLogger(ChangeProjectCollectionBasePartMediator.class);

	private static final String[] XPATH = new String[] { BusinessObjectMediatorConfig.XPATH_NOUN_BASE_PART };

	/**
	 * This method gets the xpath for the main noun part.
	 * 
	 * @return The xpath for the main noun part.
	 */
	public String[] getNounPartXPaths() {
		return XPATH;
	}

	/**
	 * This method performs no actions as creating noun is done by the
	 * <code>ChangeProjectCollectionMediator</code>.
	 * 
	 * @param aNoun
	 *            The logical <code>ProjectCollectionType</code> SDO business
	 *            object.
	 * @param aNounPart
	 *            The logical <code>ProjectCollectionType</code> SDO business
	 *            object.
	 * @throws BusinessObjectMediatorException
	 * @throws DataMediatorException
	 */
	public void create(Object aNoun, Object aNounPart)
			throws BusinessObjectMediatorException, DataMediatorException {
		final String METHODNAME = "create";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME, new Object[] { aNoun,
					aNounPart });
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}
	}

	/**
	 * This method updates the physical data container with the modified
	 * <code>Projectcollection</code> object.
	 * 
	 * @param aNoun
	 *            The logical <code>ProjectCollectionType</code> SDO business
	 *            object to update.
	 * @param aNounPart
	 *            The logical <code>ProjectCollectionType</code> SDO business
	 *            object to update.
	 * @throws AbstractApplicationException
	 */
	public void update(Object aNoun, Object aNounPart)
			throws AbstractApplicationException {
		final String METHODNAME = "update";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME, new Object[] { aNoun,
					aNounPart });
		}

		ProjectCollectionType logicalProjectCollection = (ProjectCollectionType) aNoun;

		Xprjcol physicalProjectCollection = (Xprjcol) findPhysicalEntity(aNoun,
				aNounPart);

		// set values from logical data object into the query and run it
		if (physicalProjectCollection != null) {
			// set the name
			if ((logicalProjectCollection.getProjectCollectionIdentifier() != null)
					&& (logicalProjectCollection
							.getProjectCollectionIdentifier()
							.getExternalIdentifier() != null)
					&& (logicalProjectCollection
							.getProjectCollectionIdentifier()
							.getExternalIdentifier().getName() != null)) {
				physicalProjectCollection
						.setPrjcolname(logicalProjectCollection
								.getProjectCollectionIdentifier()
								.getExternalIdentifier().getName());
			}

			
			updateNameValuePairType(logicalProjectCollection,
					physicalProjectCollection);

		}

		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}

	}

	/**
	 * This method performs no actions as the deleting noun is done by the
	 * <code>ChangeProjectCollectionMediator</code>.
	 * 
	 * @param aNoun
	 *            The logical <code>ProjectCollectionType</code> SDO business
	 *            object.
	 * @param aNounPart
	 *            The logical <code>ProjectCollectionType</code> SDO business
	 *            object.
	 * @throws BusinessObjectMediatorException
	 * @throws DataMediatorException
	 */
	public void delete(Object aNoun, Object aNounPart)
			throws BusinessObjectMediatorException, DataMediatorException {
		final String METHODNAME = "delete";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME, new Object[] { aNoun,
					aNounPart });
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}
	}

	/**
	 * This method initializes the physical data container for this mediator. It
	 * currently performs no actions as the physical data container from the
	 * <code>ChangeProjectCollectionMediator</code> is used in this mediator.
	 * 
	 * @param aMapNounPart
	 *            A map of the noun parts.
	 * @return This method returns null.
	 */
	protected PhysicalDataContainer initializePhysicalDataContainer(
			Map aMapNounPart) {
		final String METHODNAME = "initializePhysicalDataContainer";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME,
					new Object[] { aMapNounPart });
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}
		return null;
	}

	/**
	 * This method performs no actions as the resolve is done by the
	 * <code>ChangeProjectCollectionMediator</code>.
	 * 
	 * @param aNoun
	 *            The logical <code>ProjectCollectionType</code> SDO business
	 *            object.
	 * @param aNounPart
	 *            The logical <code>ProjectCollectionType</code> SDO business
	 *            object.
	 * @return This method returns false.
	 */
	protected boolean resolveByExternalIdentifier(Object aNoun, Object aNounPart) {
		final String METHODNAME = "resolveByExternalIdentifier";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME, new Object[] { aNoun,
					aNounPart });
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}
		return false;
	}

	/**
	 * This method performs no checking as the validation is done by the
	 * <code>ChangeProjectCollectionMediator</code>.
	 * 
	 * @param aNoun
	 *            The logical <code>ProjectCollectionType</code> SDO business
	 *            object.
	 * @param aNounPart
	 *            The logical <code>ProjectCollectionType</code> SDO business
	 *            object.
	 * @return This method returns null.
	 * @throws DataMediatorException
	 */
	public List validateCreate(Object aNoun, Object aNounPart)
			throws DataMediatorException {
		final String METHODNAME = "validateCreate";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME, new Object[] { aNoun,
					aNounPart });
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}
		return null;
	}

	/**
	 * This method checks if the logical <code>ProjectCollectionType</code>
	 * noun can be updated. It checks that the noun exists in the physical data
	 * container If the noun cannot be updated, the appropriate error exception
	 * is added to the list of exceptions to be returned to the caller.
	 * 
	 * @param aNoun
	 *            The logical <code>ProjectCollectionType</code> SDO business
	 *            object to validate.
	 * @param aNounPart
	 *            The logical <code>ProjectCollectionType</code> SDO business
	 *            object.
	 * @return This method returns a list of <code>ApplicationError</code> if
	 *         there are any errors, otherwise the list will be empty.
	 * @throws DataMediatorException
	 */
	public List validateChange(Object aNoun, Object aNounPart)
			throws DataMediatorException {
		final String METHODNAME = "validateChange";
		boolean traceEnabled = LoggingHelper.isTraceEnabled(LOGGER);
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME, new Object[] { aNoun,
					aNounPart });
		}
		List validationErrors = new ArrayList();

		// check whether the noun exists by uid
		Xprjcol physicalProjectCollection = (Xprjcol) findPhysicalEntity(aNoun,
				aNounPart);

		if (physicalProjectCollection != null) {			

			ProjectCollectionType logicalProjectCollection = (ProjectCollectionType) aNoun;

			// Check whether the name is valid
			if (logicalProjectCollection.getProjectCollectionIdentifier() != null
					&& logicalProjectCollection
							.getProjectCollectionIdentifier()
							.getExternalIdentifier() != null
					&& logicalProjectCollection
							.getProjectCollectionIdentifier()
							.getExternalIdentifier().getName() != null
					&& !logicalProjectCollection
							.getProjectCollectionIdentifier()
							.getExternalIdentifier().getName().equals(
									physicalProjectCollection.getPrjcolname())) {

				String name = logicalProjectCollection
						.getProjectCollectionIdentifier()
						.getExternalIdentifier().getName();
				if (name == null || name.trim().length() == 0) {
					// name cannot be empty
					ApplicationError validateError = new ApplicationError(
							ApplicationError.TYPE_GENERIC_ERROR,
							ProjectApplicationMessageKeys._APP_PROJECTCOLLECTION_NAME_EMPTY,
							null, LOGGER.getResourceBundleName());
					validationErrors.add(validateError);
				} else {
					// check whether the physical data object with the same name
					// exists already
					if (traceEnabled) {
						LOGGER.logp(Level.FINE, CLASSNAME, METHODNAME,
								"validate ProjectCollection name: " + name);
					}

					SelectionCriteria selectionCriteria = new SelectionCriteria();
					selectionCriteria
							.setXPathKey(ProjectFacadeConstants.XPATH_PROJECTCOLLECTION_NAME
									+ ProjectFacadeConstants.DOUBLE_CLOSE_XPATH);
					selectionCriteria
							.setAccessProfile(ProjectFacadeConstants.ACCESS_PROFILE_ID_RESOLVE);
					selectionCriteria
							.setXPathParameter(new RelationalExpression(
									ProjectFacadeConstants.NOUN_ATTRIBUTE_NAME_PROJECTCOLLECTION_NAME,
									name));

					PhysicalDataContainer pdc = ProjectMetadata
							.getDataServiceFacade().getPhysicalDataContainer(
									selectionCriteria);

					List physicalDOList = pdc.getPhysicalObjects();

					// if there is physical data object exist
					if (physicalDOList != null && physicalDOList.size() != 0) {
						ApplicationError validateError = new ApplicationError(
								ApplicationError.TYPE_GENERIC_ERROR,
								ProjectApplicationMessageKeys._APP_PROJECTCOLLECTION_NAME_ALREADY_EXISTS,
								new Object[] { name }, LOGGER
										.getResourceBundleName());
						validationErrors.add(validateError);
					} else if (ProjectMetadata
							.invalidStringLength(
									name,
									ProjectMetadata.PROJECTCOLLECTION_NAME_LENGTH_LIMIT)) {
						// checked name length
						ApplicationError validateError = new ApplicationError(
								ApplicationError.TYPE_GENERIC_ERROR,
								ProjectApplicationMessageKeys._APP_PROJECTCOLLECTION_NAME_TOO_LONG,
								null, LOGGER.getResourceBundleName());
						validationErrors.add(validateError);
					}
				}
			}

		}

		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME, validationErrors);
		}
		return validationErrors;
	}

	/**
	 * This method performs no checking as the validation is done by the
	 * <code>ChangeProjectCollectionMediator</code>.
	 * 
	 * @param aNoun
	 *            The logical <code>ProjectCollectionType</code> SDO business
	 *            object.
	 * @param aNounPart
	 *            The logical <code>ProjectCollectionType</code> SDO business
	 *            object.
	 * @return This method returns null.
	 * @throws DataMediatorException
	 */
	public List validateDelete(Object aNoun, Object aNounPart)
			throws DataMediatorException {
		final String METHODNAME = "validateDelete";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME, new Object[] { aNoun,
					aNounPart });
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}
		return null;
	}

	/**
	 * This method returns the <code>Xprjcol</code> physical SDO
	 * from the <code>PhysicalDataContainer</code> that was created in the
	 * <code>ChangeProjectCollectionMediator</code> mediator.
	 * 
	 * @param aNoun
	 *            The logical <code>ProjectCollectionType</code> SDO.
	 * @param aNounPart
	 *            The logical <code>ProjectCollectionType</code> SDO.
	 * @return This method returns the <code>Xprjcol</code> object
	 *         if it is found, otherwise it returns null.
	 * @throws DataMediatorException
	 */
	public Object findPhysicalEntity(Object aNoun, Object aNounPart)
			throws DataMediatorException {
		final String METHODNAME = "findPhysicalEntity";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME, new Object[] { aNoun });
		}

		Xprjcol aPhysicalEntity = null;
		PhysicalDataContainer pdc = getParentPhysicalDataContainer();

		// if the PhysicalDataContainer is not null, loop it and compare the uid
		// to find the DataObject
		if (pdc != null) {
			ProjectCollectionType aLogicalProjectCollection = (ProjectCollectionType) aNoun;

			if (aLogicalProjectCollection.getProjectCollectionIdentifier()
					.getUniqueID() != null) {
				long projectcollectionId = Long
						.parseLong(aLogicalProjectCollection
								.getProjectCollectionIdentifier().getUniqueID());
				if (LoggingHelper.isTraceEnabled(LOGGER)) {
					LOGGER.logp(Level.FINE, CLASSNAME, METHODNAME,
							"Find ProjectCollection: " + projectcollectionId);
				}

				List projectCollectionList = pdc.getPhysicalObjects();
				if (projectCollectionList != null
						&& projectCollectionList.size() > 0) {
					Iterator projectCollectionIter = projectCollectionList
							.iterator();
					while (projectCollectionIter.hasNext()) {
						Xprjcol tempPhysicalEntity = (Xprjcol) projectCollectionIter
								.next();
						// compare id to get the Physical DataObject
						if (tempPhysicalEntity.getXprjcol_id() == projectcollectionId) {							

							aPhysicalEntity = tempPhysicalEntity;
							break;
						}
					}
				}

			}
		}

		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME, aPhysicalEntity);
		}

		return aPhysicalEntity;

	}

	/**
	 * This method updates the physical object with the user data set in the
	 * logical noun. The name value pair mapping is set in the
	 * wc-businessobject-mediator XML file.
	 * 
	 * @param aNoun
	 *            The logical <code>ProjectCollectionType</code> SDO business
	 *            object.
	 * @param aPhysicalEntity
	 *            The physical <code>Xprjcol</code> SDO business
	 *            object.
	 * @throws AbstractApplicationException
	 */
	private void updateNameValuePairType(Object aNoun, Object aPhysicalEntity)
			throws AbstractApplicationException {
		final String METHODNAME = "updateNameValuePairType";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME, new Object[] { aNoun,
					aPhysicalEntity });
		}

		if (((ProjectCollectionType) aNoun).getUserData() != null) {
			updateNameValuePairType(((ProjectCollectionType) aNoun)
					.getUserData().getUserDataField(), aNoun, aPhysicalEntity);
		}

		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}
	}

}
