package com.ibm.commerce.sample.beans;

/*
 *-----------------------------------------------------------------
 * IBM Confidential
 *
 * OCO Source Materials
 *
 * WebSphere Commerce
 *
 * (C) Copyright IBM Corp. 2015, 2016
 *
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has
 * been deposited with the U.S. Copyright Office.
 *-----------------------------------------------------------------
 */
import java.util.logging.Logger;

import javax.persistence.NoResultException;

import com.ibm.commerce.beans.SmartDataBeanImpl;
import com.ibm.commerce.copyright.IBMCopyright;
import com.ibm.commerce.foundation.common.util.logging.LoggingHelper;
import com.ibm.commerce.foundation.persistence.EntityDao;
import com.ibm.commerce.sample.objects.ProjectE;
import com.ibm.commerce.sample.persistence.ProjectDaoImpl;
import com.ibm.commerce.security.Delegator;
import com.ibm.commerce.security.Protectable;

/*
 * DataBean for contact as a sample.
 */
public class ProjectDataBean extends SmartDataBeanImpl implements Delegator, Protectable {

	/**
	 * IBM copyright notice field.
	 */
	public static final String COPYRIGHT = IBMCopyright.SHORT_COPYRIGHT;

	private static final Logger LOGGER = LoggingHelper.getLogger(ProjectDataBean.class);
	private static final String CLASS_NAME = ProjectDataBean.class.getName();

	private ProjectE entity;
	private Long xproject_id;
	private Integer time;
	private Integer difficulty;
	private int storeent_id;
	private String prjname;

	public ProjectDataBean() {
	}

	public ProjectDataBean(ProjectE newEntity) {
		setEntity(newEntity);
		instantiateEntity();
	}

	
	public ProjectE getEntity() {
		return entity;
	}

	public void setEntity(ProjectE entity) {
		this.entity = entity;
	}

	public Long getXproject_id() {
		return xproject_id;
	}

	public void setXproject_id(Long xproject_id) {
		this.xproject_id = xproject_id;
	}

	public Integer getTime() {
		return time;
	}

	public void setTime(Integer time) {
		this.time = time;
	}

	public Integer getDifficulty() {
		return difficulty;
	}

	public void setDifficulty(Integer difficulty) {
		this.difficulty = difficulty;
	}

	public int getStoreent_id() {
		return storeent_id;
	}

	public void setStoreent_id(int storeent_id) {
		this.storeent_id = storeent_id;
	}

	public String getPrjname() {
		return prjname;
	}

	public void setPrjname(String prjname) {
		this.prjname = prjname;
	}

	public static Logger getLogger() {
		return LOGGER;
	}

	@Override
	public Protectable getDelegate() throws Exception {
		instantiateEntity();
		return this;
	}

	@Override
	public boolean fulfills(Long member, String relationship) throws Exception {
		instantiateEntity();
		return true;
	}

	@Override
	public Long getOwner() throws Exception {
		instantiateEntity();
		return entity.getOwner();
	}

	@Override
	public void populate() throws Exception {
		instantiateEntity();
	}

	public void instantiateEntity() {
		if (entity == null) {
			EntityDao<ProjectE, Long> entityDao = new ProjectDaoImpl();
			entity = entityDao.find(getXproject_id());
			
			setEntity(entity);
			if (entity == null) {
				throw new NoResultException();
			}
		}
		setXproject_id(entity.getXproject_id());
		setTime(entity.getTime());
		setDifficulty(entity.getDifficulty());
		setStoreent_id(entity.getStoreent_id());
		setPrjname(entity.getPrjname());

	}
}
