package com.ibm.commerce.sample.objects;

/*
 *-----------------------------------------------------------------
 * IBM Confidential
 *
 * OCO Source Materials
 *
 * WebSphere Commerce
 *
 * (C) Copyright IBM Corp. 2015
 *
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has
 * been deposited with the U.S. Copyright Office.
 *-----------------------------------------------------------------
 */

import java.io.Serializable;

import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

import com.ibm.commerce.base.objects.EntityBase;
import com.ibm.commerce.copyright.IBMCopyright;
import com.ibm.commerce.sample.objsrc.ContactAccessHelper;
import com.ibm.commerce.security.AccessHelper;
import com.ibm.commerce.security.Protectable;

/**
 * Entity class for contact as a sample.
 */
@Entity
@Table(name = "XCONTACT")
@NamedQueries({
		@NamedQuery(name = "Contact.getContactsByFirstName", query = "select c from Contact c where c.firstName = :firstName") })
public class Contact extends EntityBase implements Serializable, Protectable {

	/**
	 * IBM copyright notice field.
	 */
	public static final String COPYRIGHT = IBMCopyright.SHORT_COPYRIGHT;

	private static final long serialVersionUID = 1L;

	private Long contactId;

	private String firstName;

	private String lastName;

	private Integer storeId;

	private Long memberId;

	/**
	 * Default constructor.
	 */
	public Contact() {
	}

	/**
	 * Returns the contact id.
	 * 
	 * @return The contact id.
	 */
	@Column(name = "XCONTACT_ID", nullable = false)
	@Basic(optional = false)
	@Id
	public Long getContactId() {
		return contactId;
	}

	/**
	 * Sets the contact ID.
	 * 
	 * @param contactId
	 *            The contact ID.
	 */
	public void setContactId(Long contactId) {
		this.contactId = contactId;
	}

	/**
	 * Returns the first name.
	 * 
	 * @return The first name.
	 */
	@Column(name = "FIRST_NAME")
	public String getFirstName() {
		return firstName;
	}

	/**
	 * Sets the first name.
	 * 
	 * @param firstName
	 *            The first name.
	 */
	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	/**
	 * Returns the last name.
	 * 
	 * @return The last name.
	 */
	@Column(name = "LAST_NAME")
	public String getLastName() {
		return lastName;
	}

	/**
	 * Sets the last name.
	 * 
	 * @param lastName
	 *            The last name.
	 */
	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	/**
	 * Returns the store id.
	 * 
	 * @return The store id.
	 */
	@Column(name = "STORE_ID")
	public Integer getStoreId() {
		return storeId;
	}

	/**
	 * Sets the store id.
	 * 
	 * @param sotreId
	 *            the store id.
	 */
	public void setStoreId(Integer storeId) {
		this.storeId = storeId;
	}

	/**
	 * Returns the member id.
	 * 
	 * @return The member id.
	 */
	@Column(name = "MEMBER_ID")
	public Long getMemberId() {
		return memberId;
	}

	/**
	 * Sets the member id.
	 * 
	 * @param memberId
	 *            the member id.
	 */
	public void setMemberId(Long memberId) {
		this.memberId = memberId;
	}

	@Override
	protected AccessHelper getAccessHelper() {
		if (accessHelper == null) {
			accessHelper = new ContactAccessHelper();
		}
		return accessHelper;
	}

}
