package com.mycompany.commerce.project.facade.server.services.dataaccess.bom.mediator;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

import com.ibm.commerce.foundation.common.datatypes.CommerceFoundationFactory;
import com.ibm.commerce.foundation.common.datatypes.UserDataType;
import com.ibm.commerce.foundation.common.exception.AbstractApplicationException;
import com.ibm.commerce.foundation.common.util.logging.LoggingHelper;
import com.ibm.commerce.foundation.server.services.dataaccess.bom.mediator.AbstractReadBusinessObjectMediatorImpl;
import com.mycompany.commerce.project.facade.datatypes.ProjectType;
import com.mycompany.commerce.project.facade.datatypes.ProjectFactory;

/**
 * The Project read mediator transforms from a physical data object to
 * the logical data object for Project nouns.
 */
public class ReadProjectMediator extends AbstractReadBusinessObjectMediatorImpl {
	
	private static final String CLASSNAME = ReadProjectMediator.class.getName();
	private static final Logger LOGGER = LoggingHelper.getLogger(ReadProjectMediator.class);	
	
	/**
	 * This method builds the main Project noun.
	 * @param aLogicalEntityType The logical noun.
	 * @param aPhysicalEntityType The physical data object.
	 * @exception AbstractApplicationException
	 */
	public void buildNoun(Object aLogicalEntityType, Object aPhysicalEntityType) throws AbstractApplicationException {
		final String METHODNAME = "buildNoun";		
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME, new Object[] { aLogicalEntityType, aPhysicalEntityType });
		}
		
		// TODO: Implement code to populate a logical Project from the physical SDO aPhysicalEntityType. 
		// The following sample code populates the Project noun identifier.  
		ProjectType aProjectNoun = (ProjectType) aLogicalEntityType;		
				
		// TODO: Uncomment the following line to call the <code>buildUserData> method to populate UserData in the
		//  Project noun.
		//buildUserData(Project, ProjectPhysicalDo);
		
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}
		
	}
	
	/**
	 * This method creates a noun type that corresponds to the root physical entity.
	 * @return This method returns the noun type object for this mediator.
	 * @exception AbstractApplicationException
	 */
	public Object createNounType() throws AbstractApplicationException {
		return getProjectFactory().createProjectType();
		
	}
	
	/**
	 * This method populates the Project noun level configurable user data.
	 * @param aLogicalEntityType The logical noun.
	 * @param aPhysicalEntity The physical data object.
	 * @exception AbstractApplicationException
	 */
	public void buildUserData(ProjectType aLogicalEntityType, Object aPhysicalEntity) throws AbstractApplicationException {
		final String METHODNAME = "buildUserData";
		
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME, new Object[] { aLogicalEntityType, aPhysicalEntity });
		}
		/*Map attributes = new HashMap();
		populateNameValuePairType(attributes, aLogicalEntityType, aPhysicalEntity);
		UserDataType userData = getCommerceFoundationFactory().createUserDataType();
		aLogicalEntityType.setUserData(userData);
		Iterator anIter = attributes.entrySet().iterator();
		while (anIter.hasNext()) {
			Map.Entry anEntry = (Map.Entry) anIter.next();
			if (anEntry.getKey() != null && anEntry.getValue() != null) {
				aLogicalEntityType.getUserData().getUserDataField().put(
						anEntry.getKey().toString(),
						anEntry.getValue().toString());
			}
		}*/
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}
	}
	
	/**
	 * This method returns the default instance of the Project Factory.
	 * This factory can be used to create objects defined by the Project component.
	 * @return This method returns the default Project Factory.
	 */
	protected ProjectFactory getProjectFactory() {
		return ProjectFactory.eINSTANCE;
	}
	
	/**
	 * This method will return the default instance of the Commerce Foundation Factory.
	 * This factory can be used to create objects defined by the Commerce Foundation.
	 * @return The default Commerce Foundation Factory.
	 */
	protected CommerceFoundationFactory getCommerceFoundationFactory() {
		return CommerceFoundationFactory.eINSTANCE;
	}
		
}
