package com.mycompany.commerce.project.facade.server.services.dataaccess.bom.mediator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

import com.ibm.commerce.foundation.common.datatypes.CommerceFoundationFactory;
import com.ibm.commerce.foundation.common.exception.AbstractApplicationException;
import com.ibm.commerce.foundation.common.util.logging.LoggingHelper;
import com.ibm.commerce.foundation.server.services.dataaccess.DataServiceFacade;
import com.ibm.commerce.foundation.server.services.dataaccess.PhysicalDataContainer;
import com.ibm.commerce.foundation.server.services.dataaccess.SelectionCriteria;
import com.ibm.commerce.foundation.server.services.dataaccess.bom.mediator.AbstractChangeBusinessObjectMediatorImpl;
import com.ibm.commerce.foundation.server.services.dataaccess.exception.DataMediatorException;
import com.mycompany.commerce.project.facade.datatypes.ProjectType;
import com.mycompany.commerce.project.facade.ProjectFacadeConstants;

/**
 * The Project change mediator creates and deletes <Project nouns, and validates
 * that the create, update, or delete action can be performed. Project updates
 * are done by the Project base part mediator.
 */
public class ChangeProjectMediator extends AbstractChangeBusinessObjectMediatorImpl {
	
	private static final String CLASSNAME = ChangeProjectMediator.class.getName();
	private static final Logger LOGGER = LoggingHelper.getLogger(ChangeProjectMediator.class);	
	
	/**
	 * This method populates the physical data container with the physical SDO
	 * object to create. It sets all the Project data, including any provided user data,
	 * from the logical Project noun.
	 * @param aNoun The logical <code>ProjectType</code> SDO business object to create.
	 * @exception AbstractApplicationException
	 */
	public void create(Object aNoun) throws AbstractApplicationException {
		final String METHODNAME = "create";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME, new Object[] { aNoun });
		}		
		
		// TODO: Create a new physcal SDO.
		// PhysicalSDOType aPhysicalEntity = (PhysicalSDOType) getPhysicalDataContainer().createPhysicalObject(null, PhysicalSDOType.class);
		
		// TODO: Populate the new physical SDO with the information from the noun.
		
		// TODO: uncomment to provide user data support.
		// updateNameValuePairType(aNoun, aPhysicalEntity);						
		
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}
	}
	
	/**
	 * This method performs no actions as Project updates are done by the change Project part mediator.
	 * @param aNoun The logical <code>ProjectType</code> SDO business object.
	 * @exception AbstractApplicationException
	 */
	public void change(Object aNoun) throws AbstractApplicationException {
		final String METHODNAME = "change";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME, new Object[] { aNoun });
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}
	}
	
	/**
	 * This method updates the physical data container with the physical SDO object to delete. 
	 * @param aNoun The logical <code>ProjectType</code> SDO business object to delete.
	 * @exception AbstractApplicationException
	 */
	public void delete(Object aNoun) throws AbstractApplicationException {
		final String METHODNAME = "delete";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME, new Object[] { aNoun });
		}
		
		// TODO: Find the physical SDO to delete.
		// PhysicalSDOType aPhysicalEntity = (PhysicalSDOType) findPhysicalEntity(aNoun);
		
		// TODO: Remove the physical SDO from the PDC.
		// getPhysicalDataContainer().removePhysicalObject(aPhysicalEntity); 
						
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {			
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}
	}
	
	/**
	 * This method returns the physical SDO from the <code>PhysicalDataContainer</code> that was created in the
	 * <code>initializePhysicalDataContainer</code> method that matches the provided noun.
	 * @param aNoun The logical <code>ProjectType</code> SDO.
	 * @return This method returns the physical SDO object if it is found, otherwise it returns null.
	 * @exception DataMediatorException
	 */
	public Object findPhysicalEntity(Object aNoun) throws DataMediatorException {
		final String METHODNAME = "findPhysicalEntity";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME, new Object[] { aNoun });
		}
		
		ProjectType aProject = (ProjectType) aNoun;
		Object matchPhysicalProject = null;				
		
		// Get the physical SDOs from the physical data container.
		List aListPhysicalProject = getPhysicalDataContainer().getPhysicalObjects();
		
		if (aListPhysicalProject != null) {
			Iterator objIter = aListPhysicalProject.iterator();
			while (objIter.hasNext()) {
				// TODO: Implement the code to determine which physical SDO, if any, represents the Project noun.			
				// PhysicalSDOType aPhysicalProject = (PhysicalSDOType) objIter.next();
				
				// TODO: Implement the code to check if the aPhysicalProject matches the aProject.
				// matchPhysicalProject = aPhysicalProject;
				// break;							
			}
		}	
						
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}
		return null;
	}
	
	/**
	 * This method updates the physical Project object with the user data
	 * set in the logical Project noun. The name-value pair mapping is set in
	 * the wc-business-object-mediator XML file. 
	 * @param aNoun The logical <code>ProjectType</code> SDO business object.
	 * @param aPhysicalEntity The physical <code>Project</code> SDO business object.
	 * @exception AbstractApplicationException
	 */
	private void updateNameValuePairType(Object aNoun, Object aPhysicalEntity) throws AbstractApplicationException {
		final String METHODNAME = "updateNameValuePairType";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME, new Object[] { aNoun, aPhysicalEntity });
		}
		/*
		if (((ProjectType) aNoun).getUserData() != null) {
			updateNameValuePairType(((ProjectType) aNoun).getUserData().getUserDataField(), 
					aNoun, aPhysicalEntity);
		}
		*/
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}
	}
	
	/**
	 * This method initializes the physical data container for this mediator. For any nouns in the provided
	 * list, a query in the Project DSL query template is used to populate the physical data objects
	 * into the physical data container. If there are no nouns provided, then an empty physical data
	 * data container is returned.
	 * @param aListNoun A list of <code>ProjectType</code> nouns.
	 * @return This method returns the physical data container used to create, update, and delete nouns.
	 * @exception DataMediatorException
	 */	
	protected PhysicalDataContainer initializePhysicalDataContainer(List aListNoun) throws DataMediatorException {
		final String METHODNAME = "initializePhysicalDataContainer";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME, new Object[] { aListNoun });
		}
		
		PhysicalDataContainer pdc = null;
		List identifiers = new ArrayList();
		
		Iterator aListNounIter = aListNoun.iterator();
		while (aListNounIter.hasNext()) {
			ProjectType aProject = (ProjectType) aListNounIter.next();
			// TODO: set the uniqueId from the noun.
			String uniqueId = null;			
			identifiers.add(uniqueId);
		}
				
		// Build an expression to retrieve the required physical SDOs.
				
		SelectionCriteria anExpression = new SelectionCriteria();
		
		// TODO: Set the XPath key for the change Project query template.
		// anExpression.setXPathKey(ChangeProjectXPathKey);
		
		// TODO: Set the access profile for the change Project query template.
		// anExpression.setAccessProfile(CHANGEProjectAccessProfile);
		
		// TODO: Set the unique identifiers into the query.
		// anExpression.setXPathParameter(new RelationalExpression("UniqueID", identifiers));
		
		// TODO: Initialize the physical data container based on the above query results.
		// pdc = DataServiceFacade.getInstance(ProjectFacadeConstants.COMPONENT_NAME).getPhysicalDataContainer(anExpression);
		
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}
		return pdc;
	}
	
	/**
	 * This method sets the unique ID in the noun if it does not have the unique ID set but
	 * has the external identifier set. This is done so that the <code>initializePhysicalDataContainer</code>
	 * method only reads by the object's unique identifier.
	 * @param aNoun The logical <code>ProjectType</code> SDO business object.
	 * @return This method returns true if the noun needed to be resolved and was successfully resolved.
	 * @exception DataMediatorException
	 */
	protected boolean resolveByExternalIdentifier(Object aNoun) throws DataMediatorException  {
		final String METHODNAME = "resolveByExternalIdentifier";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME, new Object[] { aNoun });
		}
		
		boolean resolved = false;
		// TODO: Implement code to lookup the internal identifier of the noun based on the external identifier of the noun.
		
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {			
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}
		return resolved;
	}
	
	/**
	 * This method checks if the logical Project noun can be created. 
	 * If the noun cannot be created, the appropriate error exception is added to the
	 * list of exceptions to be returned to the caller.
	 * @param aNoun The logical <code>ProjectType</code> SDO business object to validate.
	 * @return This method returns a list of <code>ApplicationError</code> if there are any
	 * errors, otherwise the list will be empty.
	 * @exception DataMediatorException
	 */
	public List validateCreate(Object aNoun) throws DataMediatorException {
		final String METHODNAME = "validateCreate";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME, new Object[] { aNoun });
		}
		List validationErrors = new ArrayList();	
		
		// TODO: Check if the Project noun can be created.
		// The following sample code checks if the physical SDO that represents the Project noun
		// exists.  If the physical SDO already exists, an application exception is created.
		// PhysicalSDOType aPhysicalProject = (PhysicalSDOType) findPhysicalEntity(aNoun, aNounPart);
		// if (aPhysicalProject != null) {
		//	ApplicationError validateError = new ApplicationError(
		//			ApplicationError.TYPE_GENERIC_ERROR,
		//			ProjectApplicationMessageKeys._APP_PHYSICAL_SDO_ALREADY_EXISTS,
		//			new Object[] { aNoun }, LOGGER.getResourceBundleName());
		//	validationErrors.add(validateError);
		// }		
		
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME, validationErrors);
		}
		return validationErrors;
	}
	
	/**
	 * This method checks if the logical Projectnoun can be updated. 
	 * If the noun cannot be updated, the appropriate error exception is added to the
	 * list of exceptions to be returned to the caller.
	 * @param aNoun The logical <code>ProjectType</code> SDO business object to validate.
	 * @return This method returns a list of <code>ApplicationError</code> if there are any
	 * errors, otherwise the list will be empty.
	 * @exception DataMediatorException
	 */
	public List validateChange(Object aNoun) throws DataMediatorException {
		final String METHODNAME = "validateChange";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME, new Object[] { aNoun });
		}
		List validationErrors = new ArrayList();	
		
		// TODO: Check if the Project noun can be updated.
		// The following sample code checks if the physical SDO that represents the Project noun
		// exists.  If the physical SDO does not exist, an application exception is created.
		// PhysicalSDOType aPhysicalProject = (PhysicalSDOType) findPhysicalEntity(aNoun, aNounPart);
		// if (aPhysicalProject == null) {
		//	ApplicationError validateError = new ApplicationError(
		//			ApplicationError.TYPE_GENERIC_ERROR,
		//			ProjectApplicationMessageKeys._APP_PHYSICAL_SDO_DOES_NOT_EXIST,
		//			new Object[] { aNoun }, LOGGER.getResourceBundleName());
		//	validationErrors.add(validateError);
		// }			
		
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME, validationErrors);
		}
		return validationErrors;
	}
	
	/**
	 * This method checks if the logical Project noun can be deleted. 
	 * If the noun cannot be deleted, the appropriate error exception is added to the
	 * list of exceptions to be returned to the caller.
	 * @param aNoun The logical <code>ProjectType</code> SDO business object to validate.
	 * @return This method returns a list of <code>ApplicationError</code> if there are any
	 * errors, otherwise the list will be empty.
	 * @exception DataMediatorException
	 */
	public List validateDelete(Object aNoun) throws DataMediatorException {
		final String METHODNAME = "validateDelete";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME, new Object[] { aNoun });
		}
		
		List validationErrors = new ArrayList();
		
		// TODO: Check if the Project noun can be deleted.
		// The following sample code checks if the physical SDO that represents the Project noun
		// exists.  If the physical SDO does not exist, an application exception is created.
		// PhysicalSDOType aPhysicalProject = (PhysicalSDOType) findPhysicalEntity(aNoun, aNounPart);
		// if (aPhysicalProject == null) {
		//	ApplicationError validateError = new ApplicationError(
		//			ApplicationError.TYPE_GENERIC_ERROR,
		//			ProjectApplicationMessageKeys._APP_PHYSICAL_SDO_DOES_NOT_EXIST,
		//			new Object[] { aNoun }, LOGGER.getResourceBundleName());
		//	validationErrors.add(validateError);
		// }		
		
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME, validationErrors);
		}
		return validationErrors;
	}
	
	/**
	 * This method returns the default instance of the Commerce Foundation Factory.
	 * Use this factory to create objects defined by the Commerce Foundation.
	 * @return The default Commerce Foundation Factory.
	 */
	protected CommerceFoundationFactory getCommerceFoundationFactory() {
		return CommerceFoundationFactory.eINSTANCE;
	}
	
}
