package com.mycompany.commerce.project.facade.server.services.dataaccess.bom.mediator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

import com.ibm.commerce.foundation.common.exception.AbstractApplicationException;
import com.ibm.commerce.foundation.common.util.logging.LoggingHelper;
import com.ibm.commerce.foundation.server.services.dataaccess.PhysicalDataContainer;
import com.ibm.commerce.foundation.server.services.dataaccess.bom.config.BusinessObjectMediatorConfig;
import com.ibm.commerce.foundation.server.services.dataaccess.bom.mediator.AbstractChangeBusinessObjectPartMediatorImpl;
import com.ibm.commerce.foundation.server.services.dataaccess.exception.DataMediatorException;
import com.mycompany.commerce.project.facade.datatypes.ProjectType;

/**
 * The Project base part change mediator persists updates to a Project noun to 
 * the database.
 */
public class ChangeProjectBasePartMediator extends AbstractChangeBusinessObjectPartMediatorImpl {

	
	/**
	 * Constants for logging and tracing.
	 */
	private static final String CLASSNAME = ChangeProjectBasePartMediator.class.getName();
	private static final Logger LOGGER = LoggingHelper.getLogger(ChangeProjectBasePartMediator.class);
		
	private static final String[] XPATH = new String[] { BusinessObjectMediatorConfig.XPATH_NOUN_BASE_PART };
	
	/**
	 * This method performs no actions as Project creation is done by the change Project mediator.
	 * @param aNoun The logical <code>ProjectType</code> SDO business object.
	 * @param aNounPart The logical <code>ProjectType</code> SDO business object.
	 * @exception AbstractApplicationException
	 */
	public void create(Object aNoun, Object aNounPart) throws AbstractApplicationException {
		final String METHODNAME = "create";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME, new Object[] { aNoun, aNounPart });
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}
	}

	/**
	 * This method updates the physical data container with the modified physical SDO object.
	 * @param aNoun The logical <code>ProjectType</code> SDO business object to update.
	 * @param aNounPart The logical <code>ProjectType</code> SDO business object to update.
	 * @exception AbstractApplicationException
	 */
	public void update(Object aNoun, Object aNounPart) throws AbstractApplicationException {
		final String METHODNAME = "update";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME, new Object[] { aNoun, aNounPart });
		}	
		
		// TODO: Implement code to update the physical SDOs with the contents of the noun and noun part.
				
		//ProjectType aProjectNoun = (ProjectType) aNoun;
		
		// TODO: Find the physical SDO that represents the noun and noun part, replace "PhysicalSDOType" with the appropriate physical SDO.
		//PhysicalSDOType aPhysicalProject = (PhysicalSDOType) findPhysicalEntity(aNoun, aNounPart);
		
		// TODO: Update the physical SDO from the noun.		
				
		// TODO: If needed, call the updateNameValuePairType method to update the Project userdata.			
		//updateNameValuePairType(aProjectNoun, aPhysicalProject); 						
		
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}
		
	}

	/**
	 * This method performs no actions as Project deletion is done by the change Project mediator.
	 * @param aNoun The logical <code>ProjectType</code> SDO business object.
	 * @param aNounPart The logical <code>ProjectType</code> SDO business object.
	 * @exception AbstractApplicationException
	 */
	public void delete(Object aNoun, Object aNounPart) throws AbstractApplicationException {
		final String METHODNAME = "delete";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME, new Object[] { aNoun, aNounPart });
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}
	}
	
	/**
	 * This method gets the XPath for the main Project noun part.
	 * @return The XPath for the main Project noun part.
	 */
	public String[] getNounPartXPaths() {
		return XPATH;
	}

	/**
	 * This method initializes the physical data container for this mediator. It currently performs
	 * no actions as the physical data container from the <code>ChangeProjectMediator</code> is used
	 * in this mediator.
	 * @param aMapNounPart A map of the noun parts.
	 * @return This method returns null.
	 * {@link #getParentPhysicalDataContainer()} should be used to get the 
	 * physical data container of the parent mediator class.
	 */
	protected PhysicalDataContainer initializePhysicalDataContainer(Map aMapNounPart) {
		final String METHODNAME = "initializePhysicalDataContainer";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME, new Object[] { aMapNounPart });
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}
		return null;
	}

	/**
	 * This method performs no actions as the resolve is done by the Change Project mediator.
	 * @param aNoun The logical <code>ProjectType</code> SDO business object.
	 * @param aNounPart The logical <code>ProjectType</code> SDO business object.
	 * @return This method returns false.
	 */
	protected boolean resolveByExternalIdentifier(Object aNoun, Object aNounPart) {
		final String METHODNAME = "resolveByExternalIdentifier";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME, new Object[] { aNoun,aNounPart });
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}
		return false;
	}

	/**
	 * This method performs no checking as the validation is done by the Change Project mediator.
	 * @param aNoun The logical <code>ProjectType</code> SDO business object.
	 * @param aNounPart The logical <code>ProjectType</code> SDO business object.
	 * @return This method returns null.
	 * @exception DataMediatorException
	 */
	public List validateCreate(Object aNoun, Object aNounPart) throws DataMediatorException {
		final String METHODNAME = "validateCreate";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME, new Object[] { aNoun, aNounPart });
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}
		return null;
	}

	/**
	 * This method checks if the logical Project noun can be updated. 
	 * If the noun cannot be updated, the appropriate error exception is added to the
	 * list of exceptions to be returned to the caller.
	 * @param aNoun The logical <code>ProjectType</code> SDO business object to validate.
	 * @param aNounPart The logical <code>ProjectType</code> SDO business object.
	 * @return This method returns a list of <code>ApplicationError</code> if there are any
	 * errors, otherwise the list will be empty.
	 * @exception DataMediatorException
	 */	
	public List validateChange(Object aNoun, Object aNounPart) throws DataMediatorException {
		final String METHODNAME = "validateChange";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME, new Object[] { aNoun, aNounPart });
		}
		List validationErrors = new ArrayList();
		
		// TODO: Check if the Project noun can be updated.
		// The following sample code checks if the physical SDO that represents the Project noun
		// exists.  If the physical SDO does not exist, an application exception is created.
		// PhysicalSDOType aPhysicalProject = (PhysicalSDOType) findPhysicalEntity(aNoun, aNounPart);
		// if (aPhysicalProject == null) {
		//	ApplicationError validateError = new ApplicationError(
		//			ApplicationError.TYPE_GENERIC_ERROR,
		//			ProjectApplicationMessageKeys._APP_PHYSICAL_SDO_DOES_NOT_EXIST,
		//			new Object[] { aNoun }, LOGGER.getResourceBundleName());
		//	validationErrors.add(validateError);
		// }		
		
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {			
			LOGGER.exiting(CLASSNAME, METHODNAME, validationErrors);
		}
		return validationErrors;
	}
	
	/**
	 * This method performs no checking as the validation is done by the Change Project mediator.
	 * @param aNoun The logical <code>ProjectType</code> SDO business object.
	 * @param aNounPart The logical <code>ProjectType</code> SDO business object.
	 * @return This method returns null.
	 * @exception DataMediatorException
	 */
	public List validateDelete(Object aNoun, Object aNounPart) throws DataMediatorException {
		final String METHODNAME = "validateDelete";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME, new Object[] { aNoun, aNounPart });
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}
		return null;
	}

	/**
	 * This method returns the physical SDO from the <code>PhysicalDataContainer</code> that was created in the
	 * <code>ChangeProjectMediator</code> mediator.
	 * @param aNoun The logical <code>ProjectType</code> SDO.
	 * @param aNounPart The logical <code>ProjectType</code> SDO.
	 * @return This method returns the <code>PhysicalProject</code> object if it is found, otherwise it returns null.
	 * @exception DataMediatorException
	 */
	public Object findPhysicalEntity(Object aNoun, Object aNounPart) throws DataMediatorException {
		final String METHODNAME = "findPhysicalEntity";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME, new Object[] { aNoun });
		}			
		
		ProjectType aProject = (ProjectType) aNoun;
		Object matchPhysicalProject = null;				
		
		// Get the physical SDOs from the physical data container.
		List aListPhysicalProject = getPhysicalDataContainer().getPhysicalObjects();
		
		if (aListPhysicalProject != null) {
			Iterator objIter = aListPhysicalProject.iterator();
			while (objIter.hasNext()) {
				// TODO: Implement the code to determine which physical SDO, if any, represents the Project noun.			
				// PhysicalSDOType aPhysicalProject = (PhysicalSDOType) objIter.next();
				
				// TODO: Implement the code to check if the aPhysicalProject matches the aProject.
				// matchPhysicalProject = aPhysicalProject;
				// break;							
			}
		}	
		
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}
		
		return matchPhysicalProject;
	}	
	
	/**
	 * This method updates the physical Project object with the user data
	 * set in the logical Project noun. The name-value pair mapping is set in
	 * the wc-business-object-mediator XML file. 
	 * @param aNoun The logical <code>ProjectType</code> SDO business object.
	 * @param aPhysicalEntity The physical SDO business object.
	 * @exception AbstractApplicationException
	 */
	private void updateNameValuePairType(Object aNoun, Object aPhysicalEntity) throws AbstractApplicationException {
		final String METHODNAME = "updateNameValuePairType";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME, new Object[] { aNoun, aPhysicalEntity });
		}
		/*
		if (((ProjectType) aNoun).getUserData() != null) {
			updateNameValuePairType(((ProjectType) aNoun).getUserData().getUserDataField(), 
				aNoun, aPhysicalEntity);
		}
		*/
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}
	}
}
