package com.mycompany.commerce.project.facade.server.commands;

import java.util.ArrayList;

import com.ibm.commerce.beans.DataBeanManager;
import com.ibm.commerce.foundation.common.util.logging.LoggingHelper;
import com.ibm.commerce.foundation.server.command.bod.SearchExpression;
import com.ibm.commerce.foundation.server.command.bod.bom.AbstractFetchNounUsingBusinessObjectMediatorCmdImpl;
import com.ibm.commerce.sample.beans.ProjectDataBean;
import com.ibm.commerce.sample.objects.ProjectE;
import com.mycompany.commerce.project.facade.datatypes.ProjectDifficultyType;
import com.mycompany.commerce.project.facade.datatypes.ProjectFactory;
import com.mycompany.commerce.project.facade.datatypes.ProjectType;

/**
 * This command is used to fetch Project nouns.
 */
public class FetchProjectCmdImpl extends AbstractFetchNounUsingBusinessObjectMediatorCmdImpl implements FetchProjectCmd {
	private static final String CLASSNAME = FetchProjectCmdImpl.class.getName();
	private static final java.util.logging.Logger LOGGER = com.ibm.commerce.foundation.common.util.logging.LoggingHelper.getLogger(FetchProjectCmdImpl.class);
	private java.util.List iNouns = new ArrayList<>();
	/**
	 * This method is the default constructor. It delegates to the parent class to fetch the Project activities.
	 */
	public FetchProjectCmdImpl() {
		super();
		final String METHODNAME = "FetchProjectCmdImpl()";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME);
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}
	}

	@Override
	public void performExecute() throws Exception {
		// TODO Auto-generated method stub
		SearchExpression searchExpression = getSearchExpression();
		//part1
		String uniqueIdString = searchExpression.toString();
		uniqueIdString = uniqueIdString.substring(uniqueIdString.indexOf("UniqueID=")+9,uniqueIdString.indexOf("UniqueID=")+13);
		//Object UniqueID =searchExpression.getXPathParameters().get("UniqueID");
		//part 2
		ProjectDataBean projectDataBean = new ProjectDataBean();
		projectDataBean.setXproject_id(Long.valueOf(uniqueIdString));
		projectDataBean.setCommandContext(null);
		DataBeanManager.activate(projectDataBean);
		ProjectE projectEntity = (ProjectE)projectDataBean.getEntity();

		//part 3
		//ProjectTypeImpl aProjectLogicalDO = new ProjectTypeImpl();
		ProjectType aProjectLogicalDO = ProjectFactory.eINSTANCE.createProjectType();
		//ProjectDifficultyType difficultyType = new ProjectDifficultyType(1,"2","1");
		if(projectEntity.getDifficulty()==0){
			aProjectLogicalDO.setDifficulty(ProjectDifficultyType.EASY_LITERAL);
		}else if(projectEntity.getDifficulty()==1){
			aProjectLogicalDO.setDifficulty(ProjectDifficultyType.NORMAL_LITERAL);
		}else{
			aProjectLogicalDO.setDifficulty(ProjectDifficultyType.DIFFICULT_LITERAL);
		}
		
		//part 4
		iNouns.add(aProjectLogicalDO);

		setNouns(iNouns);
	}
	
	
}
