/**
 */
package com.mycompany.commerce.project.facade.datatypes;

import java.math.BigInteger;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Type</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * Type definition of a Project.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link com.mycompany.commerce.project.facade.datatypes.ProjectType#getProjectIdentifier <em>Project Identifier</em>}</li>
 *   <li>{@link com.mycompany.commerce.project.facade.datatypes.ProjectType#getTimeToComplete <em>Time To Complete</em>}</li>
 *   <li>{@link com.mycompany.commerce.project.facade.datatypes.ProjectType#getDifficulty <em>Difficulty</em>}</li>
 * </ul>
 *
 * @see com.mycompany.commerce.project.facade.datatypes.ProjectPackage#getProjectType()
 * @generated
 */
public interface ProjectType {
	/**
	 * Returns the value of the '<em><b>Project Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * 
	 * 						Project identification information
	 * 					
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Project Identifier</em>' containment reference.
	 * @see #setProjectIdentifier(ProjectIdentifierType)
	 * @see com.mycompany.commerce.project.facade.datatypes.ProjectPackage#getProjectType_ProjectIdentifier()
	 * @generated
	 */
	ProjectIdentifierType getProjectIdentifier();

	/**
	 * Sets the value of the '{@link com.mycompany.commerce.project.facade.datatypes.ProjectType#getProjectIdentifier <em>Project Identifier</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Project Identifier</em>' containment reference.
	 * @see #getProjectIdentifier()
	 * @generated
	 */
	void setProjectIdentifier(ProjectIdentifierType value);

	/**
	 * Returns the value of the '<em><b>Time To Complete</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * 
	 * 						The time(counted by minutes) required to complete the Project
	 * 					
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Time To Complete</em>' attribute.
	 * @see #setTimeToComplete(BigInteger)
	 * @see com.mycompany.commerce.project.facade.datatypes.ProjectPackage#getProjectType_TimeToComplete()
	 * @generated
	 */
	BigInteger getTimeToComplete();

	/**
	 * Sets the value of the '{@link com.mycompany.commerce.project.facade.datatypes.ProjectType#getTimeToComplete <em>Time To Complete</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Time To Complete</em>' attribute.
	 * @see #getTimeToComplete()
	 * @generated
	 */
	void setTimeToComplete(BigInteger value);

	/**
	 * Returns the value of the '<em><b>Difficulty</b></em>' attribute.
	 * The literals are from the enumeration {@link com.mycompany.commerce.project.facade.datatypes.ProjectDifficultyType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The difficult degree to complete the recipe:
	 * 						easy
	 * 						normal
	 * 						difficult
	 * 					
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Difficulty</em>' attribute.
	 * @see com.mycompany.commerce.project.facade.datatypes.ProjectDifficultyType
	 * @see #isSetDifficulty()
	 * @see #unsetDifficulty()
	 * @see #setDifficulty(ProjectDifficultyType)
	 * @see com.mycompany.commerce.project.facade.datatypes.ProjectPackage#getProjectType_Difficulty()
	 * @generated
	 */
	ProjectDifficultyType getDifficulty();

	/**
	 * Sets the value of the '{@link com.mycompany.commerce.project.facade.datatypes.ProjectType#getDifficulty <em>Difficulty</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Difficulty</em>' attribute.
	 * @see com.mycompany.commerce.project.facade.datatypes.ProjectDifficultyType
	 * @see #isSetDifficulty()
	 * @see #unsetDifficulty()
	 * @see #getDifficulty()
	 * @generated
	 */
	void setDifficulty(ProjectDifficultyType value);

	/**
	 * Unsets the value of the '{@link com.mycompany.commerce.project.facade.datatypes.ProjectType#getDifficulty <em>Difficulty</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isSetDifficulty()
	 * @see #getDifficulty()
	 * @see #setDifficulty(ProjectDifficultyType)
	 * @generated
	 */
	void unsetDifficulty();

	/**
	 * Returns whether the value of the '{@link com.mycompany.commerce.project.facade.datatypes.ProjectType#getDifficulty <em>Difficulty</em>}' attribute is set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return whether the value of the '<em>Difficulty</em>' attribute is set.
	 * @see #unsetDifficulty()
	 * @see #getDifficulty()
	 * @see #setDifficulty(ProjectDifficultyType)
	 * @generated
	 */
	boolean isSetDifficulty();

} // ProjectType
