<%--
 =================================================================
  Licensed Materials - Property of IBM

  WebSphere Commerce

  (C) Copyright IBM Corp. 2014, 2016 All Rights Reserved.

  US Government Users Restricted Rights - Use, duplication or
  disclosure restricted by GSA ADP Schedule Contract with
  IBM Corp.
 =================================================================
--%>

<!doctype HTML>

<%-- 
  *****
  * After a new user or buyer organization registers, and an order requiring approval is placed by a buyer this email will be sent to the approver. 
  * This email JSP page informs the approver about user or buyer organization registration and order approvals.
  *****
--%>

<%@ include file="../../Common/EnvironmentSetup.jspf" %>
<%@ include file="../../Common/nocache.jspf"%>

<wcst:alias name="JSPHelper" var="jHelper">
	<wcf:param name="parameterSource" value="javax.servlet.jsp.jspRequest"/>
</wcst:alias>
<wcst:mapper source="jHelper" method="getParameter" var="getParameter"/>

<c:set var="flowId" value="${getParameter['flowId']}" scope="request"/>
<wcf:rest var="flow" url="store/{storeId}/flow/{flowId}" scope="request">
	<wcf:var name="storeId" value="${storeId}"/>
	<wcf:var name="flowId" value="${flowId}"/>
</wcf:rest>

<c:set var="approvalIdentifier" value="${flow.identifier}" scope="request"/>
<c:if test="${approvalIdentifier eq 'OrderProcess'}">
	<c:set var="orderId" value="${getParameter['orderId']}" scope="request"/>
</c:if>

<c:if test="${approvalIdentifier eq 'ResellerOrgEntityRegistrationAdd'}">
	<c:set var="orgName" value="${getParameter['org_orgEntityName']}" scope="request"/>
	<c:set var="logonId" value="${getParameter['usr_logonId']}" scope="request"/>
	<c:set var="firstName" value="${getParameter['firstName']}" scope="request"/>
</c:if>

<c:if test="${approvalIdentifier eq 'UserRegistrationAdd'}">
	<c:set var="orgName" value="${getParameter['ancestorOrgs']}" scope="request"/>
	<c:set var="logonId" value="${getParameter['logonId']}" scope="request"/>
	<c:set var="firstName" value="${getParameter['firstName']}" scope="request"/>
</c:if>

<c:set value="${pageContext.request.scheme}://${pageContext.request.serverName}${portUsed}" var="hostPath" />
<c:set value="${jspStoreImgDir}" var="fullJspStoreImgDir" />
<c:if test="${!(fn:contains(fullJspStoreImgDir, '://'))}">
	<c:set value="${hostPath}${jspStoreImgDir}" var="fullJspStoreImgDir" />
</c:if>

<!-- BEGIN ApproverNotify.jsp -->
<html xmlns:wairole="http://www.w3.org/2005/01/wai-rdf/GUIRoleTaxonomy#" xmlns:waistate="http://www.w3.org/2005/07/aaa" lang="${shortLocale}" xml:lang="${shortLocale}">
	
	<head>
		<title>
			<fmt:message bundle="${storeText}" key="EMAIL_PAGE_TITLE_1">
				<fmt:param value="${storeName}"/>
			</fmt:message>
		</title>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	</head>

	<body text="#333333" style="background-color:#fff">
		<p>&nbsp;</p>
		<table border="0" align="center" cellpadding="6" cellspacing="6">
			<tbody>
				<tr>
				  <td align="left" valign="top" style="font-family: arial, Verdana, sans-serif; font-size: 11px; color:#666">
					<p style="margin-bottom:0px;">	
						<fmt:message bundle="${storeText}" key="EMAIL_DISCLAIMER_1_MESSAGE">
							<fmt:param value="${storeName}"/>
						</fmt:message>
					</p>
					<p style="margin-top:0px;">
						<fmt:message bundle="${storeText}" key="EMAIL_DISCLAIMER_2_MESSAGE">
							<fmt:param value="${storeName}"/>
						</fmt:message>
					</p>
					</td>
				</tr>
			</tbody>
		</table>
		<table border="0" align="center" cellpadding="0" cellspacing="0" style="background-color:#fff; width:100%; max-width:690px; ">
			<tr>
				<td align="center" valign="top" style="min-height:300px; border-color:#ccc; border-width:0px 1px 0px 1px; border-style:solid">
					 <table border="0" align="center" cellpadding="0" cellspacing="0" >
						<tr>
							<td align="center" valign="top" style="min-height:300px; padding: 0px 20px 0px 20px;">
									<table border="0" cellspacing="5" cellpadding="5" style="width: 100%;">
										<tbody>
											<c:choose>
												 <c:when test="${approvalIdentifier eq 'UserRegistrationAdd'}">
													<tr>
													<td align="left" valign="top" style="font-family: arial, Verdana, sans-serif; font-size:21px; color:#333333">
														<fmt:message bundle="${storeText}" key="EMAIL_DEAR_ADMINISTRATOR"/>
													</td>
													</tr>
												 </c:when>
												 <c:when test="${approvalIdentifier eq 'OrderProcess'}">
													<tr>
													<td align="left" valign="top" style="font-family: arial, Verdana, sans-serif; font-size:21px; color:#333333">
														<fmt:message bundle="${storeText}" key="EMAIL_DEAR_APPROVER"/>
													</td>
													</tr>
												 </c:when>
												 <c:otherwise>
													<!-- empty sub-heading -->
												 </c:otherwise>
											</c:choose>
										<tr>
										  <td align="left" valign="top" style="font-family: arial, Verdana, sans-serif; font-size:14px; color:#333333">
										  <!-- START Message body 
										   TO DO: Need to account for this type: || approvalIdentifier eq 'ResellerUserRegistrationAdd'
										  -->
											<c:choose>
												 <c:when test="${approvalIdentifier eq 'ResellerOrgEntityRegistrationAdd'}">
													<fmt:message bundle="${storeText}" key="EMAIL_APPROVAL_BUYERREG_MESSAGE">
														<fmt:param value="${orgName}"/>
													</fmt:message>
												 </c:when>
												 <c:when test="${approvalIdentifier eq 'UserRegistrationAdd'}">
													<fmt:message bundle="${storeText}" key="EMAIL_APPROVAL_USERREG_MESSAGE">
														<fmt:param value="${logonId}"/>
														<fmt:param value="${orgName}"/>
														<fmt:param value="${storeName}"/>
													</fmt:message>
												 </c:when>
												 <c:when test="${approvalIdentifier eq 'OrderProcess'}">
													<fmt:message bundle="${storeText}" key="EMAIL_APPROVAL_ALT_ORDER_MESSAGE">
														<fmt:param value="${orderId}"/>
														<fmt:param value="${storeName}"/>
													</fmt:message>
												 </c:when>
												 <c:otherwise>
													<fmt:message bundle="${storeText}" key="EMAIL_APPROVAL_GENERIC_MESSAGE"/>
												 </c:otherwise>
											</c:choose>
										   <!-- END Message body -->
										  </td>
										</tr>
									  </tbody>
									</table>
							</td>
						</tr>
					</table>
				</td>
			</tr>	
		</table>  
		<table border="0" align="center" cellpadding="6" cellspacing="6">
		  <tbody>
			<tr>
			  <td align="left" valign="top" style="font-family: arial, Verdana, sans-serif; font-size: 11px; color:#666">
				<!-- Legal info. -->
				<fmt:message bundle="${storeText}" key="EMAIL_LEGAL_INFO_MESSAGE">
					<fmt:param value="${storeName}"/>
				</fmt:message>
			  </td>
			</tr>
		  </tbody>
		</table>
		<!-- Please leave spacers at bottom -->
		<p>&nbsp;</p>
		<p>&nbsp;</p>
	</body>
</html>

