package com.mycompany.search.internal.expression.provider;

import java.util.List;
import java.util.logging.Logger;

import com.ibm.commerce.foundation.common.util.logging.LoggingHelper;
import com.ibm.commerce.search.exception.SearchApplicationException;
import com.ibm.commerce.search.expression.SearchCriteria;
import com.ibm.commerce.search.expression.SearchExpressionConstants;
import com.ibm.commerce.search.expression.provider.SearchExpressionProvider;
import com.ibm.commerce.search.internal.config.SearchConfigurationRegistry;
import com.ibm.commerce.search.internal.expression.provider.AbstractSearchExpressionProvider;
import com.ibm.commerce.search.internal.util.EntitlementHelper;
import com.ibm.commerce.search.rest.SearchServiceConstants;

public class CustomizedExpressionProvider extends
AbstractSearchExpressionProvider implements SearchExpressionProvider{
	
	private static final String CLASSNAME = CustomizedExpressionProvider.class.getName();
	private static final Logger LOGGER = LoggingHelper
			.getLogger(CustomizedExpressionProvider.class);
	
	public void invoke(SearchCriteria searchCriteria)
			throws SearchApplicationException {
		final String METHODNAME = "invoke(SearchCriteria)";
		
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME,
					new Object[] { searchCriteria });
		}
		
		super.invoke(searchCriteria);
		
		resetControlParameter(SearchExpressionConstants.CTRL_PARAM_SEARCH_INTERNAL_SORT);
		String profile = getControlParameterValue(SearchExpressionConstants.CTRL_PARAM_SEARCH_PROFILE);
		SearchConfigurationRegistry searchRegistry = SearchConfigurationRegistry
				.getInstance();
		String currencyCode = getFinalControlParameterValue(SearchExpressionConstants.CTRL_PARAM_SEARCH_CURRENCY);
		String tempPhysicalField = searchRegistry.getIndexFieldName(
				profile, SearchServiceConstants.LOGICAL_NAME_PRICE_TAG);
		String pricePhysicalField = null;
		if (tempPhysicalField != null) {
			pricePhysicalField = tempPhysicalField.replace(
					SearchExpressionConstants.CURRENCY_CODE_WILD_CARD,
					currencyCode);
		}
		
		List<String>fieldWithPatternList =  EntitlementHelper.applyFieldNamingPattern(pricePhysicalField, searchCriteria);
		for (String priceSortFieldName : fieldWithPatternList) {
			String searchExpression = priceSortFieldName
					+ ' ' + SearchExpressionConstants.SORT_DIRECTION_ASCENDING;
			addControlParameterValue(SearchExpressionConstants.CTRL_PARAM_SEARCH_INTERNAL_SORT,searchExpression);
		}

		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}
}

}