/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.updaters;

import com.ibm.commerce.jpa.port.info.EntityInfo;
import com.ibm.commerce.jpa.port.info.ModuleInfo;
import com.ibm.commerce.jpa.port.util.BackupUtil;
import com.ibm.commerce.jpa.port.util.XMLUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IbmEjbAccessBeanXmiUpdater {
    private static final String EJB_SHADOW = "accessbean:EJBShadow";
    private static final String ENTERPRISE_BEAN = "enterpriseBean";
    private static final String HREF = "href";
    private IFile iFile;
    private ModuleInfo iModuleInfo;

    public IbmEjbAccessBeanXmiUpdater(IFile file, ModuleInfo moduleInfo) {
        this.iFile = file;
        this.iModuleInfo = moduleInfo;
    }

    public void update(IProgressMonitor progressMonitor) {
        try {
            try {
                progressMonitor.beginTask("update " + this.iFile.getName(), 300);
                boolean deleteFile = false;
                Document document = this.iModuleInfo.getXMLUtil().readXml(this.iFile);
                Element documentElement = document.getDocumentElement();
                if (EJB_SHADOW.equals(documentElement.getNodeName())) {
                    EntityInfo entityInfo = this.parseEJBShadowElement(documentElement);
                    if (entityInfo != null) {
                        deleteFile = true;
                    }
                } else {
                    deleteFile = this.updateXMIElement(documentElement);
                }
                progressMonitor.worked(100);
                BackupUtil backupUtil = this.iModuleInfo.getApplicationInfo().getBackupUtil(this.iModuleInfo.getJavaProject().getProject());
                backupUtil.backupFile3(this.iFile, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                if (deleteFile) {
                    this.iFile.delete(true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                } else {
                    this.iModuleInfo.getXMLUtil().writeXml(document, this.iFile, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                }
                this.iModuleInfo.getApplicationInfo().incrementUpdateCount();
            }
            catch (CoreException e) {
                e.printStackTrace();
                progressMonitor.done();
            }
        }
        finally {
            progressMonitor.done();
        }
    }

    private boolean updateXMIElement(Element documentElement) {
        boolean deleteFile = true;
        NodeList childNodes = documentElement.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Element element;
            String nodeName;
            Node node = childNodes.item(i);
            if (node.getNodeType() == 1 && EJB_SHADOW.equals(nodeName = (element = (Element)node).getNodeName())) {
                EntityInfo entityInfo = this.parseEJBShadowElement(element);
                if (entityInfo != null) {
                    i = XMLUtil.removeElement(element);
                } else {
                    deleteFile = false;
                }
            }
            ++i;
        }
        return deleteFile;
    }

    private EntityInfo parseEJBShadowElement(Element ejbShadowElement) {
        EntityInfo entityInfo = null;
        NodeList childNodes = ejbShadowElement.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Element element;
            String nodeName;
            Node node = childNodes.item(i);
            if (node.getNodeType() == 1 && ENTERPRISE_BEAN.equals(nodeName = (element = (Element)node).getNodeName())) {
                entityInfo = this.parseEnterpriseBeanElement(element);
            }
            ++i;
        }
        return entityInfo;
    }

    private EntityInfo parseEnterpriseBeanElement(Element enterpriseBeanElement) {
        EntityInfo entityInfo = null;
        String href = enterpriseBeanElement.getAttribute(HREF);
        int index = href.indexOf(35);
        if (index > -1) {
            String entityId = href.substring(index + 1);
            entityInfo = this.iModuleInfo.getEntityInfo(entityId);
        }
        return entityInfo;
    }
}

