/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.updaters;

import com.ibm.commerce.jpa.port.info.ModuleInfo;
import com.ibm.commerce.jpa.port.util.BackupUtil;
import com.ibm.commerce.jpa.port.util.XMLUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EjbJarXmlUpdater {
    private static final String ENTERPRISE_BEANS = "enterprise-beans";
    private static final String ENTITY = "entity";
    private static final String RELATIONSHIPS = "relationships";
    private static final String DISPLAY_NAME = "display-name";
    private static final String ASSEMBLY_DESCRIPTOR = "assembly-descriptor";
    private static final String SECURITY_ROLE = "security-role";
    private static final String METHOD_PERMISSION = "method-permission";
    private static final String METHOD = "method";
    private static final String EJB_NAME = "ejb-name";
    private IFile iFile;
    private ModuleInfo iModuleInfo;

    public EjbJarXmlUpdater(IFile file, ModuleInfo moduleInfo) {
        this.iFile = file;
        this.iModuleInfo = moduleInfo;
    }

    public void update(IProgressMonitor progressMonitor) {
        try {
            try {
                progressMonitor.beginTask("update " + this.iFile.getName(), 300);
                Document document = this.iModuleInfo.getXMLUtil().readXml(this.iFile);
                Element documentElement = document.getDocumentElement();
                boolean deleteFile = this.updateEjbJarElement(documentElement);
                progressMonitor.worked(100);
                BackupUtil backupUtil = this.iModuleInfo.getApplicationInfo().getBackupUtil(this.iModuleInfo.getJavaProject().getProject());
                backupUtil.backupFile3(this.iFile, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                if (deleteFile) {
                    this.iFile.delete(true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                } else {
                    this.iModuleInfo.getXMLUtil().writeXml(document, this.iFile, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                }
                this.iModuleInfo.getApplicationInfo().incrementUpdateCount();
            }
            catch (CoreException e) {
                e.printStackTrace();
                progressMonitor.done();
            }
        }
        finally {
            progressMonitor.done();
        }
    }

    private boolean updateEjbJarElement(Element documentElement) {
        boolean deleteFile = true;
        NodeList childNodes = documentElement.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = childNodes.item(i);
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                String nodeName = element.getNodeName();
                if (ENTERPRISE_BEANS.equals(nodeName)) {
                    if (!this.updateEnterpriseBeansElement(element)) {
                        deleteFile = false;
                    }
                } else if (RELATIONSHIPS.equals(nodeName)) {
                    i = XMLUtil.removeElement(element);
                } else if (!DISPLAY_NAME.equals(nodeName)) {
                    if (ASSEMBLY_DESCRIPTOR.equals(nodeName)) {
                        if (this.updateAssemblyDescriptorElement(element)) {
                            i = XMLUtil.removeElement(element);
                        }
                    } else {
                        deleteFile = false;
                    }
                }
            }
            ++i;
        }
        return deleteFile;
    }

    private boolean updateEnterpriseBeansElement(Element enterpriseBeansElement) {
        boolean deleteFile = true;
        NodeList childNodes = enterpriseBeansElement.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = childNodes.item(i);
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                String nodeName = element.getNodeName();
                if (ENTITY.equals(nodeName)) {
                    i = XMLUtil.removeElement(element);
                } else {
                    deleteFile = false;
                }
            }
            ++i;
        }
        return deleteFile;
    }

    private boolean updateAssemblyDescriptorElement(Element assemblyDescriptorElement) {
        boolean deleteAssemblyDescriptor = true;
        NodeList childNodes = assemblyDescriptorElement.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = childNodes.item(i);
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                String nodeName = element.getNodeName();
                if (SECURITY_ROLE.equals(nodeName)) {
                    deleteAssemblyDescriptor = false;
                } else if (METHOD_PERMISSION.equals(nodeName)) {
                    if (this.updateMethodPermissionElement(element)) {
                        i = XMLUtil.removeElement(element);
                    } else {
                        deleteAssemblyDescriptor = false;
                    }
                } else {
                    deleteAssemblyDescriptor = false;
                }
            }
            ++i;
        }
        return deleteAssemblyDescriptor;
    }

    private boolean updateMethodPermissionElement(Element methodPermissionElement) {
        boolean deleteMethodPermissionElement = true;
        NodeList childNodes = methodPermissionElement.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Element element;
            String nodeName;
            Node node = childNodes.item(i);
            if (node.getNodeType() == 1 && METHOD.equals(nodeName = (element = (Element)node).getNodeName())) {
                if (this.checkMethodElement(element)) {
                    i = XMLUtil.removeElement(element);
                } else {
                    deleteMethodPermissionElement = false;
                }
            }
            ++i;
        }
        return deleteMethodPermissionElement;
    }

    private boolean checkMethodElement(Element methodElement) {
        boolean removeMethodElement = false;
        NodeList childNodes = methodElement.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Element element;
            String nodeName;
            Node node = childNodes.item(i);
            if (node.getNodeType() == 1 && EJB_NAME.equals(nodeName = (element = (Element)node).getNodeName()) && this.iModuleInfo.getEntityInfoByName(XMLUtil.getElementText(element)) != null) {
                removeMethodElement = true;
            }
            ++i;
        }
        return removeMethodElement;
    }
}

