/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.port.util;

import com.ibm.commerce.jpa.logger.LoggerHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.util.HashSet;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

public class XMLUtil {
    private static final Logger LOGGER = LoggerHelper.getLogger(XMLUtil.class);
    private DocumentBuilder iDocumentBuilder = null;
    private LSSerializer iLSSerializer = null;
    private LSOutput iLSOutput = null;
    private DOMImplementationLS iDOMImplementationLS = null;

    public XMLUtil() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            this.iDocumentBuilder = documentBuilderFactory.newDocumentBuilder();
            this.iDOMImplementationLS = (DOMImplementationLS)this.iDocumentBuilder.getDOMImplementation().getFeature("LS", "3.0");
            this.iLSOutput = this.iDOMImplementationLS.createLSOutput();
            this.iLSSerializer = this.iDOMImplementationLS.createLSSerializer();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeXml(Document document, IFile file, IProgressMonitor progressMonitor) {
        ByteArrayOutputStream outputStream = null;
        ByteArrayInputStream inputStream = null;
        try {
            try {
                outputStream = new ByteArrayOutputStream();
                this.iLSOutput.setByteStream(outputStream);
                this.iLSSerializer.write(document, this.iLSOutput);
                byte[] byteArray = outputStream.toByteArray();
                outputStream.close();
                inputStream = new ByteArrayInputStream(byteArray);
                file.setContents((InputStream)inputStream, true, false, progressMonitor);
                inputStream = null;
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (Exception e3) {
                    e3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Document readXml(IFile file) {
        Document document = null;
        try {
            document = this.readXml(file.getContents());
        }
        catch (Exception e) {
            LOGGER.info("problem reading " + file.getFullPath().toString() + " " + file.getName());
            e.printStackTrace();
        }
        return document;
    }

    public Document readXml(File file) {
        Document document = null;
        try {
            document = this.iDocumentBuilder.parse(file);
        }
        catch (Exception e) {
            LOGGER.info("problem reading " + file);
            e.printStackTrace();
        }
        return document;
    }

    public Document readXml(InputStream inputStream) {
        Document document = null;
        try {
            document = this.iDocumentBuilder.parse(inputStream);
            inputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return document;
    }

    public Document createXml() {
        return this.iDocumentBuilder.newDocument();
    }

    public void mergeXml(Document document, IFile file, IProgressMonitor progressMonitor) {
        Document targetDocument = this.readXml(file);
        Element targetElement = targetDocument.getDocumentElement();
        NodeList nodeList = document.getDocumentElement().getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            targetDocument.adoptNode(node);
            targetElement.appendChild(node);
            --i;
            ++i;
        }
        this.writeXml(targetDocument, file, progressMonitor);
    }

    public static String getElementText(Element element) {
        String text = "";
        Node node = element.getFirstChild();
        while (node != null) {
            text = String.valueOf(text) + ((Text)node).getData();
            node = node.getNextSibling();
        }
        return text;
    }

    public static int removeElement(Element element) {
        int newPosition = -1;
        Node parentNode = element.getParentNode();
        if (parentNode.getNodeType() == 1) {
            Element parentElement = (Element)parentNode;
            NodeList nodeList = parentElement.getChildNodes();
            HashSet<Node> deletePendingNodes = new HashSet<Node>();
            int i = 0;
            block0: while (i < nodeList.getLength()) {
                if (nodeList.item(i) == element) {
                    parentElement.removeChild(element);
                    newPosition = i - 1;
                    while (newPosition >= 0) {
                        Node node = nodeList.item(i);
                        if (node == null) {
                            LOGGER.info("newPosition=" + newPosition + " length=" + nodeList.getLength());
                        }
                        if (node.getNodeType() == 1) break block0;
                        deletePendingNodes.add(node);
                        --newPosition;
                    }
                    break;
                }
                ++i;
            }
            for (Node node : deletePendingNodes) {
                parentElement.removeChild(node);
            }
        }
        return newPosition;
    }
}

