/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.port.util;

import com.ibm.commerce.jpa.port.util.ImportUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTParser;

public class ResolveImportsUtil {
    private IProject iProject;
    private IFile iGeneratedFileListFile;
    private ASTParser iASTParser;

    public ResolveImportsUtil(ASTParser astParser, IProject project, IFile generatedFileListFile) {
        this.iASTParser = astParser;
        this.iProject = project;
        this.iGeneratedFileListFile = generatedFileListFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean resolveImports(IProgressMonitor progressMonitor) throws CoreException {
        boolean importsResolved = false;
        try {
            progressMonitor.beginTask("resolve imports for " + this.iProject.getName(), -1);
            if (!this.iGeneratedFileListFile.exists()) return importsResolved;
            InputStream inputStream = this.iGeneratedFileListFile.getContents(true);
            try {
                try {
                    InputStreamReader reader = new InputStreamReader(inputStream);
                    BufferedReader bufferedReader = new BufferedReader(reader);
                    String portableString = bufferedReader.readLine();
                    while (portableString != null) {
                        if (progressMonitor.isCanceled()) {
                            return importsResolved;
                        }
                        IPath path = Path.fromPortableString((String)portableString);
                        IFile generatedFile = this.iProject.getFile(path);
                        if (generatedFile.exists()) {
                            importsResolved = true;
                            ICompilationUnit compilationUnit = JavaCore.createCompilationUnitFrom((IFile)generatedFile);
                            ImportUtil.resolveImports(this.iASTParser, compilationUnit, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                        }
                        portableString = bufferedReader.readLine();
                    }
                    return importsResolved;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        inputStream.close();
                        return importsResolved;
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                        return importsResolved;
                    }
                }
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            progressMonitor.done();
        }
    }
}

