/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.port.util;

import com.ibm.commerce.jpa.port.generators.PortVisitor;
import com.ibm.commerce.jpa.port.info.AccessBeanInfo;
import com.ibm.commerce.jpa.port.info.ApplicationInfo;
import com.ibm.commerce.jpa.port.info.EntityInfo;
import com.ibm.commerce.jpa.port.info.FieldInfo;
import com.ibm.commerce.jpa.port.info.KeyClassConstructorInfo;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;

public class PrimaryKeyUtil {
    private static final String STRING = "java.lang.String";
    private static final String TO_STRING = "toString";
    private static final String IN_ENTITY_TYPE = "InEntityType";
    private static final String GET_PRIMARY_KEY = "getPrimaryKey";

    public static boolean isPrimaryKeyFieldAccess(ApplicationInfo applicationInfo, FieldAccess fieldAccess) {
        String qualifiedName;
        ITypeBinding typeBinding;
        boolean match = false;
        if (fieldAccess.getExpression() != null && (typeBinding = fieldAccess.getExpression().resolveTypeBinding()) != null && applicationInfo.isEntityKeyType(qualifiedName = typeBinding.getQualifiedName())) {
            EntityInfo entityInfo = applicationInfo.getEntityInfoForType(qualifiedName);
            match = entityInfo.getFieldInfoByName(fieldAccess.getName().getIdentifier()) != null;
        }
        return match;
    }

    public static boolean portPrimaryKeyFieldAccess(ApplicationInfo applicationInfo, FieldAccess fieldAccess, PortVisitor portVisitor) {
        boolean visitChildren = true;
        Expression keyObjectExpression = fieldAccess.getExpression();
        AccessBeanExpressionVisitor accessBeanExpressionVisitor = new AccessBeanExpressionVisitor(applicationInfo);
        keyObjectExpression.accept((ASTVisitor)accessBeanExpressionVisitor);
        String fieldName = fieldAccess.getName().getIdentifier();
        EntityInfo entityInfo = applicationInfo.getEntityInfoForType(keyObjectExpression.resolveTypeBinding().getQualifiedName());
        FieldInfo fieldInfo = entityInfo.getFieldInfoByName(fieldName);
        AST ast = fieldAccess.getAST();
        String getterName = fieldInfo.getTargetGetterName();
        if (accessBeanExpressionVisitor.getAccessBeanExpression() != null) {
            MethodInvocation newMethodInvocation = ast.newMethodInvocation();
            if (fieldInfo.getHasStringConversionAccessMethod()) {
                getterName = String.valueOf(getterName) + IN_ENTITY_TYPE;
            }
            newMethodInvocation.setName(ast.newSimpleName(getterName));
            Expression accessBeanExpression = accessBeanExpressionVisitor.getAccessBeanExpression();
            accessBeanExpression.accept((ASTVisitor)portVisitor);
            accessBeanExpression.delete();
            newMethodInvocation.setExpression(accessBeanExpression);
            portVisitor.replaceASTNode((ASTNode)fieldAccess, (ASTNode)newMethodInvocation);
            visitChildren = false;
        } else if (entityInfo.getEntityKeyClassInfo() != null) {
            MethodInvocation newMethodInvocation = ast.newMethodInvocation();
            newMethodInvocation.setName(ast.newSimpleName(getterName));
            keyObjectExpression.accept((ASTVisitor)portVisitor);
            newMethodInvocation.setExpression((Expression)ASTNode.copySubtree((AST)ast, (ASTNode)keyObjectExpression));
            portVisitor.replaceASTNode((ASTNode)fieldAccess, (ASTNode)newMethodInvocation);
            visitChildren = false;
        } else if (entityInfo.getKeyFields().size() == 1) {
            portVisitor.replaceASTNode((ASTNode)fieldAccess, ASTNode.copySubtree((AST)ast, (ASTNode)keyObjectExpression));
            visitChildren = false;
        }
        return visitChildren;
    }

    public static boolean isPrimaryKeyMethodInvocation(ApplicationInfo applicationInfo, MethodInvocation methodInvocation, PortVisitor portVisitor) {
        String qualifiedName;
        ITypeBinding typeBinding;
        boolean match = false;
        if (methodInvocation.getExpression() != null && (typeBinding = methodInvocation.getExpression().resolveTypeBinding()) != null && applicationInfo.isEntityKeyType(qualifiedName = typeBinding.getQualifiedName())) {
            EntityInfo entityInfo = applicationInfo.getEntityInfoForType(qualifiedName);
            match = entityInfo.getFieldInfoByGetterName(methodInvocation.getName().getIdentifier()) != null;
        }
        return match;
    }

    public static boolean portPrimaryKeyMethodInvocation(ApplicationInfo applicationInfo, MethodInvocation methodInvocation, PortVisitor portVisitor) {
        boolean visitChildren = true;
        Expression keyObjectExpression = methodInvocation.getExpression();
        AccessBeanExpressionVisitor accessBeanExpressionVisitor = new AccessBeanExpressionVisitor(applicationInfo);
        keyObjectExpression.accept((ASTVisitor)accessBeanExpressionVisitor);
        String methodName = methodInvocation.getName().getIdentifier();
        EntityInfo entityInfo = applicationInfo.getEntityInfoForType(keyObjectExpression.resolveTypeBinding().getQualifiedName());
        FieldInfo fieldInfo = entityInfo.getFieldInfoByGetterName(methodName);
        AST ast = methodInvocation.getAST();
        String getterName = fieldInfo.getTargetGetterName();
        if (accessBeanExpressionVisitor.getAccessBeanExpression() != null) {
            MethodInvocation newMethodInvocation = ast.newMethodInvocation();
            if (fieldInfo.getHasStringConversionAccessMethod()) {
                getterName = String.valueOf(getterName) + IN_ENTITY_TYPE;
            }
            newMethodInvocation.setName(ast.newSimpleName(getterName));
            Expression accessBeanExpression = accessBeanExpressionVisitor.getAccessBeanExpression();
            accessBeanExpression.accept((ASTVisitor)portVisitor);
            accessBeanExpression.delete();
            newMethodInvocation.setExpression(accessBeanExpression);
            portVisitor.replaceASTNode((ASTNode)methodInvocation, (ASTNode)newMethodInvocation);
            visitChildren = false;
        } else if (entityInfo.getEntityKeyClassInfo() != null) {
            MethodInvocation newMethodInvocation = ast.newMethodInvocation();
            if (fieldInfo.getRelatedEntityInfo() != null) {
                getterName = fieldInfo.getRelatedEntityInfo().getGetterName();
            }
            newMethodInvocation.setName(ast.newSimpleName(getterName));
            keyObjectExpression.accept((ASTVisitor)portVisitor);
            newMethodInvocation.setExpression((Expression)ASTNode.copySubtree((AST)ast, (ASTNode)keyObjectExpression));
            portVisitor.replaceASTNode((ASTNode)methodInvocation, (ASTNode)newMethodInvocation);
            visitChildren = false;
        } else if (entityInfo.getKeyFields().size() == 1) {
            portVisitor.replaceASTNode((ASTNode)methodInvocation, ASTNode.copySubtree((AST)ast, (ASTNode)keyObjectExpression));
            visitChildren = false;
        }
        return visitChildren;
    }

    public static boolean isPrimaryKeyQualifiedName(ApplicationInfo applicationInfo, QualifiedName qualifiedName) {
        String typeName;
        boolean match = false;
        ITypeBinding typeBinding = qualifiedName.getQualifier().resolveTypeBinding();
        if (typeBinding != null && applicationInfo.isEntityKeyType(typeName = typeBinding.getQualifiedName())) {
            EntityInfo entityInfo = applicationInfo.getEntityInfoForType(typeName);
            match = entityInfo.getFieldInfoByName(qualifiedName.getName().getIdentifier()) != null;
        }
        return match;
    }

    public static boolean portPrimaryQualifiedName(ApplicationInfo applicationInfo, QualifiedName qualifiedName, PortVisitor portVisitor) {
        String getterName;
        boolean visitChildren = true;
        Name keyObjectName = qualifiedName.getQualifier();
        String fieldName = qualifiedName.getName().getIdentifier();
        EntityInfo entityInfo = applicationInfo.getEntityInfoForType(keyObjectName.resolveTypeBinding().getQualifiedName());
        FieldInfo fieldInfo = entityInfo.getFieldInfoByName(fieldName);
        AST ast = qualifiedName.getAST();
        String string = getterName = fieldInfo.getRelatedEntityInfo() == null ? fieldInfo.getTargetGetterName() : fieldInfo.getRelatedEntityInfo().getGetterName();
        if (entityInfo.getEntityKeyClassInfo() != null) {
            MethodInvocation newMethodInvocation = ast.newMethodInvocation();
            newMethodInvocation.setName(ast.newSimpleName(getterName));
            keyObjectName.accept((ASTVisitor)portVisitor);
            newMethodInvocation.setExpression((Expression)((Name)ASTNode.copySubtree((AST)ast, (ASTNode)keyObjectName)));
            portVisitor.replaceASTNode((ASTNode)qualifiedName, (ASTNode)newMethodInvocation);
            visitChildren = false;
        } else if (entityInfo.getKeyFields().size() == 1) {
            portVisitor.replaceASTNode((ASTNode)qualifiedName, ASTNode.copySubtree((AST)ast, (ASTNode)keyObjectName));
            visitChildren = false;
        }
        return visitChildren;
    }

    public static boolean isPrimaryKeyClassInstanceCreation(ApplicationInfo applicationInfo, ClassInstanceCreation classInstanceCreation) {
        boolean match = false;
        ITypeBinding typeBinding = classInstanceCreation.resolveTypeBinding();
        if (typeBinding != null && applicationInfo.isEntityKeyType(typeBinding.getQualifiedName())) {
            match = true;
        }
        return match;
    }

    public static boolean portPrimaryKeyClassInstanceCreation(ApplicationInfo applicationInfo, ClassInstanceCreation classInstanceCreation, PortVisitor portVisitor) {
        boolean visitChildren = true;
        List arguments = classInstanceCreation.arguments();
        if (arguments.size() == 1) {
            ((Expression)arguments.get(0)).accept((ASTVisitor)portVisitor);
            Expression key = (Expression)arguments.get(0);
            key.delete();
            portVisitor.replaceASTNode((ASTNode)classInstanceCreation, (ASTNode)key);
            visitChildren = false;
        }
        return visitChildren;
    }

    public static List<Expression> getPortedInitKeyArguments(EntityInfo entityInfo, ClassInstanceCreation classInstanceCreation, PortVisitor portVisitor) {
        ArrayList<Expression> portedInitKeyArguments = new ArrayList<Expression>();
        List<FieldInfo> entityKeyFields = entityInfo.getKeyFields();
        int i = 0;
        while (i < entityKeyFields.size()) {
            portedInitKeyArguments.add(null);
            ++i;
        }
        List arguments = classInstanceCreation.arguments();
        KeyClassConstructorInfo constructorInfo = PrimaryKeyUtil.getMatchingKeyClassConstructorInfo(entityInfo, arguments);
        if (constructorInfo != null) {
            List<FieldInfo> constructorFields = constructorInfo.getFields();
            for (FieldInfo fieldInfo : constructorFields) {
                AccessBeanInfo.NullConstructorParameter nullConstructorParameter;
                String argumentType;
                int fieldIndex = entityKeyFields.indexOf(fieldInfo);
                ITypeBinding argumentTypeBinding = ((Expression)arguments.get(0)).resolveTypeBinding();
                ((Expression)arguments.get(0)).accept((ASTVisitor)portVisitor);
                Expression argument = (Expression)arguments.get(0);
                argument.delete();
                if (argumentTypeBinding != null && !STRING.equals(argumentType = argumentTypeBinding.getQualifiedName()) && (nullConstructorParameter = entityInfo.getAccessBeanInfo().getNullConstructorParameterByName(fieldInfo.getFieldName())) != null && nullConstructorParameter.getConverterClassName() != null) {
                    argument = PrimaryKeyUtil.convertExpressionToString(argument);
                }
                portedInitKeyArguments.set(fieldIndex, argument);
            }
        }
        return portedInitKeyArguments;
    }

    public static KeyClassConstructorInfo getMatchingKeyClassConstructorInfo(EntityInfo entityInfo, List<Expression> arguments) {
        KeyClassConstructorInfo matchingConstructorInfo = null;
        List<KeyClassConstructorInfo> keyClassConstructors = entityInfo.getKeyClassConstructors();
        if (keyClassConstructors != null) {
            for (KeyClassConstructorInfo current : keyClassConstructors) {
                if (arguments.size() != current.getFields().size()) continue;
                matchingConstructorInfo = current;
                break;
            }
        }
        return matchingConstructorInfo;
    }

    public static Expression convertExpressionToString(Expression expression) {
        AST ast = expression.getAST();
        if (expression.getNodeType() == 16) {
            MethodInvocation argumentToStringMethodInvocation;
            ConditionalExpression conditionalExpression = (ConditionalExpression)expression;
            if (conditionalExpression.getThenExpression().getNodeType() != 33) {
                Expression thenExpression = conditionalExpression.getThenExpression();
                argumentToStringMethodInvocation = ast.newMethodInvocation();
                argumentToStringMethodInvocation.setName(ast.newSimpleName(TO_STRING));
                conditionalExpression.setThenExpression((Expression)argumentToStringMethodInvocation);
                argumentToStringMethodInvocation.setExpression(thenExpression);
            }
            if (conditionalExpression.getElseExpression().getNodeType() != 33) {
                Expression elseExpression = conditionalExpression.getElseExpression();
                argumentToStringMethodInvocation = ast.newMethodInvocation();
                argumentToStringMethodInvocation.setName(ast.newSimpleName(TO_STRING));
                conditionalExpression.setElseExpression((Expression)argumentToStringMethodInvocation);
                argumentToStringMethodInvocation.setExpression(elseExpression);
            }
        } else {
            MethodInvocation argumentToStringMethodInvocation = ast.newMethodInvocation();
            argumentToStringMethodInvocation.setName(ast.newSimpleName(TO_STRING));
            argumentToStringMethodInvocation.setExpression(expression);
            expression = argumentToStringMethodInvocation;
        }
        return expression;
    }

    public static boolean isPrimaryKeyAssignment(ApplicationInfo applicationInfo, Assignment assignment) {
        QualifiedName qualifiedName;
        ITypeBinding typeBinding;
        boolean primaryKeyAssignment = false;
        Expression leftHandSide = assignment.getLeftHandSide();
        if (leftHandSide.getNodeType() == 22) {
            FieldAccess fieldAccess = (FieldAccess)leftHandSide;
            ITypeBinding typeBinding2 = fieldAccess.getExpression().resolveTypeBinding();
            if (typeBinding2 != null && applicationInfo.isEntityKeyType(typeBinding2.getQualifiedName())) {
                primaryKeyAssignment = true;
            }
        } else if (leftHandSide.getNodeType() == 40 && (typeBinding = (qualifiedName = (QualifiedName)leftHandSide).getQualifier().resolveTypeBinding()) != null && applicationInfo.isEntityKeyType(typeBinding.getQualifiedName())) {
            primaryKeyAssignment = true;
        }
        return primaryKeyAssignment;
    }

    public static boolean portPrimaryKeyAssignment(ApplicationInfo applicationInfo, Assignment assignment, PortVisitor portVisitor) {
        boolean visitChildren = true;
        Expression leftHandSide = assignment.getLeftHandSide();
        Expression keyObjectExpression = null;
        String fieldName = null;
        if (leftHandSide.getNodeType() == 22) {
            FieldAccess fieldAccess = (FieldAccess)leftHandSide;
            fieldAccess.getExpression().accept((ASTVisitor)portVisitor);
            keyObjectExpression = fieldAccess.getExpression();
            fieldName = fieldAccess.getName().getIdentifier();
        } else if (leftHandSide.getNodeType() == 40) {
            QualifiedName qualifiedName = (QualifiedName)leftHandSide;
            keyObjectExpression = qualifiedName.getQualifier();
            fieldName = qualifiedName.getName().getIdentifier();
        }
        EntityInfo entityInfo = applicationInfo.getEntityInfoForType(keyObjectExpression.resolveTypeBinding().getQualifiedName());
        FieldInfo fieldInfo = entityInfo.getFieldInfoByName(fieldName);
        AST ast = assignment.getAST();
        String setterName = fieldInfo.getTargetSetterName();
        if (entityInfo.getEntityKeyClassInfo() != null) {
            MethodInvocation newMethodInvocation = ast.newMethodInvocation();
            newMethodInvocation.setName(ast.newSimpleName(setterName));
            newMethodInvocation.setExpression((Expression)ASTNode.copySubtree((AST)ast, (ASTNode)keyObjectExpression));
            assignment.getRightHandSide().accept((ASTVisitor)portVisitor);
            List arguments = newMethodInvocation.arguments();
            arguments.add((Expression)ASTNode.copySubtree((AST)ast, (ASTNode)assignment.getRightHandSide()));
            portVisitor.replaceASTNode((ASTNode)assignment, (ASTNode)newMethodInvocation);
            visitChildren = false;
        }
        return visitChildren;
    }

    public static boolean isGetPrimaryKeyCastExpression(ApplicationInfo applicationInfo, CastExpression castExpression) {
        boolean result = false;
        ITypeBinding typeBinding = castExpression.getType().resolveBinding();
        Expression expression = castExpression.getExpression();
        if (typeBinding != null && applicationInfo.isEntityKeyType(typeBinding.getQualifiedName()) && expression.getNodeType() == 32) {
            MethodInvocation methodInvocation = (MethodInvocation)expression;
            result = methodInvocation.getName().getIdentifier().equals(GET_PRIMARY_KEY) && methodInvocation.getExpression() != null && methodInvocation.getExpression().resolveTypeBinding() != null && applicationInfo.isEntityInterfaceType(methodInvocation.getExpression().resolveTypeBinding().getQualifiedName());
        }
        return result;
    }

    public static boolean portGetPrimaryKeyCastExpression(ApplicationInfo applicationInfo, CastExpression castExpression, PortVisitor portVisitor) {
        boolean visitChildren = true;
        MethodInvocation methodInvocation = (MethodInvocation)castExpression.getExpression();
        EntityInfo entityInfo = applicationInfo.getEntityInfoForType(methodInvocation.getExpression().resolveTypeBinding().getQualifiedName());
        List<FieldInfo> keyFields = entityInfo.getKeyFields();
        if (keyFields.size() == 1) {
            AST ast = methodInvocation.getAST();
            MethodInvocation newMethodInvocation = ast.newMethodInvocation();
            newMethodInvocation.setName(ast.newSimpleName(keyFields.get(0).getTargetGetterName()));
            Expression expression = methodInvocation.getExpression();
            expression.delete();
            newMethodInvocation.setExpression(expression);
            expression.accept((ASTVisitor)portVisitor);
            portVisitor.replaceASTNode((ASTNode)castExpression, (ASTNode)newMethodInvocation);
            visitChildren = false;
        }
        return visitChildren;
    }

    public static class AccessBeanExpressionVisitor
    extends ASTVisitor {
        private ApplicationInfo iApplicationInfo;
        private Expression iAccessBeanExpression;

        public AccessBeanExpressionVisitor(ApplicationInfo applicationInfo) {
            this.iApplicationInfo = applicationInfo;
        }

        public void preVisit(ASTNode node) {
            String qualifiedName;
            ITypeBinding typeBinding;
            if (node instanceof Expression && (typeBinding = ((Expression)node).resolveTypeBinding()) != null && (this.iApplicationInfo.isAccessBeanType(qualifiedName = typeBinding.getQualifiedName()) || this.iApplicationInfo.isDataClassType(qualifiedName))) {
                this.iAccessBeanExpression = (Expression)node;
            }
        }

        public Expression getAccessBeanExpression() {
            return this.iAccessBeanExpression;
        }
    }
}

