/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.port.util;

import com.ibm.commerce.jpa.logger.LoggerHelper;
import com.ibm.commerce.jpa.port.info.ApplicationInfo;
import com.ibm.commerce.jpa.port.info.ProjectInfo;
import com.ibm.commerce.jpa.port.util.ApplicationInfoUtil;
import com.ibm.commerce.jpa.port.util.FinderResultCacheUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class EntityReferenceUtil {
    private static final Logger LOGGER = LoggerHelper.getLogger(EntityReferenceUtil.class);
    private static final Map<String, Collection<String>> PREDEFINED_INDIRECT_ENTITY_REFERENCING_TYPES = new HashMap<String, Collection<String>>();
    private static final Collection<String> PORT_EXEMPT_ENTITY_REFERENCING_TYPES = new HashSet<String>();

    public static void loadPredefinedEntityReferences(ApplicationInfo applicationInfo, IWorkspaceRoot workspaceRoot) {
        Set<String> predefinedProjects = PREDEFINED_INDIRECT_ENTITY_REFERENCING_TYPES.keySet();
        for (String predefinedProject : predefinedProjects) {
            ProjectInfo projectInfo = applicationInfo.getProjectInfo(workspaceRoot.getProject(predefinedProject));
            Collection<String> predefinedEntityReferencingTypes = PREDEFINED_INDIRECT_ENTITY_REFERENCING_TYPES.get(predefinedProject);
            for (String predefinedEntityReferencingType : predefinedEntityReferencingTypes) {
                try {
                    IType type = projectInfo.getJavaProject().findType(predefinedEntityReferencingType);
                    if (type == null) {
                        LOGGER.info("bad predefined type: " + predefinedEntityReferencingType);
                    }
                    ApplicationInfoUtil.addJpaStubTypeMapping(applicationInfo, type);
                    projectInfo.addIndirectEntityReferencingType(predefinedEntityReferencingType);
                }
                catch (JavaModelException e) {
                    LOGGER.info("[PD]bad predefined type: " + predefinedEntityReferencingType);
                    LOGGER.info("[PD]bad predefined project: " + predefinedProject);
                    e.printStackTrace();
                }
            }
        }
    }

    public static boolean isPortExemptEntityReferencingType(IType type) {
        return FinderResultCacheUtil.isFinderResultCacheUtil(type) || PORT_EXEMPT_ENTITY_REFERENCING_TYPES.contains(type.getFullyQualifiedName('.'));
    }
}

