/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.port.util;

import com.ibm.commerce.jpa.logger.LoggerHelper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;

public class BackupUtil {
    private static final Logger LOGGER = LoggerHelper.getLogger(BackupUtil.class);
    private IProject iProject;
    private IFolder iBackupFolder2;
    private IFolder iBackupFolder3;
    private IFile iGeneratedFileListFile;
    private IFile iGeneratedFileList2File;
    private IFile iGeneratedFileList3File;

    public BackupUtil(IProject project) {
        this.iProject = project;
        this.iBackupFolder2 = this.iProject.getFolder(".jpaBackup2");
        this.iBackupFolder3 = this.iProject.getFolder(".jpaBackup3");
        this.iGeneratedFileListFile = this.iProject.getFile(".jpaGeneratedFileList");
        this.iGeneratedFileList2File = this.iProject.getFile(".jpaGeneratedFileList2");
        this.iGeneratedFileList3File = this.iProject.getFile(".jpaGeneratedFileList3");
    }

    public void backupFile2(IFile file, IProgressMonitor progressMonitor) throws CoreException {
        try {
            IFile backupFile;
            progressMonitor.beginTask("backup2 " + file.getName(), 200);
            if (!this.iBackupFolder2.exists()) {
                this.iBackupFolder2.create(true, true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
            }
            if (!(backupFile = this.iBackupFolder2.getFile(file.getProjectRelativePath())).exists()) {
                IFolder parentFolder = (IFolder)backupFile.getParent();
                this.createFolder(parentFolder, progressMonitor);
                backupFile.create(file.getContents(), true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
            }
        }
        finally {
            progressMonitor.done();
        }
    }

    private void createFolder(IFolder folder, IProgressMonitor progressMonitor) throws CoreException {
        if (!folder.exists()) {
            IFolder parentFolder = (IFolder)folder.getParent();
            this.createFolder(parentFolder, progressMonitor);
            folder.create(true, true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
        }
    }

    public void backupFile3(IFile file, IProgressMonitor progressMonitor) throws CoreException {
        if (file.toString().contains("ProcessPromotionActivateActionCmdImpl")) {
            LOGGER.info("ProcessPromotionActivateActionCmdImpl");
        }
        try {
            IFile backupFile;
            progressMonitor.beginTask("backup " + file.getName(), 200);
            if (!this.iBackupFolder3.exists()) {
                this.iBackupFolder3.create(true, true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
            }
            if (!(backupFile = this.iBackupFolder3.getFile(file.getProjectRelativePath())).exists()) {
                IFolder parentFolder = (IFolder)backupFile.getParent();
                this.createFolder(parentFolder, progressMonitor);
                backupFile.create(file.getContents(), true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
            }
        }
        finally {
            progressMonitor.done();
        }
    }

    public void backupFolder3(IFolder folder, IProgressMonitor progressMonitor) throws CoreException {
        IResource[] members = folder.members();
        if (members != null) {
            try {
                progressMonitor.beginTask("backup " + folder.getName(), members.length * 100);
                IResource[] iResourceArray = members;
                int n = members.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource member = iResourceArray[n2];
                    if (member.getType() == 1) {
                        this.backupFile3((IFile)member, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                    } else if (member.getType() == 2) {
                        this.backupFolder3((IFolder)member, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                    }
                    ++n2;
                }
            }
            finally {
                progressMonitor.done();
            }
        }
    }

    public void addGeneratedFile(IFile file, IProgressMonitor progressMonitor) throws CoreException {
        try {
            progressMonitor.beginTask("add generated file " + file.getName(), 1000);
            IPath path = file.getProjectRelativePath();
            String portableString = String.valueOf(path.toPortableString()) + "\r\n";
            ByteArrayInputStream inputStream = new ByteArrayInputStream(portableString.getBytes());
            if (this.iGeneratedFileListFile.exists()) {
                this.iGeneratedFileListFile.appendContents((InputStream)inputStream, true, false, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1000));
            } else {
                this.iGeneratedFileListFile.create((InputStream)inputStream, true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1000));
            }
        }
        finally {
            progressMonitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGeneratedFile2(IFile file, IProgressMonitor progressMonitor) throws CoreException {
        try {
            progressMonitor.beginTask("add generated file2 " + file.getName(), 1000);
            IPath path = file.getProjectRelativePath();
            String portableString = String.valueOf(path.toPortableString()) + "\r\n";
            ByteArrayInputStream inputStream = new ByteArrayInputStream(portableString.getBytes());
            IFile iFile = this.iGeneratedFileList2File;
            synchronized (iFile) {
                if (this.iGeneratedFileList2File.exists()) {
                    this.iGeneratedFileList2File.appendContents((InputStream)inputStream, true, false, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1000));
                } else {
                    this.iGeneratedFileList2File.create((InputStream)inputStream, true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1000));
                }
            }
        }
        finally {
            progressMonitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGeneratedFile3(IFile file, IProgressMonitor progressMonitor) throws CoreException {
        try {
            progressMonitor.beginTask("add generated file 3 " + file.getName(), 1000);
            IPath path = file.getProjectRelativePath();
            String portableString = String.valueOf(path.toPortableString()) + "\r\n";
            ByteArrayInputStream inputStream = new ByteArrayInputStream(portableString.getBytes());
            IFile iFile = this.iGeneratedFileList3File;
            synchronized (iFile) {
                if (this.iGeneratedFileList3File.exists()) {
                    this.iGeneratedFileList3File.appendContents((InputStream)inputStream, true, false, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1000));
                } else {
                    this.iGeneratedFileList3File.create((InputStream)inputStream, true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1000));
                }
            }
        }
        finally {
            progressMonitor.done();
        }
    }

    public boolean restore(IProgressMonitor progressMonitor) throws CoreException {
        boolean restored;
        block15: {
            restored = false;
            try {
                block17: {
                    progressMonitor.beginTask("restore " + this.iProject.getName(), -1);
                    LOGGER.info("restore " + this.iProject.getName());
                    restored = this.restore2((IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                    if (!this.iGeneratedFileListFile.exists()) break block15;
                    InputStream inputStream = this.iGeneratedFileListFile.getContents(true);
                    try {
                        try {
                            InputStreamReader reader = new InputStreamReader(inputStream);
                            BufferedReader bufferedReader = new BufferedReader(reader);
                            String portableString = bufferedReader.readLine();
                            while (portableString != null) {
                                IPath path = Path.fromPortableString((String)portableString);
                                IFile generatedFile = this.iProject.getFile(path);
                                if (generatedFile.exists()) {
                                    generatedFile.delete(true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 10));
                                }
                                portableString = bufferedReader.readLine();
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            try {
                                inputStream.close();
                            }
                            catch (IOException e2) {
                                e2.printStackTrace();
                            }
                            break block17;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        throw throwable;
                    }
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                this.iGeneratedFileListFile.delete(true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 10));
                restored = true;
            }
            finally {
                progressMonitor.done();
            }
        }
        return restored;
    }

    public boolean restore2(IProgressMonitor progressMonitor) throws CoreException {
        boolean restored = false;
        try {
            progressMonitor.beginTask("restore2 " + this.iProject.getName(), -1);
            restored = this.restore3((IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
            if (this.iGeneratedFileList2File.exists()) {
                block19: {
                    InputStream inputStream = this.iGeneratedFileList2File.getContents(true);
                    try {
                        try {
                            InputStreamReader reader = new InputStreamReader(inputStream);
                            BufferedReader bufferedReader = new BufferedReader(reader);
                            String portableString = bufferedReader.readLine();
                            while (portableString != null) {
                                IPath path = Path.fromPortableString((String)portableString);
                                IFile generatedFile = this.iProject.getFile(path);
                                if (generatedFile.exists()) {
                                    generatedFile.delete(true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 10));
                                }
                                portableString = bufferedReader.readLine();
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            try {
                                inputStream.close();
                            }
                            catch (IOException e2) {
                                e2.printStackTrace();
                            }
                            break block19;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        throw throwable;
                    }
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                this.iGeneratedFileList2File.delete(true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 10));
                restored = true;
            }
            if (this.iBackupFolder2.exists()) {
                IResource[] members;
                IResource[] iResourceArray = members = this.iBackupFolder2.members();
                int n = members.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource member = iResourceArray[n2];
                    this.restoreFolder((IFolder)member, this.iProject.getFolder(member.getName()), (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                    ++n2;
                }
                this.iBackupFolder2.delete(true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 10));
                restored = true;
            }
        }
        finally {
            progressMonitor.done();
        }
        return restored;
    }

    public boolean restore3(IProgressMonitor progressMonitor) throws CoreException {
        boolean restored = false;
        try {
            progressMonitor.beginTask("restore3 " + this.iProject.getName(), -1);
            if (this.iGeneratedFileList3File.exists()) {
                HashSet<String> portableStrings;
                block19: {
                    portableStrings = new HashSet<String>();
                    InputStream inputStream = this.iGeneratedFileList3File.getContents(true);
                    try {
                        try {
                            InputStreamReader reader = new InputStreamReader(inputStream);
                            BufferedReader bufferedReader = new BufferedReader(reader);
                            String portableString = bufferedReader.readLine();
                            while (portableString != null) {
                                portableStrings.add(portableString);
                                portableString = bufferedReader.readLine();
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            try {
                                inputStream.close();
                            }
                            catch (IOException e2) {
                                e2.printStackTrace();
                            }
                            break block19;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        throw throwable;
                    }
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                this.iGeneratedFileList3File.delete(true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 10));
                for (String portableString : portableStrings) {
                    IPath path = Path.fromPortableString((String)portableString);
                    IFile generatedFile = this.iProject.getFile(path);
                    if (!generatedFile.exists()) continue;
                    generatedFile.delete(true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 10));
                    restored = true;
                }
            }
            if (this.iBackupFolder3.exists()) {
                IResource[] members;
                IResource[] iResourceArray = members = this.iBackupFolder3.members();
                int n = members.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource member = iResourceArray[n2];
                    this.restoreFolder((IFolder)member, this.iProject.getFolder(member.getName()), (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                    ++n2;
                }
                this.iBackupFolder3.delete(true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 10));
                this.iProject.build(15, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1000));
                restored = true;
            }
        }
        finally {
            progressMonitor.done();
        }
        return restored;
    }

    private void restoreFolder(IFolder folder, IFolder targetFolder, IProgressMonitor progressMonitor) throws CoreException {
        try {
            IResource[] members;
            progressMonitor.beginTask("restore folder " + folder.getName(), 200);
            if (!targetFolder.exists()) {
                targetFolder.create(true, true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
            }
            IResource[] iResourceArray = members = folder.members();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IResource member = iResourceArray[n2];
                if (member.getType() == 2) {
                    this.restoreFolder((IFolder)member, targetFolder.getFolder(member.getName()), (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                } else if (member.getType() == 1) {
                    IFile file = (IFile)member;
                    IFile targetFile = targetFolder.getFile(member.getName());
                    if (targetFile.exists()) {
                        targetFile.setContents(file.getContents(), true, false, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                    } else {
                        targetFile.create(file.getContents(), true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                    }
                }
                ++n2;
            }
        }
        finally {
            progressMonitor.done();
        }
    }
}

