/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.port.search;

import com.ibm.commerce.jpa.logger.LoggerHelper;
import com.ibm.commerce.jpa.port.info.ApplicationInfo;
import com.ibm.commerce.jpa.port.info.ProjectInfo;
import com.ibm.commerce.jpa.port.util.FinderResultCacheUtil;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;

public class EntitySearchUtil2 {
    private static final Logger LOGGER = LoggerHelper.getLogger(EntitySearchUtil2.class);
    private ApplicationInfo iApplicationInfo;
    private IWorkspace iWorkspace;
    private ProjectInfo iProjectInfo;
    private IJavaProject iJavaProject;
    private ASTParser iASTParser = ASTParser.newParser((int)3);
    private static Collection<String> EXEMPT_REFERENCES = new HashSet<String>();

    static {
        EXEMPT_REFERENCES.add("com.ibm.ivj.ejb.runtime.AbstractAccessBean");
        EXEMPT_REFERENCES.add("com.ibm.commerce.contract.objects.ContractJDBCHelperAccessBean");
        EXEMPT_REFERENCES.add("com.ibm.commerce.registry.StoreRegistry");
    }

    public EntitySearchUtil2(ApplicationInfo applicationInfo, IWorkspace workspace, ProjectInfo projectInfo) {
        this.iApplicationInfo = applicationInfo;
        this.iWorkspace = workspace;
        this.iProjectInfo = projectInfo;
        this.iJavaProject = projectInfo.getJavaProject();
    }

    public IStatus search(IProgressMonitor progressMonitor) {
        IStatus status = Status.OK_STATUS;
        try {
            try {
                progressMonitor.beginTask("search for entity references in " + this.iProjectInfo.getJavaProject().getElementName(), -1);
                long start = new Date().getTime();
                LOGGER.info("searching for entity references in " + this.iProjectInfo.getJavaProject().getElementName());
                if (this.isJavaProject(this.iJavaProject)) {
                    IClasspathEntry[] classpathEntries;
                    IClasspathEntry[] iClasspathEntryArray = classpathEntries = this.iJavaProject.getResolvedClasspath(true);
                    int n = classpathEntries.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IClasspathEntry entry = iClasspathEntryArray[n2];
                        if (progressMonitor.isCanceled()) {
                            status = Status.CANCEL_STATUS;
                            break;
                        }
                        if (entry.getEntryKind() == 3) {
                            IFolder sourceFolder;
                            if (entry.getPath().segmentCount() > 1 && (sourceFolder = this.iWorkspace.getRoot().getFolder(entry.getPath())).exists()) {
                                status = this.searchFolder(sourceFolder, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                            }
                            if (status == Status.CANCEL_STATUS) break;
                        }
                        ++n2;
                    }
                }
                LOGGER.info("end search in " + this.iProjectInfo.getJavaProject().getElementName() + " " + (new Date().getTime() - start) / 1000L + " seconds");
            }
            catch (CoreException e) {
                e.printStackTrace();
                progressMonitor.done();
            }
        }
        finally {
            progressMonitor.done();
        }
        return status;
    }

    private boolean isJavaProject(IJavaProject iJavaProject2) throws CoreException {
        String[] natures;
        boolean isJP = false;
        String[] stringArray = natures = iJavaProject2.getProject().getDescription().getNatureIds();
        int n = natures.length;
        int n2 = 0;
        while (n2 < n) {
            String nature = stringArray[n2];
            if (nature != null && nature.equals("org.eclipse.jdt.core.javanature")) {
                isJP = true;
            }
            ++n2;
        }
        return isJP;
    }

    private IStatus searchFolder(IFolder folder, IProgressMonitor progressMonitor) {
        IStatus status = Status.OK_STATUS;
        try {
            IResource[] members;
            IResource[] iResourceArray = members = folder.members();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IResource member = iResourceArray[n2];
                if (progressMonitor.isCanceled()) {
                    status = Status.CANCEL_STATUS;
                    break;
                }
                if (member.getType() == 1) {
                    this.searchFile((IFile)member, progressMonitor);
                } else if (member.getType() == 2 && (status = this.searchFolder((IFolder)member, progressMonitor)) == Status.CANCEL_STATUS) break;
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return status;
    }

    private void searchFile(IFile file, IProgressMonitor progressMonitor) {
        if (file.getName().endsWith(".java")) {
            ICompilationUnit compilationUnit = JavaCore.createCompilationUnitFrom((IFile)file);
            try {
                IType type;
                String qualifiedTypeName;
                if (!(compilationUnit.getTypes().length <= 0 || this.iApplicationInfo.isDeleteIntendedType(qualifiedTypeName = (type = compilationUnit.getTypes()[0]).getFullyQualifiedName('.')) || this.iApplicationInfo.isAccessBeanSubclass(qualifiedTypeName) || qualifiedTypeName.contains("JPA"))) {
                    this.iASTParser.setResolveBindings(true);
                    this.iASTParser.setSource(compilationUnit);
                    CompilationUnit astCompilationUnit = (CompilationUnit)this.iASTParser.createAST((IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                    SearchVisitor searchVisitor = new SearchVisitor();
                    astCompilationUnit.accept((ASTVisitor)searchVisitor);
                    if (searchVisitor.getContainsEntityReference()) {
                        this.iProjectInfo.addEntityReferencingType(compilationUnit.getTypes()[0].getFullyQualifiedName('.'));
                        this.iApplicationInfo.incrementSearchResultCount();
                    }
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    private class SearchVisitor
    extends ASTVisitor {
        private boolean iContainsEntityReference;

        private SearchVisitor() {
        }

        public boolean getContainsEntityReference() {
            return this.iContainsEntityReference;
        }

        public boolean visit(SimpleType simpleType) {
            ITypeBinding typeBinding = simpleType.resolveBinding();
            if (typeBinding != null) {
                String qualifiedTypeName = typeBinding.getQualifiedName();
                this.checkQualifiedTypeName(qualifiedTypeName);
            }
            return false;
        }

        public boolean visit(ParameterizedType parameterizedType) {
            ITypeBinding typeBinding = parameterizedType.resolveBinding();
            if (typeBinding != null) {
                String qualifiedTypeName = typeBinding.getTypeDeclaration().getQualifiedName();
                this.checkQualifiedTypeName(qualifiedTypeName);
            }
            return !this.iContainsEntityReference;
        }

        public boolean visit(SimpleName simpleName) {
            IBinding binding;
            if (!simpleName.isDeclaration() && (binding = simpleName.resolveBinding()) != null && binding.getKind() == 2) {
                ITypeBinding typeBinding = (ITypeBinding)binding;
                String qualifiedTypeName = typeBinding.getQualifiedName();
                this.checkQualifiedTypeName(qualifiedTypeName);
            }
            return false;
        }

        public boolean visit(QualifiedName qualifiedName) {
            String qualifiedTypeName;
            ITypeBinding typeBinding;
            IBinding binding = qualifiedName.resolveBinding();
            if (binding != null && binding.getKind() == 2) {
                typeBinding = (ITypeBinding)binding;
                qualifiedTypeName = typeBinding.getQualifiedName();
                this.checkQualifiedTypeName(qualifiedTypeName);
            }
            if (!this.iContainsEntityReference && (typeBinding = qualifiedName.getQualifier().resolveTypeBinding()) != null) {
                qualifiedTypeName = typeBinding.getQualifiedName();
                this.checkQualifiedTypeName(qualifiedTypeName);
            }
            if (!this.iContainsEntityReference) {
                qualifiedName.getQualifier().accept((ASTVisitor)this);
            }
            return !this.iContainsEntityReference;
        }

        public boolean visit(MethodInvocation methodInvocation) {
            ITypeBinding typeBinding;
            IMethodBinding methodBinding = methodInvocation.resolveMethodBinding();
            if (methodBinding != null && methodBinding.getDeclaringClass() != null && (typeBinding = methodBinding.getDeclaringClass()) != null) {
                if (FinderResultCacheUtil.isFinderResultCacheUtil(typeBinding)) {
                    this.iContainsEntityReference = true;
                } else {
                    String qualifiedTypeName = typeBinding.getQualifiedName();
                    this.checkQualifiedTypeName(qualifiedTypeName);
                }
            }
            return !this.iContainsEntityReference;
        }

        public boolean visit(FieldAccess fieldAccess) {
            ITypeBinding typeBinding;
            if (fieldAccess.getExpression() != null && (typeBinding = fieldAccess.getExpression().resolveTypeBinding()) != null) {
                String qualifiedTypeName = typeBinding.getQualifiedName();
                this.checkQualifiedTypeName(qualifiedTypeName);
            }
            return !this.iContainsEntityReference;
        }

        private void checkQualifiedTypeName(String qualifiedTypeName) {
            if (EntitySearchUtil2.this.iApplicationInfo.getTypeMapping(qualifiedTypeName) != null && !EXEMPT_REFERENCES.contains(qualifiedTypeName) || EntitySearchUtil2.this.iApplicationInfo.isDeleteIntendedType(qualifiedTypeName) || EntitySearchUtil2.this.iApplicationInfo.isAccessBeanSubclass(qualifiedTypeName)) {
                this.iContainsEntityReference = true;
            }
        }
    }
}

