/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.port.search;

import com.ibm.commerce.jpa.logger.LoggerHelper;
import com.ibm.commerce.jpa.port.info.ApplicationInfo;
import com.ibm.commerce.jpa.port.info.EntityInfo;
import com.ibm.commerce.jpa.port.search.EntitySearchPatternUtil;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.logging.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;

public class EntitySearchUtil {
    private static final Logger LOGGER = LoggerHelper.getLogger(EntitySearchUtil.class);
    private Collection<EntityInfo> iEntities;
    private ApplicationInfo iApplicationInfo;
    private Collection<String> iBinarySearchResults;
    private Collection<IType> iTypeSearchResults;

    public EntitySearchUtil(ApplicationInfo applicationInfo, Collection<EntityInfo> entities, Collection<String> binarySearchResults, Collection<IType> typeSearchResults) {
        this.iApplicationInfo = applicationInfo;
        this.iEntities = entities;
        this.iBinarySearchResults = binarySearchResults;
        this.iTypeSearchResults = typeSearchResults;
    }

    public void search(IProgressMonitor progressMonitor) {
        try {
            try {
                IProject[] projects;
                progressMonitor.beginTask("search for " + this.iEntities.size() + " entities", this.iEntities.size() * 1000 + 1000);
                long start = new Date().getTime();
                LOGGER.info("searching for " + this.iEntities.size() + " entities");
                SearchPattern searchPattern = null;
                for (EntityInfo entityInfo : this.iEntities) {
                    EntitySearchPatternUtil entitySearchPatternUtil = new EntitySearchPatternUtil(entityInfo, this.iBinarySearchResults);
                    SearchPattern entitySearchPattern = entitySearchPatternUtil.createEntitySearchPattern((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1000));
                    searchPattern = searchPattern == null ? entitySearchPattern : SearchPattern.createOrPattern((SearchPattern)searchPattern, (SearchPattern)entitySearchPattern);
                }
                SearchEngine searchEngine = new SearchEngine();
                HashSet<IJavaProject> javaProjects = new HashSet<IJavaProject>();
                IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject project = iProjectArray[n2];
                    IJavaProject javaProject = JavaCore.create((IProject)project);
                    if (javaProject != null && javaProject.exists()) {
                        javaProjects.add(javaProject);
                    }
                    ++n2;
                }
                IJavaElement[] javaElements = javaProjects.toArray(new IJavaElement[javaProjects.size()]);
                searchEngine.search(searchPattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, SearchEngine.createJavaSearchScope((IJavaElement[])javaElements, (int)1), (SearchRequestor)new TypeSearchRequestor(), (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1000));
                LOGGER.info("end search for " + this.iEntities.size() + " entities " + (new Date().getTime() - start) / 1000L + " seconds");
            }
            catch (CoreException e) {
                e.printStackTrace();
                progressMonitor.done();
            }
            catch (NullPointerException e) {
                LOGGER.info("null pointer exception");
                for (EntityInfo entityInfo : this.iEntities) {
                    LOGGER.info(entityInfo.getEjbName());
                }
                e.printStackTrace();
            }
        }
        finally {
            progressMonitor.done();
        }
    }

    private class TypeSearchRequestor
    extends SearchRequestor {
        private TypeSearchRequestor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void acceptSearchMatch(SearchMatch searchMatch) throws CoreException {
            if (searchMatch.getAccuracy() == 0 && searchMatch.isExact()) {
                IJavaElement javaElement = (IJavaElement)searchMatch.getElement();
                if (javaElement instanceof IMember) {
                    IMember member = (IMember)javaElement;
                    IType type = member.getDeclaringType();
                    if (type == null && member.getElementType() == 7) {
                        type = (IType)member;
                    }
                    if (type != null) {
                        while (type.getDeclaringType() != null) {
                            type = type.getDeclaringType();
                        }
                        if (!EntitySearchUtil.this.iApplicationInfo.isDeleteIntendedType(type.getFullyQualifiedName('.'))) {
                            if (type.isBinary()) {
                                Collection collection = EntitySearchUtil.this.iBinarySearchResults;
                                synchronized (collection) {
                                    if (!EntitySearchUtil.this.iBinarySearchResults.contains(searchMatch.getResource().getName())) {
                                        LOGGER.info("found binary search result: " + searchMatch.getResource().getName());
                                        EntitySearchUtil.this.iBinarySearchResults.add(searchMatch.getResource().getName());
                                        EntitySearchUtil.this.iApplicationInfo.incrementSearchResultCount();
                                    }
                                }
                            } else {
                                Collection collection = EntitySearchUtil.this.iTypeSearchResults;
                                synchronized (collection) {
                                    if (!EntitySearchUtil.this.iTypeSearchResults.contains(type)) {
                                        EntitySearchUtil.this.iTypeSearchResults.add(type);
                                        EntitySearchUtil.this.iApplicationInfo.incrementSearchResultCount();
                                    }
                                }
                            }
                        }
                    } else {
                        LOGGER.info("no type found " + javaElement);
                    }
                } else if (javaElement.getElementType() == 13) {
                    ICompilationUnit compilationUnit = (ICompilationUnit)javaElement.getParent().getParent();
                    IType type = compilationUnit.getTypes()[0];
                    if (!EntitySearchUtil.this.iApplicationInfo.isDeleteIntendedType(type.getFullyQualifiedName('.'))) {
                        Collection collection = EntitySearchUtil.this.iTypeSearchResults;
                        synchronized (collection) {
                            if (!EntitySearchUtil.this.iTypeSearchResults.contains(type)) {
                                EntitySearchUtil.this.iTypeSearchResults.add(type);
                                EntitySearchUtil.this.iApplicationInfo.incrementSearchResultCount();
                            }
                        }
                    }
                } else {
                    LOGGER.info("unexpected search result " + javaElement);
                }
            }
        }
    }
}

