/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.port.search;

import com.ibm.commerce.jpa.logger.LoggerHelper;
import com.ibm.commerce.jpa.port.info.ApplicationInfo;
import com.ibm.commerce.jpa.port.info.ProjectInfo;
import com.ibm.commerce.jpa.port.util.JavaUtil;
import java.util.Date;
import java.util.HashSet;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;

public class EntityReferenceSubclassSearchUtil {
    private static final Logger LOGGER = LoggerHelper.getLogger(EntityReferenceSubclassSearchUtil.class);
    private ProjectInfo iProjectInfo;
    private ApplicationInfo iApplicationInfo;
    private IJavaProject iJavaProject;

    public EntityReferenceSubclassSearchUtil(ProjectInfo projectInfo) {
        this.iApplicationInfo = projectInfo.getApplicationInfo();
        this.iProjectInfo = projectInfo;
        this.iJavaProject = projectInfo.getJavaProject();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void search(IProgressMonitor progressMonitor) {
        try {
            try {
                progressMonitor.beginTask("search for entity reference subclasses " + this.iProjectInfo.getProject().getName(), this.iProjectInfo.getEntityReferencingTypes().size() * 1000);
                start = new Date().getTime();
                EntityReferenceSubclassSearchUtil.LOGGER.info("searching for entity reference subclasses " + this.iProjectInfo.getProject().getName());
                entityReferences = new HashSet<String>();
                entityReferences.addAll(this.iProjectInfo.getEntityReferencingTypes());
                entityReferences.addAll(this.iProjectInfo.getIndirectEntityReferencingTypes());
                for (String entityReference : entityReferences) {
                    block19: {
                        type = this.iJavaProject.findType(entityReference);
                        if (!type.isClass()) break block19;
                        checkSubclasses = true;
                        currentType = type;
                        while (currentType.getSuperclassName() != null) {
                            if ((currentType = JavaUtil.resolveType(currentType, currentType.getSuperclassName())).isBinary()) break;
                            projectInfo = this.iApplicationInfo.getProjectInfo(currentType.getJavaProject().getProject());
                            qualifiedName = currentType.getFullyQualifiedName('.');
                            if (!projectInfo.getEntityReferencingTypes().contains(qualifiedName) && !projectInfo.getIndirectEntityReferencingTypes().contains(qualifiedName)) continue;
                            checkSubclasses = false;
                            break;
                        }
                        if (!checkSubclasses || (subtypes = (typeHierarchy = type.newTypeHierarchy((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1000))).getAllSubtypes(type)) == null) continue;
                        var15_19 = subtypes;
                        var14_16 = subtypes.length;
                        var13_13 = 0;
                        while (var13_13 < var14_16) {
                            block20: {
                                subtype = var15_19[var13_13];
                                qualifiedTypeName = subtype.getFullyQualifiedName('.');
                                if (this.iApplicationInfo.isDeleteIntendedType(qualifiedTypeName) || qualifiedTypeName.contains("JPA")) break block20;
                                if (!subtype.isBinary()) ** GOTO lbl36
                                EntityReferenceSubclassSearchUtil.LOGGER.info("found binary entity reference subclass: " + subtype.getFullyQualifiedName('.'));
                                this.iApplicationInfo.incrementSearchResultCount();
                                break block20;
lbl-1000:
                                // 1 sources

                                {
                                    subtype = subtype.getDeclaringType();
lbl36:
                                    // 2 sources

                                    ** while (subtype.getDeclaringType() != null)
                                }
lbl37:
                                // 1 sources

                                subtypeName /* !! */  = subtype.getFullyQualifiedName('.');
                                projectInfo = this.iApplicationInfo.getProjectInfo(subtype.getJavaProject().getProject());
                                if (!projectInfo.getEntityReferencingTypes().contains(subtypeName /* !! */ ) && !projectInfo.getIndirectEntityReferencingTypes().contains(subtypeName /* !! */ )) {
                                    projectInfo.addEntityReferenceSubclass((String)subtypeName /* !! */ );
                                    this.iApplicationInfo.incrementSearchResultCount();
                                }
                            }
                            ++var13_13;
                        }
                        continue;
                    }
                    if (!type.isInterface()) continue;
                    checkSubinterfaces = true;
                    types = new HashSet<IType>();
                    types.add(type);
                    while (!types.isEmpty() && checkSubinterfaces) {
                        newTypes = new HashSet<IType>();
                        for (IType currentType : types) {
                            subtypeName /* !! */  = superInterfaceNames = currentType.getSuperInterfaceNames();
                            qualifiedTypeName = superInterfaceNames.length;
                            var15_20 = 0;
                            while (var15_20 < qualifiedTypeName) {
                                superInterfaceName = subtypeName /* !! */ [var15_20];
                                superInterfaceType = JavaUtil.resolveType(currentType, superInterfaceName);
                                if (!superInterfaceType.isBinary()) {
                                    newTypes.add(superInterfaceType);
                                    projectInfo = this.iApplicationInfo.getProjectInfo(superInterfaceType.getJavaProject().getProject());
                                    qualifiedName = superInterfaceType.getFullyQualifiedName('.');
                                    if (projectInfo.getEntityReferencingTypes().contains(qualifiedName) || projectInfo.getIndirectEntityReferencingTypes().contains(qualifiedName)) {
                                        checkSubinterfaces = false;
                                        break;
                                    }
                                }
                                ++var15_20;
                            }
                            if (!checkSubinterfaces) break;
                        }
                        types = newTypes;
                    }
                    if (!checkSubinterfaces || (subtypes = (typeHierarchy = type.newTypeHierarchy((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1000))).getAllSubtypes(type)) == null) continue;
                    var15_21 = subtypes;
                    var14_18 = subtypes.length;
                    var13_15 = 0;
                    while (var13_15 < var14_18) {
                        block21: {
                            subtype = var15_21[var13_15];
                            if (this.iApplicationInfo.isDeleteIntendedType(subtype.getFullyQualifiedName('.')) || !subtype.isInterface()) break block21;
                            if (!subtype.isBinary()) ** GOTO lbl87
                            EntityReferenceSubclassSearchUtil.LOGGER.info("found binary entity reference subinterface: " + subtype.getFullyQualifiedName('.'));
                            this.iApplicationInfo.incrementSearchResultCount();
                            break block21;
lbl-1000:
                            // 1 sources

                            {
                                subtype = subtype.getDeclaringType();
lbl87:
                                // 2 sources

                                ** while (subtype.getDeclaringType() != null)
                            }
lbl88:
                            // 1 sources

                            subtypeName = subtype.getFullyQualifiedName('.');
                            projectInfo = this.iApplicationInfo.getProjectInfo(subtype.getJavaProject().getProject());
                            if (!projectInfo.getEntityReferencingTypes().contains(subtypeName) && !projectInfo.getIndirectEntityReferencingTypes().contains(subtypeName)) {
                                projectInfo.addEntityReferenceSubclass(subtypeName);
                                this.iApplicationInfo.incrementSearchResultCount();
                            }
                        }
                        ++var13_15;
                    }
                }
                EntityReferenceSubclassSearchUtil.LOGGER.info("end search for entity reference subclasses " + this.iProjectInfo.getProject().getName() + " " + (new Date().getTime() - start) / 1000L + " seconds");
            }
            catch (CoreException e) {
                e.printStackTrace();
                progressMonitor.done();
            }
        }
        finally {
            progressMonitor.done();
        }
    }
}

