/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.port.search;

import com.ibm.commerce.jpa.logger.LoggerHelper;
import com.ibm.commerce.jpa.port.info.ApplicationInfo;
import com.ibm.commerce.jpa.port.info.EntityInfo;
import com.ibm.commerce.jpa.port.info.ModuleInfo;
import java.util.Collection;
import java.util.Date;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;

public class AccessBeanSubclassSearchUtil {
    private static final Logger LOGGER = LoggerHelper.getLogger(AccessBeanSubclassSearchUtil.class);
    private ModuleInfo iModuleInfo;
    private ApplicationInfo iApplicationInfo;

    public AccessBeanSubclassSearchUtil(ModuleInfo moduleInfo) {
        this.iApplicationInfo = moduleInfo.getApplicationInfo();
        this.iModuleInfo = moduleInfo;
    }

    public void search(IProgressMonitor progressMonitor) {
        try {
            try {
                progressMonitor.beginTask("search for accessbean subclasses " + this.iModuleInfo.getJavaProject().getElementName(), this.iModuleInfo.getEntities().size() * 1000);
                long start = new Date().getTime();
                LOGGER.info("searching for accessbean subclasses " + this.iModuleInfo.getJavaProject().getElementName());
                Collection<EntityInfo> entities = this.iModuleInfo.getEntities();
                for (EntityInfo entityInfo : entities) {
                    ITypeHierarchy typeHierarchy;
                    IType[] subtypes;
                    if (entityInfo.getEjbAccessBeanType() == null || (subtypes = (typeHierarchy = entityInfo.getEjbAccessBeanType().newTypeHierarchy((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1000))).getAllSubtypes(entityInfo.getEjbAccessBeanType())) == null) continue;
                    IType[] iTypeArray = subtypes;
                    int n = subtypes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IType subtype = iTypeArray[n2];
                        if (subtype.isBinary()) {
                            LOGGER.info("found binary access bean subclass: " + subtype.getFullyQualifiedName('.'));
                        } else {
                            String subtypeName = subtype.getFullyQualifiedName('.');
                            this.iApplicationInfo.getProjectInfo(subtype.getResource().getProject()).getAccessBeanSubclassInfo(subtypeName, true);
                        }
                        this.iApplicationInfo.incrementSearchResultCount();
                        ++n2;
                    }
                }
                LOGGER.info("end search for accessbean subclasses " + this.iModuleInfo.getJavaProject().getElementName() + " " + (new Date().getTime() - start) / 1000L + " seconds");
            }
            catch (CoreException e) {
                e.printStackTrace();
                progressMonitor.done();
            }
        }
        finally {
            progressMonitor.done();
        }
    }
}

