/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.port.resolvers;

import com.ibm.commerce.jpa.port.info.AccessBeanInfo;
import com.ibm.commerce.jpa.port.info.AccessBeanMethodInfo;
import com.ibm.commerce.jpa.port.info.ColumnInfo;
import com.ibm.commerce.jpa.port.info.CreatorInfo;
import com.ibm.commerce.jpa.port.info.EjbRelationshipRoleInfo;
import com.ibm.commerce.jpa.port.info.EntityInfo;
import com.ibm.commerce.jpa.port.info.FieldInfo;
import com.ibm.commerce.jpa.port.info.ForeignKeyInfo;
import com.ibm.commerce.jpa.port.info.RelatedEntityInfo;
import com.ibm.commerce.jpa.port.info.TableInfo;
import com.ibm.commerce.jpa.port.info.UserMethodInfo;
import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.SimpleName;

public class EntityResolver {
    private static final Map<String, String> RELATED_ENTITY_FIELD_NAME_MAP = new HashMap<String, String>();
    private static final String GET = "get";
    private static final String SET = "set";
    private EntityInfo iEntityInfo;
    private AccessBeanInfo iAccessBeanInfo;
    private Collection<String> iProcessedMethodKeys = new HashSet<String>();
    private Collection<String> iProcessedFieldNames = new HashSet<String>();

    static {
        RELATED_ENTITY_FIELD_NAME_MAP.put("packageReferenceNumber", "packageEntity");
        RELATED_ENTITY_FIELD_NAME_MAP.put("catalogGroupIdParent", "parentCatalogGroup");
        RELATED_ENTITY_FIELD_NAME_MAP.put("catalogGroupIdChild", "childCatalogGroup");
        RELATED_ENTITY_FIELD_NAME_MAP.put("catalogEntryIdChild", "childCatalogEntry");
        RELATED_ENTITY_FIELD_NAME_MAP.put("catalogEntryIdParent", "parentCatalogEntry");
        RELATED_ENTITY_FIELD_NAME_MAP.put("catalogIdLink", "linkedCatalog");
        RELATED_ENTITY_FIELD_NAME_MAP.put("attachmentIdValue", "attachment");
    }

    public EntityResolver(EntityInfo entityInfo) {
        this.iEntityInfo = entityInfo;
        this.iAccessBeanInfo = this.iEntityInfo.getAccessBeanInfo();
    }

    public void resolve() {
        this.resolveParentEntities();
        this.resolveFields();
        this.resolveUserMethods();
        this.resolveCopyHelpers();
        this.resolveKeyFields();
        this.resolveAccessBeanMethods();
        this.iEntityInfo.releaseParseResources();
    }

    private void resolveParentEntities() {
        TableInfo tableInfo2;
        ArrayList<TableInfo> tables = new ArrayList<TableInfo>();
        if (this.iEntityInfo.getSecondaryTableInfo() != null) {
            tables.add(this.iEntityInfo.getSecondaryTableInfo());
        }
        if (this.iEntityInfo.getPrimaryTableInfo() != null) {
            tables.add(this.iEntityInfo.getPrimaryTableInfo());
        }
        if (this.iEntityInfo.getSupertype() != null && this.iEntityInfo.getSupertype().getPrimaryTableInfo() != null && !tables.contains(tableInfo2 = this.iEntityInfo.getSupertype().getPrimaryTableInfo())) {
            tables.add(tableInfo2);
        }
        for (TableInfo tableInfo2 : tables) {
            Collection<FieldInfo> fields = this.iEntityInfo.getFields();
            Set<ForeignKeyInfo> foreignKeys = tableInfo2.getForeignKeys();
            for (ForeignKeyInfo foreignKey : foreignKeys) {
                EntityInfo parentEntityInfo = foreignKey.getParentTableInfo().getEntityInfo();
                if (parentEntityInfo == null) continue;
                RelatedEntityInfo relatedEntityInfo = new RelatedEntityInfo(this.iEntityInfo, parentEntityInfo);
                Collection<FieldInfo> relatedEntityFields = parentEntityInfo.getFields();
                List<ColumnInfo> memberColumns = foreignKey.getMemberColumns();
                List<ColumnInfo> referencedColumns = foreignKey.getReferencedColumns();
                String relatedEntityFieldName = null;
                int i = 0;
                while (i < memberColumns.size()) {
                    ColumnInfo memberColumn = memberColumns.get(i);
                    FieldInfo memberFieldInfo = null;
                    for (FieldInfo fieldInfo : fields) {
                        if (fieldInfo.getColumnInfo() != memberColumn) continue;
                        memberFieldInfo = fieldInfo;
                        if (relatedEntityFieldName != null && relatedEntityFieldName.toLowerCase().contains(parentEntityInfo.getEjbName().toLowerCase())) break;
                        relatedEntityFieldName = memberFieldInfo.getFieldName();
                        break;
                    }
                    ColumnInfo referencedColumn = referencedColumns.get(i);
                    FieldInfo referencedFieldInfo = null;
                    for (FieldInfo fieldInfo : relatedEntityFields) {
                        if (fieldInfo.getColumnInfo() != referencedColumn) continue;
                        referencedFieldInfo = fieldInfo;
                        break;
                    }
                    if (memberFieldInfo != null && referencedFieldInfo != null) {
                        relatedEntityInfo.addMemberField(memberFieldInfo, referencedFieldInfo);
                    }
                    ++i;
                }
                for (EjbRelationshipRoleInfo ejbRelationshipRoleInfo : this.iEntityInfo.getEjbRelationshipRoles()) {
                    if (ejbRelationshipRoleInfo.getEjbRelationInfo().getConstraintInfo().getForeignKeyInfo() != foreignKey) continue;
                    relatedEntityInfo.setEjbRelationshipRoleInfo(ejbRelationshipRoleInfo);
                    relatedEntityFieldName = ejbRelationshipRoleInfo.getFieldName();
                    relatedEntityInfo.setFieldName(relatedEntityFieldName);
                    relatedEntityInfo.setGetterName(ejbRelationshipRoleInfo.getGetterName());
                    relatedEntityInfo.setSetterName(ejbRelationshipRoleInfo.getSetterName());
                    block6: for (FieldInfo fieldInfo : fields) {
                        if (!fieldInfo.getFieldName().startsWith(String.valueOf(relatedEntityFieldName) + "_")) continue;
                        String referencedFieldName = fieldInfo.getFieldName().substring(relatedEntityFieldName.length() + 1);
                        for (FieldInfo relatedFieldInfo : relatedEntityFields) {
                            if (!relatedFieldInfo.getFieldName().equals(referencedFieldName)) continue;
                            relatedEntityInfo.addMemberField(fieldInfo, relatedFieldInfo);
                            if (!fieldInfo.getIsKeyField()) continue block6;
                            ejbRelationshipRoleInfo.setIsKeyField(true);
                            continue block6;
                        }
                    }
                }
                if (relatedEntityInfo.getMemberFields().size() <= 0) continue;
                if (RELATED_ENTITY_FIELD_NAME_MAP.get(relatedEntityFieldName) != null) {
                    relatedEntityFieldName = RELATED_ENTITY_FIELD_NAME_MAP.get(relatedEntityFieldName);
                } else {
                    relatedEntityFieldName = Introspector.decapitalize(relatedEntityFieldName);
                    String oldSuffix = null;
                    if (relatedEntityFieldName.endsWith("_id")) {
                        oldSuffix = "_id";
                    } else if (relatedEntityFieldName.endsWith("ReferenceNumber")) {
                        oldSuffix = "ReferenceNumber";
                    } else if (relatedEntityFieldName.endsWith("Number")) {
                        oldSuffix = "Number";
                    } else if (relatedEntityFieldName.endsWith("ID") || relatedEntityFieldName.endsWith("Id")) {
                        oldSuffix = "ID";
                    }
                    if (oldSuffix != null) {
                        relatedEntityFieldName = relatedEntityFieldName.substring(0, relatedEntityFieldName.length() - oldSuffix.length());
                    }
                    if (relatedEntityFieldName.equals("class")) {
                        relatedEntityFieldName = Introspector.decapitalize(relatedEntityInfo.getParentEntityInfo().getEjbName());
                    }
                    if (relatedEntityFieldName.startsWith("str") && Character.isUpperCase(relatedEntityFieldName.charAt(3))) {
                        relatedEntityFieldName = Introspector.decapitalize(relatedEntityFieldName.substring(3));
                    }
                }
                relatedEntityInfo.setFieldName(relatedEntityFieldName);
                this.iEntityInfo.addRelatedEntityInfo(relatedEntityInfo);
                UserMethodInfo userMethodInfo = this.iEntityInfo.getUserMethodInfo(relatedEntityInfo.getGetterName());
                if (userMethodInfo == null) continue;
                userMethodInfo.setRelatedEntityInfo(relatedEntityInfo);
            }
        }
    }

    private void resolveFields() {
        Collection<FieldInfo> fields = this.iEntityInfo.getFields();
        for (FieldInfo fieldInfo : fields) {
            String fieldName;
            String targetGetterName = fieldInfo.getTargetGetterName();
            String targetSetterName = fieldInfo.getTargetSetterName();
            if (targetGetterName.startsWith("is")) {
                if (targetGetterName.substring(2).equals(targetSetterName.substring(3))) continue;
                fieldName = fieldInfo.getTargetFieldName();
                if (fieldName.startsWith("i") && Character.toUpperCase(fieldName.charAt(1)) == fieldName.charAt(1)) {
                    fieldInfo.setTargetGetterName(GET + fieldName.substring(1));
                    fieldInfo.setTargetSetterName(SET + fieldName.substring(1));
                    continue;
                }
                fieldInfo.setTargetGetterName(GET + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1));
                fieldInfo.setTargetSetterName(SET + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1));
                continue;
            }
            if (targetGetterName.substring(3).equals(targetSetterName.substring(3))) continue;
            fieldName = fieldInfo.getTargetFieldName();
            if (fieldName.startsWith("i") && Character.toUpperCase(fieldName.charAt(1)) == fieldName.charAt(1)) {
                fieldInfo.setTargetGetterName(GET + fieldName.substring(1));
                fieldInfo.setTargetSetterName(SET + fieldName.substring(1));
                continue;
            }
            fieldInfo.setTargetGetterName(GET + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1));
            fieldInfo.setTargetSetterName(SET + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1));
        }
    }

    private void resolveUserMethods() {
        List<UserMethodInfo> userMethods = this.iEntityInfo.getUserMethods();
        for (UserMethodInfo userMethod : userMethods) {
            FieldInfo fieldInfo = null;
            EjbRelationshipRoleInfo ejbRelationshipRoleInfo = null;
            String methodName = userMethod.getMethodName();
            int numberOfParameters = userMethod.getParameterTypes().size();
            if (numberOfParameters == 0 && userMethod.getReturnType() != null) {
                fieldInfo = this.iEntityInfo.getFieldInfoByGetterName(methodName);
                ejbRelationshipRoleInfo = this.iEntityInfo.getEjbRelationshipRoleInfoByGetterName(methodName);
            } else if (numberOfParameters == 1 && userMethod.getReturnType() == null) {
                fieldInfo = this.iEntityInfo.getFieldInfoBySetterName(methodName);
                if (fieldInfo != null && !userMethod.getParameterTypes().get(0).equals(fieldInfo.getTypeName())) {
                    fieldInfo = null;
                }
                if ((ejbRelationshipRoleInfo = this.iEntityInfo.getEjbRelationshipRoleInfoBySetterName(methodName)) != null && !userMethod.getParameterTypes().get(0).equals(ejbRelationshipRoleInfo.getFieldType())) {
                    ejbRelationshipRoleInfo = null;
                }
            }
            if (fieldInfo != null) {
                userMethod.setFieldInfo(fieldInfo);
            }
            if (ejbRelationshipRoleInfo == null) continue;
            userMethod.setEjbRelationshipRoleInfo(ejbRelationshipRoleInfo);
        }
        for (UserMethodInfo userMethod : userMethods) {
            if (userMethod.getRelatedEntityInfo() != null || userMethod.getFieldInfo() != null || userMethod.getEjbRelationshipRoleInfo() != null) continue;
            this.resolveMethodRequirements(userMethod.getKey());
        }
    }

    private void resolveCopyHelpers() {
        if (this.iEntityInfo != null && this.iEntityInfo.getAccessBeanInfo() != null) {
            Collection<AccessBeanInfo.CopyHelperProperty> copyHelperProperties = this.iEntityInfo.getAccessBeanInfo().getCopyHelperProperties();
            for (AccessBeanInfo.CopyHelperProperty copyHelperProperty : copyHelperProperties) {
                String methodKey;
                if (copyHelperProperty.getFieldInfo() == null) {
                    FieldInfo fieldInfo = this.iEntityInfo.getFieldInfoByName(copyHelperProperty.getName());
                    if (fieldInfo == null && copyHelperProperty.getGetterName() != null) {
                        fieldInfo = this.iEntityInfo.getFieldInfoByGetterName(copyHelperProperty.getGetterName());
                    }
                    if (fieldInfo == null && copyHelperProperty.getSetterName() != null) {
                        fieldInfo = this.iEntityInfo.getFieldInfoBySetterName(copyHelperProperty.getSetterName());
                    }
                    if (fieldInfo != null) {
                        copyHelperProperty.setFieldInfo(fieldInfo);
                        fieldInfo.setCopyHelperProperty(copyHelperProperty);
                    }
                }
                if (copyHelperProperty.getFieldInfo() != null) continue;
                if (copyHelperProperty.getGetterName() != null && this.iEntityInfo.getUserMethodInfo(copyHelperProperty.getGetterName()) == null) {
                    methodKey = copyHelperProperty.getGetterName();
                    this.iEntityInfo.addRequiredMethod(methodKey);
                    this.resolveMethodRequirements(methodKey);
                }
                if (copyHelperProperty.getSetterName() == null || this.iEntityInfo.getUserMethodInfo(methodKey = String.valueOf(copyHelperProperty.getSetterName()) + "+" + copyHelperProperty.getType()) != null) continue;
                this.iEntityInfo.addRequiredMethod(methodKey);
                this.resolveMethodRequirements(methodKey);
            }
        }
    }

    private void resolveKeyFields() {
        List<FieldInfo> keyFields = this.iEntityInfo.getKeyFields();
        for (FieldInfo keyFieldInfo : keyFields) {
            if (keyFieldInfo.getCopyHelperProperty() != null || this.iAccessBeanInfo == null) continue;
            AccessBeanInfo.CopyHelperProperty copyHelperProperty = this.iAccessBeanInfo.getCopyHelperProperty(keyFieldInfo.getFieldName(), true);
            copyHelperProperty.setType(keyFieldInfo.getTypeName());
            copyHelperProperty.setGetterName(keyFieldInfo.getTargetGetterName());
            copyHelperProperty.setFieldInfo(keyFieldInfo);
            keyFieldInfo.setCopyHelperProperty(copyHelperProperty);
        }
    }

    private void resolveMethodRequirements(String methodKey) {
        if (!this.iProcessedMethodKeys.contains(methodKey)) {
            this.iProcessedMethodKeys.add(methodKey);
            HashSet<String> methods = new HashSet<String>();
            methods.add(methodKey);
            while (!methods.isEmpty()) {
                HashSet<String> newMethods = new HashSet<String>();
                for (String currentMethodKey : methods) {
                    Collection<String> requiredMethods = this.iEntityInfo.getRequiredMethods(currentMethodKey);
                    if (requiredMethods != null) {
                        for (String requiredMethodKey : requiredMethods) {
                            if (this.iProcessedMethodKeys.contains(requiredMethodKey) || this.iEntityInfo.getUserMethodInfo(requiredMethodKey) != null || this.iEntityInfo.getFieldInfoByGetterName(requiredMethodKey) != null || this.iEntityInfo.getFieldInfoBySetterMethodKey(requiredMethodKey) != null) continue;
                            this.iProcessedMethodKeys.add(requiredMethodKey);
                            this.iEntityInfo.addRequiredMethod(requiredMethodKey);
                            if (this.iEntityInfo.getSupertype() != null) {
                                this.iEntityInfo.getSupertype().addRequiredMethod(requiredMethodKey);
                            }
                            newMethods.add(requiredMethodKey);
                        }
                    }
                    this.resolveMethodRequiredFields(currentMethodKey);
                }
                methods = newMethods;
            }
        }
    }

    private void resolveMethodRequiredFields(String methodKey) {
        Collection<String> requiredFields = this.iEntityInfo.getMethodRequiredFields(methodKey);
        if (requiredFields != null) {
            for (String requiredFieldName : requiredFields) {
                this.iEntityInfo.addRequiredField(requiredFieldName);
                if (this.iEntityInfo.getSupertype() != null) {
                    this.iEntityInfo.getSupertype().addRequiredField(requiredFieldName);
                }
                this.resolveFieldRequirements(requiredFieldName);
            }
        }
    }

    private void resolveFieldRequirements(String fieldName) {
        if (!this.iProcessedFieldNames.contains(fieldName)) {
            this.iProcessedFieldNames.add(fieldName);
            HashSet<String> fields = new HashSet<String>();
            fields.add(fieldName);
            while (!fields.isEmpty()) {
                HashSet<String> newFields = new HashSet<String>();
                for (String currentFieldName : fields) {
                    Collection<String> requiredFields = this.iEntityInfo.getFieldRequiredFields(currentFieldName);
                    if (requiredFields == null) continue;
                    for (String requiredFieldName : requiredFields) {
                        if (this.iProcessedFieldNames.contains(requiredFieldName)) continue;
                        this.iProcessedFieldNames.add(requiredFieldName);
                        this.iEntityInfo.addRequiredField(requiredFieldName);
                        if (this.iEntityInfo.getSupertype() != null) {
                            this.iEntityInfo.getSupertype().addRequiredField(requiredFieldName);
                        }
                        newFields.add(requiredFieldName);
                    }
                }
                fields = newFields;
            }
        }
    }

    private void resolveAccessBeanMethods() {
        Collection<CreatorInfo> creators = this.iEntityInfo.getCreators();
        for (CreatorInfo creatorInfo : creators) {
            if (creatorInfo.isInvalid()) continue;
            creatorInfo.getAccessBeanMethodInfo().resolve();
        }
        Collection<AccessBeanMethodInfo> accessBeanMethods = this.iEntityInfo.getAccessBeanMethods();
        for (AccessBeanMethodInfo accessBeanMethodInfo : accessBeanMethods) {
            if (accessBeanMethodInfo.isInvalid()) continue;
            accessBeanMethodInfo.resolve();
        }
        Set<CreatorInfo> creatorsCalledByCreators = this.iEntityInfo.getCreatorsCalledByCreators();
        for (CreatorInfo creatorInfo : creatorsCalledByCreators) {
            AccessBeanMethodInfo accessBeanMethodInfo = creatorInfo.getAccessBeanMethodInfo();
            String methodKey = accessBeanMethodInfo.getMethodKey();
            this.iEntityInfo.setAccessBeanMethodInfo(methodKey, accessBeanMethodInfo);
            String[] parameterTypes = accessBeanMethodInfo.getParameterTypes();
            AccessBeanMethodInfo newAccessBeanMethodInfo = new AccessBeanMethodInfo(this.iEntityInfo, "generated" + methodKey, accessBeanMethodInfo.getMethodName(), parameterTypes, null);
            AccessBeanMethodInfo.AccessBeanMethodInvocationStatement statement = new AccessBeanMethodInfo.AccessBeanMethodInvocationStatement(methodKey);
            int i = 0;
            while (i < parameterTypes.length) {
                String parameterName = accessBeanMethodInfo.getTargetParameterName(i);
                newAccessBeanMethodInfo.setParameterName(i, parameterName);
                statement.addArgument((Expression)this.iEntityInfo.getEjbCompilationUnit().getAST().newName(parameterName));
                ++i;
            }
            newAccessBeanMethodInfo.getStatements().add(statement);
            newAccessBeanMethodInfo.addReferencedAccessBeanMethod(methodKey);
            creatorInfo.setAccessBeanMethodInfo(newAccessBeanMethodInfo);
        }
        if (this.iAccessBeanInfo != null) {
            Collection<AccessBeanInfo.CopyHelperProperty> copyHelperProperties = this.iAccessBeanInfo.getCopyHelperProperties();
            for (AccessBeanInfo.CopyHelperProperty copyHelperProperty : copyHelperProperties) {
                FieldInfo fieldInfo;
                if (this.iAccessBeanInfo.isExcludedPropertyName(copyHelperProperty.getName()) || (fieldInfo = copyHelperProperty.getFieldInfo()) == null) continue;
                AccessBeanMethodInfo getterAccessBeanMethodInfo = null;
                Set<String> getterNames = fieldInfo.getGetterNames();
                for (String getterName : getterNames) {
                    if (getterAccessBeanMethodInfo != null && !getterName.equals(fieldInfo.getTargetGetterName())) continue;
                    getterAccessBeanMethodInfo = this.iEntityInfo.getAccessBeanMethodInfo(getterName);
                }
                if (getterAccessBeanMethodInfo != null && this.containsAdditionalGetterLogic(fieldInfo, getterAccessBeanMethodInfo)) {
                    fieldInfo.setGetterAccessBeanMethodInfo(getterAccessBeanMethodInfo);
                }
                AccessBeanMethodInfo setterAccessBeanMethodInfo = null;
                Set<String> setterNames = fieldInfo.getSetterNames();
                for (String setterName : setterNames) {
                    String setterMethodKey;
                    if (setterAccessBeanMethodInfo != null && !setterName.equals(fieldInfo.getTargetSetterName()) || (setterAccessBeanMethodInfo = this.iEntityInfo.getAccessBeanMethodInfo(setterMethodKey = String.valueOf(setterName) + "+" + fieldInfo.getTypeName())) != null || copyHelperProperty.getType() == null) continue;
                    setterMethodKey = String.valueOf(setterName) + "+" + copyHelperProperty.getType();
                    setterAccessBeanMethodInfo = this.iEntityInfo.getAccessBeanMethodInfo(setterMethodKey);
                }
                if (setterAccessBeanMethodInfo == null || !this.containsAdditionalSetterLogic(fieldInfo, setterAccessBeanMethodInfo)) continue;
                fieldInfo.setSetterAccessBeanMethodInfo(setterAccessBeanMethodInfo);
            }
        }
        List<UserMethodInfo> userMethods = this.iEntityInfo.getUserMethods();
        for (UserMethodInfo userMethodInfo : userMethods) {
            String setterMethodKey;
            AccessBeanMethodInfo accessBeanMethodInfo;
            if (userMethodInfo.getFieldInfo() == null || userMethodInfo.getFieldInfo().getCopyHelperProperty() != null) continue;
            if (userMethodInfo.getMethodName().startsWith(GET)) {
                AccessBeanMethodInfo accessBeanMethodInfo2 = this.iEntityInfo.getAccessBeanMethodInfo(userMethodInfo.getMethodName());
                if (accessBeanMethodInfo2 == null || !this.containsAdditionalGetterLogic(userMethodInfo.getFieldInfo(), accessBeanMethodInfo2)) continue;
                userMethodInfo.setAccessBeanMethodInfo(accessBeanMethodInfo2);
                continue;
            }
            if (!userMethodInfo.getMethodName().startsWith(SET) || (accessBeanMethodInfo = this.iEntityInfo.getAccessBeanMethodInfo(setterMethodKey = String.valueOf(userMethodInfo.getMethodName()) + "+" + userMethodInfo.getParameterTypes().get(0))) == null || !this.containsAdditionalSetterLogic(userMethodInfo.getFieldInfo(), accessBeanMethodInfo)) continue;
            userMethodInfo.setAccessBeanMethodInfo(accessBeanMethodInfo);
        }
    }

    private boolean containsAdditionalGetterLogic(FieldInfo fieldInfo, AccessBeanMethodInfo accessBeanMethodInfo) {
        Expression returnExpression;
        boolean additionalLogic = false;
        List<AccessBeanMethodInfo.AccessBeanStatement> statements = accessBeanMethodInfo.getStatements();
        if (statements.size() > 1) {
            additionalLogic = true;
        } else if (statements.size() == 1 && statements.get(0) instanceof AccessBeanMethodInfo.AccessBeanIfStatement) {
            additionalLogic = true;
        } else if (statements.size() == 1 && statements.get(0) instanceof AccessBeanMethodInfo.AccessBeanReturnStatement && (returnExpression = ((AccessBeanMethodInfo.AccessBeanReturnStatement)statements.get(0)).getReturnExpression()) != null) {
            MethodInvocation methodInvocation;
            additionalLogic = true;
            if (fieldInfo.getRelatedEntityInfo() != null) {
                if (returnExpression.getNodeType() == 36) {
                    additionalLogic = false;
                }
            } else if (returnExpression.getNodeType() == 32 && (methodInvocation = (MethodInvocation)returnExpression).getExpression() != null && methodInvocation.getExpression().getNodeType() == 42 && methodInvocation.getName().getIdentifier().equals(fieldInfo.getTargetGetterName()) && ((SimpleName)methodInvocation.getExpression()).getIdentifier().equals("iTypedEntity")) {
                additionalLogic = false;
            }
        }
        return additionalLogic;
    }

    private boolean containsAdditionalSetterLogic(FieldInfo fieldInfo, AccessBeanMethodInfo accessBeanMethodInfo) {
        boolean additionalLogic = false;
        List<AccessBeanMethodInfo.AccessBeanStatement> statements = accessBeanMethodInfo.getStatements();
        if (statements.size() > 1) {
            additionalLogic = true;
        } else if (statements.size() == 1) {
            if (statements.get(0) instanceof AccessBeanMethodInfo.AccessBeanParameterInitializedFieldStatement) {
                additionalLogic = false;
            } else if (statements.get(0) instanceof AccessBeanMethodInfo.AccessBeanIfStatement) {
                AccessBeanMethodInfo.AccessBeanIfStatement ifStatement = (AccessBeanMethodInfo.AccessBeanIfStatement)statements.get(0);
                if (ifStatement.getElseStatements().size() > 0) {
                    additionalLogic = true;
                } else if (ifStatement.getThenStatements().size() == 1 && ifStatement.getThenStatements().get(0) instanceof AccessBeanMethodInfo.AccessBeanParameterInitializedFieldStatement) {
                    additionalLogic = false;
                }
            } else {
                additionalLogic = true;
            }
        }
        return additionalLogic;
    }
}

