/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.port.parsers;

import com.ibm.commerce.jpa.logger.LoggerHelper;
import com.ibm.commerce.jpa.port.info.ColumnInfo;
import com.ibm.commerce.jpa.port.info.ConstraintInfo;
import com.ibm.commerce.jpa.port.info.ModuleInfo;
import com.ibm.commerce.jpa.port.info.TableInfo;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SchemaDbmParser {
    private static final Logger LOGGER = LoggerHelper.getLogger(SchemaDbmParser.class);
    private static final String LUW_TABLE = "LUW:LUWTable";
    private static final String SQL_TABLE = "SQLTables:PersistentTable";
    private static final String ORACLE_TABLE = "OracleModel:OracleTable";
    private static final String ID = "xmi:id";
    private static final String NAME = "name";
    private static final String COLUMNS = "columns";
    private static final String TYPE = "xsi:type";
    private static final String NULLABLE = "nullable";
    private static final String DEFAULT_VALUE = "defaultValue";
    private static final String PRIMITIVE_TYPE = "primitiveType";
    private static final String CONTAINED_TYPE = "containedType";
    private static final String LENGTH = "length";
    private static final String CONSTRAINTS = "constraints";
    private static final String MEMBERS = "members";
    private static final String FOREIGN_KEY = "ForeignKey";
    private static final String UNIQUE_CONSTRAINT = "uniqueConstraint";
    private static final String REFERENCED_MEMBERS = "referencedMembers";
    private static final String REFERENCED_TABLE = "referencedTable";
    private IFile iFile;
    private ModuleInfo iModuleInfo;

    public SchemaDbmParser(IFile file, ModuleInfo moduleInfo) {
        this.iFile = file;
        this.iModuleInfo = moduleInfo;
    }

    public void parse() {
        Document document = this.iModuleInfo.getXMLUtil().readXml(this.iFile);
        this.parseXmiElement(document.getDocumentElement());
        this.iModuleInfo.getApplicationInfo().incrementParsedAssetCount();
    }

    private void parseXmiElement(Element xmiElement) {
        NodeList childNodes = xmiElement.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = childNodes.item(i);
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                String nodeName = element.getNodeName();
                if (LUW_TABLE.equals(nodeName)) {
                    this.parseLUWTableElement(element);
                }
                if (SQL_TABLE.equals(nodeName) || ORACLE_TABLE.equals(nodeName)) {
                    LOGGER.info("Found a NONLUW_TABLE..parsing...");
                    this.parseNONLUWTableElement(element);
                }
            }
            ++i;
        }
    }

    private void parseNONLUWTableElement(Element luwTableElement) {
        TableInfo tableInfo = this.iModuleInfo.getTableInfo(luwTableElement.getAttribute(ID), true);
        this.iModuleInfo.setTableName(tableInfo, luwTableElement.getAttribute(NAME));
        NodeList childNodes = luwTableElement.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = childNodes.item(i);
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                String nodeName = element.getNodeName();
                if (COLUMNS.equals(nodeName)) {
                    this.parseColumnElement(element, tableInfo);
                } else if (CONSTRAINTS.equals(nodeName)) {
                    this.parseConstraintsElement(element, tableInfo);
                }
            }
            ++i;
        }
    }

    private void parseLUWTableElement(Element luwTableElement) {
        TableInfo tableInfo = this.iModuleInfo.getTableInfo(luwTableElement.getAttribute(ID), true);
        this.iModuleInfo.setTableName(tableInfo, luwTableElement.getAttribute(NAME));
        NodeList childNodes = luwTableElement.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = childNodes.item(i);
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                String nodeName = element.getNodeName();
                if (COLUMNS.equals(nodeName)) {
                    this.parseColumnElement(element, tableInfo);
                } else if (CONSTRAINTS.equals(nodeName)) {
                    this.parseConstraintsElement(element, tableInfo);
                }
            }
            ++i;
        }
    }

    private void parseColumnElement(Element columnElement, TableInfo tableInfo) {
        ColumnInfo columnInfo = tableInfo.getColumnInfo(columnElement.getAttribute(ID), true);
        this.iModuleInfo.addColumnInfo(columnInfo);
        tableInfo.setColumnName(columnInfo, columnElement.getAttribute(NAME).trim());
        if (columnElement.hasAttribute(NULLABLE)) {
            columnInfo.setNullable(!"false".equals(columnElement.getAttribute(NULLABLE)));
        }
        if (columnElement.hasAttribute(DEFAULT_VALUE)) {
            columnInfo.setDefaultValue(columnElement.getAttribute(DEFAULT_VALUE));
        }
        NodeList childNodes = columnElement.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Element element;
            String nodeName;
            Node node = childNodes.item(i);
            if (node.getNodeType() == 1 && CONTAINED_TYPE.equals(nodeName = (element = (Element)node).getNodeName())) {
                this.parseContainedTypeElement(element, columnInfo);
            }
            ++i;
        }
        if (columnInfo.getColumnName() != null && columnInfo.getColumnName().equals("OPTCOUNTER") && !columnInfo.getPrimitiveType().equals("INTEGER") && !columnInfo.getPrimitiveType().equals("SMALLINT")) {
            tableInfo.addError("DB SCHEMA DBM: " + tableInfo.getTableName() + " has an OPTCOUNTER column that is not a valid type: " + columnInfo.getPrimitiveType());
        }
    }

    private void parseContainedTypeElement(Element containedTypeElement, ColumnInfo columnInfo) {
        if (containedTypeElement.hasAttribute(TYPE)) {
            columnInfo.setType(containedTypeElement.getAttribute(TYPE));
        }
        if (containedTypeElement.hasAttribute(NAME)) {
            columnInfo.setTypeName(containedTypeElement.getAttribute(NAME));
        }
        if (containedTypeElement.hasAttribute(PRIMITIVE_TYPE)) {
            columnInfo.setPrimitiveType(containedTypeElement.getAttribute(PRIMITIVE_TYPE));
        }
        if (containedTypeElement.hasAttribute(LENGTH)) {
            columnInfo.setLength(new Integer(containedTypeElement.getAttribute(LENGTH)));
        }
    }

    private void parseConstraintsElement(Element constraintsElement, TableInfo tableInfo) {
        ConstraintInfo constraintInfo = tableInfo.getConstraintInfo(constraintsElement.getAttribute(ID), true);
        this.iModuleInfo.addConstraintInfo(constraintInfo);
        constraintInfo.setConstraintName(constraintsElement.getAttribute(NAME));
        constraintInfo.setType(constraintsElement.getAttribute(TYPE));
        constraintInfo.setMembers(constraintsElement.getAttribute(MEMBERS));
        if (constraintsElement.hasAttribute(UNIQUE_CONSTRAINT)) {
            constraintInfo.setUniqueConstraint(constraintsElement.getAttribute(UNIQUE_CONSTRAINT));
        }
        if (constraintsElement.hasAttribute(FOREIGN_KEY)) {
            constraintInfo.setForeignKey(constraintsElement.getAttribute(FOREIGN_KEY));
        }
        if (constraintsElement.hasAttribute(REFERENCED_MEMBERS)) {
            constraintInfo.setReferencedMembers(constraintsElement.getAttribute(REFERENCED_MEMBERS));
        }
        if (constraintsElement.hasAttribute(REFERENCED_TABLE)) {
            constraintInfo.setReferencedTable(constraintsElement.getAttribute(REFERENCED_TABLE));
        }
        if ("SQLConstraints:PrimaryKey".equals(constraintInfo.getType())) {
            String[] members;
            String[] stringArray = members = constraintInfo.getMembers();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                String member = stringArray[n2];
                if (!tableInfo.getTableName().equals("TFALGOPOL") || !member.equals("_sENdNL0yEdu0kO8I8T7YKw")) {
                    tableInfo.addPrimaryKeyColumnInfo(tableInfo.getColumnInfo(member));
                }
                ++n2;
            }
        }
    }
}

