/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.port.parsers;

import com.ibm.commerce.jpa.logger.LoggerHelper;
import com.ibm.commerce.jpa.port.info.EntityInfo;
import com.ibm.commerce.jpa.port.info.ModuleInfo;
import com.ibm.commerce.jpa.port.info.UserMethodInfo;
import com.ibm.commerce.jpa.port.util.AbstractEntityDataUtil;
import com.ibm.commerce.jpa.port.util.JavaUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class RemoteInterfaceParser {
    private static final Logger LOGGER = LoggerHelper.getLogger(RemoteInterfaceParser.class);
    private static final String PROTECTABLE = "com.ibm.commerce.security.Protectable";
    private static final String GROUPABLE = "com.ibm.commerce.grouping.Groupable";
    private static final String COPY_HELPER = "com.ibm.ivj.ejb.runtime.CopyHelper";
    private static final String EJB_OBJECT = "javax.ejb.EJBObject";
    private static final String EJB_CREATE = "ejbCreate";
    private static final String COMMIT_COPY_HELPER = "commitCopyHelper";
    private static final String REFRESH_COPY_HELPER = "refreshCopyHelper";
    private static final Set<String> STANDARD_INTERFACES = new HashSet<String>();
    private static final Set<String> STANDARD_METHODS;
    private static final String EJS_REMOTE_CMP = "EJSRemoteCMP";
    private static final String STUB = "_Stub";
    private EntityInfo iEntityInfo;
    private ModuleInfo iModuleInfo;
    private ASTParser iASTParser;

    static {
        STANDARD_INTERFACES.add(PROTECTABLE);
        STANDARD_INTERFACES.add(GROUPABLE);
        STANDARD_INTERFACES.add(COPY_HELPER);
        STANDARD_INTERFACES.add(EJB_OBJECT);
        STANDARD_METHODS = new HashSet<String>();
        STANDARD_METHODS.add(EJB_CREATE);
        STANDARD_METHODS.add(COMMIT_COPY_HELPER);
        STANDARD_METHODS.add(REFRESH_COPY_HELPER);
    }

    public RemoteInterfaceParser(ASTParser astParser, EntityInfo entityInfo) {
        this.iASTParser = astParser;
        this.iEntityInfo = entityInfo;
        this.iModuleInfo = entityInfo.getModuleInfo();
    }

    public void parse(IProgressMonitor progressMonitor) {
        try {
            try {
                progressMonitor.beginTask("parse remote interface for " + this.iEntityInfo.getEjbName(), -1);
                IType remoteInterface = this.iEntityInfo.getRemoteType();
                if (remoteInterface != null) {
                    this.parseInterface(progressMonitor, remoteInterface);
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
                progressMonitor.done();
            }
        }
        finally {
            progressMonitor.done();
        }
    }

    private void parseInterface(IProgressMonitor progressMonitor, IType interfaceType) throws JavaModelException {
        String[] superInterfaceNames;
        String[] stringArray = superInterfaceNames = interfaceType.getSuperInterfaceNames();
        int n = superInterfaceNames.length;
        int n2 = 0;
        while (n2 < n) {
            String superInterfaceName = stringArray[n2];
            IType superInterface = JavaUtil.resolveType(interfaceType, superInterfaceName);
            if (superInterface != null) {
                superInterfaceName = superInterface.getFullyQualifiedName('.');
                if (PROTECTABLE.equals(superInterfaceName)) {
                    this.iEntityInfo.setProtectable(true);
                } else if (GROUPABLE.equals(superInterfaceName)) {
                    this.iEntityInfo.setGroupable(true);
                }
                if (!STANDARD_INTERFACES.contains(superInterfaceName) && superInterface.getResource() != null && superInterface.getResource().getProject() == interfaceType.getResource().getProject()) {
                    this.parseInterface(progressMonitor, superInterface);
                }
            }
            ++n2;
        }
        this.iASTParser.setResolveBindings(true);
        this.iASTParser.setSource(interfaceType.getCompilationUnit());
        CompilationUnit compilationUnit = (CompilationUnit)this.iASTParser.createAST((IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
        TypeDeclaration typeDeclaration = (TypeDeclaration)compilationUnit.types().get(0);
        List bodyDeclarations = typeDeclaration.bodyDeclarations();
        for (BodyDeclaration bodyDeclaration : bodyDeclarations) {
            if (bodyDeclaration.getNodeType() != 31) continue;
            this.parseMethodDeclaration(interfaceType, (MethodDeclaration)bodyDeclaration);
            progressMonitor.worked(100);
        }
        this.iModuleInfo.addDeleteIntendedType(interfaceType.getFullyQualifiedName('.'));
        ITypeHierarchy typeHierarchy = interfaceType.newTypeHierarchy(this.iModuleInfo.getJavaProject(), (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1000));
        IType[] implementingClasses = typeHierarchy.getImplementingClasses(interfaceType);
        if (implementingClasses != null) {
            IType[] iTypeArray = implementingClasses;
            int n3 = implementingClasses.length;
            int n4 = 0;
            while (n4 < n3) {
                IType implementingClass = iTypeArray[n4];
                String typeName = implementingClass.getTypeQualifiedName();
                if (typeName.startsWith(EJS_REMOTE_CMP)) {
                    this.iModuleInfo.addDeleteIntendedType(implementingClass.getFullyQualifiedName('.'));
                    String tieClassName = String.valueOf(implementingClass.getPackageFragment().getElementName()) + "._" + implementingClass.getTypeQualifiedName() + "_Tie";
                    IType tieClassType = JavaUtil.resolveType(implementingClass, tieClassName);
                    if (tieClassType != null) {
                        this.iModuleInfo.addDeleteIntendedType(tieClassType.getFullyQualifiedName('.'));
                    }
                } else if (typeName.endsWith(STUB)) {
                    this.iModuleInfo.addDeleteIntendedType(implementingClass.getFullyQualifiedName('.'));
                } else {
                    LOGGER.info("unexpected remote interface implementor: " + implementingClass.getFullyQualifiedName('.'));
                }
                ++n4;
            }
        }
        this.iModuleInfo.getApplicationInfo().incrementParsedAssetCount();
    }

    private void parseMethodDeclaration(IType interfaceType, MethodDeclaration methodDeclaration) {
        String methodName = methodDeclaration.getName().getIdentifier();
        if (!STANDARD_METHODS.contains(methodName)) {
            UserMethodInfo userMethodInfo = new UserMethodInfo(methodName);
            List parameters = methodDeclaration.parameters();
            for (SingleVariableDeclaration parameter : parameters) {
                String parameterName = parameter.getName().getIdentifier();
                Type parameterType = parameter.getType();
                String parameterTypeName = parameterType.resolveBinding().getQualifiedName();
                int i = 0;
                while (i < parameter.getExtraDimensions()) {
                    parameterTypeName = String.valueOf(parameterTypeName) + "[]";
                    ++i;
                }
                userMethodInfo.addParameter(parameterName, parameterTypeName);
            }
            Type returnType = methodDeclaration.getReturnType2();
            if (!(returnType == null || returnType.isPrimitiveType() && ((PrimitiveType)returnType).getPrimitiveTypeCode() == PrimitiveType.VOID)) {
                userMethodInfo.setReturnType(returnType.resolveBinding().getQualifiedName());
            }
            boolean entityDataUserMethod = false;
            if (userMethodInfo.getParameterTypes().size() == 1) {
                entityDataUserMethod = this.isEntityDataType(interfaceType, userMethodInfo.getParameterTypes().get(0));
            } else if (userMethodInfo.getReturnType() != null) {
                entityDataUserMethod = this.isEntityDataType(interfaceType, userMethodInfo.getReturnType());
            }
            if (!entityDataUserMethod) {
                this.iEntityInfo.addUserMethod(userMethodInfo);
            }
        }
    }

    private boolean isEntityDataType(IType interfaceType, String typeName) {
        IType type = JavaUtil.resolveType(interfaceType, typeName);
        try {
            return AbstractEntityDataUtil.isAbstractEntityDataType(type);
        }
        catch (Exception e) {
            LOGGER.info("exception " + e + " while checking " + interfaceType + " typeName=" + typeName);
            return false;
        }
    }
}

