/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.port.parsers;

import com.ibm.commerce.jpa.port.info.EntityInfo;
import com.ibm.commerce.jpa.port.info.FinderInfo;
import com.ibm.commerce.jpa.port.info.MethodInfo;
import com.ibm.commerce.jpa.port.info.ModuleInfo;
import org.eclipse.core.resources.IFile;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IbmEjbJarExtXmiParser {
    private static final String EJB_EXTENSIONS = "ejbExtensions";
    private static final String ID = "xmi:id";
    private static final String NAME = "name";
    private static final String CONCURRENCY_CONTROL = "concurrencyControl";
    private static final String TYPE = "type";
    private static final String PARMS = "parms";
    private static final String ENTERPRISE_BEAN = "enterpriseBean";
    private static final String HREF = "href";
    private static final String FINDER_DESCRIPTORS = "finderDescriptors";
    private static final String XMI_TYPE = "xmi:type";
    private static final String WHERE_CLAUSE = "whereClause";
    private static final String SELECT_STATEMENT = "selectStatement";
    private static final String EJB_QL_QUERY_STRING = "ejbqlQueryString";
    private static final String FINDER_METHOD_ELEMENTS = "finderMethodElements";
    private static final String ACCESS_INTENTS = "accessIntents";
    private static final String INTENT_TYPE = "intentType";
    private static final String METHOD_ELEMENTS = "methodElements";
    private static final String GENERALIZATIONS = "generalizations";
    private static final String SUBTYPE = "subtype";
    private static final String SUPERTYPE = "supertype";
    private static final String FOR_UPDATE_WITH_RS = "FOR UPDATE WITH RS";
    private static final String FOR_UPDATE = "FOR UPDATE";
    private IFile iFile;
    private ModuleInfo iModuleInfo;

    public IbmEjbJarExtXmiParser(IFile file, ModuleInfo moduleInfo) {
        this.iFile = file;
        this.iModuleInfo = moduleInfo;
    }

    public void parse() {
        Document document = this.iModuleInfo.getXMLUtil().readXml(this.iFile);
        this.parseEJBJarExtensionElement(document.getDocumentElement());
        this.iModuleInfo.getApplicationInfo().incrementParsedAssetCount();
    }

    private void parseEJBJarExtensionElement(Element ejbJarExtensionElement) {
        NodeList childNodes = ejbJarExtensionElement.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = childNodes.item(i);
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                String nodeName = element.getNodeName();
                if (EJB_EXTENSIONS.equals(nodeName)) {
                    this.parseEjbExtensionsElement(element);
                } else {
                    GENERALIZATIONS.equals(nodeName);
                }
            }
            ++i;
        }
    }

    private void parseEjbExtensionsElement(Element ejbExtensionsElement) {
        Element element;
        String nodeName;
        Node node;
        EntityInfo entityInfo = null;
        NodeList childNodes = ejbExtensionsElement.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            node = childNodes.item(i);
            if (node.getNodeType() == 1 && ENTERPRISE_BEAN.equals(nodeName = (element = (Element)node).getNodeName())) {
                entityInfo = this.parseEnterpriseBeanElement(element);
            }
            ++i;
        }
        if (entityInfo != null && ejbExtensionsElement.hasAttribute(CONCURRENCY_CONTROL)) {
            entityInfo.setConcurrencyControl(ejbExtensionsElement.getAttribute(CONCURRENCY_CONTROL));
        }
        i = 0;
        while (i < childNodes.getLength()) {
            node = childNodes.item(i);
            if (node.getNodeType() == 1) {
                element = (Element)node;
                nodeName = element.getNodeName();
                if (FINDER_DESCRIPTORS.equals(nodeName) && entityInfo != null) {
                    this.parseFinderDescriptorsElement(element, entityInfo);
                } else if (ACCESS_INTENTS.equals(nodeName) && entityInfo != null) {
                    this.parseAccessIntentsElement(element, entityInfo);
                }
            }
            ++i;
        }
    }

    private EntityInfo parseEnterpriseBeanElement(Element enterpriseBeanElement) {
        EntityInfo entityInfo = null;
        String href = enterpriseBeanElement.getAttribute(HREF);
        int index = href.indexOf(35);
        if (index > -1) {
            String entityId = href.substring(index + 1);
            entityInfo = this.iModuleInfo.getEntityInfo(entityId);
        }
        return entityInfo;
    }

    private void parseFinderDescriptorsElement(Element finderDescriptorsElement, EntityInfo entityInfo) {
        FinderInfo finderInfo = entityInfo.getFinderInfo(finderDescriptorsElement.getAttribute(ID), true);
        if (finderDescriptorsElement.hasAttribute(XMI_TYPE)) {
            finderInfo.setFinderType(finderDescriptorsElement.getAttribute(XMI_TYPE));
        }
        if (finderDescriptorsElement.hasAttribute(WHERE_CLAUSE)) {
            String finderWhereClause = finderDescriptorsElement.getAttribute(WHERE_CLAUSE);
            finderInfo.setFinderWhereClause(finderWhereClause);
            if (finderWhereClause.contains(FOR_UPDATE_WITH_RS)) {
                finderInfo.setOracleFinderWhereClause(finderWhereClause.replaceAll(FOR_UPDATE_WITH_RS, FOR_UPDATE));
            }
        }
        if (finderDescriptorsElement.hasAttribute(SELECT_STATEMENT)) {
            finderInfo.setFinderSelectStatement(finderDescriptorsElement.getAttribute(SELECT_STATEMENT));
        }
        if (finderDescriptorsElement.hasAttribute(EJB_QL_QUERY_STRING)) {
            finderInfo.setFinderQuery(finderDescriptorsElement.getAttribute(EJB_QL_QUERY_STRING));
        }
        NodeList childNodes = finderDescriptorsElement.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Element element;
            String nodeName;
            Node node = childNodes.item(i);
            if (node.getNodeType() == 1 && FINDER_METHOD_ELEMENTS.equals(nodeName = (element = (Element)node).getNodeName())) {
                this.parseFinderMethodElementsElement(element, finderInfo);
            }
            ++i;
        }
    }

    private void parseFinderMethodElementsElement(Element finderMethodElementsElement, FinderInfo finderInfo) {
        if (finderMethodElementsElement.hasAttribute(NAME)) {
            finderInfo.setFinderMethodName(finderMethodElementsElement.getAttribute(NAME));
        }
        if (finderMethodElementsElement.hasAttribute(PARMS)) {
            finderInfo.setFinderMethodParameterTypes(finderMethodElementsElement.getAttribute(PARMS));
        }
        if (finderMethodElementsElement.hasAttribute(TYPE)) {
            finderInfo.setFinderMethodType(finderMethodElementsElement.getAttribute(TYPE));
        }
    }

    private void parseAccessIntentsElement(Element accessIntentsElement, EntityInfo entityInfo) {
        String intentType = accessIntentsElement.getAttribute(INTENT_TYPE);
        NodeList childNodes = accessIntentsElement.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Element element;
            String nodeName;
            Node node = childNodes.item(i);
            if (node.getNodeType() == 1 && METHOD_ELEMENTS.equals(nodeName = (element = (Element)node).getNodeName())) {
                MethodInfo methodInfo = new MethodInfo(element.getAttribute(NAME), element.getAttribute(PARMS));
                if (element.hasAttribute(TYPE)) {
                    methodInfo.setMethodType(element.getAttribute(TYPE));
                }
                entityInfo.addAccessIntentMethod(intentType, methodInfo);
            }
            ++i;
        }
    }

    private void parseGeneralizationsElement(Element generalizationsElement) {
        EntityInfo subtype = null;
        EntityInfo supertype = null;
        NodeList childNodes = generalizationsElement.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = childNodes.item(i);
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                String nodeName = element.getNodeName();
                if (SUBTYPE.equals(nodeName)) {
                    subtype = this.parseEnterpriseBeanElement(element);
                } else if (SUPERTYPE.equals(nodeName)) {
                    supertype = this.parseEnterpriseBeanElement(element);
                }
            }
            ++i;
        }
        subtype.setSuperType(supertype);
        supertype.addSubtype(subtype);
    }
}

