/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.port.parsers;

import com.ibm.commerce.jpa.port.info.EntityInfo;
import com.ibm.commerce.jpa.port.info.ModuleInfo;
import org.eclipse.core.resources.IFile;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IbmEjbJarBndXmiParser {
    private static final String EJB_BINDINGS = "ejbBindings";
    private static final String JNDI_NAME = "jndiName";
    private static final String ENTERPRISE_BEAN = "enterpriseBean";
    private static final String HREF = "href";
    private IFile iFile;
    private ModuleInfo iModuleInfo;

    public IbmEjbJarBndXmiParser(IFile file, ModuleInfo moduleInfo) {
        this.iFile = file;
        this.iModuleInfo = moduleInfo;
    }

    public void parse() {
        Document document = this.iModuleInfo.getXMLUtil().readXml(this.iFile);
        this.parseEJBJarBindingElement(document.getDocumentElement());
        this.iModuleInfo.getApplicationInfo().incrementParsedAssetCount();
    }

    private void parseEJBJarBindingElement(Element ejbJarExtensionElement) {
        NodeList childNodes = ejbJarExtensionElement.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Element element;
            String nodeName;
            Node node = childNodes.item(i);
            if (node.getNodeType() == 1 && EJB_BINDINGS.equals(nodeName = (element = (Element)node).getNodeName())) {
                this.parseEjbBindingsElement(element);
            }
            ++i;
        }
    }

    private void parseEjbBindingsElement(Element ejbBindingsElement) {
        String jndiName = null;
        if (ejbBindingsElement.hasAttribute(JNDI_NAME)) {
            jndiName = ejbBindingsElement.getAttribute(JNDI_NAME);
        }
        EntityInfo entityInfo = null;
        NodeList childNodes = ejbBindingsElement.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Element element;
            String nodeName;
            Node node = childNodes.item(i);
            if (node.getNodeType() == 1 && ENTERPRISE_BEAN.equals(nodeName = (element = (Element)node).getNodeName())) {
                entityInfo = this.parseEnterpriseBeanElement(element);
            }
            ++i;
        }
        if (jndiName != null && entityInfo != null) {
            entityInfo.setJndiName(jndiName);
        }
    }

    private EntityInfo parseEnterpriseBeanElement(Element enterpriseBeanElement) {
        EntityInfo entityInfo = null;
        String href = enterpriseBeanElement.getAttribute(HREF);
        int index = href.indexOf(35);
        if (index > -1) {
            String entityId = href.substring(index + 1);
            entityInfo = this.iModuleInfo.getEntityInfo(entityId);
        }
        return entityInfo;
    }
}

