/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.port.parsers;

import com.ibm.commerce.jpa.port.info.EntityInfo;
import com.ibm.commerce.jpa.port.info.FieldInfo;
import com.ibm.commerce.jpa.port.info.KeyClassConstructorInfo;
import com.ibm.commerce.jpa.port.info.ModuleInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class EjbKeyClassParser {
    private EntityInfo iEntityInfo;
    private ModuleInfo iModuleInfo;
    private ASTParser iASTParser;

    public EjbKeyClassParser(ASTParser astParser, EntityInfo entityInfo) {
        this.iASTParser = astParser;
        this.iEntityInfo = entityInfo;
        this.iModuleInfo = entityInfo.getModuleInfo();
    }

    public void parse(IProgressMonitor progressMonitor) {
        try {
            progressMonitor.beginTask("parse key class for " + this.iEntityInfo.getEjbName(), -1);
            IType primaryKeyType = this.iEntityInfo.getPrimaryKeyType();
            if (primaryKeyType != null && !primaryKeyType.isBinary()) {
                this.iModuleInfo.addDeleteIntendedType(primaryKeyType.getFullyQualifiedName('.'));
                this.parseKeyClass(progressMonitor, primaryKeyType);
            }
        }
        finally {
            progressMonitor.done();
        }
    }

    private void parseKeyClass(IProgressMonitor progressMonitor, IType primaryKeyType) {
        CompilationUnit compilationUnit = null;
        if (this.iEntityInfo.getSupertype() != null && this.iEntityInfo.getPrimaryKeyClass().equals(this.iEntityInfo.getSupertype().getPrimaryKeyClass())) {
            compilationUnit = this.iEntityInfo.getSupertype().getEjbKeyClassCompilationUnit();
        } else {
            this.iASTParser.setResolveBindings(true);
            this.iASTParser.setSource(primaryKeyType.getCompilationUnit());
            compilationUnit = (CompilationUnit)this.iASTParser.createAST((IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
            if (this.iEntityInfo.getSubtypes() != null) {
                this.iEntityInfo.setEjbKeyClassCompilationUnit(compilationUnit);
            }
        }
        TypeDeclaration typeDeclaration = (TypeDeclaration)compilationUnit.types().get(0);
        List bodyDeclarations = typeDeclaration.bodyDeclarations();
        for (BodyDeclaration bodyDeclaration : bodyDeclarations) {
            if (bodyDeclaration.getNodeType() != 31) continue;
            this.parseMethodDeclaration(primaryKeyType, (MethodDeclaration)bodyDeclaration);
            progressMonitor.worked(100);
        }
        this.iModuleInfo.getApplicationInfo().incrementParsedAssetCount();
    }

    private void parseMethodDeclaration(IType primaryKeyType, MethodDeclaration methodDeclaration) {
        if (methodDeclaration.isConstructor()) {
            KeyClassConstructorInfo constructorInfo = new KeyClassConstructorInfo();
            ConstructorVisitor constructorVisitor = new ConstructorVisitor();
            List<FieldInfo> constructorFields = constructorInfo.getFields();
            methodDeclaration.getBody().accept((ASTVisitor)constructorVisitor);
            List parameters = methodDeclaration.parameters();
            for (SingleVariableDeclaration singleVariableDeclaration : parameters) {
                String parameterName = singleVariableDeclaration.getName().getIdentifier();
                FieldInfo fieldInfo = constructorVisitor.getFieldInfo(parameterName);
                constructorFields.add(fieldInfo);
            }
            int index = 0;
            for (FieldInfo constructorField : constructorFields) {
                if (constructorField == null) {
                    List<FieldInfo> keyFields = this.iEntityInfo.getKeyFields();
                    for (FieldInfo keyField : keyFields) {
                        if (constructorFields.contains(keyField)) continue;
                        constructorFields.set(index, keyField);
                        break;
                    }
                }
                ++index;
            }
            this.iEntityInfo.addKeyClassConstructor(constructorInfo);
        }
    }

    private class ConstructorVisitor
    extends ASTVisitor {
        private Map<String, FieldInfo> iParameterToFieldMap = new HashMap<String, FieldInfo>();

        public FieldInfo getFieldInfo(String parameterName) {
            return this.iParameterToFieldMap.get(parameterName);
        }

        public boolean visit(Assignment assignment) {
            IBinding binding;
            SimpleName simpleName;
            String parameterName = null;
            FieldInfo fieldInfo = null;
            Expression rightHandSide = assignment.getRightHandSide();
            if (rightHandSide.getNodeType() == 42 && !(simpleName = (SimpleName)rightHandSide).isDeclaration() && (binding = simpleName.resolveBinding()) instanceof IVariableBinding && ((IVariableBinding)binding).isParameter()) {
                parameterName = simpleName.getIdentifier();
                Expression leftHandSide = assignment.getLeftHandSide();
                switch (leftHandSide.getNodeType()) {
                    case 42: {
                        simpleName = (SimpleName)leftHandSide;
                        fieldInfo = EjbKeyClassParser.this.iEntityInfo.getFieldInfoByName(simpleName.getIdentifier());
                        break;
                    }
                    case 22: {
                        FieldAccess fieldAccess = (FieldAccess)leftHandSide;
                        if (fieldAccess.getExpression().getNodeType() != 52) break;
                        fieldInfo = EjbKeyClassParser.this.iEntityInfo.getFieldInfoByName(fieldAccess.getName().getIdentifier());
                        break;
                    }
                    case 47: {
                        SuperFieldAccess superFieldAccess = (SuperFieldAccess)leftHandSide;
                        fieldInfo = EjbKeyClassParser.this.iEntityInfo.getFieldInfoByName(superFieldAccess.getName().getIdentifier());
                    }
                }
            }
            if (parameterName != null && fieldInfo != null) {
                this.iParameterToFieldMap.put(parameterName, fieldInfo);
            }
            return false;
        }
    }
}

