/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.port.parsers;

import com.ibm.commerce.jpa.logger.LoggerHelper;
import com.ibm.commerce.jpa.port.info.AccessBeanInfo;
import com.ibm.commerce.jpa.port.info.AccessBeanMethodInfo;
import com.ibm.commerce.jpa.port.info.CreatorInfo;
import com.ibm.commerce.jpa.port.info.EntityInfo;
import com.ibm.commerce.jpa.port.info.FieldInfo;
import com.ibm.commerce.jpa.port.info.InstanceVariableInfo;
import com.ibm.commerce.jpa.port.info.ModuleInfo;
import com.ibm.commerce.jpa.port.info.StaticFieldInfo;
import com.ibm.commerce.jpa.port.util.JavaUtil;
import java.beans.Introspector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;

public class EjbClassParser {
    private static final Logger LOGGER = LoggerHelper.getLogger(EjbClassParser.class);
    private static final String GENERATE_KEY_AS_INT = "generateKeyAsInt+java.lang.String";
    private static final String GENERATE_KEY_AS_LONG = "generateKeyAsLong+java.lang.String";
    private static final String INTEGER_TYPE = "java.lang.Integer";
    private static final String LONG_TYPE = "java.lang.Long";
    private static final String EJB_CREATE = "ejbCreate";
    private static final String EJB_STORE = "ejbStore";
    private static final String CREATE = "create";
    private static final String STORE = "store";
    private static final String SET_VALUE = "setValue";
    private static final String COPYRIGHT_FIELD = "COPYRIGHT";
    private static final String OPT_COUNTER = "optCounter";
    private static final String CLOB_ATTRIBUTE_VALUE = "com.ibm.commerce.base.helpers.ClobAttributeValue";
    private static final String BLOB_ATTRIBUTE_VALUE = "com.ibm.commerce.base.helpers.BlobAttributeValue";
    private static final String INITIALIZE_OPT_COUNTER = "initializeOptCounter+java.lang.Object";
    private static final String INITIALIZE_OPT_COUNTER_INFO = "initializeOptCounterInfo+java.lang.Object";
    private static final String INIT_LINKS = "_initLinks";
    private static final String RESET = "reset";
    private static final String INITIALIZE_CLOBS = "initializeClobs";
    private static final String INITIALIZE_FIELDS = "initializeFields";
    private static final String INITIALIZE = "initialize";
    private static final String PROPERTY_SET = "propertySet+java.util.Hashtable";
    private static final String LOG_AUCTION = "logAuction+com.ibm.commerce.negotiation.objects.AuctionAccessBean";
    private static final String INIT_NON_NULL_FIELDS = "initNonNullFields";
    private static final String LOG_BID = "logBid+com.ibm.commerce.negotiation.objects.BidAccessBean";
    private static final String LOG_AUTO_BID = "logAutoBid+com.ibm.commerce.negotiation.objects.AutoBidAccessBean";
    private static final String CHECK_ADDRESS_BOOK = "checkAddressBook+java.lang.Long";
    private static final String SET_ORGANIZATION_ID = "setOrganizationId+java.lang.Long";
    private static final String SET_USER_ID = "setUserId+java.lang.Long";
    private static final String CLEAR_ORDER_ITEMS_CACHE = "clearOrderItemsCache";
    private static final String GET_CLASS = "getClass";
    private static final String BASE_COMPILATION_UNIT = "baseCompilationUnit";
    private static final String TRIM = "trim";
    private static final String ACCESS_BEAN_HASHTABLE = "com.ibm.ivj.ejb.runtime.AccessBeanHashtable";
    private static final String HASH_TABLE = "java.util.Hashtable";
    private static final String PUT = "put";
    private static final String CONTAINS_KEY = "containsKey";
    private static final String COPY_FROM_EJB = "_copyFromEJB";
    private static final String COPY_TO_EJB = "_copyToEJB";
    private static final Set<String> EXEMPT_ACCESS_BEAN_METHODS = new HashSet<String>();
    private static final Set<String> CREATOR_INITIALIZERS;
    private ModuleInfo iModuleInfo;
    private EntityInfo iEntityInfo;
    private ASTParser iASTParser;
    private AccessBeanInfo iAccessBeanInfo;
    private List<CompilationUnit> iEjbCompilationUnits = new ArrayList<CompilationUnit>();
    private Set<String> iEjbCreateMethods = new HashSet<String>();
    private Set<String> iEjbGetterMethods = new HashSet<String>();
    private Set<String> iEjbSetterMethods = new HashSet<String>();
    private Set<String> iExpressionAccessBeanMethods = new HashSet<String>();
    private Set<String> iReferencedAccessBeanMethods = new HashSet<String>();
    private Set<String> iProcessedAccessBeanMethods = new HashSet<String>();
    private Map<String, String> iClobAttributeToSetterMap = new HashMap<String, String>();
    private Map<String, String> iClobAttributeToGetterMap = new HashMap<String, String>();
    private Map<String, AccessBeanInfo.CopyHelperProperty> iEjbGetterNameToCopyHelperPropertyMap = new HashMap<String, AccessBeanInfo.CopyHelperProperty>();
    private Map<String, AccessBeanInfo.CopyHelperProperty> iEjbSetterNameToCopyHelperPropertyMap = new HashMap<String, AccessBeanInfo.CopyHelperProperty>();

    static {
        EXEMPT_ACCESS_BEAN_METHODS.add(INITIALIZE_OPT_COUNTER);
        EXEMPT_ACCESS_BEAN_METHODS.add(INITIALIZE_OPT_COUNTER_INFO);
        EXEMPT_ACCESS_BEAN_METHODS.add(INIT_LINKS);
        EXEMPT_ACCESS_BEAN_METHODS.add(RESET);
        EXEMPT_ACCESS_BEAN_METHODS.add(INITIALIZE_CLOBS);
        EXEMPT_ACCESS_BEAN_METHODS.add(SET_ORGANIZATION_ID);
        CREATOR_INITIALIZERS = new HashSet<String>();
        CREATOR_INITIALIZERS.add(INITIALIZE);
        CREATOR_INITIALIZERS.add(INITIALIZE_FIELDS);
        CREATOR_INITIALIZERS.add(PROPERTY_SET);
        CREATOR_INITIALIZERS.add(LOG_AUCTION);
        CREATOR_INITIALIZERS.add(INIT_NON_NULL_FIELDS);
        CREATOR_INITIALIZERS.add(LOG_BID);
        CREATOR_INITIALIZERS.add(LOG_AUTO_BID);
        CREATOR_INITIALIZERS.add(CHECK_ADDRESS_BOOK);
        CREATOR_INITIALIZERS.add(SET_USER_ID);
        CREATOR_INITIALIZERS.add(CLEAR_ORDER_ITEMS_CACHE);
    }

    public EjbClassParser(ASTParser astParser, EntityInfo entityInfo) {
        this.iASTParser = astParser;
        this.iModuleInfo = entityInfo.getModuleInfo();
        this.iEntityInfo = entityInfo;
        this.iAccessBeanInfo = entityInfo.getAccessBeanInfo();
    }

    public void parse(IProgressMonitor progressMonitor) {
        try {
            try {
                int n;
                int n2;
                IType[] iTypeArray;
                ITypeHierarchy typeHierarchy;
                progressMonitor.beginTask("parse " + this.iEntityInfo.getEjbType().getFullyQualifiedName('.'), -1);
                this.iModuleInfo.addDeleteIntendedType(this.iEntityInfo.getEjbType().getFullyQualifiedName('.'));
                String ejsFinderInterfaceName = String.valueOf(this.iEntityInfo.getEjbType().getPackageFragment().getElementName()) + ".EJSFinder" + this.iEntityInfo.getEjbType().getTypeQualifiedName();
                IType ejsFinderInterfaceType = JavaUtil.resolveType(this.iEntityInfo.getEjbType(), ejsFinderInterfaceName);
                if (ejsFinderInterfaceType != null) {
                    this.iModuleInfo.addDeleteIntendedType(ejsFinderInterfaceName);
                    typeHierarchy = ejsFinderInterfaceType.newTypeHierarchy(this.iModuleInfo.getJavaProject(), (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                    IType[] implementingClasses = typeHierarchy.getImplementingClasses(ejsFinderInterfaceType);
                    if (implementingClasses != null) {
                        iTypeArray = implementingClasses;
                        n2 = implementingClasses.length;
                        n = 0;
                        while (n < n2) {
                            IType implementingClass = iTypeArray[n];
                            String typeName = implementingClass.getFullyQualifiedName('.');
                            this.iModuleInfo.addDeleteIntendedType(typeName);
                            ++n;
                        }
                    }
                }
                if (Flags.isAbstract((int)this.iEntityInfo.getEjbType().getFlags())) {
                    typeHierarchy = this.iEntityInfo.getEjbType().newTypeHierarchy(this.iModuleInfo.getJavaProject(), (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                    IType[] subClasses = typeHierarchy.getSubclasses(this.iEntityInfo.getEjbType());
                    iTypeArray = subClasses;
                    n2 = subClasses.length;
                    n = 0;
                    while (n < n2) {
                        IType subClass = iTypeArray[n];
                        this.iModuleInfo.addDeleteIntendedType(subClass.getFullyQualifiedName('.'));
                        ++n;
                    }
                }
                this.iEntityInfo.setEjbCompilationUnit(this.parseEJBType(progressMonitor, this.iEntityInfo.getEjbType()));
                IType currentType = this.iEntityInfo.getEjbType();
                this.iEntityInfo.addClassToEjbHierarchy(currentType.getFullyQualifiedName('.'));
                if (this.iEntityInfo.getEjbBaseType() != null) {
                    this.iModuleInfo.addDeleteIntendedType(this.iEntityInfo.getEjbBaseType().getFullyQualifiedName('.'));
                    this.iEntityInfo.setEjbBaseCompilationUnit(this.parseEJBType(progressMonitor, this.iEntityInfo.getEjbBaseType()));
                    currentType = this.iEntityInfo.getEjbBaseType();
                    this.iEntityInfo.addClassToEjbHierarchy(currentType.getFullyQualifiedName('.'));
                }
                if (this.iEntityInfo.getSupertype() != null) {
                    this.iEjbCompilationUnits.add(this.iEntityInfo.getSupertype().getEjbCompilationUnit());
                    currentType = this.iEntityInfo.getSupertype().getEjbType();
                    this.iEntityInfo.addClassToEjbHierarchy(currentType.getFullyQualifiedName('.'));
                    if (this.iEntityInfo.getSupertype().getEjbBaseType() != null) {
                        this.iEjbCompilationUnits.add(this.iEntityInfo.getSupertype().getEjbBaseCompilationUnit());
                        currentType = this.iEntityInfo.getSupertype().getEjbBaseType();
                        this.iEntityInfo.addClassToEjbHierarchy(currentType.getFullyQualifiedName('.'));
                    }
                }
                progressMonitor.worked(1000);
                while (currentType != null) {
                    String baseName = currentType.getSuperclassName();
                    if (baseName != null) {
                        if ((currentType = JavaUtil.resolveType(currentType, baseName)).getCompilationUnit() == null) continue;
                        CompilationUnit compilationUnit = this.iModuleInfo.getCompilationUnit(currentType.getFullyQualifiedName('.'));
                        if (compilationUnit != null) {
                            this.iEjbCompilationUnits.add(compilationUnit);
                        } else {
                            compilationUnit = this.parseEJBType(progressMonitor, currentType);
                            compilationUnit.setProperty(BASE_COMPILATION_UNIT, (Object)Boolean.TRUE);
                            this.iModuleInfo.setCompilationUnit(currentType.getFullyQualifiedName('.'), compilationUnit);
                        }
                        this.iEntityInfo.addClassToEjbHierarchy(currentType.getFullyQualifiedName('.'));
                        continue;
                    }
                    currentType = null;
                }
                progressMonitor.worked(1000);
                this.parseCompilationUnits();
                progressMonitor.worked(1000);
                this.parseCreators();
                progressMonitor.worked(1000);
                this.parseGetters();
                progressMonitor.worked(1000);
                this.parseSetters();
                progressMonitor.worked(1000);
                this.parseReferencedAccessBeanMethods();
                progressMonitor.worked(1000);
            }
            catch (JavaModelException e) {
                e.printStackTrace();
                progressMonitor.done();
            }
        }
        finally {
            progressMonitor.done();
        }
    }

    private CompilationUnit parseEJBType(IProgressMonitor progressMonitor, IType ejbType) {
        CompilationUnit compilationUnit = null;
        if (ejbType != null) {
            this.iASTParser.setResolveBindings(true);
            this.iASTParser.setSource(ejbType.getCompilationUnit());
            compilationUnit = (CompilationUnit)this.iASTParser.createAST((IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
            this.iEjbCompilationUnits.add(compilationUnit);
        }
        return compilationUnit;
    }

    private void parseCompilationUnits() {
        for (CompilationUnit ejbCompilationUnit : this.iEjbCompilationUnits) {
            List typeDeclarations = ejbCompilationUnit.types();
            TypeDeclaration typeDeclaration = (TypeDeclaration)typeDeclarations.get(0);
            List bodyDeclarations = typeDeclaration.bodyDeclarations();
            for (BodyDeclaration bodyDeclaration : bodyDeclarations) {
                if (bodyDeclaration.getNodeType() == 31) {
                    MethodDeclaration methodDeclaration = (MethodDeclaration)bodyDeclaration;
                    String methodKey = JavaUtil.getMethodKey(methodDeclaration);
                    if (ejbCompilationUnit.getProperty(BASE_COMPILATION_UNIT) == null) {
                        this.iEntityInfo.addEjbMethodDeclaration(methodDeclaration);
                    }
                    this.parseMethodDeclaration(methodKey, methodDeclaration);
                    continue;
                }
                if (bodyDeclaration.getNodeType() != 23) continue;
                this.parseFieldDeclaration((FieldDeclaration)bodyDeclaration);
            }
            this.iModuleInfo.getApplicationInfo().incrementParsedAssetCount();
        }
        this.parseGettersAndSetters();
    }

    private void parseMethodDeclaration(String methodKey, MethodDeclaration methodDeclaration) {
        int modifiers;
        String methodName = methodDeclaration.getName().getIdentifier();
        methodDeclaration.accept((ASTVisitor)new MethodRequirementsVisitor(methodKey));
        if (methodName.equals(EJB_CREATE)) {
            this.iEntityInfo.addPortExemptMethod(methodKey);
            List parameters = methodDeclaration.parameters();
            if (parameters.size() > 0) {
                this.iEjbCreateMethods.add(methodKey);
            }
        } else if (methodName.equals(EJB_STORE)) {
            methodDeclaration.getBody().accept((ASTVisitor)new EjbStoreVisitor());
        } else if (methodName.equals(COPY_TO_EJB)) {
            methodDeclaration.getBody().accept((ASTVisitor)new CopyToEJBVisitor());
        } else if (methodName.equals(COPY_FROM_EJB)) {
            methodDeclaration.getBody().accept((ASTVisitor)new CopyFromEJBVisitor());
        } else if (methodDeclaration.resolveBinding() != null && Flags.isPublic((int)(modifiers = methodDeclaration.resolveBinding().getModifiers())) && Flags.isStatic((int)modifiers)) {
            this.iEntityInfo.addStaticMethod(methodKey);
        }
    }

    private void parseGettersAndSetters() {
        for (CompilationUnit ejbCompilationUnit : this.iEjbCompilationUnits) {
            List typeDeclarations = ejbCompilationUnit.types();
            TypeDeclaration typeDeclaration = (TypeDeclaration)typeDeclarations.get(0);
            List bodyDeclarations = typeDeclaration.bodyDeclarations();
            for (BodyDeclaration bodyDeclaration : bodyDeclarations) {
                FieldInfo fieldInfo;
                if (bodyDeclaration.getNodeType() != 31) continue;
                MethodDeclaration methodDeclaration = (MethodDeclaration)bodyDeclaration;
                String methodName = methodDeclaration.getName().getIdentifier();
                String methodKey = JavaUtil.getMethodKey(methodDeclaration);
                if (methodDeclaration.parameters().size() == 0 && methodDeclaration.getReturnType2() != null) {
                    String returnType = methodDeclaration.getReturnType2().resolveBinding().getQualifiedName();
                    if (methodDeclaration.getBody() != null) {
                        if (!methodName.startsWith(EJB_CREATE)) {
                            methodDeclaration.getBody().accept((ASTVisitor)new GeneratePrimaryKeyMethodVisitor(methodKey, returnType));
                        }
                        if (!this.iEjbGetterNameToCopyHelperPropertyMap.containsKey(methodName) && (this.iEjbGetterNameToCopyHelperPropertyMap.size() != 0 || !methodName.startsWith("get") && !methodName.startsWith("is")) && (this.iAccessBeanInfo == null || !this.iAccessBeanInfo.isExcludedPropertyMethod(methodKey))) continue;
                        GetterMethodVisitor getterMethodVisitor = new GetterMethodVisitor(methodKey, methodName);
                        methodDeclaration.getBody().accept((ASTVisitor)getterMethodVisitor);
                        continue;
                    }
                    if (!methodName.startsWith("get")) continue;
                    String fieldName = methodName.substring(3);
                    FieldInfo fieldInfo2 = this.iEntityInfo.getFieldInfoByName(fieldName);
                    if (fieldInfo2 == null) {
                        fieldInfo2 = this.iEntityInfo.getFieldInfoByName("i" + fieldName);
                    }
                    if (fieldInfo2 == null && fieldName.length() > 1) {
                        fieldName = String.valueOf(Character.toLowerCase(fieldName.charAt(0))) + fieldName.substring(1);
                        fieldInfo2 = this.iEntityInfo.getFieldInfoByName(fieldName);
                    }
                    if (fieldInfo2 == null) continue;
                    fieldInfo2.setTypeName(returnType);
                    fieldInfo2.setGetterName(methodName);
                    this.iEntityInfo.addPortExemptMethod(methodKey);
                    continue;
                }
                if (methodDeclaration.parameters().size() != 1 || !methodName.startsWith("set")) continue;
                if (methodDeclaration.getBody() != null) {
                    if (!this.iEjbSetterNameToCopyHelperPropertyMap.containsKey(methodName) && this.iEjbSetterNameToCopyHelperPropertyMap.size() != 0) continue;
                    SetterMethodVisitor setterMethodVisitor = new SetterMethodVisitor(methodName);
                    methodDeclaration.getBody().accept((ASTVisitor)setterMethodVisitor);
                    fieldInfo = setterMethodVisitor.getFieldInfo();
                    if (fieldInfo == null) continue;
                    fieldInfo.setSetterName(methodName);
                    this.iEntityInfo.setFieldSetterMethodKey(fieldInfo, methodKey);
                    this.iEntityInfo.addPortExemptMethod(methodKey);
                    this.iEjbSetterMethods.add(methodKey);
                    AccessBeanInfo.CopyHelperProperty copyHelperProperty = this.iEjbSetterNameToCopyHelperPropertyMap.get(methodName);
                    if (copyHelperProperty == null || copyHelperProperty.getFieldInfo() != null) continue;
                    copyHelperProperty.setFieldInfo(fieldInfo);
                    fieldInfo.setCopyHelperProperty(copyHelperProperty);
                    continue;
                }
                String fieldName = methodName.substring(3);
                fieldInfo = this.iEntityInfo.getFieldInfoByName(fieldName);
                if (fieldInfo == null) {
                    fieldInfo = this.iEntityInfo.getFieldInfoByName("i" + fieldName);
                }
                if (fieldInfo == null && fieldName.length() > 1) {
                    fieldName = String.valueOf(Character.toLowerCase(fieldName.charAt(0))) + fieldName.substring(1);
                    fieldInfo = this.iEntityInfo.getFieldInfoByName(fieldName);
                }
                if (fieldInfo == null) continue;
                fieldInfo.setSetterName(methodName);
                this.iEntityInfo.setFieldSetterMethodKey(fieldInfo, methodKey);
                this.iEntityInfo.addPortExemptMethod(methodKey);
            }
        }
    }

    private void parseAccessBeanMethod(AccessBeanMethodInfo accessBeanMethodInfo, MethodDeclaration methodDeclaration) {
        this.iProcessedAccessBeanMethods.add(accessBeanMethodInfo.getMethodKey());
        List parameters = methodDeclaration.parameters();
        methodDeclaration.getBody().accept((ASTVisitor)new AccessBeanMethodVisitor(parameters, accessBeanMethodInfo, accessBeanMethodInfo.getStatements()));
        String[] parameterNames = accessBeanMethodInfo.getParameterNames();
        int i = 0;
        while (i < parameterNames.length) {
            String parameterName = parameterNames[i];
            Set<FieldInfo> fieldsInitializedByParameter = accessBeanMethodInfo.getFieldsInitializedByParameter(i);
            if (fieldsInitializedByParameter != null && fieldsInitializedByParameter.size() == 1) {
                for (FieldInfo fieldInfo : fieldsInitializedByParameter) {
                    String newParameterName = fieldInfo.getTargetFieldName();
                    int j = 0;
                    while (j < parameterNames.length) {
                        if (j != i && newParameterName.equals(parameterNames[j])) {
                            newParameterName = parameterName;
                            break;
                        }
                        ++j;
                    }
                    if (newParameterName.equals(parameterName)) continue;
                    accessBeanMethodInfo.setTargetParameterName(i, newParameterName);
                }
            }
            ++i;
        }
    }

    private void parseFieldDeclaration(FieldDeclaration fieldDeclaration) {
        Type fieldType = fieldDeclaration.getType();
        ITypeBinding typeBinding = fieldType.resolveBinding();
        List ejbVariableDeclarationFragments = fieldDeclaration.fragments();
        for (VariableDeclarationFragment ejbVariableDeclarationFragment : ejbVariableDeclarationFragments) {
            String fieldName = ejbVariableDeclarationFragment.getName().getIdentifier();
            FieldInfo fieldInfo = this.iEntityInfo.getFieldInfoByName(fieldName);
            if (fieldInfo == null) {
                if (!(this.iEntityInfo.getSupertype() != null && this.iEntityInfo.getSupertype().getFieldInfoByName(fieldName) != null || COPYRIGHT_FIELD.equals(fieldName))) {
                    if ((fieldDeclaration.getModifiers() & 0x18) == 24) {
                        StaticFieldInfo staticFieldInfo = new StaticFieldInfo(fieldName, typeBinding.getQualifiedName(), ejbVariableDeclarationFragment.getInitializer());
                        this.iEntityInfo.addEjbStaticFieldInfo(staticFieldInfo);
                    } else {
                        InstanceVariableInfo instanceVariableInfo = new InstanceVariableInfo(fieldName, typeBinding.getQualifiedName(), ejbVariableDeclarationFragment.getInitializer());
                        this.iEntityInfo.addEjbInstanceVariableInfo(instanceVariableInfo);
                    }
                }
                if (ejbVariableDeclarationFragment.getInitializer() == null) continue;
                ejbVariableDeclarationFragment.getInitializer().accept((ASTVisitor)new FieldRequirementsVisitor(fieldName));
                continue;
            }
            fieldInfo.setTypeName(typeBinding.getQualifiedName());
            this.iEntityInfo.addPortExemptField(fieldName);
        }
    }

    private void parseCreators() {
        for (String ejbCreateMethodKey : this.iEjbCreateMethods) {
            List<MethodDeclaration> methodDeclarations = this.iEntityInfo.getEjbMethodDeclarations(ejbCreateMethodKey);
            for (MethodDeclaration methodDeclaration : methodDeclarations) {
                List parameters = methodDeclaration.parameters();
                String[] parameterTypes = new String[parameters.size()];
                String[] parameterNames = new String[parameters.size()];
                int i = 0;
                for (SingleVariableDeclaration parameter : parameters) {
                    parameterNames[i] = parameter.getName().getIdentifier();
                    Type type = parameter.getType();
                    ITypeBinding typeBinding = type.resolveBinding();
                    if (typeBinding != null) {
                        parameterTypes[i] = typeBinding.getQualifiedName();
                        if (this.iEntityInfo.getPrimaryKeyField() == null && parameterTypes[i].equals(this.iEntityInfo.getPrimaryKeyClass())) {
                            parameterNames[i] = "key";
                        }
                    }
                    ++i;
                }
                CreatorInfo creatorInfo = this.iEntityInfo.getCreatorInfo(parameterTypes);
                if (creatorInfo == null) continue;
                AccessBeanMethodInfo accessBeanMethodInfo = new AccessBeanMethodInfo(this.iEntityInfo, ejbCreateMethodKey, methodDeclaration.getName().getIdentifier(), parameterTypes, null);
                i = 0;
                while (i < parameterNames.length) {
                    accessBeanMethodInfo.setParameterName(i, parameterNames[i]);
                    ++i;
                }
                this.parseAccessBeanMethod(accessBeanMethodInfo, methodDeclaration);
                creatorInfo.addAccessBeanMethodInfo(accessBeanMethodInfo);
            }
        }
    }

    private void parseGetters() {
        for (String ejbGetterMethodKey : this.iEjbGetterMethods) {
            List<MethodDeclaration> methodDeclarations = this.iEntityInfo.getEjbMethodDeclarations(ejbGetterMethodKey);
            for (MethodDeclaration methodDeclaration : methodDeclarations) {
                String returnType = null;
                if (methodDeclaration.getReturnType2() != null) {
                    returnType = methodDeclaration.getReturnType2().resolveBinding().getQualifiedName();
                }
                AccessBeanMethodInfo accessBeanMethodInfo = new AccessBeanMethodInfo(this.iEntityInfo, ejbGetterMethodKey, methodDeclaration.getName().getIdentifier(), new String[0], returnType);
                this.parseAccessBeanMethod(accessBeanMethodInfo, methodDeclaration);
                if (this.iEntityInfo.getAccessBeanMethodInfo(ejbGetterMethodKey) == null) {
                    this.iEntityInfo.setAccessBeanMethodInfo(ejbGetterMethodKey, accessBeanMethodInfo);
                    continue;
                }
                this.iEntityInfo.getAccessBeanMethodInfo(ejbGetterMethodKey).addSuperAccessBeanMethodInfo(accessBeanMethodInfo);
            }
        }
    }

    private void parseSetters() {
        for (String ejbSetterMethodKey : this.iEjbSetterMethods) {
            List<MethodDeclaration> methodDeclarations = this.iEntityInfo.getEjbMethodDeclarations(ejbSetterMethodKey);
            for (MethodDeclaration methodDeclaration : methodDeclarations) {
                List parameters = methodDeclaration.parameters();
                String[] parameterTypes = new String[parameters.size()];
                String[] parameterNames = new String[parameters.size()];
                int i = 0;
                for (SingleVariableDeclaration parameter : parameters) {
                    parameterNames[i] = parameter.getName().getIdentifier();
                    Type type = parameter.getType();
                    ITypeBinding typeBinding = type.resolveBinding();
                    if (typeBinding != null) {
                        parameterTypes[i] = typeBinding.getQualifiedName();
                    }
                    ++i;
                }
                AccessBeanMethodInfo accessBeanMethodInfo = new AccessBeanMethodInfo(this.iEntityInfo, ejbSetterMethodKey, methodDeclaration.getName().getIdentifier(), parameterTypes, null);
                i = 0;
                while (i < parameterNames.length) {
                    accessBeanMethodInfo.setParameterName(i, parameterNames[i]);
                    ++i;
                }
                this.parseAccessBeanMethod(accessBeanMethodInfo, methodDeclaration);
                FieldInfo fieldInfo = this.iEntityInfo.getFieldInfoBySetterMethodKey(ejbSetterMethodKey);
                if (fieldInfo != null) {
                    accessBeanMethodInfo.setTargetParameterName(0, fieldInfo.getTargetFieldName());
                }
                if (this.iEntityInfo.getAccessBeanMethodInfo(ejbSetterMethodKey) == null) {
                    this.iEntityInfo.setAccessBeanMethodInfo(ejbSetterMethodKey, accessBeanMethodInfo);
                    continue;
                }
                this.iEntityInfo.getAccessBeanMethodInfo(ejbSetterMethodKey).addSuperAccessBeanMethodInfo(accessBeanMethodInfo);
            }
        }
    }

    private void parseReferencedAccessBeanMethods() {
        while (!this.iReferencedAccessBeanMethods.isEmpty()) {
            Set<String> accessBeanMethods = this.iReferencedAccessBeanMethods;
            this.iReferencedAccessBeanMethods = new HashSet<String>();
            for (String methodKey : accessBeanMethods) {
                List<MethodDeclaration> methodDeclarations = this.iEntityInfo.getEjbMethodDeclarations(methodKey);
                if (methodDeclarations == null) continue;
                for (MethodDeclaration methodDeclaration : methodDeclarations) {
                    String returnType = null;
                    if (this.iExpressionAccessBeanMethods.contains(methodKey) && methodDeclaration.getReturnType2() != null) {
                        returnType = methodDeclaration.getReturnType2().resolveBinding().getQualifiedName();
                    }
                    List parameters = methodDeclaration.parameters();
                    String[] parameterTypes = new String[parameters.size()];
                    String[] parameterNames = new String[parameters.size()];
                    int i = 0;
                    for (SingleVariableDeclaration parameter : parameters) {
                        parameterNames[i] = parameter.getName().getIdentifier();
                        Type type = parameter.getType();
                        ITypeBinding typeBinding = type.resolveBinding();
                        if (typeBinding != null) {
                            parameterTypes[i] = typeBinding.getQualifiedName();
                        }
                        ++i;
                    }
                    AccessBeanMethodInfo accessBeanMethodInfo = new AccessBeanMethodInfo(this.iEntityInfo, methodKey, methodDeclaration.getName().getIdentifier(), parameterTypes, returnType);
                    i = 0;
                    while (i < parameterNames.length) {
                        accessBeanMethodInfo.setParameterName(i, parameterNames[i]);
                        ++i;
                    }
                    this.parseAccessBeanMethod(accessBeanMethodInfo, methodDeclaration);
                    if (this.iEntityInfo.getAccessBeanMethodInfo(methodKey) == null) {
                        this.iEntityInfo.setAccessBeanMethodInfo(methodKey, accessBeanMethodInfo);
                        continue;
                    }
                    this.iEntityInfo.getAccessBeanMethodInfo(methodKey).addSuperAccessBeanMethodInfo(accessBeanMethodInfo);
                }
            }
        }
    }

    private class AccessBeanExpressionVisitor
    extends ASTVisitor {
        public boolean visit(MethodInvocation methodInvocation) {
            IMethodBinding methodBinding;
            if ((methodInvocation.getExpression() == null || methodInvocation.getExpression().getNodeType() == 52) && (methodBinding = methodInvocation.resolveMethodBinding()) != null) {
                String methodKey = JavaUtil.getMethodKey(methodBinding);
                if (EjbClassParser.GENERATE_KEY_AS_INT.equals(methodKey)) {
                    EjbClassParser.this.iEntityInfo.setGeneratePrimaryKeyMethodKey(methodKey);
                    EjbClassParser.this.iEntityInfo.setGeneratedPrimaryKeyType(EjbClassParser.INTEGER_TYPE);
                } else if (EjbClassParser.GENERATE_KEY_AS_LONG.equals(methodKey)) {
                    EjbClassParser.this.iEntityInfo.setGeneratePrimaryKeyMethodKey(methodKey);
                    EjbClassParser.this.iEntityInfo.setGeneratedPrimaryKeyType(EjbClassParser.LONG_TYPE);
                }
                if (!(methodKey.equals(EjbClassParser.this.iEntityInfo.getGeneratePrimaryKeyMethodKey()) || EjbClassParser.this.iEntityInfo.getFieldInfoByGetterName(methodKey) != null || methodKey.equals(EjbClassParser.GET_CLASS) || EjbClassParser.this.iProcessedAccessBeanMethods.contains(methodKey))) {
                    EjbClassParser.this.iReferencedAccessBeanMethods.add(methodKey);
                    EjbClassParser.this.iExpressionAccessBeanMethods.add(methodKey);
                }
            }
            return true;
        }
    }

    private class AccessBeanMethodVisitor
    extends ASTVisitor {
        private List<SingleVariableDeclaration> iParameters;
        private AccessBeanMethodInfo iAccessBeanMethodInfo;
        private List<AccessBeanMethodInfo.AccessBeanStatement> iAccessBeanStatementList;
        private AccessBeanExpressionVisitor iAccessBeanExpressionVisitor;

        public AccessBeanMethodVisitor(List<SingleVariableDeclaration> parameters, AccessBeanMethodInfo accessBeanMethodInfo, List<AccessBeanMethodInfo.AccessBeanStatement> accessBeanStatementList) {
            this.iParameters = parameters;
            this.iAccessBeanMethodInfo = accessBeanMethodInfo;
            this.iAccessBeanStatementList = accessBeanStatementList;
            this.iAccessBeanExpressionVisitor = new AccessBeanExpressionVisitor();
        }

        public boolean visit(VariableDeclarationStatement variableDeclarationStatement) {
            AccessBeanMethodInfo.AccessBeanVariableDeclarationStatement accessBeanVariableDeclarationStatement = new AccessBeanMethodInfo.AccessBeanVariableDeclarationStatement();
            accessBeanVariableDeclarationStatement.setType(variableDeclarationStatement.getType().resolveBinding().getQualifiedName());
            List variableDeclarationFragments = variableDeclarationStatement.fragments();
            Iterator iterator = variableDeclarationFragments.iterator();
            if (iterator.hasNext()) {
                VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)iterator.next();
                accessBeanVariableDeclarationStatement.setVariableName(variableDeclarationFragment.getName().getIdentifier());
                Expression initializationExpression = variableDeclarationFragment.getInitializer();
                accessBeanVariableDeclarationStatement.setInitializationExpression(initializationExpression);
                initializationExpression.accept((ASTVisitor)this.iAccessBeanExpressionVisitor);
                int i = 0;
                while (i < variableDeclarationFragment.getExtraDimensions()) {
                    accessBeanVariableDeclarationStatement.setType(String.valueOf(accessBeanVariableDeclarationStatement.getType()) + "[]");
                    ++i;
                }
            }
            this.iAccessBeanStatementList.add(accessBeanVariableDeclarationStatement);
            return true;
        }

        public boolean visit(IfStatement ifStatement) {
            Expression ifExpression = ifStatement.getExpression();
            AccessBeanMethodInfo.AccessBeanIfStatement accessBeanIfStatement = new AccessBeanMethodInfo.AccessBeanIfStatement();
            ifExpression.accept((ASTVisitor)this.iAccessBeanExpressionVisitor);
            accessBeanIfStatement.setIfExpression(ifExpression);
            ifStatement.getThenStatement().accept((ASTVisitor)new AccessBeanMethodVisitor(this.iParameters, this.iAccessBeanMethodInfo, accessBeanIfStatement.getThenStatements()));
            if (ifStatement.getElseStatement() != null) {
                ifStatement.getElseStatement().accept((ASTVisitor)new AccessBeanMethodVisitor(this.iParameters, this.iAccessBeanMethodInfo, accessBeanIfStatement.getElseStatements()));
            }
            this.iAccessBeanStatementList.add(accessBeanIfStatement);
            return false;
        }

        public boolean visit(TryStatement tryStatement) {
            AccessBeanMethodInfo.AccessBeanTryStatement accessBeanTryStatement = new AccessBeanMethodInfo.AccessBeanTryStatement();
            tryStatement.getBody().accept((ASTVisitor)new AccessBeanMethodVisitor(this.iParameters, this.iAccessBeanMethodInfo, accessBeanTryStatement.getTryStatements()));
            List catchClauses = tryStatement.catchClauses();
            for (CatchClause catchClause : catchClauses) {
                AccessBeanMethodInfo.AccessBeanCatchClause accessBeanCatchClause = new AccessBeanMethodInfo.AccessBeanCatchClause(this.iAccessBeanMethodInfo);
                accessBeanTryStatement.getCatchClauses().add(accessBeanCatchClause);
                SingleVariableDeclaration catchException = catchClause.getException();
                accessBeanCatchClause.setExceptionType(catchException.getType().resolveBinding().getQualifiedName());
                accessBeanCatchClause.setExceptionVariableName(catchException.getName().getIdentifier());
                catchClause.getBody().accept((ASTVisitor)new AccessBeanMethodVisitor(this.iParameters, this.iAccessBeanMethodInfo, accessBeanCatchClause.getCatchStatements()));
            }
            if (tryStatement.getFinally() != null) {
                tryStatement.getFinally().accept((ASTVisitor)new AccessBeanMethodVisitor(this.iParameters, this.iAccessBeanMethodInfo, accessBeanTryStatement.getFinallyStatements()));
            }
            this.iAccessBeanStatementList.add(accessBeanTryStatement);
            return false;
        }

        public boolean visit(Assignment assignment) {
            Expression assignmentExpression;
            FieldInfo fieldInfo = null;
            String variableName = null;
            String instanceVariableName = null;
            Expression leftHandSide = assignment.getLeftHandSide();
            switch (leftHandSide.getNodeType()) {
                case 22: {
                    FieldAccess fieldAccess = (FieldAccess)leftHandSide;
                    if (fieldAccess.getExpression().getNodeType() != 52) break;
                    instanceVariableName = fieldAccess.getName().getIdentifier();
                    fieldInfo = EjbClassParser.this.iEntityInfo.getFieldInfoByName(instanceVariableName);
                    break;
                }
                case 42: {
                    SimpleName simpleName = (SimpleName)leftHandSide;
                    IBinding binding = simpleName.resolveBinding();
                    if (!(binding instanceof IVariableBinding)) break;
                    IVariableBinding variableBinding = (IVariableBinding)binding;
                    if (variableBinding.isField()) {
                        instanceVariableName = simpleName.getIdentifier();
                        fieldInfo = EjbClassParser.this.iEntityInfo.getFieldInfoByName(instanceVariableName);
                        break;
                    }
                    variableName = simpleName.getIdentifier();
                    break;
                }
                case 47: {
                    SuperFieldAccess superFieldAccess = (SuperFieldAccess)leftHandSide;
                    instanceVariableName = superFieldAccess.getName().getIdentifier();
                    fieldInfo = EjbClassParser.this.iEntityInfo.getFieldInfoByName(instanceVariableName);
                }
            }
            if (fieldInfo != null && !EjbClassParser.OPT_COUNTER.equals(fieldInfo.getFieldName())) {
                Expression rightHandSide;
                Expression initializationExpression = rightHandSide = assignment.getRightHandSide();
                if (rightHandSide.getNodeType() == 11) {
                    CastExpression castExpression = (CastExpression)rightHandSide;
                    rightHandSide = castExpression.getExpression();
                }
                if (rightHandSide.getNodeType() == 42) {
                    IVariableBinding variableBinding;
                    SimpleName simpleName = (SimpleName)rightHandSide;
                    IBinding binding = simpleName.resolveBinding();
                    if (binding instanceof IVariableBinding && (variableBinding = (IVariableBinding)binding).isParameter()) {
                        int i = 0;
                        for (SingleVariableDeclaration parameter : this.iParameters) {
                            if (parameter.getName().getIdentifier().equals(simpleName.getIdentifier())) {
                                AccessBeanMethodInfo.AccessBeanParameterInitializedFieldStatement accessBeanParameterInitializedFieldStatement = new AccessBeanMethodInfo.AccessBeanParameterInitializedFieldStatement(fieldInfo, i);
                                this.iAccessBeanStatementList.add(accessBeanParameterInitializedFieldStatement);
                                this.iAccessBeanMethodInfo.addFieldInitializedByParameter(i, fieldInfo);
                                this.iAccessBeanMethodInfo.addInitializedField(fieldInfo);
                                initializationExpression = null;
                                break;
                            }
                            ++i;
                        }
                    }
                } else if (rightHandSide.getNodeType() == 40) {
                    SimpleName simpleName;
                    QualifiedName qualifiedName = (QualifiedName)rightHandSide;
                    if (qualifiedName.getQualifier().getNodeType() == 42 && (simpleName = (SimpleName)qualifiedName.getQualifier()).resolveTypeBinding().getQualifiedName().equals(EjbClassParser.this.iEntityInfo.getPrimaryKeyClass())) {
                        AccessBeanMethodInfo.AccessBeanKeyParameterInitializedFieldStatement accessBeanKeyParameterInitializedFieldStatement = new AccessBeanMethodInfo.AccessBeanKeyParameterInitializedFieldStatement();
                        accessBeanKeyParameterInitializedFieldStatement.setFieldInfo(fieldInfo);
                        this.iAccessBeanStatementList.add(accessBeanKeyParameterInitializedFieldStatement);
                        initializationExpression = null;
                    }
                } else if (rightHandSide.getNodeType() == 32) {
                    String expressionType;
                    MethodInvocation methodInvocation = (MethodInvocation)rightHandSide;
                    String methodName = methodInvocation.getName().getIdentifier();
                    if (methodInvocation.getExpression() != null && (methodName.equals(EjbClassParser.CREATE) || methodName.equals(EjbClassParser.SET_VALUE)) && methodInvocation.arguments().size() == 1 && (EjbClassParser.CLOB_ATTRIBUTE_VALUE.equals(expressionType = methodInvocation.getExpression().resolveTypeBinding().getQualifiedName()) || EjbClassParser.BLOB_ATTRIBUTE_VALUE.equals(expressionType))) {
                        IVariableBinding variableBinding;
                        SimpleName simpleName;
                        IBinding binding;
                        Expression argument;
                        initializationExpression = argument = (Expression)methodInvocation.arguments().get(0);
                        if (argument.getNodeType() == 42 && (binding = (simpleName = (SimpleName)argument).resolveBinding()) instanceof IVariableBinding && (variableBinding = (IVariableBinding)binding).isParameter()) {
                            int i = 0;
                            for (SingleVariableDeclaration parameter : this.iParameters) {
                                if (parameter.getName().getIdentifier().equals(simpleName.getIdentifier())) {
                                    AccessBeanMethodInfo.AccessBeanParameterInitializedFieldStatement accessBeanParameterInitializedFieldStatement = new AccessBeanMethodInfo.AccessBeanParameterInitializedFieldStatement(fieldInfo, i);
                                    this.iAccessBeanStatementList.add(accessBeanParameterInitializedFieldStatement);
                                    this.iAccessBeanMethodInfo.addFieldInitializedByParameter(i, fieldInfo);
                                    this.iAccessBeanMethodInfo.addInitializedField(fieldInfo);
                                    initializationExpression = null;
                                    break;
                                }
                                ++i;
                            }
                        }
                    }
                }
                if (initializationExpression != null && initializationExpression.getNodeType() != 33) {
                    AccessBeanMethodInfo.AccessBeanExpressionInitializedFieldStatement accessBeanExpressionInitializedFieldStatement = new AccessBeanMethodInfo.AccessBeanExpressionInitializedFieldStatement();
                    accessBeanExpressionInitializedFieldStatement.setFieldInfo(fieldInfo);
                    accessBeanExpressionInitializedFieldStatement.setExpression(initializationExpression);
                    initializationExpression.accept((ASTVisitor)this.iAccessBeanExpressionVisitor);
                    this.iAccessBeanStatementList.add(accessBeanExpressionInitializedFieldStatement);
                    this.iAccessBeanMethodInfo.addInitializedField(fieldInfo);
                }
            } else if (variableName != null) {
                AccessBeanMethodInfo.AccessBeanVariableAssignmentStatement accessBeanVariableAssignmentStatement = new AccessBeanMethodInfo.AccessBeanVariableAssignmentStatement();
                accessBeanVariableAssignmentStatement.setVariableName(variableName);
                assignmentExpression = assignment.getRightHandSide();
                accessBeanVariableAssignmentStatement.setAssignmentExpression(assignmentExpression);
                assignmentExpression.accept((ASTVisitor)this.iAccessBeanExpressionVisitor);
                this.iAccessBeanStatementList.add(accessBeanVariableAssignmentStatement);
            } else if (fieldInfo == null && instanceVariableName != null && !EjbClassParser.OPT_COUNTER.equals(instanceVariableName) && assignment.getRightHandSide().getNodeType() != 33) {
                AccessBeanMethodInfo.AccessBeanInstanceVariableAssignmentStatement accessBeanInstanceVariableAssignmentStatement = new AccessBeanMethodInfo.AccessBeanInstanceVariableAssignmentStatement();
                accessBeanInstanceVariableAssignmentStatement.setInstanceVariableName(instanceVariableName);
                assignmentExpression = assignment.getRightHandSide();
                accessBeanInstanceVariableAssignmentStatement.setAssignmentExpression(assignmentExpression);
                assignmentExpression.accept((ASTVisitor)this.iAccessBeanExpressionVisitor);
                this.iAccessBeanStatementList.add(accessBeanInstanceVariableAssignmentStatement);
            }
            return false;
        }

        public boolean visit(ReturnStatement returnStatement) {
            boolean visitChildren = true;
            Expression returnExpression = returnStatement.getExpression();
            if ((EjbClassParser.this.iExpressionAccessBeanMethods.contains(this.iAccessBeanMethodInfo.getMethodKey()) || EjbClassParser.this.iEjbGetterMethods.contains(this.iAccessBeanMethodInfo.getMethodKey())) && (returnExpression == null || returnExpression.getNodeType() != 48)) {
                AccessBeanMethodInfo.AccessBeanReturnStatement accessBeanReturnStatement = new AccessBeanMethodInfo.AccessBeanReturnStatement();
                accessBeanReturnStatement.setReturnExpression(returnExpression);
                returnExpression.accept((ASTVisitor)this.iAccessBeanExpressionVisitor);
                this.iAccessBeanStatementList.add(accessBeanReturnStatement);
            } else if (returnExpression != null) {
                this.processStatementExpression(returnExpression);
            }
            return visitChildren;
        }

        public boolean visit(ExpressionStatement expressionStatement) {
            return this.processStatementExpression(expressionStatement.getExpression());
        }

        private boolean processStatementExpression(Expression expression) {
            boolean visitChildren = true;
            if (expression.getNodeType() == 32) {
                IVariableBinding variableBinding;
                SimpleName simpleName;
                IBinding binding;
                MethodInvocation methodInvocation = (MethodInvocation)expression;
                List arguments = methodInvocation.arguments();
                if (methodInvocation.getExpression() == null || methodInvocation.getExpression().getNodeType() == 52) {
                    visitChildren = this.processStatementMethodInvocation(methodInvocation.resolveMethodBinding(), arguments);
                } else if (methodInvocation.getExpression().getNodeType() == 42 && (binding = (simpleName = (SimpleName)methodInvocation.getExpression()).resolveBinding()) != null && binding.getKind() == 3 && !(variableBinding = (IVariableBinding)binding).isField()) {
                    AccessBeanMethodInfo.AccessBeanVariableMethodInvocationStatement accessBeanVariableMethodInvocationStatement = new AccessBeanMethodInfo.AccessBeanVariableMethodInvocationStatement();
                    accessBeanVariableMethodInvocationStatement.setVariableName(simpleName.getIdentifier());
                    accessBeanVariableMethodInvocationStatement.setVariableType(variableBinding.getType().getQualifiedName());
                    accessBeanVariableMethodInvocationStatement.setMethodName(methodInvocation.getName().getIdentifier());
                    accessBeanVariableMethodInvocationStatement.setMethodKey(JavaUtil.getMethodKey(methodInvocation.resolveMethodBinding()));
                    for (Expression argument : arguments) {
                        accessBeanVariableMethodInvocationStatement.addArgument(argument);
                        argument.accept((ASTVisitor)this.iAccessBeanExpressionVisitor);
                    }
                    this.iAccessBeanStatementList.add(accessBeanVariableMethodInvocationStatement);
                }
            } else if (expression.getNodeType() == 48) {
                SuperMethodInvocation superMethodInvocation = (SuperMethodInvocation)expression;
                String methodKey = JavaUtil.getMethodKey(superMethodInvocation.resolveMethodBinding());
                if (this.iAccessBeanMethodInfo.getMethodKey().equals(methodKey)) {
                    AccessBeanMethodInfo.AccessBeanSuperMethodInvocationStatement accessBeanSuperMethodInvocationStatement = new AccessBeanMethodInfo.AccessBeanSuperMethodInvocationStatement();
                    this.iAccessBeanStatementList.add(accessBeanSuperMethodInvocationStatement);
                    List arguments = superMethodInvocation.arguments();
                    for (Expression argument : arguments) {
                        accessBeanSuperMethodInvocationStatement.addArgument(argument);
                        argument.accept((ASTVisitor)this.iAccessBeanExpressionVisitor);
                    }
                    this.iAccessBeanMethodInfo.setCallsSuperAccessBeanMethod(true);
                } else {
                    List arguments = superMethodInvocation.arguments();
                    visitChildren = this.processStatementMethodInvocation(superMethodInvocation.resolveMethodBinding(), arguments);
                }
            }
            return visitChildren;
        }

        private boolean processStatementMethodInvocation(IMethodBinding methodBinding, List<Expression> arguments) {
            boolean visitChildren = true;
            String methodName = methodBinding.getName();
            FieldInfo fieldInfo = null;
            if (methodName.startsWith("set") && arguments.size() == 1) {
                String parameterType = methodBinding.getParameterTypes()[0].getQualifiedName();
                fieldInfo = EjbClassParser.this.iEntityInfo.getFieldInfoBySetterName(methodName);
                if (fieldInfo == null) {
                    String fieldName = methodName.substring(3);
                    fieldInfo = EjbClassParser.this.iEntityInfo.getFieldInfoByName(fieldName);
                    if (fieldInfo == null) {
                        fieldInfo = EjbClassParser.this.iEntityInfo.getFieldInfoByName("i" + fieldName);
                    }
                    if (fieldInfo == null) {
                        fieldInfo = EjbClassParser.this.iEntityInfo.getFieldInfoByName(Introspector.decapitalize(fieldName));
                    }
                }
                if (fieldInfo != null && !parameterType.equals(fieldInfo.getTypeName())) {
                    fieldInfo = null;
                }
                if (fieldInfo != null) {
                    IVariableBinding variableBinding;
                    SimpleName simpleName;
                    IBinding binding;
                    Expression setterExpression = arguments.get(0);
                    if (setterExpression.getNodeType() == 42 && (binding = (simpleName = (SimpleName)setterExpression).resolveBinding()) instanceof IVariableBinding && (variableBinding = (IVariableBinding)binding).isParameter()) {
                        int i = 0;
                        for (SingleVariableDeclaration parameter : this.iParameters) {
                            if (parameter.getName().getIdentifier().equals(simpleName.getIdentifier())) {
                                AccessBeanMethodInfo.AccessBeanParameterInitializedFieldStatement accessBeanParameterInitializedFieldStatement = new AccessBeanMethodInfo.AccessBeanParameterInitializedFieldStatement(fieldInfo, i);
                                this.iAccessBeanStatementList.add(accessBeanParameterInitializedFieldStatement);
                                this.iAccessBeanMethodInfo.addFieldInitializedByParameter(i, fieldInfo);
                                this.iAccessBeanMethodInfo.addInitializedField(fieldInfo);
                                setterExpression = null;
                                break;
                            }
                            ++i;
                        }
                    }
                    if (setterExpression != null && setterExpression.getNodeType() != 33) {
                        AccessBeanMethodInfo.AccessBeanExpressionInitializedFieldStatement accessBeanExpressionInitializedFieldStatement = new AccessBeanMethodInfo.AccessBeanExpressionInitializedFieldStatement();
                        accessBeanExpressionInitializedFieldStatement.setFieldInfo(fieldInfo);
                        accessBeanExpressionInitializedFieldStatement.setExpression(setterExpression);
                        setterExpression.accept((ASTVisitor)this.iAccessBeanExpressionVisitor);
                        this.iAccessBeanStatementList.add(accessBeanExpressionInitializedFieldStatement);
                        this.iAccessBeanMethodInfo.addInitializedField(fieldInfo);
                    }
                    visitChildren = false;
                }
            }
            if (fieldInfo == null) {
                String methodKey = JavaUtil.getMethodKey(methodBinding);
                if (EjbClassParser.this.iEntityInfo.getUserMethodInfo(methodKey) != null) {
                    AccessBeanMethodInfo.AccessBeanUserMethodInvocationStatement accessBeanUserMethodInvocationStatement = new AccessBeanMethodInfo.AccessBeanUserMethodInvocationStatement(methodKey);
                    for (Expression argument : arguments) {
                        accessBeanUserMethodInvocationStatement.addArgument(argument);
                        argument.accept((ASTVisitor)this.iAccessBeanExpressionVisitor);
                    }
                    this.iAccessBeanStatementList.add(accessBeanUserMethodInvocationStatement);
                } else if (!EXEMPT_ACCESS_BEAN_METHODS.contains(methodKey)) {
                    if (CREATOR_INITIALIZERS.contains(methodKey) || methodKey.startsWith(EjbClassParser.EJB_CREATE)) {
                        if (methodKey.equals(this.iAccessBeanMethodInfo.getMethodKey())) {
                            LOGGER.info("Marking method invalid: " + EjbClassParser.this.iEntityInfo.getEjbName() + " " + this.iAccessBeanMethodInfo.getMethodKey());
                            this.iAccessBeanMethodInfo.markInvalid();
                        } else {
                            AccessBeanMethodInfo.AccessBeanMethodInvocationStatement accessBeanMethodInvocationStatement = new AccessBeanMethodInfo.AccessBeanMethodInvocationStatement(methodKey);
                            for (Expression argument : arguments) {
                                accessBeanMethodInvocationStatement.addArgument(argument);
                                argument.accept((ASTVisitor)this.iAccessBeanExpressionVisitor);
                            }
                            this.iAccessBeanStatementList.add(accessBeanMethodInvocationStatement);
                            if (!methodKey.startsWith(EjbClassParser.EJB_CREATE) && !EjbClassParser.this.iProcessedAccessBeanMethods.contains(methodKey)) {
                                EjbClassParser.this.iReferencedAccessBeanMethods.add(methodKey);
                            }
                        }
                    } else {
                        LOGGER.info("access bean method invocation statement: " + methodKey + " in ejbCreate " + EjbClassParser.this.iEntityInfo.getEjbClass());
                    }
                }
            }
            return visitChildren;
        }
    }

    private class CopyFromEJBVisitor
    extends ASTVisitor {
        private CopyFromEJBVisitor() {
        }

        public boolean visit(MethodInvocation methodInvocation) {
            String typeName;
            ITypeBinding typeBinding;
            if (methodInvocation.getExpression() != null && EjbClassParser.PUT.equals(methodInvocation.getName().getIdentifier()) && methodInvocation.arguments().size() == 2 && (typeBinding = methodInvocation.getExpression().resolveTypeBinding()) != null && (EjbClassParser.ACCESS_BEAN_HASHTABLE.equals(typeName = typeBinding.getQualifiedName()) || EjbClassParser.HASH_TABLE.equals(typeName))) {
                MethodInvocation getterMethodInvocation;
                ClassInstanceCreation classInstanceCreation;
                List arguments;
                Expression argument;
                Expression firstArgument = (Expression)methodInvocation.arguments().get(0);
                Expression secondArgument = (Expression)methodInvocation.arguments().get(1);
                String copyHelperPropertyName = null;
                String getterMethodName = null;
                String propertyType = null;
                if (firstArgument.getNodeType() == 45) {
                    copyHelperPropertyName = ((StringLiteral)firstArgument).getLiteralValue();
                }
                if (secondArgument.getNodeType() == 32) {
                    MethodInvocation getterMethodInvocation2 = (MethodInvocation)secondArgument;
                    if (getterMethodInvocation2.getExpression() == null || getterMethodInvocation2.getNodeType() == 52) {
                        getterMethodName = getterMethodInvocation2.getName().getIdentifier();
                        ITypeBinding methodInvocationTypeBinding = getterMethodInvocation2.resolveTypeBinding();
                        if (methodInvocationTypeBinding != null) {
                            propertyType = methodInvocationTypeBinding.getQualifiedName();
                        }
                    }
                } else if (secondArgument.getNodeType() == 14 && (argument = (Expression)(arguments = (classInstanceCreation = (ClassInstanceCreation)secondArgument).arguments()).get(0)).getNodeType() == 32 && ((getterMethodInvocation = (MethodInvocation)argument).getExpression() == null || getterMethodInvocation.getNodeType() == 52)) {
                    getterMethodName = getterMethodInvocation.getName().getIdentifier();
                    ITypeBinding classInstanceCreationTypeBinding = classInstanceCreation.resolveTypeBinding();
                    if (classInstanceCreationTypeBinding != null) {
                        propertyType = classInstanceCreationTypeBinding.getQualifiedName();
                    }
                }
                if (copyHelperPropertyName != null && getterMethodName != null) {
                    AccessBeanInfo.CopyHelperProperty copyHelperProperty = EjbClassParser.this.iAccessBeanInfo.getCopyHelperProperty(copyHelperPropertyName, true);
                    EjbClassParser.this.iEjbGetterNameToCopyHelperPropertyMap.put(getterMethodName, copyHelperProperty);
                    if (copyHelperProperty.getType() == null) {
                        copyHelperProperty.setType(propertyType);
                    }
                }
            }
            return false;
        }
    }

    private class CopyToEJBVisitor
    extends ASTVisitor {
        private CopyToEJBVisitor() {
        }

        public boolean visit(IfStatement ifStatement) {
            MethodInvocation methodInvocation;
            Expression expression = ifStatement.getExpression();
            if (expression.getNodeType() == 32 && (methodInvocation = (MethodInvocation)expression).getExpression() != null && EjbClassParser.CONTAINS_KEY.equals(methodInvocation.getName().getIdentifier())) {
                Expression argument = (Expression)methodInvocation.arguments().get(0);
                ITypeBinding typeBinding = methodInvocation.getExpression().resolveTypeBinding();
                if (typeBinding != null && argument.getNodeType() == 45) {
                    String copyHelperPropertyName = ((StringLiteral)argument).getLiteralValue();
                    String typeName = typeBinding.getQualifiedName();
                    if (EjbClassParser.HASH_TABLE.equals(typeName)) {
                        ExpressionStatement expressionStatement;
                        Block block;
                        Statement thenStatement = ifStatement.getThenStatement();
                        if (thenStatement.getNodeType() == 8 && (block = (Block)thenStatement).statements().size() == 1) {
                            thenStatement = (Statement)block.statements().get(0);
                        }
                        if (thenStatement.getNodeType() == 21 && (expressionStatement = (ExpressionStatement)thenStatement).getExpression().getNodeType() == 32) {
                            AccessBeanInfo.CopyHelperProperty copyHelperProperty = EjbClassParser.this.iAccessBeanInfo.getCopyHelperProperty(copyHelperPropertyName, true);
                            EjbClassParser.this.iEjbSetterNameToCopyHelperPropertyMap.put(((MethodInvocation)expressionStatement.getExpression()).getName().getIdentifier(), copyHelperProperty);
                        }
                    }
                }
            }
            return false;
        }
    }

    private class EjbStoreVisitor
    extends ASTVisitor {
        private EjbStoreVisitor() {
        }

        public boolean visit(Assignment assignment) {
            SimpleName simpleName;
            IBinding binding;
            MethodInvocation methodInvocation;
            FieldInfo fieldInfo = null;
            String clobAttributeFieldName = null;
            Expression rightHandSide = assignment.getRightHandSide();
            if (rightHandSide.getNodeType() == 32 && (methodInvocation = (MethodInvocation)rightHandSide).getExpression() != null && methodInvocation.getName().getIdentifier().equals(EjbClassParser.STORE) && (rightHandSide = methodInvocation.getExpression()).getNodeType() == 42 && (binding = (simpleName = (SimpleName)rightHandSide).resolveBinding()) instanceof IVariableBinding && ((IVariableBinding)binding).isField()) {
                clobAttributeFieldName = simpleName.getIdentifier();
                Expression leftHandSide = assignment.getLeftHandSide();
                switch (leftHandSide.getNodeType()) {
                    case 42: {
                        simpleName = (SimpleName)leftHandSide;
                        fieldInfo = EjbClassParser.this.iEntityInfo.getFieldInfoByName(simpleName.getIdentifier());
                        break;
                    }
                    case 22: {
                        FieldAccess fieldAccess = (FieldAccess)leftHandSide;
                        if (fieldAccess.getExpression().getNodeType() != 52) break;
                        fieldInfo = EjbClassParser.this.iEntityInfo.getFieldInfoByName(fieldAccess.getName().getIdentifier());
                        break;
                    }
                    case 47: {
                        SuperFieldAccess superFieldAccess = (SuperFieldAccess)leftHandSide;
                        fieldInfo = EjbClassParser.this.iEntityInfo.getFieldInfoByName(superFieldAccess.getName().getIdentifier());
                    }
                }
            }
            if (fieldInfo != null && clobAttributeFieldName != null) {
                EjbClassParser.this.iEntityInfo.setClobAttributeFieldInfo(clobAttributeFieldName, fieldInfo);
                if (EjbClassParser.this.iClobAttributeToGetterMap.get(clobAttributeFieldName) != null) {
                    String getterMethodName = (String)EjbClassParser.this.iClobAttributeToGetterMap.get(clobAttributeFieldName);
                    fieldInfo.setGetterName(getterMethodName);
                    EjbClassParser.this.iEntityInfo.addPortExemptMethod(getterMethodName);
                }
                if (EjbClassParser.this.iClobAttributeToSetterMap.get(clobAttributeFieldName) != null) {
                    String setterMethodName = (String)EjbClassParser.this.iClobAttributeToSetterMap.get(clobAttributeFieldName);
                    fieldInfo.setSetterName(setterMethodName);
                    EjbClassParser.this.iEntityInfo.addPortExemptMethod(String.valueOf(setterMethodName) + "+" + fieldInfo.getTypeName());
                }
            }
            return false;
        }
    }

    private class FieldRequirementsVisitor
    extends ASTVisitor {
        private String iFieldName;

        public FieldRequirementsVisitor(String fieldName) {
            this.iFieldName = fieldName;
        }

        public boolean visit(SimpleName simpleName) {
            IVariableBinding variableBinding;
            IBinding binding;
            if (!simpleName.isDeclaration() && (binding = simpleName.resolveBinding()) instanceof IVariableBinding && (variableBinding = (IVariableBinding)binding).getDeclaringClass() != null) {
                EjbClassParser.this.iEntityInfo.addFieldRequiredField(this.iFieldName, simpleName.getIdentifier());
            }
            return true;
        }

        public boolean visit(QualifiedName qualifiedName) {
            return false;
        }

        public boolean visit(FieldAccess fieldAccess) {
            if (fieldAccess.getExpression().getNodeType() == 52) {
                EjbClassParser.this.iEntityInfo.addFieldRequiredField(this.iFieldName, fieldAccess.getName().getIdentifier());
            }
            return false;
        }

        public boolean visit(SuperFieldAccess superFieldAccess) {
            if (superFieldAccess.getQualifier() == null) {
                EjbClassParser.this.iEntityInfo.addFieldRequiredField(this.iFieldName, superFieldAccess.getName().getIdentifier());
            }
            return false;
        }
    }

    private class GeneratePrimaryKeyMethodVisitor
    extends ASTVisitor {
        private String iMethodKey;
        private String iReturnType;

        public GeneratePrimaryKeyMethodVisitor(String methodKey, String returnType) {
            this.iMethodKey = methodKey;
            this.iReturnType = returnType;
        }

        public boolean visit(SimpleName node) {
            if ("ECKeyManager".equals(node.getIdentifier())) {
                EjbClassParser.this.iEntityInfo.setGeneratePrimaryKeyMethodKey(this.iMethodKey);
                EjbClassParser.this.iEntityInfo.setGeneratedPrimaryKeyType(this.iReturnType);
                EjbClassParser.this.iEntityInfo.addPortExemptMethod(this.iMethodKey);
            }
            return false;
        }

        public boolean visit(MethodInvocation methodInvocation) {
            String methodKey;
            if ((methodInvocation.getExpression() == null || methodInvocation.getExpression().getNodeType() == 52) && methodInvocation.arguments().size() == 1 && ((methodKey = JavaUtil.getMethodKey(methodInvocation.resolveMethodBinding())).equals(EjbClassParser.GENERATE_KEY_AS_INT) || methodKey.equals(EjbClassParser.GENERATE_KEY_AS_LONG))) {
                EjbClassParser.this.iEntityInfo.setGeneratePrimaryKeyMethodKey(this.iMethodKey);
                EjbClassParser.this.iEntityInfo.setGeneratedPrimaryKeyType(this.iReturnType);
                EjbClassParser.this.iEntityInfo.addPortExemptMethod(this.iMethodKey);
            }
            return true;
        }
    }

    private class GetterMethodVisitor
    extends ASTVisitor {
        private String iMethodKey;
        private String iMethodName;
        private FieldInfo iFieldInfo;
        private String iFieldVariableName;

        public GetterMethodVisitor(String methodKey, String methodName) {
            this.iMethodKey = methodKey;
            this.iMethodName = methodName;
        }

        public boolean visit(ReturnStatement returnStatement) {
            Expression expression = returnStatement.getExpression();
            if (expression.getNodeType() == 36) {
                expression = ((ParenthesizedExpression)expression).getExpression();
            }
            if (expression.getNodeType() == 27) {
                InfixExpression infixExpression = (InfixExpression)expression;
                this.checkExpression(infixExpression.getLeftOperand());
                this.checkExpression(infixExpression.getRightOperand());
            } else {
                this.checkExpression(expression);
            }
            return false;
        }

        public boolean visit(VariableDeclarationStatement variableDeclarationStatement) {
            List fragments = variableDeclarationStatement.fragments();
            for (VariableDeclarationFragment fragment : fragments) {
                FieldInfo fieldInfo;
                ClassInstanceCreation classInstanceCreation;
                MethodInvocation methodInvocation;
                if (fragment.getInitializer() == null) continue;
                String fieldName = null;
                Expression expression = fragment.getInitializer();
                if (expression.getNodeType() == 32 && (methodInvocation = (MethodInvocation)expression).getExpression() != null) {
                    expression = methodInvocation.getExpression();
                }
                if (expression.getNodeType() == 14 && (classInstanceCreation = (ClassInstanceCreation)expression).arguments().size() == 1) {
                    List arguments = classInstanceCreation.arguments();
                    expression = (Expression)arguments.get(0);
                }
                switch (expression.getNodeType()) {
                    case 42: {
                        SimpleName simpleName = (SimpleName)expression;
                        fieldName = simpleName.getIdentifier();
                        break;
                    }
                    case 22: {
                        FieldAccess fieldAccess = (FieldAccess)expression;
                        if (fieldAccess.getExpression().getNodeType() != 52) break;
                        fieldName = fieldAccess.getName().getIdentifier();
                        break;
                    }
                    case 47: {
                        SuperFieldAccess superFieldAccess = (SuperFieldAccess)expression;
                        fieldName = superFieldAccess.getName().getIdentifier();
                    }
                }
                if (fieldName == null || (fieldInfo = EjbClassParser.this.iEntityInfo.getFieldInfoByName(fieldName)) == null) continue;
                this.iFieldInfo = fieldInfo;
                this.iFieldVariableName = fragment.getName().getIdentifier();
            }
            return true;
        }

        private void checkExpression(Expression expression) {
            MethodInvocation methodInvocation;
            String fieldName = null;
            if (expression.getNodeType() == 32 && (methodInvocation = (MethodInvocation)expression).getExpression() != null) {
                expression = methodInvocation.getExpression();
            }
            switch (expression.getNodeType()) {
                case 42: {
                    SimpleName simpleName = (SimpleName)expression;
                    fieldName = simpleName.getIdentifier();
                    break;
                }
                case 22: {
                    FieldAccess fieldAccess = (FieldAccess)expression;
                    if (fieldAccess.getExpression().getNodeType() != 52) break;
                    fieldName = fieldAccess.getName().getIdentifier();
                    break;
                }
                case 47: {
                    SuperFieldAccess superFieldAccess = (SuperFieldAccess)expression;
                    fieldName = superFieldAccess.getName().getIdentifier();
                }
            }
            if (fieldName != null) {
                if (fieldName.equals(this.iFieldVariableName)) {
                    fieldName = this.iFieldInfo.getFieldName();
                }
                AccessBeanInfo.CopyHelperProperty copyHelperProperty = (AccessBeanInfo.CopyHelperProperty)EjbClassParser.this.iEjbGetterNameToCopyHelperPropertyMap.get(this.iMethodName);
                AccessBeanInfo.CopyHelperProperty fieldCopyHelperProperty = null;
                if (EjbClassParser.this.iAccessBeanInfo != null) {
                    fieldCopyHelperProperty = EjbClassParser.this.iAccessBeanInfo.getCopyHelperProperty(fieldName, false);
                }
                if (fieldCopyHelperProperty == null && EjbClassParser.this.iAccessBeanInfo != null) {
                    fieldCopyHelperProperty = EjbClassParser.this.iAccessBeanInfo.getCopyHelperProperty(String.valueOf(Character.toLowerCase(fieldName.charAt(0))) + fieldName.substring(1), false);
                }
                if (copyHelperProperty == null || fieldCopyHelperProperty == null || fieldCopyHelperProperty == copyHelperProperty) {
                    FieldInfo fieldInfo = EjbClassParser.this.iEntityInfo.getFieldInfoByName(fieldName);
                    if (fieldInfo == null && EjbClassParser.this.iEntityInfo.getClobAttributeFieldInfo(fieldName) != null) {
                        fieldInfo = EjbClassParser.this.iEntityInfo.getClobAttributeFieldInfo(fieldName);
                    }
                    if (fieldInfo != null) {
                        fieldInfo.setGetterName(this.iMethodName);
                        EjbClassParser.this.iEntityInfo.addPortExemptMethod(this.iMethodKey);
                        EjbClassParser.this.iEjbGetterMethods.add(this.iMethodKey);
                        if (copyHelperProperty != null && copyHelperProperty.getFieldInfo() == null) {
                            copyHelperProperty.setFieldInfo(fieldInfo);
                            fieldInfo.setCopyHelperProperty(copyHelperProperty);
                        }
                    } else {
                        EjbClassParser.this.iClobAttributeToGetterMap.put(fieldName, this.iMethodName);
                    }
                }
            }
        }
    }

    private class MethodRequirementsVisitor
    extends ASTVisitor {
        private String iMethodKey;

        public MethodRequirementsVisitor(String methodKey) {
            this.iMethodKey = methodKey;
        }

        public boolean visit(MethodInvocation methodInvocation) {
            if (this.isThisClass(methodInvocation.getExpression())) {
                IMethodBinding methodBinding = methodInvocation.resolveMethodBinding();
                String requiredMethodKey = JavaUtil.getMethodKey(methodBinding);
                EjbClassParser.this.iEntityInfo.addRequiredMethod(this.iMethodKey, requiredMethodKey);
            }
            return true;
        }

        public boolean visit(SuperMethodInvocation superMethodInvocation) {
            IMethodBinding methodBinding = superMethodInvocation.resolveMethodBinding();
            String requiredMethodKey = JavaUtil.getMethodKey(methodBinding);
            EjbClassParser.this.iEntityInfo.addRequiredMethod(this.iMethodKey, requiredMethodKey);
            return true;
        }

        public boolean visit(SimpleName simpleName) {
            IVariableBinding variableBinding;
            IBinding binding;
            if (!simpleName.isDeclaration() && (binding = simpleName.resolveBinding()) instanceof IVariableBinding && (variableBinding = (IVariableBinding)binding).getDeclaringClass() != null) {
                EjbClassParser.this.iEntityInfo.addMethodRequiredField(this.iMethodKey, simpleName.getIdentifier());
            }
            return true;
        }

        public boolean visit(QualifiedName qualifiedName) {
            return false;
        }

        public boolean visit(FieldAccess fieldAccess) {
            if (fieldAccess.getExpression().getNodeType() == 52) {
                EjbClassParser.this.iEntityInfo.addMethodRequiredField(this.iMethodKey, fieldAccess.getName().getIdentifier());
            }
            return false;
        }

        public boolean visit(SuperFieldAccess superFieldAccess) {
            if (superFieldAccess.getQualifier() == null) {
                EjbClassParser.this.iEntityInfo.addMethodRequiredField(this.iMethodKey, superFieldAccess.getName().getIdentifier());
            }
            return false;
        }

        private boolean isThisClass(Expression expression) {
            boolean thisClass = true;
            if (expression != null && expression.getNodeType() != 52) {
                SimpleName simpleName;
                IBinding binding;
                thisClass = false;
                if (expression.getNodeType() == 42 && (binding = (simpleName = (SimpleName)expression).resolveBinding()) != null && binding.getKind() == 2) {
                    ITypeBinding typeBinding = (ITypeBinding)binding;
                    String qualifiedTypeName = typeBinding.getQualifiedName();
                    thisClass = qualifiedTypeName.equals(EjbClassParser.this.iEntityInfo.getEjbType().getFullyQualifiedName('.')) || qualifiedTypeName.equals(EjbClassParser.this.iEntityInfo.getEjbBaseType() == null ? null : EjbClassParser.this.iEntityInfo.getEjbBaseType().getFullyQualifiedName('.'));
                }
            }
            return thisClass;
        }
    }

    private class SetterMethodVisitor
    extends ASTVisitor {
        private String iMethodName;
        private FieldInfo iFieldInfo;

        public SetterMethodVisitor(String methodName) {
            this.iMethodName = methodName;
        }

        public FieldInfo getFieldInfo() {
            return this.iFieldInfo;
        }

        public boolean visit(Assignment assignment) {
            IBinding binding;
            SimpleName simpleName;
            ClassInstanceCreation classinstanceCreation;
            List arguments;
            String fieldName = null;
            Expression rightHandSide = assignment.getRightHandSide();
            Expression leftHandSide = assignment.getLeftHandSide();
            if (rightHandSide.getNodeType() == 32) {
                MethodInvocation methodInvocation = (MethodInvocation)rightHandSide;
                String methodName = methodInvocation.getName().getIdentifier();
                if (methodInvocation.getExpression() != null) {
                    if (EjbClassParser.TRIM.equals(methodName)) {
                        rightHandSide = methodInvocation.getExpression();
                    } else if (EjbClassParser.SET_VALUE.equals(methodName) && methodInvocation.arguments().size() == 1) {
                        rightHandSide = (Expression)methodInvocation.arguments().get(0);
                    }
                }
            } else if (rightHandSide.getNodeType() == 16) {
                ConditionalExpression conditionalExpression = (ConditionalExpression)rightHandSide;
                rightHandSide = conditionalExpression.getExpression();
            } else if (rightHandSide.getNodeType() == 14 && (arguments = (classinstanceCreation = (ClassInstanceCreation)rightHandSide).arguments()).size() == 1) {
                rightHandSide = (Expression)arguments.get(0);
            }
            if (rightHandSide.getNodeType() == 42 && !(simpleName = (SimpleName)rightHandSide).isDeclaration() && (binding = simpleName.resolveBinding()) instanceof IVariableBinding && ((IVariableBinding)binding).isParameter()) {
                switch (leftHandSide.getNodeType()) {
                    case 42: {
                        simpleName = (SimpleName)leftHandSide;
                        fieldName = simpleName.getIdentifier();
                        break;
                    }
                    case 22: {
                        FieldAccess fieldAccess = (FieldAccess)leftHandSide;
                        if (fieldAccess.getExpression().getNodeType() != 52) break;
                        fieldName = fieldAccess.getName().getIdentifier();
                        break;
                    }
                    case 47: {
                        SuperFieldAccess superFieldAccess = (SuperFieldAccess)leftHandSide;
                        fieldName = superFieldAccess.getName().getIdentifier();
                    }
                }
            }
            if (fieldName != null) {
                FieldInfo fieldInfo = EjbClassParser.this.iEntityInfo.getFieldInfoByName(fieldName);
                if (fieldInfo == null && EjbClassParser.this.iEntityInfo.getClobAttributeFieldInfo(fieldName) != null) {
                    fieldInfo = EjbClassParser.this.iEntityInfo.getClobAttributeFieldInfo(fieldName);
                }
                if (fieldInfo != null) {
                    this.iFieldInfo = fieldInfo;
                } else {
                    EjbClassParser.this.iClobAttributeToSetterMap.put(fieldName, this.iMethodName);
                }
            }
            return false;
        }
    }
}

