/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.port.parsers;

import com.ibm.commerce.jpa.port.info.AccessBeanInfo;
import com.ibm.commerce.jpa.port.info.EntityInfo;
import com.ibm.commerce.jpa.port.info.FieldInfo;
import com.ibm.commerce.jpa.port.info.ModuleInfo;
import com.ibm.commerce.jpa.port.util.JavaUtil;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class EjbAccessBeanClassParser {
    private static final String GET = "get";
    private static final String SET = "set";
    private static final String IN_EJB_TYPE = "InEJBType";
    private static final String STRING_CONVERTER = "com.ibm.ivj.ejb.runtime.StringConverter";
    private static final String GET_CACHE = "__getCache";
    private static final String SET_CACHE = "__setCache";
    private static final String SET_INIT_KEY = "setInitKey_";
    private EntityInfo iEntityInfo;
    private ModuleInfo iModuleInfo;
    private AccessBeanInfo iAccessBeanInfo;
    private ASTParser iASTParser;

    public EjbAccessBeanClassParser(ASTParser astParser, EntityInfo entityInfo) {
        this.iASTParser = astParser;
        this.iEntityInfo = entityInfo;
        this.iModuleInfo = entityInfo.getModuleInfo();
        this.iAccessBeanInfo = entityInfo.getAccessBeanInfo();
    }

    public void parse(IProgressMonitor progressMonitor) {
        block7: {
            try {
                try {
                    progressMonitor.beginTask("parse access bean class for " + this.iEntityInfo.getEjbName(), -1);
                    IType accessBeanType = this.iEntityInfo.getEjbAccessBeanType();
                    if (accessBeanType != null) {
                        this.parseAccessBeanClass(progressMonitor, accessBeanType);
                        break block7;
                    }
                    if (this.iEntityInfo.getAccessBeanInfo().getAccessBeanPackage() != null) {
                        this.iEntityInfo.getAccessBeanInfo().addError("ibm-ejb-access-bean.xmi: AccessBean class " + this.iEntityInfo.getAccessBeanInfo().getQualifiedAccessBeanName() + " does not exist");
                        break block7;
                    }
                    this.iEntityInfo.getAccessBeanInfo().addError("ibm-ejb-access-bean.xmi: Could not locate access bean for entity " + this.iEntityInfo.getEjbClass());
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                    progressMonitor.done();
                }
            }
            finally {
                progressMonitor.done();
            }
        }
    }

    private void parseAccessBeanClass(IProgressMonitor progressMonitor, IType accessBeanType) throws JavaModelException {
        String[] superInterfaceNames;
        this.iModuleInfo.addDeleteIntendedType(accessBeanType.getFullyQualifiedName('.'));
        String[] stringArray = superInterfaceNames = accessBeanType.getSuperInterfaceNames();
        int n = superInterfaceNames.length;
        int n2 = 0;
        while (n2 < n) {
            String superInterfaceName = stringArray[n2];
            IType superInterface = JavaUtil.resolveType(accessBeanType, superInterfaceName);
            if (superInterface != null && superInterface.getResource() != null && superInterface.getResource().getProject() == accessBeanType.getResource().getProject()) {
                this.iAccessBeanInfo.addAccessBeanInterface(superInterface.getFullyQualifiedName('.'));
                this.iModuleInfo.addDeleteIntendedType(superInterface.getFullyQualifiedName('.'));
            }
            ++n2;
        }
        this.iASTParser.setResolveBindings(true);
        this.iASTParser.setSource(accessBeanType.getCompilationUnit());
        CompilationUnit compilationUnit = (CompilationUnit)this.iASTParser.createAST((IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
        TypeDeclaration typeDeclaration = (TypeDeclaration)compilationUnit.types().get(0);
        List bodyDeclarations = typeDeclaration.bodyDeclarations();
        for (BodyDeclaration bodyDeclaration : bodyDeclarations) {
            if (bodyDeclaration.getNodeType() != 31) continue;
            this.parseMethodDeclaration(accessBeanType, (MethodDeclaration)bodyDeclaration);
            progressMonitor.worked(100);
        }
        this.iModuleInfo.getApplicationInfo().incrementParsedAssetCount();
    }

    private void parseMethodDeclaration(IType primaryKeyType, MethodDeclaration methodDeclaration) {
        if (!methodDeclaration.isConstructor()) {
            String methodName = methodDeclaration.getName().getIdentifier();
            if (methodName.startsWith(GET) && methodDeclaration.parameters().size() == 0 && !methodName.endsWith(IN_EJB_TYPE)) {
                GetterMethodVisitor getterMethodVisitor = new GetterMethodVisitor();
                methodDeclaration.getBody().accept((ASTVisitor)getterMethodVisitor);
                if (getterMethodVisitor.getFieldName() != null) {
                    AccessBeanInfo.CopyHelperProperty copyHelperProperty = this.iAccessBeanInfo.getCopyHelperProperty(getterMethodVisitor.getFieldName(), false);
                    if (copyHelperProperty == null) {
                        copyHelperProperty = this.iAccessBeanInfo.getCopyHelperProperty(getterMethodVisitor.getFieldName(), true);
                        copyHelperProperty.setType(getterMethodVisitor.getFieldType());
                    }
                    if (this.iAccessBeanInfo.isExcludedPropertyName(getterMethodVisitor.getFieldName())) {
                        this.iAccessBeanInfo.removeExcludedPropertyName(getterMethodVisitor.getFieldName());
                    }
                    copyHelperProperty.setGetterName(methodName);
                    copyHelperProperty.setConverterClassName(getterMethodVisitor.getConverterClassName());
                } else {
                    FieldInfo fieldInfo = this.iEntityInfo.getFieldInfoByGetterName(methodName);
                    if (fieldInfo != null) {
                        AccessBeanInfo.CopyHelperProperty copyHelperProperty;
                        if (this.iAccessBeanInfo.isExcludedPropertyName(fieldInfo.getFieldName())) {
                            this.iAccessBeanInfo.removeExcludedPropertyName(fieldInfo.getFieldName());
                        }
                        if ((copyHelperProperty = this.iAccessBeanInfo.getCopyHelperProperty(fieldInfo.getFieldName(), false)) == null) {
                            copyHelperProperty = this.iAccessBeanInfo.getCopyHelperProperty(fieldInfo.getFieldName(), true);
                            copyHelperProperty.setType(fieldInfo.getTypeName());
                        }
                        copyHelperProperty.setGetterName(methodName);
                    }
                }
            } else if (methodName.startsWith(SET_INIT_KEY) && methodDeclaration.parameters().size() == 1) {
                String fieldName = methodName.substring(SET_INIT_KEY.length());
                FieldInfo fieldInfo = this.iEntityInfo.getFieldInfoByName(fieldName);
                if (fieldInfo != null) {
                    SetInitKeyMethodVisitor setInitKeyMethodVisitor = new SetInitKeyMethodVisitor();
                    methodDeclaration.getBody().accept((ASTVisitor)setInitKeyMethodVisitor);
                    AccessBeanInfo.NullConstructorParameter nullConstructorParameter = this.iAccessBeanInfo.getNullConstructorParameterByName(fieldName);
                    if (nullConstructorParameter == null) {
                        nullConstructorParameter = this.iAccessBeanInfo.getNullConstructorParameter(fieldName, true);
                        nullConstructorParameter.setName(fieldName);
                        nullConstructorParameter.setType(setInitKeyMethodVisitor.getFieldType());
                    }
                    if (setInitKeyMethodVisitor.getConverterClassName() != null) {
                        nullConstructorParameter.setConverterClassName(setInitKeyMethodVisitor.getConverterClassName());
                    }
                }
            } else if (methodName.startsWith(SET) && methodDeclaration.parameters().size() == 1) {
                SetterMethodVisitor setterMethodVisitor = new SetterMethodVisitor();
                methodDeclaration.getBody().accept((ASTVisitor)setterMethodVisitor);
                if (setterMethodVisitor.getFieldName() != null) {
                    AccessBeanInfo.CopyHelperProperty copyHelperProperty = this.iEntityInfo.getAccessBeanInfo().getCopyHelperProperty(setterMethodVisitor.getFieldName(), false);
                    if (copyHelperProperty == null) {
                        copyHelperProperty = this.iAccessBeanInfo.getCopyHelperProperty(setterMethodVisitor.getFieldName(), true);
                        copyHelperProperty.setType(setterMethodVisitor.getFieldType());
                    }
                    if (this.iAccessBeanInfo.isExcludedPropertyName(setterMethodVisitor.getFieldName())) {
                        this.iAccessBeanInfo.removeExcludedPropertyName(setterMethodVisitor.getFieldName());
                    }
                    copyHelperProperty.setSetterName(methodName);
                    if (setterMethodVisitor.getConverterClassName() != null) {
                        copyHelperProperty.setConverterClassName(setterMethodVisitor.getConverterClassName());
                    }
                }
            }
        }
    }

    private class GetterMethodVisitor
    extends ASTVisitor {
        private String iFieldName;
        private String iConverterClassName;
        private String iFieldType;

        public String getFieldName() {
            return this.iFieldName;
        }

        public String getConverterClassName() {
            return this.iConverterClassName;
        }

        public String getFieldType() {
            return this.iFieldType;
        }

        public boolean visit(MethodInvocation methodInvocation) {
            ITypeBinding[] interfaces;
            ITypeBinding typeBinding;
            String methodName = methodInvocation.getName().getIdentifier();
            if (EjbAccessBeanClassParser.GET_CACHE.equals(methodName) && methodInvocation.arguments().size() == 1) {
                Expression argument = (Expression)methodInvocation.arguments().get(0);
                if (argument.getNodeType() == 45) {
                    StringLiteral stringLiteral = (StringLiteral)argument;
                    this.iFieldName = stringLiteral.getLiteralValue();
                }
            } else if (methodInvocation.getExpression() != null && methodInvocation.arguments().size() == 1 && (typeBinding = methodInvocation.getExpression().resolveTypeBinding()) != null && (interfaces = typeBinding.getInterfaces()) != null) {
                ITypeBinding[] iTypeBindingArray = interfaces;
                int n = interfaces.length;
                int n2 = 0;
                while (n2 < n) {
                    ITypeBinding interfaceTypeBinding = iTypeBindingArray[n2];
                    if (EjbAccessBeanClassParser.STRING_CONVERTER.equals(interfaceTypeBinding.getQualifiedName())) {
                        this.iConverterClassName = typeBinding.getQualifiedName();
                        this.iFieldType = ((Expression)methodInvocation.arguments().get(0)).resolveTypeBinding().getQualifiedName();
                        break;
                    }
                    ++n2;
                }
            }
            return true;
        }

        public void endVisit(ReturnStatement returnStatement) {
            if (this.iFieldType == null && returnStatement.getExpression() != null) {
                this.iFieldType = returnStatement.getExpression().resolveTypeBinding().getQualifiedName();
            }
        }
    }

    private class SetInitKeyMethodVisitor
    extends ASTVisitor {
        private String iConverterClassName;
        private String iFieldType;

        public String getConverterClassName() {
            return this.iConverterClassName;
        }

        public String getFieldType() {
            return this.iFieldType;
        }

        public boolean visit(MethodInvocation methodInvocation) {
            ITypeBinding[] interfaces;
            ITypeBinding typeBinding;
            if (methodInvocation.getExpression() != null && methodInvocation.arguments().size() == 1 && (typeBinding = methodInvocation.getExpression().resolveTypeBinding()) != null && (interfaces = typeBinding.getInterfaces()) != null) {
                ITypeBinding[] iTypeBindingArray = interfaces;
                int n = interfaces.length;
                int n2 = 0;
                while (n2 < n) {
                    ITypeBinding interfaceTypeBinding = iTypeBindingArray[n2];
                    if (EjbAccessBeanClassParser.STRING_CONVERTER.equals(interfaceTypeBinding.getQualifiedName())) {
                        this.iConverterClassName = typeBinding.getQualifiedName();
                        this.iFieldType = methodInvocation.resolveTypeBinding().getQualifiedName();
                        break;
                    }
                    ++n2;
                }
            }
            return true;
        }
    }

    private class SetterMethodVisitor
    extends ASTVisitor {
        private String iFieldName;
        private String iConverterClassName;
        private String iFieldType;

        public String getFieldName() {
            return this.iFieldName;
        }

        public String getFieldType() {
            return this.iFieldType;
        }

        public String getConverterClassName() {
            return this.iConverterClassName;
        }

        public boolean visit(MethodInvocation methodInvocation) {
            ITypeBinding[] interfaces;
            ITypeBinding typeBinding;
            String methodName = methodInvocation.getName().getIdentifier();
            if (EjbAccessBeanClassParser.SET_CACHE.equals(methodName) && methodInvocation.arguments().size() == 2) {
                Expression argument = (Expression)methodInvocation.arguments().get(0);
                if (argument.getNodeType() == 45) {
                    StringLiteral stringLiteral = (StringLiteral)argument;
                    this.iFieldName = stringLiteral.getLiteralValue();
                    this.iFieldType = ((Expression)methodInvocation.arguments().get(1)).resolveTypeBinding().getQualifiedName();
                }
            } else if (methodInvocation.getExpression() != null && (typeBinding = methodInvocation.getExpression().resolveTypeBinding()) != null && (interfaces = typeBinding.getInterfaces()) != null) {
                ITypeBinding[] iTypeBindingArray = interfaces;
                int n = interfaces.length;
                int n2 = 0;
                while (n2 < n) {
                    ITypeBinding interfaceTypeBinding = iTypeBindingArray[n2];
                    if (EjbAccessBeanClassParser.STRING_CONVERTER.equals(interfaceTypeBinding.getQualifiedName())) {
                        this.iConverterClassName = typeBinding.getQualifiedName();
                        break;
                    }
                    ++n2;
                }
            }
            return true;
        }
    }
}

