/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.port.info;

import com.ibm.commerce.jpa.port.info.EjbRelationshipRoleInfo;
import com.ibm.commerce.jpa.port.info.EntityInfo;
import com.ibm.commerce.jpa.port.info.FieldInfo;
import java.util.ArrayList;
import java.util.List;

public class RelatedEntityInfo {
    private EntityInfo iEntityInfo;
    private EntityInfo iParentEntityInfo;
    private String iFieldName;
    private List<FieldInfo> iMemberFields = new ArrayList<FieldInfo>();
    private List<FieldInfo> iReferencedFields = new ArrayList<FieldInfo>();
    private String iGetterName;
    private String iSetterName;
    private EjbRelationshipRoleInfo iEjbRelationshipRoleInfo;

    public RelatedEntityInfo(EntityInfo entityInfo, EntityInfo parentEntityInfo) {
        this.iEntityInfo = entityInfo;
        this.iParentEntityInfo = parentEntityInfo;
    }

    public EntityInfo getEntityInfo() {
        return this.iEntityInfo;
    }

    public EntityInfo getParentEntityInfo() {
        return this.iParentEntityInfo;
    }

    public void setFieldName(String fieldName) {
        this.iFieldName = fieldName;
        if (this.iGetterName == null) {
            this.iGetterName = "get" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
        }
        if (this.iSetterName == null) {
            this.iSetterName = "set" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
        }
    }

    public String getFieldName() {
        return this.iFieldName;
    }

    public void addMemberField(FieldInfo memberFieldInfo, FieldInfo referencedFieldInfo) {
        this.iMemberFields.add(memberFieldInfo);
        this.iReferencedFields.add(referencedFieldInfo);
        memberFieldInfo.setRelatedEntityInfo(this);
        memberFieldInfo.setReferencedFieldInfo(referencedFieldInfo);
    }

    public List<FieldInfo> getMemberFields() {
        return this.iMemberFields;
    }

    public List<FieldInfo> getReferencedFields() {
        return this.iReferencedFields;
    }

    public boolean getIsKeyField() {
        boolean isKeyField = false;
        for (FieldInfo fieldInfo : this.iMemberFields) {
            if (!fieldInfo.getIsKeyField()) continue;
            isKeyField = true;
        }
        return isKeyField;
    }

    public String getKeyFieldType() {
        String keyFieldType = null;
        if (this.getIsKeyField()) {
            if (this.iReferencedFields.size() == 1) {
                keyFieldType = this.iReferencedFields.get(0).getTypeName();
            } else if (this.iReferencedFields.size() > 1 && this.iParentEntityInfo.getEntityKeyClassInfo() != null) {
                keyFieldType = this.iParentEntityInfo.getEntityKeyClassInfo().getQualifiedClassName();
            }
        }
        return keyFieldType;
    }

    public boolean getOptional() {
        boolean optional = true;
        for (FieldInfo fieldInfo : this.iMemberFields) {
            if (fieldInfo.getColumnInfo().getNullable()) continue;
            optional = false;
        }
        return optional;
    }

    public void setGetterName(String getterName) {
        this.iGetterName = getterName;
    }

    public String getGetterName() {
        return this.iGetterName;
    }

    public void setSetterName(String setterName) {
        this.iSetterName = setterName;
    }

    public String getSetterName() {
        return this.iSetterName;
    }

    public void setEjbRelationshipRoleInfo(EjbRelationshipRoleInfo ejbRelationshipRoleInfo) {
        this.iEjbRelationshipRoleInfo = ejbRelationshipRoleInfo;
    }

    public EjbRelationshipRoleInfo getEjbRelationshipRoleInfo() {
        return this.iEjbRelationshipRoleInfo;
    }
}

