/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.port.info;

import com.ibm.commerce.jpa.logger.LoggerHelper;
import com.ibm.commerce.jpa.port.info.ApplicationInfo;
import com.ibm.commerce.jpa.port.info.ColumnInfo;
import com.ibm.commerce.jpa.port.info.ConstraintInfo;
import com.ibm.commerce.jpa.port.info.EjbRelationshipRoleInfo;
import com.ibm.commerce.jpa.port.info.EntityInfo;
import com.ibm.commerce.jpa.port.info.TableInfo;
import com.ibm.commerce.jpa.port.util.XMLUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class ModuleInfo {
    private static final Logger LOGGER = LoggerHelper.getLogger(ModuleInfo.class);
    private ApplicationInfo iApplicationInfo;
    private IJavaProject iJavaProject;
    private Map<String, EntityInfo> iEntities = new HashMap<String, EntityInfo>();
    private Map<String, EntityInfo> iEntitiesByName = new HashMap<String, EntityInfo>();
    private Map<String, EjbRelationshipRoleInfo> iEjbRelationshipRoles = new HashMap<String, EjbRelationshipRoleInfo>();
    private Map<String, TableInfo> iTables = new HashMap<String, TableInfo>();
    private Map<String, TableInfo> iTablesByName = new HashMap<String, TableInfo>();
    private Map<String, ColumnInfo> iColumns = new HashMap<String, ColumnInfo>();
    private Map<String, ConstraintInfo> iConstraints = new HashMap<String, ConstraintInfo>();
    private Map<String, CompilationUnit> iCompilationUnits = new HashMap<String, CompilationUnit>();
    private Set<String> iDeleteIntendedTypes = new HashSet<String>();

    public ModuleInfo(ApplicationInfo applicationInfo, IJavaProject javaProject) {
        this.iApplicationInfo = applicationInfo;
        this.iJavaProject = javaProject;
    }

    public ApplicationInfo getApplicationInfo() {
        return this.iApplicationInfo;
    }

    public IJavaProject getJavaProject() {
        return this.iJavaProject;
    }

    public XMLUtil getXMLUtil() {
        return this.iApplicationInfo.getXMLUtil(this.iJavaProject.getProject());
    }

    public EntityInfo getEntityInfo(String entityId) {
        return this.getEntityInfo(entityId, false);
    }

    public EntityInfo getEntityInfo(String entityId, boolean create) {
        EntityInfo entityInfo = this.iEntities.get(entityId);
        if (entityInfo == null && create) {
            entityInfo = new EntityInfo(this, entityId);
            this.iEntities.put(entityId, entityInfo);
        }
        return entityInfo;
    }

    public Collection<EntityInfo> getEntities() {
        return this.iEntities.values();
    }

    public EntityInfo getEntityInfoByName(String entityName) {
        return this.iEntitiesByName.get(entityName);
    }

    public void setEntityName(EntityInfo entityInfo, String entityName) {
        this.iEntitiesByName.put(entityName, entityInfo);
    }

    public EjbRelationshipRoleInfo getEjbRelationshipRoleInfo(String ejbRelationshipRoleId) {
        return this.getEjbRelationshipRoleInfo(ejbRelationshipRoleId, false);
    }

    public EjbRelationshipRoleInfo getEjbRelationshipRoleInfo(String ejbRelationshipRoleId, boolean create) {
        EjbRelationshipRoleInfo ejbRelationshipRoleInfo = this.iEjbRelationshipRoles.get(ejbRelationshipRoleId);
        if (ejbRelationshipRoleInfo == null && create) {
            ejbRelationshipRoleInfo = new EjbRelationshipRoleInfo(ejbRelationshipRoleId);
            this.iEjbRelationshipRoles.put(ejbRelationshipRoleId, ejbRelationshipRoleInfo);
        }
        return ejbRelationshipRoleInfo;
    }

    public Collection<EjbRelationshipRoleInfo> getEjbRelationshipRoles() {
        return this.iEjbRelationshipRoles.values();
    }

    public TableInfo getTableInfo(String tableId, boolean create) {
        TableInfo tableInfo = this.iTables.get(tableId);
        if (tableInfo == null && create) {
            tableInfo = new TableInfo(this, tableId);
            this.iTables.put(tableId, tableInfo);
        }
        return tableInfo;
    }

    public TableInfo getTableInfo(String tableId) {
        return this.getTableInfo(tableId, false);
    }

    public void setTableName(TableInfo tableInfo, String tableName) {
        tableInfo.setTableName(tableName);
        this.iTablesByName.put(tableName, tableInfo);
    }

    public TableInfo getTableInfoByName(String tableName) {
        return this.iTablesByName.get(tableName);
    }

    public Collection<TableInfo> getTables() {
        return this.iTables.values();
    }

    public void addColumnInfo(ColumnInfo columnInfo) {
        if (this.iColumns.containsKey(columnInfo.getColumnId())) {
            LOGGER.info("duplicate column ID " + columnInfo.getColumnId() + " in " + this.iJavaProject.getElementName());
        }
        this.iColumns.put(columnInfo.getColumnId(), columnInfo);
    }

    public ColumnInfo getColumnInfo(String columnId) {
        return this.iColumns.get(columnId);
    }

    public void addConstraintInfo(ConstraintInfo constraintInfo) {
        this.iConstraints.put(constraintInfo.getConstraintId(), constraintInfo);
    }

    public ConstraintInfo getConstraintInfo(String constraintId) {
        return this.iConstraints.get(constraintId);
    }

    public void setCompilationUnit(String type, CompilationUnit compilationUnit) {
        this.iCompilationUnits.put(type, compilationUnit);
    }

    public CompilationUnit getCompilationUnit(String type) {
        return this.iCompilationUnits.get(type);
    }

    public void addDeleteIntendedType(String deleteIntendedType) {
        this.iDeleteIntendedTypes.add(deleteIntendedType);
        this.iApplicationInfo.addDeleteIntendedType(deleteIntendedType);
    }

    public Set<String> getDeleteIntendedTypes() {
        return this.iDeleteIntendedTypes;
    }
}

