/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.port.info;

import com.ibm.commerce.jpa.logger.LoggerHelper;
import com.ibm.commerce.jpa.port.info.AccessBeanSubclassInfo;
import com.ibm.commerce.jpa.port.info.EntityInfo;
import com.ibm.commerce.jpa.port.info.ModuleInfo;
import com.ibm.commerce.jpa.port.info.PersistenceUnitInfo;
import com.ibm.commerce.jpa.port.info.ProjectInfo;
import com.ibm.commerce.jpa.port.info.TableInfo;
import com.ibm.commerce.jpa.port.util.BackupUtil;
import com.ibm.commerce.jpa.port.util.XMLUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;

public class ApplicationInfo {
    private static final Logger LOGGER = LoggerHelper.getLogger(ApplicationInfo.class);
    private static final String ENTITY_CREATION_DATA = "com.ibm.commerce.context.content.objects.EntityCreationData";
    private static final String ENTITY_BEAN_CREATION_DATA = "com.ibm.commerce.context.content.resources.EntityBeanCreationData";
    private XMLUtil iXMLUtil = new XMLUtil();
    private Map<String, XMLUtil> iXMLUtils = new HashMap<String, XMLUtil>();
    private PersistenceUnitInfo iPersistenceUnitInfo;
    private Set<ModuleInfo> iModules = new HashSet<ModuleInfo>();
    private Map<String, String> iTypeMap = new HashMap<String, String>();
    private Set<String> iEntityTypes = new HashSet<String>();
    private Set<String> iEntityInterfaceTypes = new HashSet<String>();
    private Set<String> iEntityKeyTypes = new HashSet<String>();
    private Set<String> iAccessBeanTypes = new HashSet<String>();
    private Set<String> iAccessBeanInterfaceTypes = new HashSet<String>();
    private Set<String> iDataClassTypes = new HashSet<String>();
    private Map<String, EntityInfo> iEntitiesByType = new HashMap<String, EntityInfo>();
    private Set<String> iHomeInterfaceTypes = new HashSet<String>();
    private Map<String, BackupUtil> iBackupUtils = new HashMap<String, BackupUtil>();
    private Set<String> iDeleteIntendedTypes = new HashSet<String>();
    private Set<String> iEjbStubTypes = new HashSet<String>();
    private Set<String> iFactoryTypes = new HashSet<String>();
    private Map<String, ProjectInfo> iProjects = new HashMap<String, ProjectInfo>();
    private Set<String> iAccessBeanSubclasses = new HashSet<String>();
    private Map<String, AccessBeanSubclassInfo> iAccessBeanSubclassesByType = new HashMap<String, AccessBeanSubclassInfo>();
    private Set<String> iEntityJndiNames = new HashSet<String>();
    private Set<String> iStubTypes = new HashSet<String>();
    private int iParsedAssetCount = 0;
    private int iGeneratedAssetCount = 0;
    private int iSearchResultCount = 0;
    private int iUpdateCount = 0;
    private int iDeleteCount = 0;

    public ApplicationInfo() {
        this.iTypeMap.put(ENTITY_CREATION_DATA, ENTITY_BEAN_CREATION_DATA);
        this.addTypeMapping("com.ibm.commerce.registry.StoreRegistry", "com.ibm.commerce.registry.StoreRegistry");
        this.addTypeMapping("com.ibm.commerce.contract.objects.ContractJDBCHelperAccessBean", "com.ibm.commerce.contract.objects.ContractJDBCHelperAccessBean");
        this.addTypeMapping("com.ibm.commerce.utf.helper.SortingAttribute", "com.ibm.commerce.base.util.SortingAttribute");
        this.addDeleteIntendedType("com.ibm.commerce.utf.helper.SortingAttribute");
        this.addTypeMapping("com.ibm.commerce.negotiation.util.SortingAttribute", "com.ibm.commerce.base.util.SortingAttribute");
        this.addDeleteIntendedType("com.ibm.commerce.negotiation.util.SortingAttribute");
        this.iTypeMap.put("com.ibm.ivj.ejb.runtime.AbstractEntityAccessBean", "com.ibm.commerce.persistence.AbstractJpaEntityAccessBean");
        this.iTypeMap.put("com.ibm.ivj.ejb.runtime.AbstractAccessBean", "com.ibm.commerce.persistence.AbstractJpaEntityAccessBean");
        this.addDeleteIntendedType("com.ibm.commerce.context.objects.util.EJBLocalHomeFactory");
        this.addTypeMapping("com.ibm.commerce.datatype.RefreshOnceAccessBean", "com.ibm.commerce.datatype.InstantiateOnceAccessBean");
        this.addTypeMapping("com.ibm.commerce.datatype.RefreshOnceAccessBeanHelper", "com.ibm.commerce.datatype.InstantiateOnceAccessBeanHelper");
    }

    public XMLUtil getXMLUtil() {
        return this.iXMLUtil;
    }

    public void setPersistenceUnitInfo(PersistenceUnitInfo persistenceUnitInfo) {
        this.iPersistenceUnitInfo = persistenceUnitInfo;
    }

    public PersistenceUnitInfo getPersistenceUnitInfo() {
        return this.iPersistenceUnitInfo;
    }

    public void addModule(ModuleInfo moduleInfo) {
        this.iModules.add(moduleInfo);
    }

    public Set<ModuleInfo> getModules() {
        return this.iModules;
    }

    public TableInfo getTableInfo(String tableName) {
        TableInfo tableInfo = null;
        for (ModuleInfo moduleInfo : this.iModules) {
            tableInfo = moduleInfo.getTableInfoByName(tableName);
            if (tableInfo != null) break;
        }
        return tableInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTypeMapping(String oldType, String newType) {
        Map<String, String> map = this.iTypeMap;
        synchronized (map) {
            this.iTypeMap.put(oldType, newType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTypeMapping(String oldType) {
        Map<String, String> map = this.iTypeMap;
        synchronized (map) {
            return this.iTypeMap.get(oldType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntityType(String entityType) {
        Set<String> set = this.iEntityTypes;
        synchronized (set) {
            this.iEntityTypes.add(entityType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEntityType(String entityType) {
        Set<String> set = this.iEntityTypes;
        synchronized (set) {
            return this.iEntityTypes.contains(entityType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntityInterfaceType(String entityInterfaceType) {
        Set<String> set = this.iEntityInterfaceTypes;
        synchronized (set) {
            this.iEntityInterfaceTypes.add(entityInterfaceType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEntityInterfaceType(String entityInterfaceType) {
        Set<String> set = this.iEntityInterfaceTypes;
        synchronized (set) {
            return this.iEntityInterfaceTypes.contains(entityInterfaceType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntityKeyType(String entityKeyType) {
        Set<String> set = this.iEntityKeyTypes;
        synchronized (set) {
            this.iEntityKeyTypes.add(entityKeyType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEntityKeyType(String entityKeyType) {
        Set<String> set = this.iEntityKeyTypes;
        synchronized (set) {
            return this.iEntityKeyTypes.contains(entityKeyType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAccessBeanType(String accessBeanType) {
        Set<String> set = this.iAccessBeanTypes;
        synchronized (set) {
            this.iAccessBeanTypes.add(accessBeanType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAccessBeanType(String type) {
        Set<String> set = this.iAccessBeanTypes;
        synchronized (set) {
            return this.iAccessBeanTypes.contains(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAccessBeanInterfaceType(String accessBeanInterfaceType) {
        Set<String> set = this.iAccessBeanInterfaceTypes;
        synchronized (set) {
            this.iAccessBeanInterfaceTypes.add(accessBeanInterfaceType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAccessBeanInterfaceType(String type) {
        Set<String> set = this.iAccessBeanInterfaceTypes;
        synchronized (set) {
            return this.iAccessBeanInterfaceTypes.contains(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataClassType(String dataClassType) {
        Set<String> set = this.iDataClassTypes;
        synchronized (set) {
            this.iDataClassTypes.add(dataClassType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDataClassType(String type) {
        Set<String> set = this.iDataClassTypes;
        synchronized (set) {
            return this.iDataClassTypes.contains(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEntityInfoForType(String type, EntityInfo entityInfo) {
        Map<String, EntityInfo> map = this.iEntitiesByType;
        synchronized (map) {
            this.iEntitiesByType.put(type, entityInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityInfo getEntityInfoForType(String type) {
        Map<String, EntityInfo> map = this.iEntitiesByType;
        synchronized (map) {
            return this.iEntitiesByType.get(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHomeInterfaceType(String homeInterfaceType) {
        Set<String> set = this.iHomeInterfaceTypes;
        synchronized (set) {
            this.iHomeInterfaceTypes.add(homeInterfaceType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHomeInterfaceType(String type) {
        Set<String> set = this.iHomeInterfaceTypes;
        synchronized (set) {
            return this.iHomeInterfaceTypes.contains(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackupUtil getBackupUtil(IProject project) {
        Map<String, BackupUtil> map = this.iBackupUtils;
        synchronized (map) {
            BackupUtil backupUtil = this.iBackupUtils.get(project.getName());
            if (backupUtil == null) {
                backupUtil = new BackupUtil(project);
                this.iBackupUtils.put(project.getName(), backupUtil);
            }
            return backupUtil;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectInfo getProjectInfo(IProject project) {
        Map<String, ProjectInfo> map = this.iProjects;
        synchronized (map) {
            ProjectInfo projectInfo = this.iProjects.get(project.getName());
            if (projectInfo == null) {
                projectInfo = new ProjectInfo(this, project);
                this.iProjects.put(project.getName(), projectInfo);
            }
            return projectInfo;
        }
    }

    public Collection<ProjectInfo> getProjects() {
        return this.iProjects.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLUtil getXMLUtil(IProject project) {
        Map<String, XMLUtil> map = this.iXMLUtils;
        synchronized (map) {
            XMLUtil xmlUtil = this.iXMLUtils.get(project.getName());
            if (xmlUtil == null) {
                xmlUtil = new XMLUtil();
                this.iXMLUtils.put(project.getName(), xmlUtil);
            }
            return xmlUtil;
        }
    }

    public ModuleInfo getModuleInfo(IJavaProject project) {
        ModuleInfo moduleInfo = null;
        for (ModuleInfo currentModuleInfo : this.iModules) {
            if (!currentModuleInfo.getJavaProject().getElementName().equals(project.getElementName())) continue;
            moduleInfo = currentModuleInfo;
            break;
        }
        return moduleInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDeleteIntendedType(String typeName) {
        if ("java.lang.String".equals(typeName)) {
            LOGGER.info("wrong!");
        }
        Set<String> set = this.iDeleteIntendedTypes;
        synchronized (set) {
            this.iDeleteIntendedTypes.add(typeName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDeleteIntendedType(String typeName) {
        Set<String> set = this.iDeleteIntendedTypes;
        synchronized (set) {
            return this.iDeleteIntendedTypes.contains(typeName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEjbStubType(String typeName) {
        Set<String> set = this.iEjbStubTypes;
        synchronized (set) {
            this.iEjbStubTypes.add(typeName);
        }
    }

    public Collection<String> getEjbStubTypes() {
        return this.iEjbStubTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFactoryType(String factoryType) {
        Set<String> set = this.iFactoryTypes;
        synchronized (set) {
            this.iFactoryTypes.add(factoryType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFactoryType(String type) {
        Set<String> set = this.iFactoryTypes;
        synchronized (set) {
            return this.iFactoryTypes.contains(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAccessBeanSubclass(String accessBeanSubclass) {
        Set<String> set = this.iAccessBeanSubclasses;
        synchronized (set) {
            this.iAccessBeanSubclasses.add(accessBeanSubclass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAccessBeanSubclass(String type) {
        Set<String> set = this.iAccessBeanSubclasses;
        synchronized (set) {
            return this.iAccessBeanSubclasses.contains(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAccessBeanSubclassInfoForType(String type, AccessBeanSubclassInfo accessBeanSubclassInfo) {
        Map<String, AccessBeanSubclassInfo> map = this.iAccessBeanSubclassesByType;
        synchronized (map) {
            this.iAccessBeanSubclassesByType.put(type, accessBeanSubclassInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessBeanSubclassInfo getAccessBeanSubclassInfoForType(String type) {
        Map<String, AccessBeanSubclassInfo> map = this.iAccessBeanSubclassesByType;
        synchronized (map) {
            return this.iAccessBeanSubclassesByType.get(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntityJndiName(String jndiName) {
        Set<String> set = this.iEntityJndiNames;
        synchronized (set) {
            this.iEntityJndiNames.add(jndiName);
        }
    }

    public boolean isEntityJndiName(String string) {
        return this.iEntityJndiNames.contains(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStubType(String stubType) {
        Set<String> set = this.iStubTypes;
        synchronized (set) {
            this.iStubTypes.add(stubType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStubType(String stubType) {
        Set<String> set = this.iStubTypes;
        synchronized (set) {
            this.iStubTypes.remove(stubType);
        }
    }

    public boolean isStubType(String type) {
        return this.iStubTypes.contains(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementParsedAssetCount() {
        ApplicationInfo applicationInfo = this;
        synchronized (applicationInfo) {
            ++this.iParsedAssetCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementGeneratedAssetCount() {
        ApplicationInfo applicationInfo = this;
        synchronized (applicationInfo) {
            ++this.iGeneratedAssetCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementSearchResultCount() {
        ApplicationInfo applicationInfo = this;
        synchronized (applicationInfo) {
            ++this.iSearchResultCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementUpdateCount() {
        ApplicationInfo applicationInfo = this;
        synchronized (applicationInfo) {
            ++this.iUpdateCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementDeleteCount() {
        ApplicationInfo applicationInfo = this;
        synchronized (applicationInfo) {
            ++this.iDeleteCount;
        }
    }

    public void printSummary() {
        LOGGER.info("parsed " + this.iParsedAssetCount + " assets");
        LOGGER.info("generated " + this.iGeneratedAssetCount + " assets");
        LOGGER.info("search found " + this.iSearchResultCount + " assets");
        LOGGER.info("updated " + this.iUpdateCount + " assets");
        LOGGER.info("deleted " + this.iDeleteCount + " assets");
    }
}

