/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.port.generators;

import com.ibm.commerce.jpa.logger.LoggerHelper;
import com.ibm.commerce.jpa.port.generators.PortVisitor;
import com.ibm.commerce.jpa.port.info.AccessBeanSubclassInfo;
import com.ibm.commerce.jpa.port.info.ApplicationInfo;
import com.ibm.commerce.jpa.port.info.EntityInfo;
import com.ibm.commerce.jpa.port.info.TargetExceptionInfo;
import com.ibm.commerce.jpa.port.util.AccessBeanUtil;
import com.ibm.commerce.jpa.port.util.JavaUtil;
import com.ibm.commerce.jpa.port.util.TargetExceptionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;

public class EntityReferencingTypeGenerator {
    private static final Logger LOGGER = LoggerHelper.getLogger(EntityReferencingTypeGenerator.class);
    private static final String COMMIT_COPY_HELPER = "commitCopyHelper";
    private static final String REFRESH_COPY_HELPER = "refreshCopyHelper";
    private static final String INSTANTIATE_ENTITY = "instantiateEntity";
    private static final String GET_EJB_REF = "getEJBRef";
    private static final String EJB_OBJECT = "javax.ejb.EJBObject";
    private static final String NARROW = "narrow";
    private static final Map<String, Map<String, String>> TYPE_MAPPINGS = new HashMap<String, Map<String, String>>();
    private ASTParser iASTParser;
    private ApplicationInfo iApplicationInfo;
    private IType iType;
    private String iSimpleTypeName;
    private String iSimpleJpaName;
    private Map<String, String> iTypeMappings;
    private static final String COPYRIGHT_FIELD_NAME = "COPYRIGHT";

    public EntityReferencingTypeGenerator(ASTParser astParser, ApplicationInfo applicationInfo, IType type) {
        this.iASTParser = astParser;
        this.iApplicationInfo = applicationInfo;
        this.iType = type;
        this.iSimpleTypeName = this.iType.getTypeQualifiedName();
        this.iSimpleJpaName = "JPA" + this.iSimpleTypeName;
        if (applicationInfo.isStubType(type.getFullyQualifiedName())) {
            this.iSimpleJpaName = "$" + this.iSimpleJpaName;
        }
        this.iTypeMappings = TYPE_MAPPINGS.get(type.getFullyQualifiedName('.'));
    }

    public void generate(IProgressMonitor progressMonitor) {
        try {
            progressMonitor.beginTask("generate entity referencing class " + this.iType.getFullyQualifiedName('.'), -1);
            this.portEntityReferencingType(progressMonitor);
        }
        finally {
            progressMonitor.done();
        }
    }

    public void portEntityReferencingType(IProgressMonitor progressMonitor) {
        try {
            this.iASTParser.setProject(this.iType.getJavaProject());
            this.iASTParser.setSource(this.iType.getCompilationUnit());
            this.iASTParser.setResolveBindings(true);
            CompilationUnit astCompilationUnit = (CompilationUnit)this.iASTParser.createAST((IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
            astCompilationUnit.recordModifications();
            astCompilationUnit.accept((ASTVisitor)new EntityReferencingTypePortVisitor());
            IDocument document = JavaUtil.getDocument(this.iType);
            TextEdit edits = astCompilationUnit.rewrite(document, null);
            edits.apply(document);
            ICompilationUnit compilationUnit = this.iType.getPackageFragment().createCompilationUnit(String.valueOf(this.iSimpleJpaName) + ".java", document.get(), true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
            this.iApplicationInfo.getBackupUtil(this.iType.getJavaProject().getProject()).addGeneratedFile2((IFile)compilationUnit.getResource(), (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
            this.iApplicationInfo.incrementGeneratedAssetCount();
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private class AccessBeanSubclassPortVisitor
    extends PortVisitor {
        private EntityReferencingTypePortVisitor iEntityReferencingTypePortVisitor;
        private AccessBeanSubclassInfo iAccessBeanSubclassInfo;
        private EntityInfo iEntityInfo;

        public AccessBeanSubclassPortVisitor(AccessBeanSubclassInfo accessBeanSubclassInfo, EntityReferencingTypePortVisitor entityReferencingTypePortVisitor) {
            super(EntityReferencingTypeGenerator.this.iApplicationInfo, EntityReferencingTypeGenerator.this.iType.getJavaProject());
            this.iAccessBeanSubclassInfo = accessBeanSubclassInfo;
            this.iEntityInfo = accessBeanSubclassInfo.getEntityInfo();
            this.iEntityReferencingTypePortVisitor = entityReferencingTypePortVisitor;
        }

        public boolean visit(TypeDeclaration typeDeclaration) {
            boolean visitChildren = true;
            ITypeBinding typeBinding = typeDeclaration.resolveBinding();
            if (typeBinding == null || !typeBinding.getQualifiedName().equals(this.iAccessBeanSubclassInfo.getName())) {
                typeDeclaration.accept((ASTVisitor)this.iEntityReferencingTypePortVisitor);
                visitChildren = false;
            }
            return visitChildren;
        }

        @Override
        public boolean visit(MethodDeclaration methodDeclaration) {
            boolean visitChildren = true;
            String methodKey = JavaUtil.getMethodKey(methodDeclaration);
            if (EntityReferencingTypeGenerator.COMMIT_COPY_HELPER.equals(methodKey)) {
                methodDeclaration.delete();
                visitChildren = false;
            }
            if (EntityReferencingTypeGenerator.NARROW.equals(methodDeclaration.getName().getIdentifier())) {
                methodDeclaration.delete();
                visitChildren = false;
            } else {
                TargetExceptionUtil.getUnhandledTargetExceptions(EntityReferencingTypeGenerator.this.iApplicationInfo, EntityReferencingTypeGenerator.this.iType.getJavaProject(), (ASTNode)methodDeclaration.getBody());
                AST ast = methodDeclaration.getAST();
                if (!methodDeclaration.isConstructor()) {
                    String methodName = AccessBeanUtil.getNewAccessBeanMethodName(this.iEntityInfo, methodDeclaration.getName().getIdentifier());
                    if (methodName != null) {
                        methodDeclaration.setName(ast.newSimpleName(methodName));
                    }
                } else {
                    ITypeBinding typeBinding;
                    List parameters = methodDeclaration.parameters();
                    if (parameters != null && parameters.size() == 1 && (typeBinding = ((SingleVariableDeclaration)parameters.get(0)).getType().resolveBinding()) != null && EntityReferencingTypeGenerator.EJB_OBJECT.equals(typeBinding.getQualifiedName())) {
                        ((SingleVariableDeclaration)parameters.get(0)).setType((Type)ast.newSimpleType(ast.newName(this.iEntityInfo.getEntityClassInfo().getQualifiedClassName())));
                    }
                }
                IJavaProject javaProject = EntityReferencingTypeGenerator.this.iType.getJavaProject();
                TargetExceptionInfo targetExceptionInfo = TargetExceptionUtil.getAccessBeanSubclassMethodUnhandledTargetExceptions(this.iAccessBeanSubclassInfo, methodKey);
                if (targetExceptionInfo == null) {
                    LOGGER.info("no target exceptions for " + methodKey + " in " + this.iAccessBeanSubclassInfo.getName());
                } else if (methodDeclaration.getParent() instanceof TypeDeclaration && ((TypeDeclaration)methodDeclaration.getParent()).getName().getIdentifier().equals("JPATermConditionCopy") && (methodDeclaration.getName().getIdentifier().equals("getProductSetAdjustments") || methodDeclaration.getName().getIdentifier().equals("findProductSetIdsByTCIdAndType") || methodDeclaration.getName().getIdentifier().equals("getExclusionProductSets") || methodDeclaration.getName().getIdentifier().equals("getInclusionProductSets"))) {
                    List thrownExceptions = methodDeclaration.thrownExceptions();
                    ArrayList<Name> newExceptions = new ArrayList<Name>();
                    int i = 0;
                    while (i < thrownExceptions.size()) {
                        Name thrownException = (Name)thrownExceptions.get(i);
                        if (!thrownException.getFullyQualifiedName().equals("javax.ejb.FinderException") && !thrownException.getFullyQualifiedName().equals("java.rmi.RemoteException")) {
                            newExceptions.add(thrownException);
                        }
                        ++i;
                    }
                    thrownExceptions.clear();
                    thrownExceptions.addAll(newExceptions);
                } else {
                    Collection<String> targetExceptions = TargetExceptionUtil.getFilteredExceptions(javaProject, targetExceptionInfo.getTargetExceptions());
                    List thrownExceptions = methodDeclaration.thrownExceptions();
                    int i = 0;
                    while (i < thrownExceptions.size()) {
                        Name thrownException = (Name)thrownExceptions.get(i);
                        ITypeBinding exceptionTypeBinding = thrownException.resolveTypeBinding();
                        if (exceptionTypeBinding != null) {
                            String declaredException = exceptionTypeBinding.getQualifiedName();
                            boolean exceptionUsed = false;
                            for (String targetException : targetExceptions) {
                                if (!TargetExceptionUtil.catchHandlesException(javaProject, declaredException, targetException)) continue;
                                exceptionUsed = true;
                                break;
                            }
                            if (!exceptionUsed) {
                                thrownExceptions.remove(i);
                                --i;
                            }
                        }
                        ++i;
                    }
                }
                visitChildren = super.visit(methodDeclaration);
            }
            return visitChildren;
        }

        @Override
        public boolean visit(MethodInvocation methodInvocation) {
            String methodName;
            boolean visitChildren = true;
            if ((methodInvocation.getExpression() == null || methodInvocation.getExpression().getNodeType() == 52) && (methodName = AccessBeanUtil.getNewAccessBeanMethodName(this.iEntityInfo, methodInvocation.getName().getIdentifier())) != null) {
                methodInvocation.setName(methodInvocation.getAST().newSimpleName(methodName));
            }
            visitChildren = AccessBeanUtil.isCachedAccessBeanInitializeMethodInvocation(EntityReferencingTypeGenerator.this.iApplicationInfo, methodInvocation) ? AccessBeanUtil.portCachedAccessBeanInitializeMethodInvocation(EntityReferencingTypeGenerator.this.iApplicationInfo, methodInvocation, this) : super.visit(methodInvocation);
            return visitChildren;
        }

        public boolean visit(SuperMethodInvocation superMethodInvocation) {
            boolean visitChildren = true;
            String methodName = AccessBeanUtil.getNewAccessBeanMethodName(this.iEntityInfo, superMethodInvocation.getName().getIdentifier());
            if (methodName != null) {
                superMethodInvocation.setName(superMethodInvocation.getAST().newSimpleName(methodName));
            }
            visitChildren = AccessBeanUtil.isCachedAccessBeanInitializeSuperMethodInvocation(EntityReferencingTypeGenerator.this.iApplicationInfo, superMethodInvocation) ? AccessBeanUtil.portCachedAccessBeanInitializeSuperMethodInvocation(EntityReferencingTypeGenerator.this.iApplicationInfo, superMethodInvocation, this) : super.visit(superMethodInvocation);
            return visitChildren;
        }

        @Override
        public boolean visit(ExpressionStatement expressionStatement) {
            MethodInvocation methodInvocation;
            boolean visitChildren = true;
            Expression statementExpression = expressionStatement.getExpression();
            if (statementExpression.getNodeType() == 48) {
                SuperMethodInvocation superMethodInvocation = (SuperMethodInvocation)statementExpression;
                String methodName = superMethodInvocation.getName().getIdentifier();
                int argumentCount = superMethodInvocation.arguments().size();
                if (EntityReferencingTypeGenerator.COMMIT_COPY_HELPER.equals(methodName) || EntityReferencingTypeGenerator.REFRESH_COPY_HELPER.equals(methodName) && argumentCount == 1) {
                    expressionStatement.delete();
                    visitChildren = false;
                } else if (EntityReferencingTypeGenerator.REFRESH_COPY_HELPER.equals(methodName) || EntityReferencingTypeGenerator.GET_EJB_REF.equals(methodName)) {
                    superMethodInvocation.setName(superMethodInvocation.getAST().newSimpleName(EntityReferencingTypeGenerator.INSTANTIATE_ENTITY));
                    visitChildren = false;
                }
            } else if (statementExpression.getNodeType() == 32 && ((methodInvocation = (MethodInvocation)statementExpression).getExpression() == null || methodInvocation.getExpression().getNodeType() == 52)) {
                String methodName = methodInvocation.getName().getIdentifier();
                int argumentCount = methodInvocation.arguments().size();
                if (EntityReferencingTypeGenerator.COMMIT_COPY_HELPER.equals(methodName) || EntityReferencingTypeGenerator.REFRESH_COPY_HELPER.equals(methodName) && argumentCount == 1) {
                    expressionStatement.delete();
                    visitChildren = false;
                } else if (EntityReferencingTypeGenerator.REFRESH_COPY_HELPER.equals(methodName) || EntityReferencingTypeGenerator.GET_EJB_REF.equals(methodName)) {
                    methodInvocation.setName(methodInvocation.getAST().newSimpleName(EntityReferencingTypeGenerator.INSTANTIATE_ENTITY));
                    visitChildren = false;
                }
            }
            if (visitChildren) {
                visitChildren = super.visit(expressionStatement);
            }
            return visitChildren;
        }

        public boolean visit(Initializer initializer) {
            TargetExceptionUtil.getUnhandledTargetExceptions(EntityReferencingTypeGenerator.this.iApplicationInfo, EntityReferencingTypeGenerator.this.iType.getJavaProject(), (ASTNode)initializer.getBody());
            return super.visit(initializer);
        }

        @Override
        public boolean visit(SimpleName simpleName) {
            if (simpleName.getIdentifier().equals(EntityReferencingTypeGenerator.this.iSimpleTypeName)) {
                super.replaceASTNode((ASTNode)simpleName, (ASTNode)simpleName.getAST().newName(EntityReferencingTypeGenerator.this.iSimpleJpaName));
            } else {
                super.visit(simpleName);
            }
            return false;
        }
    }

    private class EntityReferencingTypePortVisitor
    extends PortVisitor {
        public EntityReferencingTypePortVisitor() {
            super(EntityReferencingTypeGenerator.this.iApplicationInfo, EntityReferencingTypeGenerator.this.iType.getJavaProject(), true);
        }

        @Override
        public boolean visit(MethodDeclaration methodDeclaration) {
            TargetExceptionUtil.getEntityReferencingTypeUnhandledTargetExceptions(EntityReferencingTypeGenerator.this.iApplicationInfo, EntityReferencingTypeGenerator.this.iType.getJavaProject(), (ASTNode)methodDeclaration.getBody());
            return super.visit(methodDeclaration);
        }

        public boolean visit(Initializer initializer) {
            TargetExceptionUtil.getEntityReferencingTypeUnhandledTargetExceptions(EntityReferencingTypeGenerator.this.iApplicationInfo, EntityReferencingTypeGenerator.this.iType.getJavaProject(), (ASTNode)initializer.getBody());
            return super.visit(initializer);
        }

        @Override
        public boolean visit(SimpleName simpleName) {
            if (simpleName.getIdentifier().equals(EntityReferencingTypeGenerator.this.iSimpleTypeName)) {
                super.replaceASTNode((ASTNode)simpleName, (ASTNode)simpleName.getAST().newName(EntityReferencingTypeGenerator.this.iSimpleJpaName));
            } else {
                super.visit(simpleName);
            }
            return false;
        }

        public boolean visit(TypeDeclaration typeDeclaration) {
            boolean visitChildren = true;
            List superInterfaceTypes = typeDeclaration.superInterfaceTypes();
            int i = 0;
            while (i < superInterfaceTypes.size()) {
                Type superInterfaceType = (Type)superInterfaceTypes.get(i);
                ITypeBinding superInterfaceTypeBinding = superInterfaceType.resolveBinding();
                if (superInterfaceTypeBinding != null && EntityReferencingTypeGenerator.this.iApplicationInfo.isAccessBeanInterfaceType(superInterfaceTypeBinding.getQualifiedName())) {
                    superInterfaceType.delete();
                    --i;
                }
                ++i;
            }
            ITypeBinding typeBinding = typeDeclaration.resolveBinding();
            if (typeBinding != null) {
                String qualifiedName = typeBinding.getQualifiedName();
                AccessBeanSubclassInfo accessBeanSubclassInfo = EntityReferencingTypeGenerator.this.iApplicationInfo.getAccessBeanSubclassInfoForType(qualifiedName);
                if (accessBeanSubclassInfo != null) {
                    typeDeclaration.accept((ASTVisitor)new AccessBeanSubclassPortVisitor(accessBeanSubclassInfo, this));
                    visitChildren = false;
                } else if (EntityReferencingTypeGenerator.this.iApplicationInfo.isStubType(qualifiedName)) {
                    typeDeclaration.accept((ASTVisitor)new StubPortVisitor());
                    visitChildren = false;
                }
            }
            return visitChildren;
        }

        @Override
        public String getTypeMapping(String typeName) {
            String typeMapping = null;
            typeMapping = EntityReferencingTypeGenerator.this.iTypeMappings != null && EntityReferencingTypeGenerator.this.iTypeMappings.containsKey(typeName) ? (String)EntityReferencingTypeGenerator.this.iTypeMappings.get(typeName) : super.getTypeMapping(typeName);
            return typeMapping;
        }
    }

    private class StubPortVisitor
    extends PortVisitor {
        public StubPortVisitor() {
            super(EntityReferencingTypeGenerator.this.iApplicationInfo, EntityReferencingTypeGenerator.this.iType.getJavaProject());
        }

        public boolean visit(Initializer initializer) {
            initializer.delete();
            return false;
        }

        @Override
        public boolean visit(FieldDeclaration fieldDeclaration) {
            boolean visitChildren = true;
            List fragments = fieldDeclaration.fragments();
            if (Modifier.isPrivate((int)fieldDeclaration.getModifiers())) {
                fieldDeclaration.delete();
                visitChildren = false;
            } else {
                Type type = fieldDeclaration.getType();
                for (VariableDeclarationFragment fragment : fragments) {
                    String fieldName = fragment.getName().getIdentifier();
                    if (EntityReferencingTypeGenerator.COPYRIGHT_FIELD_NAME.equals(fieldName)) continue;
                    fragment.setInitializer(this.getTypedStubExpression(type));
                }
                List modifiers = fieldDeclaration.modifiers();
                int i = 0;
                while (i < modifiers.size()) {
                    if (((IExtendedModifier)modifiers.get(i)).isAnnotation()) {
                        modifiers.remove(i);
                        --i;
                    }
                    ++i;
                }
            }
            if (visitChildren) {
                visitChildren = super.visit(fieldDeclaration);
            }
            return visitChildren;
        }

        public boolean visit(TypeDeclaration typeDeclaration) {
            boolean visitChildren = true;
            if (Modifier.isPrivate((int)typeDeclaration.getModifiers())) {
                if (typeDeclaration.getName().getFullyQualifiedName().equals("ServerInfo") && ((TypeDeclaration)typeDeclaration.getParent()).getName().getFullyQualifiedName().equals("$JPAUpdateStaticEARContentUsingFTPCmdImpl")) {
                    List list = typeDeclaration.bodyDeclarations();
                    list.clear();
                } else {
                    typeDeclaration.delete();
                    visitChildren = false;
                }
            }
            if (visitChildren) {
                visitChildren = super.visit(typeDeclaration);
            }
            return visitChildren;
        }

        @Override
        public boolean visit(MethodDeclaration methodDeclaration) {
            boolean visitChildren = true;
            if (Modifier.isPrivate((int)methodDeclaration.getModifiers()) && !methodDeclaration.isConstructor()) {
                visitChildren = false;
                methodDeclaration.delete();
            } else {
                List modifiers = methodDeclaration.modifiers();
                int i = 0;
                while (i < modifiers.size()) {
                    if (((IExtendedModifier)modifiers.get(i)).isAnnotation()) {
                        modifiers.remove(i);
                        --i;
                    }
                    ++i;
                }
                List parameters = methodDeclaration.parameters();
                for (SingleVariableDeclaration parameter : parameters) {
                    List parameterModifiers = parameter.modifiers();
                    int i2 = 0;
                    while (i2 < parameterModifiers.size()) {
                        if (((IExtendedModifier)parameterModifiers.get(i2)).isAnnotation()) {
                            parameterModifiers.remove(i2);
                            --i2;
                        }
                        ++i2;
                    }
                }
                if (methodDeclaration.getBody() != null) {
                    AST ast = methodDeclaration.getAST();
                    if (methodDeclaration.isConstructor()) {
                        List statements = methodDeclaration.getBody().statements();
                        int i3 = 0;
                        while (i3 < statements.size()) {
                            Statement statement = (Statement)statements.get(i3);
                            if (statement.getNodeType() != 46 && statement.getNodeType() != 17) {
                                statement.delete();
                                --i3;
                            }
                            ++i3;
                        }
                    } else {
                        Block newBody = ast.newBlock();
                        List newStatements = newBody.statements();
                        ReturnStatement newReturnStatement = ast.newReturnStatement();
                        Type returnType = methodDeclaration.getReturnType2();
                        newStatements.add(newReturnStatement);
                        if (returnType != null) {
                            newReturnStatement.setExpression(this.getTypedStubExpression(returnType));
                        }
                        this.replaceASTNode((ASTNode)methodDeclaration.getBody(), (ASTNode)newBody);
                    }
                }
            }
            if (visitChildren) {
                visitChildren = super.visit(methodDeclaration);
            }
            return visitChildren;
        }

        @Override
        public boolean visit(SimpleName simpleName) {
            if (simpleName.getIdentifier().equals(EntityReferencingTypeGenerator.this.iSimpleTypeName)) {
                super.replaceASTNode((ASTNode)simpleName, (ASTNode)simpleName.getAST().newName(EntityReferencingTypeGenerator.this.iSimpleJpaName));
            } else {
                super.visit(simpleName);
            }
            return false;
        }

        private Expression getTypedStubExpression(Type type) {
            Object expression = null;
            if (type.isPrimitiveType()) {
                PrimitiveType primitiveType = (PrimitiveType)type;
                if (primitiveType.getPrimitiveTypeCode() != PrimitiveType.VOID) {
                    expression = primitiveType.getPrimitiveTypeCode() == PrimitiveType.BOOLEAN ? type.getAST().newBooleanLiteral(false) : type.getAST().newNumberLiteral("0");
                }
            } else {
                expression = type.getAST().newNullLiteral();
            }
            return expression;
        }
    }
}

