/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.port.generators;

import com.ibm.commerce.jpa.logger.LoggerHelper;
import com.ibm.commerce.jpa.port.generators.EntityReferencingTypeGenerator;
import com.ibm.commerce.jpa.port.info.ApplicationInfo;
import com.ibm.commerce.jpa.port.info.ProjectInfo;
import com.ibm.commerce.jpa.updaters.GeneratedTypeUpdater;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTParser;

public class EntityReferencingProjectGenerator {
    private static final Logger LOGGER = LoggerHelper.getLogger(EntityReferencingProjectGenerator.class);
    private ASTParser iASTParser = ASTParser.newParser((int)3);
    private ApplicationInfo iApplicationInfo;
    private ProjectInfo iProjectInfo;

    public EntityReferencingProjectGenerator(ApplicationInfo applicationInfo, ProjectInfo projectInfo) {
        this.iApplicationInfo = applicationInfo;
        this.iProjectInfo = projectInfo;
    }

    public boolean generate(IProgressMonitor progressMonitor) {
        boolean referencesGenerated = false;
        LOGGER.info("generating entity referencing types " + this.iProjectInfo.getProject().getName());
        try {
            try {
                progressMonitor.beginTask("Generate " + this.iProjectInfo.getProject().getName(), -1);
                IFile generatedFileList = this.iProjectInfo.getProject().getFile(".jpaGeneratedFileList");
                if (generatedFileList.exists()) {
                    HashSet<IType> generatedTypes;
                    block24: {
                        generatedTypes = new HashSet<IType>();
                        try {
                            InputStream inputStream = generatedFileList.getContents(true);
                            try {
                                try {
                                    InputStreamReader reader = new InputStreamReader(inputStream);
                                    BufferedReader bufferedReader = new BufferedReader(reader);
                                    String portableString = bufferedReader.readLine();
                                    while (portableString != null) {
                                        IPath path = Path.fromPortableString((String)portableString);
                                        IFile generatedFile = this.iProjectInfo.getProject().getFile(path);
                                        if (generatedFile.getName().endsWith(".java")) {
                                            IJavaElement javaElement = JavaCore.create((IFile)generatedFile);
                                            generatedTypes.add(((ICompilationUnit)javaElement).getTypes()[0]);
                                        }
                                        portableString = bufferedReader.readLine();
                                    }
                                    this.iApplicationInfo.incrementParsedAssetCount();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                    try {
                                        inputStream.close();
                                    }
                                    catch (IOException e2) {
                                        e2.printStackTrace();
                                    }
                                    break block24;
                                }
                            }
                            catch (Throwable throwable) {
                                try {
                                    inputStream.close();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                                throw throwable;
                            }
                            try {
                                inputStream.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                    }
                    for (IType generatedType : generatedTypes) {
                        GeneratedTypeUpdater generatedTypeUpdater = new GeneratedTypeUpdater(this.iASTParser, this.iApplicationInfo, generatedType);
                        generatedTypeUpdater.update((IProgressMonitor)new SubProgressMonitor(progressMonitor, 200));
                        referencesGenerated = true;
                    }
                }
                HashSet<String> entityReferencingTypes = new HashSet<String>();
                entityReferencingTypes.addAll(this.iProjectInfo.getEntityReferencingTypes());
                entityReferencingTypes.addAll(this.iProjectInfo.getIndirectEntityReferencingTypes());
                for (String entityReferencingType : entityReferencingTypes) {
                    IType type = this.iProjectInfo.getJavaProject().findType(entityReferencingType);
                    if (type == null) {
                        LOGGER.info("type not found " + entityReferencingType);
                    }
                    EntityReferencingTypeGenerator entityReferencingTypeGenerator = new EntityReferencingTypeGenerator(this.iASTParser, this.iApplicationInfo, type);
                    entityReferencingTypeGenerator.generate((IProgressMonitor)new SubProgressMonitor(progressMonitor, 200));
                    referencesGenerated = true;
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
                progressMonitor.done();
            }
        }
        finally {
            progressMonitor.done();
        }
        return referencesGenerated;
    }
}

