/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.port.generators;

import com.ibm.commerce.jpa.logger.LoggerHelper;
import com.ibm.commerce.jpa.port.generators.FieldGenerator;
import com.ibm.commerce.jpa.port.generators.PVCDeviceSpecJPAQueryHelperBaseGenerator;
import com.ibm.commerce.jpa.port.generators.PortVisitor;
import com.ibm.commerce.jpa.port.info.ApplicationInfo;
import com.ibm.commerce.jpa.port.info.ClassInfo;
import com.ibm.commerce.jpa.port.info.EntityInfo;
import com.ibm.commerce.jpa.port.info.ModuleInfo;
import com.ibm.commerce.jpa.port.util.BackupUtil;
import com.ibm.commerce.jpa.port.util.ExceptionUtil;
import com.ibm.commerce.jpa.port.util.ImportUtil;
import com.ibm.commerce.jpa.port.util.JavaUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;

public class EntityQueryHelperClassGenerator {
    private static final Logger LOGGER = LoggerHelper.getLogger(EntityQueryHelperClassGenerator.class);
    private static final String COPYRIGHT_FIELD = "COPYRIGHT";
    private static final String SET_NULL = "setNull";
    private static final String SET_BYTES = "setBytes";
    private static final String SET_LONG = "setLong";
    private static final String SET_DOUBLE = "setDouble";
    private static final String SET_INT = "setInt";
    private static final String SET_STRING = "setString";
    private static final String SET_FLOAT = "setFloat";
    private static final String SET_OBJECT = "setObject";
    private static final String SET_SHORT = "setShort";
    private static final String SET_TIMESTAMP = "setTimestamp";
    private static final String SET_PARAMETER = "setParameter";
    private static final String SET_MAX_ROWS = "setMaxRows";
    private static final String SET_MAX_RESULTS = "setMaxResults";
    private static final String GET_MERGED_PREPARED_STATEMENT = "getMergedPreparedStatement";
    private static final String GET_MERGED_QUERY = "getMergedQuery";
    private static final String GET_PREPARED_STATEMENT = "getPreparedStatement";
    private static final String GET_QUERY = "getQuery";
    private static final String PREPARED_STATEMENT = "java.sql.PreparedStatement";
    private static final String CATALOG_SQL_HELPER = "com.ibm.commerce.catalog.objects.CatalogSqlHelper";
    private static final String SET_PARAMETERS_IN_WHERE_CLAUSE = "setParametersInWhereClause";
    private static final String SET_PARAMETERS_IN_QUERY = "setParametersInQuery";
    private static final String QUERY = "javax.persistence.Query";
    private static final String SQL_EXCEPTION = "java.sql.SQLException";
    private static final String ILLEGAL_ARGUMENT_EXCEPTION = "java.lang.IllegalArgumentException";
    private static final String UTF_SORTING_ATTRIBUTE = "com.ibm.commerce.utf.helper.SortingAttribute";
    private static final String NEGOTIATION_SORTING_ATTRIBUTE = "com.ibm.commerce.negotiation.util.SortingAttribute";
    private static final String SORTING_ATTRIBUE = "com.ibm.commerce.base.util.SortingAttribute";
    private static final String UTF_QUERY_COLUMN = "com.ibm.commerce.utf.helper.QueryColumn";
    private static final String NEGOTIATION_QUERY_COLUMN = "com.ibm.commerce.negotiation.util.QueryColumn";
    private static final String QUERY_COLUMN = "com.ibm.commerce.base.util.QueryColumn";
    private static final String FIND_WITH_PUSH_DOWN_QUERY = "findWithPushDownQuery";
    private static final Map<String, String> PREPARED_STATEMENT_TO_QUERY_METHOD_MAP = new HashMap<String, String>();
    private static final Map<String, String> FINDER_OBJECT_TO_QUERY_HELPER_METHOD_MAP;
    private static final Map<String, String> TYPE_MAP;
    private static final Set<String> EXEMPT_METHODS;
    private static final Map<String, List<FieldGenerator>> FIELD_GENERATORS_MAP;
    private ASTParser iASTParser;
    private BackupUtil iBackupUtil;
    private EntityInfo iEntityInfo;
    private ModuleInfo iModuleInfo;
    private ApplicationInfo iApplicationInfo;
    private ClassInfo iEntityQueryHelperClassInfo;
    private ClassInfo iEntityQueryHelperBaseClassInfo;
    private List<FieldGenerator> iEntityQueryHelperFieldGenerators;
    private List<FieldGenerator> iEntityQueryHelperBaseFieldGenerators;

    static {
        PREPARED_STATEMENT_TO_QUERY_METHOD_MAP.put(SET_NULL, SET_PARAMETER);
        PREPARED_STATEMENT_TO_QUERY_METHOD_MAP.put(SET_BYTES, SET_PARAMETER);
        PREPARED_STATEMENT_TO_QUERY_METHOD_MAP.put(SET_LONG, SET_PARAMETER);
        PREPARED_STATEMENT_TO_QUERY_METHOD_MAP.put(SET_DOUBLE, SET_PARAMETER);
        PREPARED_STATEMENT_TO_QUERY_METHOD_MAP.put(SET_INT, SET_PARAMETER);
        PREPARED_STATEMENT_TO_QUERY_METHOD_MAP.put(SET_STRING, SET_PARAMETER);
        PREPARED_STATEMENT_TO_QUERY_METHOD_MAP.put(SET_FLOAT, SET_PARAMETER);
        PREPARED_STATEMENT_TO_QUERY_METHOD_MAP.put(SET_OBJECT, SET_PARAMETER);
        PREPARED_STATEMENT_TO_QUERY_METHOD_MAP.put(SET_SHORT, SET_PARAMETER);
        PREPARED_STATEMENT_TO_QUERY_METHOD_MAP.put(SET_TIMESTAMP, SET_PARAMETER);
        PREPARED_STATEMENT_TO_QUERY_METHOD_MAP.put(SET_MAX_ROWS, SET_MAX_RESULTS);
        FINDER_OBJECT_TO_QUERY_HELPER_METHOD_MAP = new HashMap<String, String>();
        FINDER_OBJECT_TO_QUERY_HELPER_METHOD_MAP.put(GET_MERGED_PREPARED_STATEMENT, GET_MERGED_QUERY);
        FINDER_OBJECT_TO_QUERY_HELPER_METHOD_MAP.put(GET_PREPARED_STATEMENT, GET_QUERY);
        TYPE_MAP = new HashMap<String, String>();
        TYPE_MAP.put(PREPARED_STATEMENT, QUERY);
        TYPE_MAP.put(SQL_EXCEPTION, ILLEGAL_ARGUMENT_EXCEPTION);
        TYPE_MAP.put(UTF_SORTING_ATTRIBUTE, SORTING_ATTRIBUE);
        TYPE_MAP.put(UTF_QUERY_COLUMN, QUERY_COLUMN);
        TYPE_MAP.put(NEGOTIATION_SORTING_ATTRIBUTE, SORTING_ATTRIBUE);
        TYPE_MAP.put(NEGOTIATION_QUERY_COLUMN, QUERY_COLUMN);
        EXEMPT_METHODS = new HashSet<String>();
        EXEMPT_METHODS.add(FIND_WITH_PUSH_DOWN_QUERY);
        FIELD_GENERATORS_MAP = new HashMap<String, List<FieldGenerator>>();
        ArrayList<PVCDeviceSpecJPAQueryHelperBaseGenerator.FromClauseFieldGenerator> fieldGenerators = new ArrayList<PVCDeviceSpecJPAQueryHelperBaseGenerator.FromClauseFieldGenerator>();
        fieldGenerators.add(new PVCDeviceSpecJPAQueryHelperBaseGenerator.FromClauseFieldGenerator());
        FIELD_GENERATORS_MAP.put("com.ibm.commerce.pvcdevices.objsrc.PVCDeviceSpecJPAQueryHelperBase", fieldGenerators);
    }

    public EntityQueryHelperClassGenerator(ASTParser astParser, BackupUtil backupUtil, EntityInfo entityInfo) {
        this.iASTParser = astParser;
        this.iBackupUtil = backupUtil;
        this.iEntityInfo = entityInfo;
        this.iModuleInfo = entityInfo.getModuleInfo();
        this.iApplicationInfo = this.iModuleInfo.getApplicationInfo();
        this.iEntityQueryHelperClassInfo = entityInfo.getEntityQueryHelperClassInfo();
        this.iEntityQueryHelperBaseClassInfo = entityInfo.getEntityQueryHelperBaseClassInfo();
        if (this.iEntityQueryHelperClassInfo != null) {
            this.iEntityQueryHelperFieldGenerators = FIELD_GENERATORS_MAP.get(this.iEntityQueryHelperClassInfo.getQualifiedClassName());
            if (this.iEntityQueryHelperBaseClassInfo != null) {
                this.iEntityQueryHelperBaseFieldGenerators = FIELD_GENERATORS_MAP.get(this.iEntityQueryHelperBaseClassInfo.getQualifiedClassName());
            }
        }
    }

    public void generate(IProgressMonitor progressMonitor) {
        try {
            progressMonitor.beginTask("generate query helper for " + this.iEntityInfo.getEjbName(), -1);
            this.generateEntityQueryHelperBaseClass(progressMonitor);
            progressMonitor.worked(1000);
            this.generateEntityQueryHelperClass(progressMonitor);
            progressMonitor.worked(1000);
        }
        finally {
            progressMonitor.done();
        }
    }

    private void generateEntityQueryHelperClass(IProgressMonitor progressMonitor) {
        if (this.iEntityInfo.getEjbFinderObjectType() != null) {
            try {
                this.iASTParser.setSource(this.iEntityInfo.getEjbFinderObjectType().getCompilationUnit());
                this.iASTParser.setResolveBindings(true);
                CompilationUnit ejbFinderObjectCompilationUnit = (CompilationUnit)this.iASTParser.createAST((IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                StringBuilder sb = new StringBuilder();
                sb.append("package ");
                sb.append(this.iEntityQueryHelperClassInfo.getPackageFragment().getElementName());
                sb.append(";\r\n");
                JavaUtil.appendCopyrightComment(sb);
                sb.append("\r\nimport javax.persistence.*;\r\n");
                List importDeclarations = ejbFinderObjectCompilationUnit.imports();
                ImportUtil.appendImports(importDeclarations, sb);
                if (this.iEntityQueryHelperClassInfo.getSuperclassName() != null && !this.iEntityQueryHelperClassInfo.getSuperclassPackage().equals(this.iEntityQueryHelperClassInfo.getPackageFragment().getElementName())) {
                    sb.append("\r\nimport ");
                    sb.append(this.iEntityQueryHelperClassInfo.getQualifiedSuperclassName());
                    sb.append(";\r\n");
                }
                sb.append("\r\npublic class ");
                sb.append(this.iEntityQueryHelperClassInfo.getClassName());
                if (this.iEntityQueryHelperClassInfo.getSuperclassName() != null) {
                    sb.append(" extends ");
                    sb.append(this.iEntityQueryHelperClassInfo.getSuperclassName());
                }
                sb.append(" {\r\n");
                JavaUtil.appendCopyrightField(sb);
                this.appendGeneratedFields(sb, this.iEntityInfo, this.iEntityQueryHelperFieldGenerators);
                sb.append("\r\n\tpublic ");
                sb.append(this.iEntityQueryHelperClassInfo.getClassName());
                sb.append("() {\r\n\t}\r\n}");
                Document document = new Document(sb.toString());
                this.iASTParser.setProject(this.iEntityInfo.getModuleInfo().getJavaProject());
                this.iASTParser.setResolveBindings(true);
                this.iASTParser.setSource(document.get().toCharArray());
                CompilationUnit astCompilationUnit = (CompilationUnit)this.iASTParser.createAST((IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                astCompilationUnit.recordModifications();
                this.portFinderObjectTypeDeclaration((TypeDeclaration)ejbFinderObjectCompilationUnit.types().get(0), astCompilationUnit, this.iEntityQueryHelperFieldGenerators);
                TextEdit edits = astCompilationUnit.rewrite((IDocument)document, null);
                edits.apply((IDocument)document);
                ICompilationUnit compilationUnit = this.iEntityQueryHelperClassInfo.getPackageFragment().createCompilationUnit(String.valueOf(this.iEntityQueryHelperClassInfo.getClassName()) + ".java", document.get(), true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                ExceptionUtil.suppressExceptions(this.iASTParser, compilationUnit, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                this.iBackupUtil.addGeneratedFile((IFile)compilationUnit.getResource(), (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                this.iApplicationInfo.incrementGeneratedAssetCount();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }

    private void generateEntityQueryHelperBaseClass(IProgressMonitor progressMonitor) {
        if (this.iEntityQueryHelperBaseClassInfo != null) {
            try {
                this.iASTParser.setSource(this.iEntityInfo.getEjbFinderObjectBaseType().getCompilationUnit());
                this.iASTParser.setResolveBindings(true);
                CompilationUnit ejbFinderObjectBaseCompilationUnit = (CompilationUnit)this.iASTParser.createAST((IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                StringBuilder sb = new StringBuilder();
                sb.append("package ");
                sb.append(this.iEntityQueryHelperBaseClassInfo.getPackageFragment().getElementName());
                sb.append(";\r\n");
                JavaUtil.appendCopyrightComment(sb);
                sb.append("\r\nimport javax.persistence.*;\r\n");
                List importDeclarations = ejbFinderObjectBaseCompilationUnit.imports();
                ImportUtil.appendImports(importDeclarations, sb);
                if (this.iEntityQueryHelperBaseClassInfo.getSuperclassName() != null && !this.iEntityQueryHelperBaseClassInfo.getSuperclassPackage().equals(this.iEntityQueryHelperBaseClassInfo.getPackageFragment().getElementName())) {
                    sb.append("\r\nimport ");
                    sb.append(this.iEntityQueryHelperBaseClassInfo.getQualifiedSuperclassName());
                    sb.append(";\r\n");
                }
                sb.append("\r\npublic class ");
                sb.append(this.iEntityQueryHelperBaseClassInfo.getClassName());
                if (this.iEntityQueryHelperBaseClassInfo.getSuperclassName() != null) {
                    sb.append(" extends ");
                    sb.append(this.iEntityQueryHelperBaseClassInfo.getSuperclassName());
                }
                sb.append(" {\r\n");
                JavaUtil.appendCopyrightField(sb);
                this.appendGeneratedFields(sb, this.iEntityInfo, this.iEntityQueryHelperBaseFieldGenerators);
                sb.append("\r\n\tpublic ");
                sb.append(this.iEntityQueryHelperBaseClassInfo.getClassName());
                sb.append("() {\r\n\t}\r\n}");
                Document document = new Document(sb.toString());
                this.iASTParser.setProject(this.iEntityInfo.getModuleInfo().getJavaProject());
                this.iASTParser.setResolveBindings(true);
                this.iASTParser.setSource(document.get().toCharArray());
                CompilationUnit astCompilationUnit = (CompilationUnit)this.iASTParser.createAST((IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                astCompilationUnit.recordModifications();
                this.portFinderObjectTypeDeclaration((TypeDeclaration)ejbFinderObjectBaseCompilationUnit.types().get(0), astCompilationUnit, this.iEntityQueryHelperBaseFieldGenerators);
                TextEdit edits = astCompilationUnit.rewrite((IDocument)document, null);
                edits.apply((IDocument)document);
                ICompilationUnit compilationUnit = this.iEntityQueryHelperBaseClassInfo.getPackageFragment().createCompilationUnit(String.valueOf(this.iEntityQueryHelperBaseClassInfo.getClassName()) + ".java", document.get(), true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                ExceptionUtil.suppressExceptions(this.iASTParser, compilationUnit, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                this.iBackupUtil.addGeneratedFile((IFile)compilationUnit.getResource(), (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                this.iApplicationInfo.incrementGeneratedAssetCount();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }

    private void appendGeneratedFields(StringBuilder sb, EntityInfo entityInfo, List<FieldGenerator> fieldGenerators) {
        if (fieldGenerators != null) {
            for (FieldGenerator fieldGenerator : fieldGenerators) {
                fieldGenerator.appendField(sb, entityInfo);
            }
        }
    }

    private void portFinderObjectTypeDeclaration(TypeDeclaration finderObjectTypeDeclaration, CompilationUnit entityQueryHelperCompilationUnit, List<FieldGenerator> fieldGenerators) {
        List bodyDeclarations = finderObjectTypeDeclaration.bodyDeclarations();
        for (BodyDeclaration bodyDeclaration : bodyDeclarations) {
            switch (bodyDeclaration.getNodeType()) {
                case 23: {
                    FieldDeclaration fieldDeclaration = (FieldDeclaration)bodyDeclaration;
                    this.portFieldDeclaration(fieldDeclaration, entityQueryHelperCompilationUnit, fieldGenerators);
                    break;
                }
                case 28: {
                    this.portInitializer((Initializer)bodyDeclaration, entityQueryHelperCompilationUnit);
                    break;
                }
                case 31: {
                    this.portMethodDeclaration((MethodDeclaration)bodyDeclaration, entityQueryHelperCompilationUnit);
                }
            }
        }
    }

    private void portFieldDeclaration(FieldDeclaration fieldDeclaration, CompilationUnit entityQueryHelperCompilationUnit, List<FieldGenerator> fieldGenerators) {
        fieldDeclaration.accept((ASTVisitor)new QueryHelperPortVisitor());
        List bodyDeclarations = ((TypeDeclaration)entityQueryHelperCompilationUnit.types().get(0)).bodyDeclarations();
        List ejbVariableDeclarationFragments = fieldDeclaration.fragments();
        for (VariableDeclarationFragment ejbVariableDeclarationFragment : ejbVariableDeclarationFragments) {
            String fieldName = ejbVariableDeclarationFragment.getName().getIdentifier();
            if (COPYRIGHT_FIELD.equals(fieldName)) continue;
            boolean generatedField = false;
            if (fieldGenerators != null) {
                for (FieldGenerator fieldGenerator : fieldGenerators) {
                    if (!fieldGenerator.getFieldName().equals(fieldName)) continue;
                    generatedField = true;
                    break;
                }
            }
            if (generatedField) continue;
            FieldDeclaration entityQueryHelperFieldDeclaration = (FieldDeclaration)ASTNode.copySubtree((AST)entityQueryHelperCompilationUnit.getAST(), (ASTNode)fieldDeclaration);
            bodyDeclarations.add(entityQueryHelperFieldDeclaration);
        }
    }

    private void portInitializer(Initializer initializer, CompilationUnit entityQueryHelperCompilationUnit) {
        initializer.accept((ASTVisitor)new QueryHelperPortVisitor());
        List bodyDeclarations = ((TypeDeclaration)entityQueryHelperCompilationUnit.types().get(0)).bodyDeclarations();
        Initializer entityQueryHelperInitializer = (Initializer)ASTNode.copySubtree((AST)entityQueryHelperCompilationUnit.getAST(), (ASTNode)initializer);
        bodyDeclarations.add(entityQueryHelperInitializer);
    }

    private void portMethodDeclaration(MethodDeclaration methodDeclaration, CompilationUnit entityQueryHelperCompilationUnit) {
        if (!methodDeclaration.isConstructor() && !EXEMPT_METHODS.contains(methodDeclaration.getName().getIdentifier())) {
            methodDeclaration.accept((ASTVisitor)new QueryHelperPortVisitor());
            MethodDeclaration entityQueryHelperMethodDeclaration = (MethodDeclaration)ASTNode.copySubtree((AST)entityQueryHelperCompilationUnit.getAST(), (ASTNode)methodDeclaration);
            entityQueryHelperMethodDeclaration.setJavadoc(null);
            List thrownExceptions = entityQueryHelperMethodDeclaration.thrownExceptions();
            thrownExceptions.clear();
            List bodyDeclarations = ((TypeDeclaration)entityQueryHelperCompilationUnit.types().get(0)).bodyDeclarations();
            bodyDeclarations.add(entityQueryHelperMethodDeclaration);
        }
    }

    private static class BlockInfo {
        public Block iBlock;
        public Collection<Expression> iDeadIfExpressions;
        public Collection<Expression> iDeadElseExpressions;

        public BlockInfo(Block block) {
            this.iBlock = block;
        }
    }

    private class QueryHelperPortVisitor
    extends PortVisitor {
        private Deque<BlockInfo> iBlockInfoStack;
        private Deque<IfStatement> iIfStatementStack;

        public QueryHelperPortVisitor() {
            super(EntityQueryHelperClassGenerator.this.iApplicationInfo, EntityQueryHelperClassGenerator.this.iModuleInfo.getJavaProject());
            this.iBlockInfoStack = new ArrayDeque<BlockInfo>();
            this.iIfStatementStack = new ArrayDeque<IfStatement>();
        }

        @Override
        public boolean visit(Block block) {
            this.iBlockInfoStack.push(new BlockInfo(block));
            return true;
        }

        public void endVisit(Block block) {
            if (this.iBlockInfoStack.peek().iBlock == block) {
                this.iBlockInfoStack.pop();
            }
        }

        public boolean visit(IfStatement ifStatement) {
            boolean visitChildren = true;
            Expression ifExpression = ifStatement.getExpression();
            for (BlockInfo blockInfo : this.iBlockInfoStack) {
                List statements;
                if (blockInfo.iDeadIfExpressions != null) {
                    for (Expression deadIfExpression : blockInfo.iDeadIfExpressions) {
                        if (!deadIfExpression.toString().equals(ifExpression.toString())) continue;
                        if (ifStatement.getElseStatement() != null) {
                            ifStatement.getElseStatement().accept((ASTVisitor)this);
                            if (ifStatement.getElseStatement().getNodeType() == 8) {
                                statements = ((Block)ifStatement.getElseStatement()).statements();
                                this.replaceStatement((Statement)ifStatement, statements);
                            } else {
                                this.replaceASTNode((ASTNode)ifStatement, (ASTNode)ifStatement.getElseStatement());
                            }
                        } else {
                            ifStatement.delete();
                        }
                        visitChildren = false;
                        break;
                    }
                    if (!visitChildren) break;
                }
                if (blockInfo.iDeadElseExpressions == null) continue;
                for (Expression deadElseExpression : blockInfo.iDeadElseExpressions) {
                    if (!deadElseExpression.toString().equals(ifExpression.toString())) continue;
                    ifStatement.getThenStatement().accept((ASTVisitor)this);
                    if (ifStatement.getThenStatement().getNodeType() == 8) {
                        statements = ((Block)ifStatement.getThenStatement()).statements();
                        this.replaceStatement((Statement)ifStatement, statements);
                    } else {
                        this.replaceASTNode((ASTNode)ifStatement, (ASTNode)ifStatement.getThenStatement());
                    }
                    visitChildren = false;
                    break;
                }
                if (!visitChildren) break;
            }
            if (visitChildren) {
                this.iIfStatementStack.push(ifStatement);
            }
            return visitChildren;
        }

        public void endVisit(IfStatement ifStatement) {
            if (this.iIfStatementStack.peek() == ifStatement) {
                this.iIfStatementStack.pop();
            }
        }

        @Override
        public boolean visit(ExpressionStatement expressionStatement) {
            ITypeBinding typeBinding;
            MethodInvocation methodInvocation;
            boolean visitChildren = true;
            if (expressionStatement.getExpression().getNodeType() == 32 && (methodInvocation = (MethodInvocation)expressionStatement.getExpression()).getExpression() != null && methodInvocation.getExpression().getNodeType() != 52 && (typeBinding = methodInvocation.getExpression().resolveTypeBinding()) != null) {
                String methodName = methodInvocation.getName().getIdentifier();
                if (EntityQueryHelperClassGenerator.PREPARED_STATEMENT.equals(typeBinding.getQualifiedName()) && EntityQueryHelperClassGenerator.SET_NULL.equals(methodName)) {
                    AST ast = methodInvocation.getAST();
                    ClassInstanceCreation classInstanceCreation = ast.newClassInstanceCreation();
                    classInstanceCreation.setType((Type)ast.newSimpleType(ast.newName("javax.persistence.NoResultException")));
                    ThrowStatement throwStatement = ast.newThrowStatement();
                    throwStatement.setExpression((Expression)classInstanceCreation);
                    Block currentBlock = this.iBlockInfoStack.peek().iBlock;
                    List statements = currentBlock.statements();
                    boolean beforeCurrentStatement = true;
                    int i = 0;
                    while (i < statements.size()) {
                        Statement statement = (Statement)statements.get(i);
                        if (beforeCurrentStatement) {
                            if (statement == expressionStatement) {
                                beforeCurrentStatement = false;
                            }
                        } else {
                            statement.delete();
                            --i;
                        }
                        ++i;
                    }
                    IfStatement currentIfStatement = this.iIfStatementStack.peek();
                    if (currentIfStatement.getThenStatement() == expressionStatement || currentIfStatement.getThenStatement() == currentBlock) {
                        if (currentIfStatement.getParent().getNodeType() == 8) {
                            for (BlockInfo blockInfo : this.iBlockInfoStack) {
                                if (blockInfo.iBlock != currentIfStatement.getParent()) continue;
                                if (blockInfo.iDeadIfExpressions == null) {
                                    blockInfo.iDeadIfExpressions = new HashSet<Expression>();
                                }
                                blockInfo.iDeadIfExpressions.add(currentIfStatement.getExpression());
                                break;
                            }
                        }
                    } else if ((currentIfStatement.getElseStatement() == expressionStatement || currentIfStatement.getElseStatement() == currentBlock) && currentIfStatement.getParent().getNodeType() == 8) {
                        for (BlockInfo blockInfo : this.iBlockInfoStack) {
                            if (blockInfo.iBlock != currentIfStatement.getParent()) continue;
                            if (blockInfo.iDeadElseExpressions == null) {
                                blockInfo.iDeadElseExpressions = new HashSet<Expression>();
                            }
                            blockInfo.iDeadElseExpressions.add(currentIfStatement.getExpression());
                            break;
                        }
                    }
                    this.replaceASTNode((ASTNode)expressionStatement, (ASTNode)throwStatement);
                    visitChildren = false;
                }
            }
            return visitChildren;
        }

        public void endVisit(MethodInvocation methodInvocation) {
            String methodName = methodInvocation.getName().getIdentifier();
            if (methodInvocation.getExpression() != null && methodInvocation.getExpression().getNodeType() != 52) {
                ITypeBinding typeBinding = methodInvocation.getExpression().resolveTypeBinding();
                if (typeBinding != null) {
                    if (EntityQueryHelperClassGenerator.PREPARED_STATEMENT.equals(typeBinding.getQualifiedName())) {
                        if (PREPARED_STATEMENT_TO_QUERY_METHOD_MAP.containsKey(methodName)) {
                            methodInvocation.getName().setIdentifier((String)PREPARED_STATEMENT_TO_QUERY_METHOD_MAP.get(methodName));
                        } else {
                            LOGGER.info("unmapped prepared statement method: " + methodName);
                        }
                        if (EntityQueryHelperClassGenerator.SET_NULL.equals(methodName)) {
                            List arguments = methodInvocation.arguments();
                            while (arguments.size() > 1) {
                                arguments.remove(arguments.size() - 1);
                            }
                            NullLiteral nullLiteral = methodInvocation.getAST().newNullLiteral();
                            arguments.add(nullLiteral);
                        } else if (EntityQueryHelperClassGenerator.SET_OBJECT.equals(methodName)) {
                            List arguments = methodInvocation.arguments();
                            while (arguments.size() > 2) {
                                arguments.remove(arguments.size() - 1);
                            }
                        }
                    } else if (EntityQueryHelperClassGenerator.CATALOG_SQL_HELPER.equals(typeBinding.getQualifiedName()) && methodName.equals(EntityQueryHelperClassGenerator.SET_PARAMETERS_IN_WHERE_CLAUSE)) {
                        methodInvocation.setExpression(null);
                        methodInvocation.getName().setIdentifier(EntityQueryHelperClassGenerator.SET_PARAMETERS_IN_QUERY);
                    }
                }
            } else if (FINDER_OBJECT_TO_QUERY_HELPER_METHOD_MAP.containsKey(methodName)) {
                methodInvocation.getName().setIdentifier((String)FINDER_OBJECT_TO_QUERY_HELPER_METHOD_MAP.get(methodName));
            }
        }

        public void endVisit(SuperMethodInvocation node) {
            String methodName = node.getName().getIdentifier();
            if (FINDER_OBJECT_TO_QUERY_HELPER_METHOD_MAP.containsKey(methodName)) {
                node.getName().setIdentifier((String)FINDER_OBJECT_TO_QUERY_HELPER_METHOD_MAP.get(methodName));
            }
        }

        @Override
        public boolean visit(SimpleType node) {
            boolean visitChildren = true;
            ITypeBinding typeBinding = node.resolveBinding();
            if (typeBinding != null) {
                String qualifiedTypeName = typeBinding.getQualifiedName();
                if (TYPE_MAP.containsKey(qualifiedTypeName)) {
                    SimpleType newType = node.getAST().newSimpleType(node.getAST().newName((String)TYPE_MAP.get(qualifiedTypeName)));
                    this.replaceASTNode((ASTNode)node, (ASTNode)newType);
                    visitChildren = false;
                }
            }
            if (visitChildren) {
                super.visit(node);
            }
            return visitChildren;
        }

        @Override
        public boolean visit(SimpleName node) {
            boolean visitChildren = true;
            IBinding binding = node.resolveBinding();
            if (binding != null && binding.getKind() == 3) {
                String declaringClass;
                IVariableBinding variableBinding = (IVariableBinding)binding;
                if (!node.isDeclaration() && variableBinding.getDeclaringClass() != null && variableBinding.isField() && (variableBinding.getModifiers() & 0x19) == 25 && !this.isClassInHierarchy(declaringClass = variableBinding.getDeclaringClass().getQualifiedName())) {
                    Name newName = node.getAST().newName(String.valueOf(declaringClass) + "." + node.getIdentifier());
                    this.replaceASTNode((ASTNode)node, (ASTNode)newName);
                    visitChildren = false;
                }
            }
            if (visitChildren) {
                visitChildren = super.visit(node);
            }
            return visitChildren;
        }

        @Override
        public boolean visit(FieldAccess node) {
            String declaringClass;
            IVariableBinding variableBinding;
            boolean visitChildren = true;
            if (node.getExpression().getNodeType() == 52 && (variableBinding = node.resolveFieldBinding()) != null && variableBinding.getDeclaringClass() != null && variableBinding.isField() && (variableBinding.getModifiers() & 0x19) == 25 && !this.isClassInHierarchy(declaringClass = variableBinding.getDeclaringClass().getQualifiedName())) {
                Name newName = node.getAST().newName(String.valueOf(declaringClass) + "." + node.getName().getIdentifier());
                this.replaceASTNode((ASTNode)node, (ASTNode)newName);
                visitChildren = false;
            }
            if (visitChildren) {
                visitChildren = super.visit(node);
            }
            return visitChildren;
        }

        private boolean isClassInHierarchy(String className) {
            return EntityQueryHelperClassGenerator.this.iEntityInfo.getEjbFinderObjectType() != null && EntityQueryHelperClassGenerator.this.iEntityInfo.getEjbFinderObjectType().getFullyQualifiedName('.').equals(className) || EntityQueryHelperClassGenerator.this.iEntityInfo.getEjbFinderObjectBaseType() != null && EntityQueryHelperClassGenerator.this.iEntityInfo.getEjbFinderObjectBaseType().getFullyQualifiedName('.').equals(className) || EntityQueryHelperClassGenerator.this.iEntityInfo.getSupertype() != null && EntityQueryHelperClassGenerator.this.iEntityInfo.getSupertype().getEjbFinderObjectType() != null && EntityQueryHelperClassGenerator.this.iEntityInfo.getSupertype().getEjbFinderObjectType().equals(className) || EntityQueryHelperClassGenerator.this.iEntityInfo.getSupertype() != null && EntityQueryHelperClassGenerator.this.iEntityInfo.getSupertype().getEjbFinderObjectBaseType() != null && EntityQueryHelperClassGenerator.this.iEntityInfo.getSupertype().getEjbFinderObjectBaseType().equals(className);
        }
    }
}

