/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.port.generators;

import com.ibm.commerce.jpa.port.generators.PortVisitor;
import com.ibm.commerce.jpa.port.info.ApplicationInfo;
import com.ibm.commerce.jpa.port.info.ClassInfo;
import com.ibm.commerce.jpa.port.info.EntityInfo;
import com.ibm.commerce.jpa.port.info.FieldInfo;
import com.ibm.commerce.jpa.port.info.ModuleInfo;
import com.ibm.commerce.jpa.port.info.RelatedEntityInfo;
import com.ibm.commerce.jpa.port.util.BackupUtil;
import com.ibm.commerce.jpa.port.util.DataClassUtil;
import com.ibm.commerce.jpa.port.util.ImportUtil;
import com.ibm.commerce.jpa.port.util.JavaUtil;
import com.ibm.commerce.jpa.port.util.TargetExceptionUtil;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;

public class EntityDataClassGenerator {
    private static final String COPYRIGHT_FIELD = "COPYRIGHT";
    private static final String IS = "is";
    private static final String DIRTY = "Dirty";
    private static final String GET_IS = "getIs";
    private static final String GET = "get";
    private static final String COPY_TO = "copyTo";
    private static final String INITIALIZE = "initialize";
    private static final String GET_PRIMARY_KEY = "getPrimaryKey";
    private ASTParser iASTParser;
    private BackupUtil iBackupUtil;
    private EntityInfo iEntityInfo;
    private ModuleInfo iModuleInfo;
    private ApplicationInfo iApplicationInfo;
    private ClassInfo iEntityAccessBeanClassInfo;
    private TypeDeclaration iEntityDataClassTypeDeclaration;

    public EntityDataClassGenerator(ASTParser astParser, BackupUtil backupUtil, EntityInfo entityInfo) {
        this.iASTParser = astParser;
        this.iBackupUtil = backupUtil;
        this.iEntityInfo = entityInfo;
        this.iModuleInfo = entityInfo.getModuleInfo();
        this.iApplicationInfo = entityInfo.getModuleInfo().getApplicationInfo();
        this.iEntityAccessBeanClassInfo = entityInfo.getEntityAccessBeanClassInfo();
    }

    public void generate(IProgressMonitor progressMonitor) {
        try {
            progressMonitor.beginTask("generate entity data class for " + this.iEntityInfo.getEjbName(), 1000);
            try {
                this.iASTParser.setSource(this.iEntityInfo.getEjbAccessBeanType().getCompilationUnit());
                this.iASTParser.setResolveBindings(true);
                CompilationUnit ejbDataClassCompilationUnit = (CompilationUnit)this.iASTParser.createAST((IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                StringBuilder sb = new StringBuilder();
                sb.append("package ");
                sb.append(this.iEntityAccessBeanClassInfo.getPackageFragment().getElementName());
                sb.append(";\r\n");
                JavaUtil.appendCopyrightComment(sb);
                List importDeclarations = ejbDataClassCompilationUnit.imports();
                ImportUtil.appendImports(importDeclarations, sb);
                sb.append("\r\npublic class ");
                sb.append(this.iEntityAccessBeanClassInfo.getClassName());
                String[] superInterfaceNames = this.iEntityInfo.getEjbAccessBeanType().getSuperInterfaceNames();
                boolean firstInterface = true;
                String[] stringArray = superInterfaceNames;
                int n = superInterfaceNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String superInterfaceName = stringArray[n2];
                    if (firstInterface) {
                        firstInterface = false;
                        sb.append(" implements ");
                    } else {
                        sb.append(", ");
                    }
                    sb.append(superInterfaceName);
                    ++n2;
                }
                sb.append(" {\r\n");
                JavaUtil.appendCopyrightField(sb);
                this.appendConstructors(sb);
                sb.append("}");
                String source = sb.toString();
                Document document = new Document(source);
                this.iASTParser.setProject(this.iModuleInfo.getJavaProject());
                this.iASTParser.setResolveBindings(false);
                this.iASTParser.setSource(document.get().toCharArray());
                CompilationUnit entityDataClassCompilationUnit = (CompilationUnit)this.iASTParser.createAST((IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                this.iEntityDataClassTypeDeclaration = (TypeDeclaration)entityDataClassCompilationUnit.types().get(0);
                entityDataClassCompilationUnit.recordModifications();
                this.portDataClassTypeDeclaration((TypeDeclaration)ejbDataClassCompilationUnit.types().get(0));
                TextEdit edits = entityDataClassCompilationUnit.rewrite((IDocument)document, null);
                edits.apply((IDocument)document);
                source = document.get();
                ICompilationUnit compilationUnit = this.iEntityAccessBeanClassInfo.getPackageFragment().createCompilationUnit(String.valueOf(this.iEntityAccessBeanClassInfo.getClassName()) + ".java", source, true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                this.iBackupUtil.addGeneratedFile((IFile)compilationUnit.getResource(), (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                this.iApplicationInfo.incrementGeneratedAssetCount();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            progressMonitor.worked(500);
        }
        finally {
            progressMonitor.done();
        }
    }

    private void appendConstructors(StringBuilder sb) {
        sb.append("\r\n\tpublic ");
        sb.append(this.iEntityAccessBeanClassInfo.getClassName());
        sb.append("(){\r\n\t}\r\n");
    }

    private void portDataClassTypeDeclaration(TypeDeclaration ejbDataClassTypeDeclaration) {
        List ejbBodyDeclarations = ejbDataClassTypeDeclaration.bodyDeclarations();
        for (BodyDeclaration ejbBodyDeclaration : ejbBodyDeclarations) {
            switch (ejbBodyDeclaration.getNodeType()) {
                case 23: {
                    this.portFieldDeclaration((FieldDeclaration)ejbBodyDeclaration);
                    break;
                }
                case 31: {
                    this.portMethodDeclaration((MethodDeclaration)ejbBodyDeclaration);
                }
            }
        }
    }

    private void portFieldDeclaration(FieldDeclaration fieldDeclaration) {
        List variableDeclarationFragments = fieldDeclaration.fragments();
        for (VariableDeclarationFragment variableDeclarationFragment : variableDeclarationFragments) {
            String fieldName = variableDeclarationFragment.getName().getIdentifier();
            if (fieldName.equals(COPYRIGHT_FIELD) || fieldName.startsWith(IS) && fieldName.endsWith(DIRTY)) continue;
            fieldDeclaration.accept((ASTVisitor)new PortDataClassVisitor());
            FieldDeclaration entityFieldDeclaration = (FieldDeclaration)ASTNode.copySubtree((AST)this.iEntityDataClassTypeDeclaration.getAST(), (ASTNode)fieldDeclaration);
            int index = 0;
            List entityBodyDeclarations = this.iEntityDataClassTypeDeclaration.bodyDeclarations();
            for (BodyDeclaration bodyDeclaration : entityBodyDeclarations) {
                if (bodyDeclaration.getNodeType() == 31) break;
                ++index;
            }
            entityBodyDeclarations.add(index, entityFieldDeclaration);
        }
    }

    private void portMethodDeclaration(MethodDeclaration methodDeclaration) {
        if (!methodDeclaration.isConstructor()) {
            String methodName = methodDeclaration.getName().getIdentifier();
            if (methodName.equals(INITIALIZE)) {
                this.portInitializeMethodDeclaration(methodDeclaration);
            } else if (!(methodName.startsWith(GET_IS) && methodName.endsWith(DIRTY) || COPY_TO.equals(methodName))) {
                TargetExceptionUtil.getUnhandledTargetExceptions(this.iApplicationInfo, this.iModuleInfo.getJavaProject(), (ASTNode)methodDeclaration.getBody());
                methodDeclaration.accept((ASTVisitor)new PortDataClassVisitor());
                MethodDeclaration entityMethodDeclaration = (MethodDeclaration)ASTNode.copySubtree((AST)this.iEntityDataClassTypeDeclaration.getAST(), (ASTNode)methodDeclaration);
                List entityBodyDeclarations = this.iEntityDataClassTypeDeclaration.bodyDeclarations();
                entityBodyDeclarations.add(entityMethodDeclaration);
            }
        }
    }

    private void portInitializeMethodDeclaration(MethodDeclaration initializeMethodDeclaration) {
        AST ast = initializeMethodDeclaration.getAST();
        JavaUtil.setMethodPublic(initializeMethodDeclaration);
        List parameters = initializeMethodDeclaration.parameters();
        SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)parameters.get(0);
        singleVariableDeclaration.setType((Type)ast.newSimpleType(ast.newName(this.iEntityInfo.getEntityClassInfo().getQualifiedClassName())));
        initializeMethodDeclaration.getBody().accept((ASTVisitor)new InitializeMethodVisitor());
        MethodDeclaration entityMethodDeclaration = (MethodDeclaration)ASTNode.copySubtree((AST)this.iEntityDataClassTypeDeclaration.getAST(), (ASTNode)initializeMethodDeclaration);
        List entityBodyDeclarations = this.iEntityDataClassTypeDeclaration.bodyDeclarations();
        entityBodyDeclarations.add(entityMethodDeclaration);
    }

    private class InitializeMethodVisitor
    extends ASTVisitor {
        private InitializeMethodVisitor() {
        }

        public boolean visit(MethodInvocation methodInvocation) {
            RelatedEntityInfo relatedEntityInfo;
            FieldInfo fieldInfo;
            boolean visitChildren = true;
            String methodName = methodInvocation.getName().getIdentifier();
            if (methodName.startsWith(EntityDataClassGenerator.GET) && (fieldInfo = EntityDataClassGenerator.this.iEntityInfo.getFieldInfoByGetterName(methodName)) != null && (relatedEntityInfo = fieldInfo.getRelatedEntityInfo()) != null) {
                AST ast = methodInvocation.getAST();
                String relatedEntityGetterName = relatedEntityInfo.getGetterName();
                if (relatedEntityGetterName == null) {
                    relatedEntityGetterName = EntityDataClassGenerator.GET + Character.toUpperCase(relatedEntityInfo.getFieldName().charAt(0)) + relatedEntityInfo.getFieldName().substring(1);
                }
                String referencedFieldGetterName = fieldInfo.getReferencedFieldInfo().getRelatedEntityInfo() == null ? fieldInfo.getReferencedFieldInfo().getTargetGetterName() : fieldInfo.getReferencedFieldInfo().getRelatedEntityInfo().getGetterName();
                ConditionalExpression conditionalExpression = ast.newConditionalExpression();
                MethodInvocation getterMethodInvocation = ast.newMethodInvocation();
                getterMethodInvocation.setName(ast.newSimpleName(relatedEntityGetterName));
                getterMethodInvocation.setExpression((Expression)ASTNode.copySubtree((AST)ast, (ASTNode)methodInvocation.getExpression()));
                InfixExpression infixExpression = ast.newInfixExpression();
                infixExpression.setLeftOperand((Expression)getterMethodInvocation);
                infixExpression.setOperator(InfixExpression.Operator.EQUALS);
                infixExpression.setRightOperand((Expression)ast.newNullLiteral());
                conditionalExpression.setExpression((Expression)infixExpression);
                conditionalExpression.setThenExpression((Expression)ast.newNullLiteral());
                getterMethodInvocation = (MethodInvocation)ASTNode.copySubtree((AST)ast, (ASTNode)getterMethodInvocation);
                MethodInvocation fieldMethodInvocation = ast.newMethodInvocation();
                fieldMethodInvocation.setExpression((Expression)getterMethodInvocation);
                fieldMethodInvocation.setName(ast.newSimpleName(referencedFieldGetterName));
                if (fieldInfo.getReferencedFieldInfo().getRelatedEntityInfo() == null) {
                    conditionalExpression.setElseExpression((Expression)fieldMethodInvocation);
                } else {
                    MethodInvocation relatedFieldMethodInvocation = ast.newMethodInvocation();
                    relatedFieldMethodInvocation.setExpression((Expression)fieldMethodInvocation);
                    relatedFieldMethodInvocation.setName(ast.newSimpleName(fieldInfo.getReferencedFieldInfo().getReferencedFieldInfo().getTargetGetterName()));
                    conditionalExpression.setElseExpression((Expression)relatedFieldMethodInvocation);
                }
                JavaUtil.replaceASTNode((ASTNode)methodInvocation, (ASTNode)conditionalExpression);
                visitChildren = false;
            }
            return visitChildren;
        }
    }

    private class PortDataClassVisitor
    extends PortVisitor {
        public PortDataClassVisitor() {
            super(EntityDataClassGenerator.this.iApplicationInfo, EntityDataClassGenerator.this.iModuleInfo.getJavaProject());
        }

        @Override
        public boolean visit(ExpressionStatement expressionStatement) {
            boolean visitChildren = true;
            Expression statementExpression = expressionStatement.getExpression();
            if (statementExpression.getNodeType() == 7) {
                Assignment assignment = (Assignment)statementExpression;
                Expression leftHandSide = assignment.getLeftHandSide();
                switch (leftHandSide.getNodeType()) {
                    case 22: {
                        String fieldName;
                        FieldAccess fieldAccess = (FieldAccess)leftHandSide;
                        if (fieldAccess.getExpression().getNodeType() != 52 || !(fieldName = fieldAccess.getName().getIdentifier()).startsWith(EntityDataClassGenerator.IS) || !fieldName.endsWith(EntityDataClassGenerator.DIRTY)) break;
                        expressionStatement.delete();
                        visitChildren = false;
                        break;
                    }
                    case 42: {
                        String fieldName;
                        IVariableBinding variableBinding;
                        SimpleName simpleName = (SimpleName)leftHandSide;
                        IBinding binding = simpleName.resolveBinding();
                        if (!(binding instanceof IVariableBinding) || !(variableBinding = (IVariableBinding)binding).isField() || !(fieldName = simpleName.getIdentifier()).startsWith(EntityDataClassGenerator.IS) || !fieldName.endsWith(EntityDataClassGenerator.DIRTY)) break;
                        expressionStatement.delete();
                        visitChildren = false;
                    }
                }
            }
            if (visitChildren) {
                visitChildren = super.visit(expressionStatement);
            }
            return visitChildren;
        }

        @Override
        public boolean visit(MethodInvocation methodInvocation) {
            String methodName;
            boolean visitChildren = true;
            if ((methodInvocation.getExpression() == null || methodInvocation.getExpression().getNodeType() == 52) && EntityDataClassGenerator.GET_PRIMARY_KEY.equals(methodName = methodInvocation.getName().getIdentifier())) {
                visitChildren = DataClassUtil.portGetPrimaryKeyMethodInvocation(EntityDataClassGenerator.this.iEntityInfo, methodInvocation, (PortVisitor)this);
            }
            if (visitChildren) {
                visitChildren = super.visit(methodInvocation);
            }
            return visitChildren;
        }

        @Override
        public boolean visit(CastExpression castExpression) {
            MethodInvocation methodInvocation;
            String methodName;
            boolean visitChildren = true;
            if (castExpression.getExpression().getNodeType() == 32 && EntityDataClassGenerator.GET_PRIMARY_KEY.equals(methodName = (methodInvocation = (MethodInvocation)castExpression.getExpression()).getName().getIdentifier())) {
                visitChildren = DataClassUtil.portGetPrimaryKeyMethodInvocation(EntityDataClassGenerator.this.iEntityInfo, methodInvocation, (ASTNode)castExpression, this);
            }
            if (visitChildren) {
                visitChildren = super.visit(castExpression);
            }
            return visitChildren;
        }
    }
}

