/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.port.generators;

import com.ibm.commerce.jpa.logger.LoggerHelper;
import com.ibm.commerce.jpa.port.generators.CatalogEntryEntityBaseGenerator;
import com.ibm.commerce.jpa.port.generators.EmailConfigurationEntityBaseGenerator;
import com.ibm.commerce.jpa.port.generators.EmailPromotionEntityBaseGenerator;
import com.ibm.commerce.jpa.port.generators.FieldGenerator;
import com.ibm.commerce.jpa.port.generators.ManagedFileEntityBaseGenerator;
import com.ibm.commerce.jpa.port.generators.MemberAttributeEntityBaseGenerator;
import com.ibm.commerce.jpa.port.generators.MemberAttributeValueEntityBaseGenerator;
import com.ibm.commerce.jpa.port.generators.MemberEntityBaseGenerator;
import com.ibm.commerce.jpa.port.generators.MethodGenerator;
import com.ibm.commerce.jpa.port.generators.OrderItemEntityBaseGenerator;
import com.ibm.commerce.jpa.port.generators.PAttrAttachmentValueEntityGenerator;
import com.ibm.commerce.jpa.port.generators.PortVisitor;
import com.ibm.commerce.jpa.port.generators.StoreEntityEntityBaseGenerator;
import com.ibm.commerce.jpa.port.info.AccessBeanInfo;
import com.ibm.commerce.jpa.port.info.ApplicationInfo;
import com.ibm.commerce.jpa.port.info.ClassInfo;
import com.ibm.commerce.jpa.port.info.ColumnInfo;
import com.ibm.commerce.jpa.port.info.EjbRelationshipRoleInfo;
import com.ibm.commerce.jpa.port.info.EntityInfo;
import com.ibm.commerce.jpa.port.info.FieldInfo;
import com.ibm.commerce.jpa.port.info.FinderInfo;
import com.ibm.commerce.jpa.port.info.ForeignKeyInfo;
import com.ibm.commerce.jpa.port.info.ModuleInfo;
import com.ibm.commerce.jpa.port.info.RelatedEntityInfo;
import com.ibm.commerce.jpa.port.info.TableInfo;
import com.ibm.commerce.jpa.port.info.TargetExceptionInfo;
import com.ibm.commerce.jpa.port.info.UserMethodInfo;
import com.ibm.commerce.jpa.port.util.AccessBeanUtil;
import com.ibm.commerce.jpa.port.util.BackupUtil;
import com.ibm.commerce.jpa.port.util.ImportUtil;
import com.ibm.commerce.jpa.port.util.JavaUtil;
import com.ibm.commerce.jpa.port.util.PrimaryKeyUtil;
import com.ibm.commerce.jpa.port.util.TargetExceptionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;

public class EntityClassGenerator {
    private static final Logger LOGGER = LoggerHelper.getLogger(EntityClassGenerator.class);
    private static final String BLOB = "BLOB";
    private static final String CLOB = "CLOB";
    private static final String CHAR = "CHAR";
    private static final String VARCHAR = "VARCHAR";
    private static final String INTEGER = "INTEGER";
    private static final String OPT_COUNTER = "optCounter";
    private static final String STRING = "java.lang.String";
    private static final String SET_INIT_KEY = "setInitKey_";
    private static final String INSTANTIATE_ENTITY = "instantiateEntity";
    private static final String TRIM = "trim";
    private static final Map<String, List<MethodGenerator>> METHOD_GENERATORS_MAP = new HashMap<String, List<MethodGenerator>>();
    private static final Map<String, List<FieldGenerator>> FIELD_GENERATORS_MAP;
    private ASTParser iASTParser;
    private BackupUtil iBackupUtil;
    private EntityInfo iEntityInfo;
    private ModuleInfo iModuleInfo;
    private ApplicationInfo iApplicationInfo;
    private ClassInfo iEntityClassInfo;
    private ClassInfo iEntityBaseClassInfo;
    private ClassInfo iEntityKeyClassInfo;
    private ClassInfo iEntityAccessHelperClassInfo;
    private List<FieldGenerator> iEntityFieldGenerators;
    private List<FieldGenerator> iEntityBaseFieldGenerators;
    private List<MethodGenerator> iEntityMethodGenerators;
    private List<MethodGenerator> iEntityBaseMethodGenerators;

    static {
        ArrayList<MethodGenerator> methodGenerators = new ArrayList<MethodGenerator>();
        methodGenerators.add(new CatalogEntryEntityBaseGenerator.GetTypeMethodGenerator());
        METHOD_GENERATORS_MAP.put("com.ibm.commerce.catalog.objimpl.CatalogEntryJPAEntityBase", methodGenerators);
        methodGenerators = new ArrayList();
        methodGenerators.add(new MemberEntityBaseGenerator.GetTypeMethodGenerator());
        METHOD_GENERATORS_MAP.put("com.ibm.commerce.user.objimpl.MemberJPAEntityBase", methodGenerators);
        methodGenerators = new ArrayList();
        methodGenerators.add(new MemberAttributeEntityBaseGenerator.AddAttributeValueMethodGenerator());
        METHOD_GENERATORS_MAP.put("com.ibm.commerce.user.objimpl.MemberAttributeJPAEntityBase", methodGenerators);
        methodGenerators = new ArrayList();
        methodGenerators.add(new StoreEntityEntityBaseGenerator.GetTypeMethodGenerator());
        METHOD_GENERATORS_MAP.put("com.ibm.commerce.catalog.objimpl.StoreEntityJPAEntityBase", methodGenerators);
        methodGenerators = new ArrayList();
        methodGenerators.add(new ManagedFileEntityBaseGenerator.GetContextMethodGenerator());
        methodGenerators.add(new ManagedFileEntityBaseGenerator.GetFileMethodGenerator());
        methodGenerators.add(new ManagedFileEntityBaseGenerator.SetFileMethodGenerator());
        methodGenerators.add(new ManagedFileEntityBaseGenerator.GetLargeFileHomeMethodGenerator());
        methodGenerators.add(new ManagedFileEntityBaseGenerator.GetSmallFileHomeMethodGenerator());
        METHOD_GENERATORS_MAP.put("com.ibm.commerce.context.content.resources.file.objimpl.ManagedFileJPAEntityBase", methodGenerators);
        methodGenerators = new ArrayList();
        methodGenerators.add(new PAttrAttachmentValueEntityGenerator.SetPAttrValueMethodGenerator());
        METHOD_GENERATORS_MAP.put("com.ibm.commerce.utf.objects.PAttrAttachmentValueJPAEntity", methodGenerators);
        methodGenerators = new ArrayList();
        methodGenerators.add(new MemberAttributeValueEntityBaseGenerator.GetMemberAttributeTypeMethodGenerator());
        METHOD_GENERATORS_MAP.put("com.ibm.commerce.user.objimpl.MemberAttributeValueJPAEntityBase", methodGenerators);
        FIELD_GENERATORS_MAP = new HashMap<String, List<FieldGenerator>>();
        ArrayList<FieldGenerator> fieldGenerators = new ArrayList<FieldGenerator>();
        fieldGenerators.add(new CatalogEntryEntityBaseGenerator.TypeSuffixFieldGenerator());
        FIELD_GENERATORS_MAP.put("com.ibm.commerce.catalog.objimpl.CatalogEntryJPAEntityBase", fieldGenerators);
        fieldGenerators = new ArrayList();
        fieldGenerators.add(new MemberEntityBaseGenerator.TypeSuffixFieldGenerator());
        FIELD_GENERATORS_MAP.put("com.ibm.commerce.user.objimpl.MemberJPAEntityBase", fieldGenerators);
        fieldGenerators = new ArrayList();
        fieldGenerators.add(new StoreEntityEntityBaseGenerator.TypeSuffixFieldGenerator());
        FIELD_GENERATORS_MAP.put("com.ibm.commerce.catalog.objimpl.StoreEntityJPAEntityBase", fieldGenerators);
        fieldGenerators = new ArrayList();
        fieldGenerators.add(new MemberAttributeValueEntityBaseGenerator.TypeSuffixFieldGenerator());
        FIELD_GENERATORS_MAP.put("com.ibm.commerce.user.objimpl.MemberAttributeValueJPAEntityBase", fieldGenerators);
        fieldGenerators = new ArrayList();
        fieldGenerators.add(new ManagedFileEntityBaseGenerator.ConstantLargeFileEjbNameFieldGenerator());
        fieldGenerators.add(new ManagedFileEntityBaseGenerator.ConstantSmallFileEjbNameFieldGenerator());
        fieldGenerators.add(new ManagedFileEntityBaseGenerator.ContextFieldGenerator());
        fieldGenerators.add(new ManagedFileEntityBaseGenerator.LargeFileBlobColumnNameFieldGenerator());
        fieldGenerators.add(new ManagedFileEntityBaseGenerator.LargeFileHomeFieldGenerator());
        fieldGenerators.add(new ManagedFileEntityBaseGenerator.LargeFileTableNameFieldGenerator());
        fieldGenerators.add(new ManagedFileEntityBaseGenerator.LargeFileWhereClauseFieldGenerator());
        fieldGenerators.add(new ManagedFileEntityBaseGenerator.SmallFileBlobColumnNameFieldGenerator());
        fieldGenerators.add(new ManagedFileEntityBaseGenerator.SmallFileHomeFieldGenerator());
        fieldGenerators.add(new ManagedFileEntityBaseGenerator.SmallFileTableNameFieldGenerator());
        fieldGenerators.add(new ManagedFileEntityBaseGenerator.SmallFileWhereClauseFieldGenerator());
        FIELD_GENERATORS_MAP.put("com.ibm.commerce.context.content.resources.file.objimpl.ManagedFileJPAEntityBase", fieldGenerators);
        fieldGenerators = new ArrayList();
        fieldGenerators.add(new EmailPromotionEntityBaseGenerator.UnsentIntegerFieldGenerator());
        fieldGenerators.add(new EmailPromotionEntityBaseGenerator.SentIntegerFieldGenerator());
        fieldGenerators.add(new EmailPromotionEntityBaseGenerator.DeletedIntegerFieldGenerator());
        FIELD_GENERATORS_MAP.put("com.ibm.commerce.emarketing.objimpl.EmailPromotionJPAEntityBase", fieldGenerators);
        fieldGenerators = new ArrayList();
        fieldGenerators.add(new OrderItemEntityBaseGenerator.BigDecimalFieldGenerator());
        FIELD_GENERATORS_MAP.put("com.ibm.commerce.order.objimpl.OrderItemJPAEntityBase", fieldGenerators);
        fieldGenerators = new ArrayList();
        fieldGenerators.add(new EmailConfigurationEntityBaseGenerator.TypeInboundFieldGenerator());
        fieldGenerators.add(new EmailConfigurationEntityBaseGenerator.TypeOutboundFieldGenerator());
        FIELD_GENERATORS_MAP.put("com.ibm.commerce.emarketing.objimpl.EmailConfigurationJPAEntityBase", fieldGenerators);
    }

    public EntityClassGenerator(ASTParser astParser, BackupUtil backupUtil, EntityInfo entityInfo) {
        this.iASTParser = astParser;
        this.iBackupUtil = backupUtil;
        this.iEntityInfo = entityInfo;
        this.iModuleInfo = entityInfo.getModuleInfo();
        this.iApplicationInfo = this.iModuleInfo.getApplicationInfo();
        this.iEntityClassInfo = entityInfo.getEntityClassInfo();
        this.iEntityBaseClassInfo = entityInfo.getEntityBaseClassInfo();
        this.iEntityKeyClassInfo = entityInfo.getEntityKeyClassInfo();
        this.iEntityAccessHelperClassInfo = entityInfo.getEntityAccessHelperClassInfo();
        this.iEntityFieldGenerators = FIELD_GENERATORS_MAP.get(this.iEntityClassInfo.getQualifiedClassName());
        this.iEntityMethodGenerators = METHOD_GENERATORS_MAP.get(this.iEntityClassInfo.getQualifiedClassName());
        if (this.iEntityBaseClassInfo != null) {
            this.iEntityBaseFieldGenerators = FIELD_GENERATORS_MAP.get(this.iEntityBaseClassInfo.getQualifiedClassName());
            this.iEntityBaseMethodGenerators = METHOD_GENERATORS_MAP.get(this.iEntityBaseClassInfo.getQualifiedClassName());
        }
    }

    public void generate(IProgressMonitor progressMonitor) {
        try {
            progressMonitor.beginTask("generate " + this.iEntityInfo.getEjbName(), -1);
            this.generateEntityBaseClass(progressMonitor);
            progressMonitor.worked(500);
            this.generateEntityClass(progressMonitor);
            progressMonitor.worked(500);
        }
        finally {
            progressMonitor.done();
        }
    }

    private void generateEntityClass(IProgressMonitor progressMonitor) {
        try {
            CompilationUnit ejbCompilationUnit = this.iEntityInfo.getEjbCompilationUnit();
            StringBuilder sb = new StringBuilder();
            sb.append("package ");
            sb.append(this.iEntityClassInfo.getPackageFragment().getElementName());
            sb.append(";\r\n");
            JavaUtil.appendCopyrightComment(sb);
            sb.append("\r\nimport javax.persistence.*;\r\n");
            List importDeclarations = ejbCompilationUnit.imports();
            ImportUtil.appendImports(importDeclarations, sb);
            if (this.iEntityClassInfo.getSuperclassName() != null && !this.iEntityClassInfo.getSuperclassPackage().equals(this.iEntityClassInfo.getPackageFragment().getElementName())) {
                sb.append("\r\nimport ");
                sb.append(this.iEntityClassInfo.getQualifiedSuperclassName());
                sb.append(";\r\n");
            }
            sb.append("\r\n@javax.persistence.Entity(name = \"");
            sb.append(this.iEntityInfo.getEjbName());
            sb.append("\")");
            TableInfo tableInfo = this.iEntityInfo.getSecondaryTableInfo();
            if (tableInfo == null) {
                tableInfo = this.iEntityInfo.getPrimaryTableInfo();
            }
            if (tableInfo != null) {
                LOGGER.info("table=" + tableInfo.getTableName());
                sb.append("\r\n@Table(name = \"");
                sb.append(tableInfo.getTableName());
                sb.append("\")");
            } else {
                LOGGER.info("no table for " + this.iEntityInfo.getEjbName());
            }
            if (this.iEntityInfo.getSubtypes() != null) {
                sb.append("\r\n@Inheritance(strategy = ");
                boolean joined = false;
                for (EntityInfo subType : this.iEntityInfo.getSubtypes()) {
                    if (subType.getSecondaryTableInfo() == null) continue;
                    joined = true;
                    break;
                }
                if (joined) {
                    sb.append("InheritanceType.JOINED");
                } else {
                    sb.append("InheritanceType.SINGLE_TABLE");
                }
                sb.append(")");
                if (this.iEntityInfo.getDiscriminatorColumnInfo() != null) {
                    ColumnInfo columnInfo = this.iEntityInfo.getDiscriminatorColumnInfo();
                    sb.append("\r\n@DiscriminatorColumn(name = \"");
                    sb.append(columnInfo.getColumnName());
                    sb.append("\"");
                    String type = columnInfo.getTypeName();
                    Integer length = columnInfo.getLength();
                    if (CHAR.equals(type) && (length == null || length == 1)) {
                        sb.append(", discriminatorType = DiscriminatorType.CHAR");
                    } else if (VARCHAR.equals(type) || CHAR.equals(type)) {
                        sb.append(", discriminatorType = DiscriminatorType.STRING");
                    } else if (INTEGER.equals(type)) {
                        sb.append(", discriminatorType = DiscriminatorType.INTEGER");
                    }
                    if (columnInfo.getLength() != null) {
                        sb.append(", length = ");
                        sb.append(columnInfo.getLength());
                    }
                    sb.append(")");
                }
            }
            if (this.iEntityInfo.getDiscriminatorValue() != null) {
                String discriminatorValue = this.iEntityInfo.getDiscriminatorValue();
                ColumnInfo discriminatorColumnInfo = this.iEntityInfo.getDiscriminatorColumnInfo();
                if (discriminatorColumnInfo == null && this.iEntityInfo.getSupertype() != null) {
                    discriminatorColumnInfo = this.iEntityInfo.getSupertype().getDiscriminatorColumnInfo();
                }
                if (discriminatorColumnInfo != null) {
                    Integer length = discriminatorColumnInfo.getLength();
                    if (CHAR.equals(discriminatorColumnInfo.getTypeName()) && length != null && length > 1) {
                        while (discriminatorValue.length() < length) {
                            discriminatorValue = String.valueOf(discriminatorValue) + " ";
                        }
                    }
                }
                sb.append("\r\n@DiscriminatorValue(\"");
                sb.append(discriminatorValue);
                sb.append("\")");
            }
            if (this.iEntityInfo.getJoinKey() != null && this.iEntityInfo.getSecondaryTableInfo() != null) {
                ColumnInfo joinColumn = this.iEntityInfo.getSecondaryTableInfo().getColumnInfo(this.iEntityInfo.getJoinKey().getMembers()[0]);
                ColumnInfo referencedColumn = this.iEntityInfo.getSupertype().getPrimaryTableInfo().getColumnInfo(this.iEntityInfo.getJoinKey().getReferencedMembers()[0]);
                sb.append("\r\n@PrimaryKeyJoinColumn(name = \"");
                sb.append(joinColumn.getColumnName());
                sb.append("\", referencedColumnName = \"");
                sb.append(referencedColumn.getColumnName());
                sb.append("\")");
            }
            boolean includeAllKeyFields = false;
            if (this.iEntityKeyClassInfo != null && this.hasKeyFields(this.iEntityInfo.getEjbType())) {
                sb.append("\r\n@IdClass(");
                sb.append(this.iEntityKeyClassInfo.getQualifiedClassName());
                sb.append(".class)");
                includeAllKeyFields = true;
            }
            this.appendNamedNativeQueries(sb);
            sb.append("\r\npublic class ");
            sb.append(this.iEntityClassInfo.getClassName());
            if (this.iEntityClassInfo.getSuperclassName() != null) {
                sb.append(" extends ");
                sb.append(this.iEntityClassInfo.getSuperclassName());
            }
            if (this.iEntityBaseClassInfo == null) {
                if (this.iEntityInfo.getProtectable() && (this.iEntityInfo.getSupertype() == null || !this.iEntityInfo.getSupertype().getProtectable())) {
                    sb.append(" implements com.ibm.commerce.security.Protectable");
                    if (this.iEntityInfo.getGroupable() && (this.iEntityInfo.getSupertype() == null || !this.iEntityInfo.getSupertype().getGroupable())) {
                        sb.append(", com.ibm.commerce.grouping.Groupable");
                    }
                } else if (this.iEntityInfo.getGroupable() && (this.iEntityInfo.getSupertype() == null || !this.iEntityInfo.getSupertype().getGroupable())) {
                    sb.append(" implements com.ibm.commerce.security.Groupable");
                }
            }
            sb.append(" {\r\n");
            JavaUtil.appendCopyrightField(sb);
            sb.append("\r\n\tpublic ");
            sb.append(this.iEntityClassInfo.getClassName());
            sb.append("() {\r\n\t}\r\n");
            List<FieldInfo> fields = this.getFields((TypeDeclaration)ejbCompilationUnit.types().get(0));
            List<RelatedEntityInfo> relatedEntities = this.getRelatedEntities((TypeDeclaration)ejbCompilationUnit.types().get(0));
            List<EjbRelationshipRoleInfo> ejbRelationshipRoles = this.getEjbRelationshipRoles((TypeDeclaration)ejbCompilationUnit.types().get(0));
            if (includeAllKeyFields) {
                List<FieldInfo> keyFields = this.iEntityInfo.getKeyFields();
                for (FieldInfo keyFieldInfo : keyFields) {
                    Object relatedEntityInfo;
                    if (!fields.contains(keyFieldInfo)) {
                        fields.add(keyFieldInfo);
                    }
                    if ((relatedEntityInfo = keyFieldInfo.getRelatedEntityInfo()) == null || relatedEntities.contains(relatedEntityInfo)) continue;
                    relatedEntities.add((RelatedEntityInfo)relatedEntityInfo);
                }
                List<EjbRelationshipRoleInfo> allEjbRelationshipRoles = this.iEntityInfo.getEjbRelationshipRoles();
                for (EjbRelationshipRoleInfo ejbRelationshipRole : allEjbRelationshipRoles) {
                    if (!ejbRelationshipRole.getIsKeyField() || ejbRelationshipRoles.contains(ejbRelationshipRole)) continue;
                    ejbRelationshipRoles.add(ejbRelationshipRole);
                }
            }
            this.appendFieldDeclarations(fields, relatedEntities, ejbRelationshipRoles, sb);
            this.appendGeneratedFields(sb, this.iEntityInfo, this.iEntityFieldGenerators);
            this.appendGettersAndSetters(fields, relatedEntities, ejbRelationshipRoles, sb);
            if (this.iEntityBaseClassInfo == null) {
                this.appendGetAccessHelper(sb);
            }
            this.appendGeneratedMethods(sb, this.iEntityInfo, this.iEntityMethodGenerators);
            sb.append("}");
            String source = sb.toString();
            List<FieldDeclaration> fieldDeclarations = this.getPortRequiredFieldDeclarations((TypeDeclaration)ejbCompilationUnit.types().get(0), this.iEntityFieldGenerators);
            List<MethodDeclaration> methodDeclarations = this.getPortRequiredMethodDeclarations((TypeDeclaration)ejbCompilationUnit.types().get(0), this.iEntityMethodGenerators);
            if (fieldDeclarations.size() > 0 || methodDeclarations.size() > 0) {
                Document document = new Document(source);
                this.iASTParser.setProject(this.iEntityInfo.getModuleInfo().getJavaProject());
                this.iASTParser.setResolveBindings(false);
                this.iASTParser.setSource(document.get().toCharArray());
                CompilationUnit entityCompilationUnit = (CompilationUnit)this.iASTParser.createAST((IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                entityCompilationUnit.recordModifications();
                this.portFieldDeclarations((TypeDeclaration)entityCompilationUnit.types().get(0), fieldDeclarations);
                this.portMethodDeclarations((TypeDeclaration)entityCompilationUnit.types().get(0), methodDeclarations);
                TextEdit edits = entityCompilationUnit.rewrite((IDocument)document, null);
                edits.apply((IDocument)document);
                source = document.get();
            }
            ICompilationUnit compilationUnit = this.iEntityClassInfo.getPackageFragment().createCompilationUnit(String.valueOf(this.iEntityClassInfo.getClassName()) + ".java", source, true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
            this.iBackupUtil.addGeneratedFile((IFile)compilationUnit.getResource(), (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
            this.iApplicationInfo.incrementGeneratedAssetCount();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private void generateEntityBaseClass(IProgressMonitor progressMonitor) {
        if (this.iEntityBaseClassInfo != null) {
            try {
                CompilationUnit ejbBaseCompilationUnit = this.iEntityInfo.getEjbBaseCompilationUnit();
                StringBuilder sb = new StringBuilder();
                sb.append("package ");
                sb.append(this.iEntityBaseClassInfo.getPackageFragment().getElementName());
                sb.append(";\r\n");
                JavaUtil.appendCopyrightComment(sb);
                sb.append("\r\nimport javax.persistence.*;\r\n");
                List importDeclarations = ejbBaseCompilationUnit.imports();
                ImportUtil.appendImports(importDeclarations, sb);
                if (this.iEntityBaseClassInfo.getSuperclassName() != null && !this.iEntityBaseClassInfo.getSuperclassPackage().equals(this.iEntityBaseClassInfo.getPackageFragment().getElementName())) {
                    sb.append("\r\nimport ");
                    sb.append(this.iEntityBaseClassInfo.getQualifiedSuperclassName());
                    sb.append(";\r\n");
                }
                sb.append("\r\n@MappedSuperclass");
                boolean excludeAllKeyFields = false;
                if (this.iEntityKeyClassInfo != null && this.hasKeyFields(this.iEntityInfo.getEjbBaseType())) {
                    if (!this.hasKeyFields(this.iEntityInfo.getEjbType())) {
                        sb.append("\r\n@IdClass(");
                        sb.append(this.iEntityKeyClassInfo.getQualifiedClassName());
                        sb.append(".class)");
                    } else {
                        excludeAllKeyFields = true;
                    }
                }
                sb.append("\r\npublic class ");
                sb.append(this.iEntityBaseClassInfo.getClassName());
                if (this.iEntityBaseClassInfo.getSuperclassName() != null) {
                    sb.append(" extends ");
                    sb.append(this.iEntityBaseClassInfo.getSuperclassName());
                }
                if (this.iEntityInfo.getProtectable() && (this.iEntityInfo.getSupertype() == null || !this.iEntityInfo.getSupertype().getProtectable())) {
                    sb.append(" implements com.ibm.commerce.security.Protectable");
                    if (this.iEntityInfo.getGroupable() && (this.iEntityInfo.getSupertype() == null || !this.iEntityInfo.getSupertype().getGroupable())) {
                        sb.append(", com.ibm.commerce.grouping.Groupable");
                    }
                } else if (this.iEntityInfo.getGroupable() && (this.iEntityInfo.getSupertype() == null || !this.iEntityInfo.getSupertype().getGroupable())) {
                    sb.append(" implements com.ibm.commerce.grouping.Groupable");
                }
                sb.append(" {\r\n");
                JavaUtil.appendCopyrightField(sb);
                List<FieldInfo> fields = this.getFields((TypeDeclaration)ejbBaseCompilationUnit.types().get(0));
                List<RelatedEntityInfo> relatedEntities = this.getRelatedEntities((TypeDeclaration)ejbBaseCompilationUnit.types().get(0));
                List<EjbRelationshipRoleInfo> ejbRelationshipRoles = this.getEjbRelationshipRoles((TypeDeclaration)ejbBaseCompilationUnit.types().get(0));
                if (excludeAllKeyFields) {
                    List<FieldInfo> keyFields = this.iEntityInfo.getKeyFields();
                    for (FieldInfo keyFieldInfo : keyFields) {
                        Object relatedEntityInfo;
                        if (fields.contains(keyFieldInfo)) {
                            fields.remove(keyFieldInfo);
                        }
                        if ((relatedEntityInfo = keyFieldInfo.getRelatedEntityInfo()) == null || !relatedEntities.contains(relatedEntityInfo)) continue;
                        relatedEntities.remove(relatedEntityInfo);
                    }
                    List<EjbRelationshipRoleInfo> allEjbRelationshipRoles = this.iEntityInfo.getEjbRelationshipRoles();
                    for (EjbRelationshipRoleInfo ejbRelationshipRole : allEjbRelationshipRoles) {
                        if (!ejbRelationshipRole.getIsKeyField() || !ejbRelationshipRoles.contains(ejbRelationshipRole)) continue;
                        ejbRelationshipRoles.remove(ejbRelationshipRole);
                    }
                }
                this.appendFieldDeclarations(fields, relatedEntities, ejbRelationshipRoles, sb);
                this.appendGeneratedFields(sb, this.iEntityInfo, this.iEntityBaseFieldGenerators);
                this.appendGettersAndSetters(fields, relatedEntities, ejbRelationshipRoles, sb);
                this.appendGetAccessHelper(sb);
                this.appendGeneratedMethods(sb, this.iEntityInfo, this.iEntityBaseMethodGenerators);
                sb.append("}");
                String source = sb.toString();
                List<FieldDeclaration> fieldDeclarations = this.getPortRequiredFieldDeclarations((TypeDeclaration)ejbBaseCompilationUnit.types().get(0), this.iEntityBaseFieldGenerators);
                List<MethodDeclaration> methodDeclarations = this.getPortRequiredMethodDeclarations((TypeDeclaration)ejbBaseCompilationUnit.types().get(0), this.iEntityBaseMethodGenerators);
                if (fieldDeclarations.size() > 0 || methodDeclarations.size() > 0) {
                    Document document = new Document(source);
                    this.iASTParser.setProject(this.iEntityInfo.getModuleInfo().getJavaProject());
                    this.iASTParser.setResolveBindings(false);
                    this.iASTParser.setSource(document.get().toCharArray());
                    CompilationUnit entityCompilationUnit = (CompilationUnit)this.iASTParser.createAST((IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                    entityCompilationUnit.recordModifications();
                    this.portFieldDeclarations((TypeDeclaration)entityCompilationUnit.types().get(0), fieldDeclarations);
                    this.portMethodDeclarations((TypeDeclaration)entityCompilationUnit.types().get(0), methodDeclarations);
                    TextEdit edits = entityCompilationUnit.rewrite((IDocument)document, null);
                    edits.apply((IDocument)document);
                    source = document.get();
                }
                ICompilationUnit compilationUnit = this.iEntityBaseClassInfo.getPackageFragment().createCompilationUnit(String.valueOf(this.iEntityBaseClassInfo.getClassName()) + ".java", source, true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                this.iBackupUtil.addGeneratedFile((IFile)compilationUnit.getResource(), (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                this.iApplicationInfo.incrementGeneratedAssetCount();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }

    private List<FieldInfo> getFields(TypeDeclaration ejbTypeDeclaration) {
        ArrayList<FieldInfo> fields = new ArrayList<FieldInfo>();
        List bodyDeclarations = ejbTypeDeclaration.bodyDeclarations();
        block4: for (BodyDeclaration bodyDeclaration : bodyDeclarations) {
            switch (bodyDeclaration.getNodeType()) {
                case 23: {
                    FieldDeclaration fieldDeclaration = (FieldDeclaration)bodyDeclaration;
                    List ejbVariableDeclarationFragments = fieldDeclaration.fragments();
                    for (VariableDeclarationFragment ejbVariableDeclarationFragment : ejbVariableDeclarationFragments) {
                        String fieldName = ejbVariableDeclarationFragment.getName().getIdentifier();
                        FieldInfo fieldInfo = this.iEntityInfo.getFieldInfoByName(fieldName);
                        if (fieldInfo == null || fields.contains(fieldInfo)) continue;
                        fields.add(fieldInfo);
                    }
                    continue block4;
                }
                case 31: {
                    FieldInfo fieldInfo;
                    MethodDeclaration methodDeclaration = (MethodDeclaration)bodyDeclaration;
                    if (methodDeclaration.getReturnType2() == null || methodDeclaration.parameters().size() != 0 || (fieldInfo = this.iEntityInfo.getFieldInfoByGetterName(methodDeclaration.getName().getIdentifier())) == null || fields.contains(fieldInfo)) continue block4;
                    fields.add(fieldInfo);
                }
            }
        }
        return fields;
    }

    private List<RelatedEntityInfo> getRelatedEntities(TypeDeclaration ejbTypeDeclaration) {
        ArrayList<RelatedEntityInfo> relatedEntities = new ArrayList<RelatedEntityInfo>();
        List bodyDeclarations = ejbTypeDeclaration.bodyDeclarations();
        block4: for (BodyDeclaration bodyDeclaration : bodyDeclarations) {
            switch (bodyDeclaration.getNodeType()) {
                case 23: {
                    FieldDeclaration fieldDeclaration = (FieldDeclaration)bodyDeclaration;
                    List ejbVariableDeclarationFragments = fieldDeclaration.fragments();
                    for (VariableDeclarationFragment ejbVariableDeclarationFragment : ejbVariableDeclarationFragments) {
                        String fieldName = ejbVariableDeclarationFragment.getName().getIdentifier();
                        FieldInfo fieldInfo = this.iEntityInfo.getFieldInfoByName(fieldName);
                        if (fieldInfo == null || fieldInfo.getRelatedEntityInfo() == null || relatedEntities.contains(fieldInfo.getRelatedEntityInfo())) continue;
                        relatedEntities.add(fieldInfo.getRelatedEntityInfo());
                    }
                    continue block4;
                }
                case 31: {
                    FieldInfo fieldInfo;
                    MethodDeclaration methodDeclaration = (MethodDeclaration)bodyDeclaration;
                    if (methodDeclaration.getReturnType2() == null || methodDeclaration.parameters().size() != 0 || (fieldInfo = this.iEntityInfo.getFieldInfoByGetterName(methodDeclaration.getName().getIdentifier())) == null || fieldInfo.getRelatedEntityInfo() == null || relatedEntities.contains(fieldInfo.getRelatedEntityInfo())) continue block4;
                    relatedEntities.add(fieldInfo.getRelatedEntityInfo());
                }
            }
        }
        return relatedEntities;
    }

    private List<EjbRelationshipRoleInfo> getEjbRelationshipRoles(TypeDeclaration ejbTypeDeclaration) {
        ArrayList<EjbRelationshipRoleInfo> ejbRelationshipRoles = new ArrayList<EjbRelationshipRoleInfo>();
        List bodyDeclarations = ejbTypeDeclaration.bodyDeclarations();
        block4: for (BodyDeclaration bodyDeclaration : bodyDeclarations) {
            switch (bodyDeclaration.getNodeType()) {
                case 23: {
                    FieldDeclaration fieldDeclaration = (FieldDeclaration)bodyDeclaration;
                    List ejbVariableDeclarationFragments = fieldDeclaration.fragments();
                    for (VariableDeclarationFragment ejbVariableDeclarationFragment : ejbVariableDeclarationFragments) {
                        String fieldName = ejbVariableDeclarationFragment.getName().getIdentifier();
                        EjbRelationshipRoleInfo ejbRelationshipRoleInfo = this.iEntityInfo.getEjbRelationshipRoleInfoByName(fieldName);
                        if (ejbRelationshipRoleInfo == null || ejbRelationshipRoles.contains(ejbRelationshipRoleInfo)) continue;
                        ejbRelationshipRoles.add(ejbRelationshipRoleInfo);
                    }
                    continue block4;
                }
                case 31: {
                    EjbRelationshipRoleInfo ejbRelationshipRoleInfo;
                    MethodDeclaration methodDeclaration = (MethodDeclaration)bodyDeclaration;
                    if (methodDeclaration.getReturnType2() == null || methodDeclaration.parameters().size() != 0 || (ejbRelationshipRoleInfo = this.iEntityInfo.getEjbRelationshipRoleInfoByGetterName(methodDeclaration.getName().getIdentifier())) == null || ejbRelationshipRoles.contains(ejbRelationshipRoleInfo)) continue block4;
                    ejbRelationshipRoles.add(ejbRelationshipRoleInfo);
                }
            }
        }
        return ejbRelationshipRoles;
    }

    private void appendFieldDeclarations(List<FieldInfo> fields, List<RelatedEntityInfo> relatedEntities, List<EjbRelationshipRoleInfo> ejbRelationshipRoles, StringBuilder sb) {
        for (FieldInfo fieldInfo : fields) {
            if (fieldInfo.getRelatedEntityInfo() != null || fieldInfo.getFieldName().equals(OPT_COUNTER)) continue;
            sb.append("\r\n\tprivate ");
            sb.append(fieldInfo.getTypeName());
            sb.append(" ");
            sb.append(fieldInfo.getTargetFieldName());
            sb.append(";\r\n");
        }
        for (RelatedEntityInfo relatedEntityInfo : relatedEntities) {
            if (relatedEntityInfo.getEjbRelationshipRoleInfo() != null) continue;
            sb.append("\r\n\tprivate ");
            sb.append(relatedEntityInfo.getParentEntityInfo().getEntityClassInfo().getQualifiedClassName());
            sb.append(" ");
            sb.append(relatedEntityInfo.getFieldName());
            sb.append(";\r\n");
        }
        for (EjbRelationshipRoleInfo ejbRelationshipRoleInfo : ejbRelationshipRoles) {
            sb.append("\r\n\tprivate ");
            if ("java.util.Collection".equals(ejbRelationshipRoleInfo.getFieldType())) {
                sb.append("java.util.Collection<");
            }
            sb.append(ejbRelationshipRoleInfo.getRelatedEntityInfo().getEntityClassInfo().getQualifiedClassName());
            if ("java.util.Collection".equals(ejbRelationshipRoleInfo.getFieldType())) {
                sb.append(">");
            }
            sb.append(" ");
            sb.append(ejbRelationshipRoleInfo.getFieldName());
            sb.append(";\r\n");
        }
    }

    private void appendGettersAndSetters(List<FieldInfo> fields, List<RelatedEntityInfo> relatedEntities, List<EjbRelationshipRoleInfo> ejbRelationshipRoles, StringBuilder sb) {
        for (FieldInfo fieldInfo : fields) {
            if (fieldInfo.getRelatedEntityInfo() != null || fieldInfo.getFieldName().equals(OPT_COUNTER)) continue;
            sb.append("\r\n\tpublic void ");
            sb.append(fieldInfo.getTargetSetterName());
            sb.append("(");
            sb.append(fieldInfo.getTypeName());
            sb.append(" ");
            sb.append(fieldInfo.getTargetFieldName());
            sb.append(") {\r\n\t\tthis.");
            sb.append(fieldInfo.getTargetFieldName());
            sb.append(" = ");
            sb.append(fieldInfo.getTargetFieldName());
            sb.append(";\r\n\t}\r\n\r\n\t");
            ColumnInfo columnInfo = fieldInfo.getColumnInfo();
            if (columnInfo != null) {
                if (CLOB.equals(columnInfo.getTypeName()) || BLOB.equals(columnInfo.getTypeName())) {
                    sb.append("@Lob\r\n\t");
                }
                sb.append("@Column(name = \"");
                sb.append(columnInfo.getColumnName());
                sb.append("\"");
                if (!columnInfo.getNullable()) {
                    sb.append(", nullable = false");
                }
                if (columnInfo.getLength() != null) {
                    sb.append(", length = ");
                    sb.append(columnInfo.getLength().toString());
                }
                sb.append(")\r\n\t");
                if (!columnInfo.getNullable()) {
                    sb.append("@Basic(optional = false)\r\n\t");
                }
            }
            if (fieldInfo.getIsKeyField()) {
                sb.append("@Id\r\n\t");
            }
            sb.append("public ");
            sb.append(fieldInfo.getTypeName());
            sb.append(" ");
            sb.append(fieldInfo.getTargetGetterName());
            sb.append("() {\r\n\t\treturn ");
            sb.append(fieldInfo.getTargetFieldName());
            sb.append(";\r\n\t}\r\n");
        }
        for (RelatedEntityInfo relatedEntityInfo : relatedEntities) {
            if (relatedEntityInfo.getEjbRelationshipRoleInfo() != null) continue;
            sb.append("\r\n\tpublic void ");
            sb.append(relatedEntityInfo.getSetterName());
            sb.append("(");
            sb.append(relatedEntityInfo.getParentEntityInfo().getEntityClassInfo().getQualifiedClassName());
            sb.append(" ");
            sb.append(relatedEntityInfo.getFieldName());
            sb.append(") {\r\n\t\tthis.");
            sb.append(relatedEntityInfo.getFieldName());
            sb.append(" = ");
            sb.append(relatedEntityInfo.getFieldName());
            sb.append(";\r\n\t}\r\n\r\n\t@OneToOne");
            if (!relatedEntityInfo.getOptional()) {
                sb.append("(optional = false)");
            }
            sb.append("\r\n\t");
            List<FieldInfo> memberFields = relatedEntityInfo.getMemberFields();
            if (memberFields.size() == 1) {
                ColumnInfo columnInfo = memberFields.get(0).getColumnInfo();
                ColumnInfo referencedColumn = columnInfo.getReferencedColumn();
                sb.append("@JoinColumn(name = \"");
                sb.append(columnInfo.getColumnName());
                sb.append("\"");
                if (!columnInfo.getNullable()) {
                    sb.append(", nullable = false");
                }
                sb.append(", referencedColumnName = \"");
                sb.append(referencedColumn.getColumnName());
                sb.append("\")\r\n\t");
            } else if (memberFields.size() > 1) {
                sb.append("@JoinColumns({\r\n\t\t");
                boolean firstColumn = true;
                for (FieldInfo fieldInfo : memberFields) {
                    ColumnInfo columnInfo = fieldInfo.getColumnInfo();
                    ColumnInfo referencedColumn = columnInfo.getReferencedColumn();
                    if (firstColumn) {
                        firstColumn = false;
                    } else {
                        sb.append(",\r\n\t\t");
                    }
                    sb.append("@JoinColumn(name = \"");
                    sb.append(columnInfo.getColumnName());
                    sb.append("\"");
                    if (!columnInfo.getNullable()) {
                        sb.append(", nullable = false");
                    }
                    sb.append(", referencedColumnName = \"");
                    sb.append(referencedColumn.getColumnName());
                    sb.append("\")");
                }
                sb.append("\r\n\t})\r\n\t");
            }
            if (relatedEntityInfo.getIsKeyField()) {
                sb.append("@Id\r\n\t");
            }
            sb.append("public ");
            sb.append(relatedEntityInfo.getParentEntityInfo().getEntityClassInfo().getQualifiedClassName());
            sb.append(" ");
            sb.append(relatedEntityInfo.getGetterName());
            sb.append("() {\r\n\t\treturn ");
            sb.append(relatedEntityInfo.getFieldName());
            sb.append(";\r\n\t}\r\n");
        }
        for (EjbRelationshipRoleInfo ejbRelationshipRoleInfo : ejbRelationshipRoles) {
            sb.append("\r\n\tpublic void ");
            sb.append(ejbRelationshipRoleInfo.getSetterName());
            sb.append("(");
            if ("java.util.Collection".equals(ejbRelationshipRoleInfo.getFieldType())) {
                sb.append("java.util.Collection<");
            }
            sb.append(ejbRelationshipRoleInfo.getRelatedEntityInfo().getEntityClassInfo().getQualifiedClassName());
            if ("java.util.Collection".equals(ejbRelationshipRoleInfo.getFieldType())) {
                sb.append(">");
            }
            sb.append(" ");
            sb.append(ejbRelationshipRoleInfo.getFieldName());
            sb.append(") {\r\n\t\tthis.");
            sb.append(ejbRelationshipRoleInfo.getFieldName());
            sb.append(" = ");
            sb.append(ejbRelationshipRoleInfo.getFieldName());
            sb.append(";\r\n\t}\r\n\r\n\t@");
            sb.append(ejbRelationshipRoleInfo.getMultiplicity());
            sb.append("To");
            sb.append(ejbRelationshipRoleInfo.getRelatedMultiplicity());
            ForeignKeyInfo foreignKeyInfo = ejbRelationshipRoleInfo.getEjbRelationInfo().getConstraintInfo().getForeignKeyInfo();
            TableInfo tableInfo = ejbRelationshipRoleInfo.getEntityInfo().getTableInfo();
            if (foreignKeyInfo.getTableInfo() == tableInfo) {
                ColumnInfo columnInfo = foreignKeyInfo.getMemberColumns().get(0);
                if (!columnInfo.getNullable()) {
                    sb.append("(optional = false)");
                }
                sb.append("\r\n\t");
                ColumnInfo referencedColumn = columnInfo.getReferencedColumn();
                sb.append("@JoinColumn(name = \"");
                sb.append(columnInfo.getColumnName());
                sb.append("\"");
                if (!columnInfo.getNullable()) {
                    sb.append(", nullable = false");
                }
                sb.append(", referencedColumnName = \"");
                sb.append(referencedColumn.getColumnName());
                sb.append("\")\r\n\t");
                if (ejbRelationshipRoleInfo.getIsKeyField()) {
                    sb.append("@Id\r\n\t");
                }
            } else {
                sb.append("(mappedBy = \"");
                sb.append(ejbRelationshipRoleInfo.getRelatedFieldName());
                sb.append("\"");
                if (ejbRelationshipRoleInfo.getCascadeDelete()) {
                    sb.append(", cascade = REMOVE");
                }
                sb.append(")\r\n\t");
            }
            sb.append("public ");
            if ("java.util.Collection".equals(ejbRelationshipRoleInfo.getFieldType())) {
                sb.append("java.util.Collection<");
            }
            sb.append(ejbRelationshipRoleInfo.getRelatedEntityInfo().getEntityClassInfo().getQualifiedClassName());
            if ("java.util.Collection".equals(ejbRelationshipRoleInfo.getFieldType())) {
                sb.append(">");
            }
            sb.append(" ");
            sb.append(ejbRelationshipRoleInfo.getGetterName());
            sb.append("() {\r\n\t\treturn ");
            sb.append(ejbRelationshipRoleInfo.getFieldName());
            sb.append(";\r\n\t}\r\n");
        }
    }

    private void appendGetAccessHelper(StringBuilder sb) {
        if (this.iEntityAccessHelperClassInfo != null) {
            sb.append("\r\n\t@Transient\r\n\tprotected com.ibm.commerce.security.AccessHelper getAccessHelper() {\r\n\t\tif (accessHelper == null) {\r\n\t\t\taccessHelper = new ");
            sb.append(this.iEntityAccessHelperClassInfo.getQualifiedClassName());
            sb.append("();\r\n\t\t}\r\n\t\treturn accessHelper;\r\n\t}\r\n");
        }
    }

    private void appendGeneratedFields(StringBuilder sb, EntityInfo entityInfo, List<FieldGenerator> fieldGenerators) {
        if (fieldGenerators != null) {
            for (FieldGenerator fieldGenerator : fieldGenerators) {
                fieldGenerator.appendField(sb, entityInfo);
            }
        }
    }

    private void appendGeneratedMethods(StringBuilder sb, EntityInfo entityInfo, List<MethodGenerator> methodGenerators) {
        if (methodGenerators != null) {
            for (MethodGenerator methodGenerator : methodGenerators) {
                methodGenerator.appendMethod(sb, entityInfo);
            }
        }
    }

    private void appendNamedNativeQueries(StringBuilder sb) {
        Set names;
        List<FinderInfo> finders = this.iEntityInfo.getQueryFinders();
        HashMap<String, String> nativeQueries = new HashMap<String, String>();
        HashMap<String, String> queries = new HashMap<String, String>();
        for (FinderInfo finderInfo : finders) {
            if (finderInfo.getFinderSelectStatement() != null) {
                nativeQueries.put(finderInfo.getQueryName(), finderInfo.getFinderSelectStatement());
                continue;
            }
            if (finderInfo.getFinderQuery() != null) {
                queries.put(finderInfo.getQueryName(), this.resolveQuery(finderInfo.getFinderQuery()));
                continue;
            }
            nativeQueries.put(finderInfo.getQueryName(), String.valueOf(this.iEntityInfo.getSelectClause()) + finderInfo.getFinderWhereClause());
            if (finderInfo.getOracleFinderWhereClause() == null) continue;
            nativeQueries.put(String.valueOf(finderInfo.getQueryName()) + "_ORACLE", String.valueOf(this.iEntityInfo.getSelectClause()) + finderInfo.getOracleFinderWhereClause());
        }
        if (nativeQueries.size() == 1) {
            names = nativeQueries.keySet();
            for (String name : names) {
                sb.append("\r\n@NamedNativeQuery(name = \"");
                sb.append(name);
                sb.append("\", query = \"");
                sb.append((String)nativeQueries.get(name));
                sb.append("\", resultClass=");
                sb.append(this.iEntityClassInfo.getQualifiedClassName());
                sb.append(".class)");
            }
        } else {
            names = nativeQueries.keySet();
            boolean firstQuery = true;
            for (Object name : names) {
                if (firstQuery) {
                    firstQuery = false;
                    sb.append("\r\n@NamedNativeQueries({");
                } else {
                    sb.append(",");
                }
                sb.append("\r\n\t@NamedNativeQuery(name = \"");
                sb.append((String)name);
                sb.append("\", query = \"");
                sb.append((String)nativeQueries.get(name));
                sb.append("\", resultClass=");
                sb.append(this.iEntityClassInfo.getQualifiedClassName());
                sb.append(".class)");
            }
            if (!firstQuery) {
                sb.append("\r\n})");
            }
        }
        if (queries.size() == 1) {
            names = queries.keySet();
            for (String name : names) {
                sb.append("\r\n@NamedQuery(name = \"");
                sb.append(name);
                sb.append("\", query = \"");
                sb.append((String)queries.get(name));
                sb.append("\")");
            }
        } else {
            names = queries.keySet();
            boolean firstQuery = true;
            for (Object name : names) {
                if (firstQuery) {
                    firstQuery = false;
                    sb.append("\r\n@NamedQueries({");
                } else {
                    sb.append(",");
                }
                sb.append("\r\n\t@NamedQuery(name = \"");
                sb.append((String)name);
                sb.append("\", query = \"");
                sb.append((String)queries.get(name));
                sb.append("\")");
            }
            if (!firstQuery) {
                sb.append("\r\n})");
            }
        }
    }

    private String resolveQuery(String sourceQuery) {
        String targetQuery = sourceQuery.replace(" from " + this.iEntityInfo.getEjbName() + "Bean", " from " + this.iEntityInfo.getEjbName());
        Collection<FieldInfo> fields = this.iEntityInfo.getFields();
        for (FieldInfo fieldInfo : fields) {
            if (fieldInfo.getRelatedEntityInfo() == null) continue;
            targetQuery = targetQuery.replaceAll("." + fieldInfo.getFieldName(), "." + fieldInfo.getRelatedEntityInfo().getFieldName() + "." + fieldInfo.getReferencedFieldInfo().getTargetFieldName());
        }
        targetQuery = targetQuery.replaceAll(" (.*?)Bean ", " $1 ");
        return targetQuery;
    }

    private boolean hasKeyFields(IType testClass) {
        boolean foundKeyField;
        block6: {
            foundKeyField = false;
            try {
                IMethod[] testMethods;
                IField[] testFields;
                IField[] iFieldArray = testFields = testClass.getFields();
                int n = testFields.length;
                int n2 = 0;
                while (n2 < n) {
                    IField testField = iFieldArray[n2];
                    FieldInfo fieldInfo = this.iEntityInfo.getFieldInfoByName(testField.getElementName());
                    if (fieldInfo != null && fieldInfo.getIsKeyField()) {
                        foundKeyField = true;
                        break;
                    }
                    ++n2;
                }
                if (foundKeyField) break block6;
                IMethod[] iMethodArray = testMethods = testClass.getMethods();
                int n3 = testMethods.length;
                n = 0;
                while (n < n3) {
                    IMethod testMethod = iMethodArray[n];
                    FieldInfo fieldInfo = this.iEntityInfo.getFieldInfoByGetterName(testMethod.getElementName());
                    if (fieldInfo != null && fieldInfo.getIsKeyField()) {
                        foundKeyField = true;
                        break;
                    }
                    ++n;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return foundKeyField;
    }

    private List<FieldDeclaration> getPortRequiredFieldDeclarations(TypeDeclaration ejbTypeDeclaration, List<FieldGenerator> fieldGenerators) {
        ArrayList<FieldDeclaration> fieldDeclarations = new ArrayList<FieldDeclaration>();
        List bodyDeclarations = ejbTypeDeclaration.bodyDeclarations();
        block0: for (BodyDeclaration bodyDeclaration : bodyDeclarations) {
            if (bodyDeclaration.getNodeType() != 23) continue;
            FieldDeclaration fieldDeclaration = (FieldDeclaration)bodyDeclaration;
            List ejbVariableDeclarationFragments = fieldDeclaration.fragments();
            for (VariableDeclarationFragment ejbVariableDeclarationFragment : ejbVariableDeclarationFragments) {
                String fieldName = ejbVariableDeclarationFragment.getName().getIdentifier();
                boolean generatedField = false;
                if (fieldGenerators != null) {
                    for (FieldGenerator fieldGenerator : fieldGenerators) {
                        if (!fieldName.equals(fieldGenerator.getFieldName())) continue;
                        generatedField = true;
                        break;
                    }
                }
                if (generatedField || !this.iEntityInfo.isRequiredField(fieldName)) continue;
                fieldDeclarations.add(fieldDeclaration);
                continue block0;
            }
        }
        return fieldDeclarations;
    }

    private List<MethodDeclaration> getPortRequiredMethodDeclarations(TypeDeclaration ejbTypeDeclaration, List<MethodGenerator> methodGenerators) {
        ArrayList<MethodDeclaration> methodDeclarations = new ArrayList<MethodDeclaration>();
        List bodyDeclarations = ejbTypeDeclaration.bodyDeclarations();
        for (BodyDeclaration bodyDeclaration : bodyDeclarations) {
            UserMethodInfo userMethodInfo;
            if (bodyDeclaration.getNodeType() != 31) continue;
            MethodDeclaration methodDeclaration = (MethodDeclaration)bodyDeclaration;
            String methodKey = JavaUtil.getMethodKey(methodDeclaration);
            boolean generatedMethod = false;
            if (methodGenerators != null) {
                for (MethodGenerator methodGenerator : methodGenerators) {
                    if (!methodKey.equals(methodGenerator.getMethodKey())) continue;
                    generatedMethod = true;
                    break;
                }
            }
            if (generatedMethod || ((userMethodInfo = this.iEntityInfo.getUserMethodInfo(methodKey)) == null || userMethodInfo.getRelatedEntityInfo() != null || userMethodInfo.getFieldInfo() != null || userMethodInfo.getEjbRelationshipRoleInfo() != null) && !this.iEntityInfo.isRequiredMethod(methodKey)) continue;
            methodDeclarations.add(methodDeclaration);
        }
        return methodDeclarations;
    }

    private void portFieldDeclarations(TypeDeclaration entityTypeDeclaration, List<FieldDeclaration> fieldDeclarations) {
        List bodyDeclarations = entityTypeDeclaration.bodyDeclarations();
        int index = 0;
        for (BodyDeclaration bodyDeclaration : bodyDeclarations) {
            if (bodyDeclaration.getNodeType() == 31) break;
            ++index;
        }
        AST ast = entityTypeDeclaration.getAST();
        for (FieldDeclaration fieldDeclaration : fieldDeclarations) {
            fieldDeclaration.accept((ASTVisitor)new EntityPortVisitor());
            FieldDeclaration entityFieldDeclaration = (FieldDeclaration)ASTNode.copySubtree((AST)ast, (ASTNode)fieldDeclaration);
            JavaUtil.setFieldProtected(entityFieldDeclaration);
            bodyDeclarations.add(index, entityFieldDeclaration);
            ++index;
        }
    }

    private void portMethodDeclarations(TypeDeclaration entityTypeDeclaration, List<MethodDeclaration> methodDeclarations) {
        List bodyDeclarations = entityTypeDeclaration.bodyDeclarations();
        int index = bodyDeclarations.size();
        AST ast = entityTypeDeclaration.getAST();
        for (MethodDeclaration methodDeclaration : methodDeclarations) {
            String methodName = methodDeclaration.getName().getIdentifier();
            String methodKey = JavaUtil.getMethodKey(methodDeclaration);
            TargetExceptionInfo targetExceptionInfo = TargetExceptionUtil.getEjbMethodUnhandledTargetExceptions(this.iEntityInfo, methodKey);
            methodDeclaration.accept((ASTVisitor)new EntityPortVisitor());
            MethodDeclaration entityMethodDeclaration = (MethodDeclaration)ASTNode.copySubtree((AST)entityTypeDeclaration.getAST(), (ASTNode)methodDeclaration);
            List thrownExceptions = entityMethodDeclaration.thrownExceptions();
            thrownExceptions.clear();
            Collection<String> unhandledExceptions = TargetExceptionUtil.getFilteredExceptions(this.iModuleInfo.getJavaProject(), targetExceptionInfo.getTargetExceptions());
            for (String unhandledException : unhandledExceptions) {
                thrownExceptions.add(entityMethodDeclaration.getAST().newName(unhandledException));
            }
            List modifiers = entityMethodDeclaration.modifiers();
            if ((methodName.startsWith("get") || methodName.startsWith("is")) && entityMethodDeclaration.getReturnType2() != null && entityMethodDeclaration.parameters().size() == 0) {
                MarkerAnnotation idAnnotation = ast.newMarkerAnnotation();
                idAnnotation.setTypeName((Name)ast.newSimpleName("Transient"));
                modifiers.add(0, idAnnotation);
            }
            bodyDeclarations.add(index, entityMethodDeclaration);
            ++index;
        }
    }

    private class EntityPortVisitor
    extends PortVisitor {
        public EntityPortVisitor() {
            super(EntityClassGenerator.this.iApplicationInfo, EntityClassGenerator.this.iModuleInfo.getJavaProject());
        }

        @Override
        public String getTypeMapping(String typeName) {
            EntityInfo entityInfo;
            String typeMapping = null;
            if (EntityClassGenerator.this.iApplicationInfo.isEntityInterfaceType(typeName) && (entityInfo = EntityClassGenerator.this.iApplicationInfo.getEntityInfoForType(typeName)).getRemote().equals(typeName)) {
                typeMapping = entityInfo.getEntityAccessBeanClassInfo().getQualifiedClassName();
            }
            return typeMapping != null ? typeMapping : super.getTypeMapping(typeName);
        }

        @Override
        public boolean visit(SimpleName simpleName) {
            if (!simpleName.isDeclaration()) {
                FieldInfo fieldInfo = EntityClassGenerator.this.iEntityInfo.getFieldInfoByName(simpleName.getIdentifier());
                if (fieldInfo != null) {
                    IVariableBinding variableBinding;
                    IBinding binding = simpleName.resolveBinding();
                    if (binding instanceof IVariableBinding && (variableBinding = (IVariableBinding)binding).getDeclaringClass() != null && EntityClassGenerator.this.iEntityInfo.isClassInEjbHierarchy(variableBinding.getDeclaringClass().getQualifiedName())) {
                        this.replaceFieldReference((ASTNode)simpleName, fieldInfo);
                    }
                } else {
                    super.visit(simpleName);
                }
            }
            return false;
        }

        @Override
        public boolean visit(FieldAccess fieldAccess) {
            boolean visitChildren = true;
            if (fieldAccess.getExpression().getNodeType() == 52) {
                FieldInfo fieldInfo = EntityClassGenerator.this.iEntityInfo.getFieldInfoByName(fieldAccess.getName().getIdentifier());
                if (fieldInfo != null) {
                    this.replaceFieldReference((ASTNode)fieldAccess, fieldInfo);
                    visitChildren = false;
                }
            } else {
                visitChildren = super.visit(fieldAccess);
            }
            return visitChildren;
        }

        public boolean visit(SuperFieldAccess superFieldAccess) {
            FieldInfo fieldInfo;
            boolean visitChildren = false;
            if (superFieldAccess.getQualifier() == null && (fieldInfo = EntityClassGenerator.this.iEntityInfo.getFieldInfoByName(superFieldAccess.getName().getIdentifier())) != null) {
                this.replaceFieldReference((ASTNode)superFieldAccess, fieldInfo);
                visitChildren = false;
            }
            return visitChildren;
        }

        @Override
        public boolean visit(MethodInvocation methodInvocation) {
            boolean visitChildren = true;
            IMethodBinding methodBinding = methodInvocation.resolveMethodBinding();
            if (methodInvocation.getExpression() == null || methodInvocation.getExpression().getNodeType() == 52) {
                if (methodBinding != null) {
                    String methodKey = JavaUtil.getMethodKey(methodBinding);
                    FieldInfo fieldInfo = EntityClassGenerator.this.iEntityInfo.getFieldInfoByGetterName(methodKey);
                    if (fieldInfo != null) {
                        this.replaceFieldReference((ASTNode)methodInvocation, fieldInfo);
                        visitChildren = false;
                    }
                }
            } else {
                visitChildren = super.visit(methodInvocation);
            }
            return visitChildren;
        }

        @Override
        public boolean visit(Assignment assignment) {
            boolean visitChildren = true;
            FieldInfo fieldInfo = null;
            Expression leftHandSide = assignment.getLeftHandSide();
            switch (leftHandSide.getNodeType()) {
                case 42: {
                    SimpleName simpleName = (SimpleName)leftHandSide;
                    IBinding binding = simpleName.resolveBinding();
                    if (!(binding instanceof IVariableBinding) || !((IVariableBinding)binding).isField()) break;
                    fieldInfo = EntityClassGenerator.this.iEntityInfo.getFieldInfoByName(simpleName.getIdentifier());
                    break;
                }
                case 22: {
                    FieldAccess fieldAccess = (FieldAccess)leftHandSide;
                    if (fieldAccess.getExpression().getNodeType() != 52) break;
                    fieldInfo = EntityClassGenerator.this.iEntityInfo.getFieldInfoByName(fieldAccess.getName().getIdentifier());
                    break;
                }
                case 47: {
                    SuperFieldAccess superFieldAccess = (SuperFieldAccess)leftHandSide;
                    fieldInfo = EntityClassGenerator.this.iEntityInfo.getFieldInfoByName(superFieldAccess.getName().getIdentifier());
                }
            }
            if (fieldInfo != null) {
                if (fieldInfo.getRelatedEntityInfo() == null) {
                    MethodInvocation setterMethodInvocation = assignment.getAST().newMethodInvocation();
                    setterMethodInvocation.setName(assignment.getAST().newSimpleName(fieldInfo.getTargetSetterName()));
                    List arguments = setterMethodInvocation.arguments();
                    Expression rightHandSideExpression = assignment.getRightHandSide();
                    rightHandSideExpression.accept((ASTVisitor)this);
                    arguments.add((Expression)ASTNode.copySubtree((AST)rightHandSideExpression.getAST(), (ASTNode)rightHandSideExpression));
                    this.replaceASTNode((ASTNode)assignment, (ASTNode)setterMethodInvocation);
                    visitChildren = false;
                    assignment.getRightHandSide().accept((ASTVisitor)this);
                } else {
                    LOGGER.info("user method calls related entity field setter");
                }
            } else {
                visitChildren = super.visit(assignment);
            }
            return visitChildren;
        }

        @Override
        public boolean visit(ExpressionStatement expressionStatement) {
            Assignment assignment;
            FieldInfo fieldInfo;
            boolean visitChildren = true;
            Expression statementExpression = expressionStatement.getExpression();
            if (statementExpression.getNodeType() == 7 && (fieldInfo = this.getAssignedField(assignment = (Assignment)statementExpression)) != null && fieldInfo.getRelatedEntityInfo() != null && fieldInfo.getRelatedEntityInfo().getParentEntityInfo().getKeyFields().size() == 1) {
                AccessBeanInfo.NullConstructorParameter nullConstructorParameter;
                AST ast = expressionStatement.getAST();
                RelatedEntityInfo relatedEntityInfo = fieldInfo.getRelatedEntityInfo();
                assignment.getRightHandSide().accept((ASTVisitor)this);
                Expression primaryKeyExpression = (Expression)ASTNode.copySubtree((AST)ast, (ASTNode)assignment.getRightHandSide());
                if (primaryKeyExpression.getNodeType() == 16) {
                    ConditionalExpression conditionalExpression = (ConditionalExpression)primaryKeyExpression;
                    if (conditionalExpression.getThenExpression().getNodeType() == 33) {
                        primaryKeyExpression = conditionalExpression.getElseExpression();
                    } else if (conditionalExpression.getElseExpression().getNodeType() == 33) {
                        primaryKeyExpression = conditionalExpression.getThenExpression();
                    }
                }
                InfixExpression infixExpression = ast.newInfixExpression();
                infixExpression.setOperator(InfixExpression.Operator.NOT_EQUALS);
                infixExpression.setLeftOperand((Expression)ASTNode.copySubtree((AST)ast, (ASTNode)primaryKeyExpression));
                infixExpression.setRightOperand((Expression)ast.newNullLiteral());
                IfStatement ifStatement = ast.newIfStatement();
                ifStatement.setExpression((Expression)infixExpression);
                VariableDeclarationFragment variableDeclarationFragment = ast.newVariableDeclarationFragment();
                String accessBeanVariableName = String.valueOf(relatedEntityInfo.getFieldName()) + "AccessBean";
                variableDeclarationFragment.setName(ast.newSimpleName(accessBeanVariableName));
                ClassInstanceCreation classInstanceCreation = ast.newClassInstanceCreation();
                classInstanceCreation.setType((Type)ast.newSimpleType(ast.newName(relatedEntityInfo.getParentEntityInfo().getEntityAccessBeanClassInfo().getQualifiedClassName())));
                variableDeclarationFragment.setInitializer((Expression)classInstanceCreation);
                VariableDeclarationStatement variableDeclarationStatement = ast.newVariableDeclarationStatement(variableDeclarationFragment);
                variableDeclarationStatement.setType((Type)ast.newSimpleType(ast.newName(relatedEntityInfo.getParentEntityInfo().getEntityAccessBeanClassInfo().getQualifiedClassName())));
                Block block = ast.newBlock();
                List newStatementList = block.statements();
                newStatementList.add(variableDeclarationStatement);
                if (!EntityClassGenerator.STRING.equals(fieldInfo.getTypeName()) && (nullConstructorParameter = relatedEntityInfo.getParentEntityInfo().getAccessBeanInfo().getNullConstructorParameterByName(fieldInfo.getFieldName())) != null && nullConstructorParameter.getConverterClassName() != null) {
                    primaryKeyExpression = PrimaryKeyUtil.convertExpressionToString((Expression)ASTNode.copySubtree((AST)ast, (ASTNode)primaryKeyExpression));
                }
                FieldInfo keyField = relatedEntityInfo.getParentEntityInfo().getKeyFields().get(0);
                MethodInvocation setInitKeyMethodInvocation = ast.newMethodInvocation();
                setInitKeyMethodInvocation.setName(ast.newSimpleName(EntityClassGenerator.SET_INIT_KEY + keyField.getTargetFieldName()));
                setInitKeyMethodInvocation.setExpression((Expression)ast.newSimpleName(accessBeanVariableName));
                List setInitKeyMethodInvocationArguments = setInitKeyMethodInvocation.arguments();
                setInitKeyMethodInvocationArguments.add(primaryKeyExpression);
                ExpressionStatement initKeyExpressionStatement = ast.newExpressionStatement((Expression)setInitKeyMethodInvocation);
                newStatementList.add(initKeyExpressionStatement);
                MethodInvocation instantiateEntityMethodInvocation = ast.newMethodInvocation();
                instantiateEntityMethodInvocation.setName(ast.newSimpleName(EntityClassGenerator.INSTANTIATE_ENTITY));
                instantiateEntityMethodInvocation.setExpression((Expression)ast.newSimpleName(accessBeanVariableName));
                ExpressionStatement instantiateEntityExpressionStatement = ast.newExpressionStatement((Expression)instantiateEntityMethodInvocation);
                newStatementList.add(instantiateEntityExpressionStatement);
                MethodInvocation getEntityMethodInvocation = ast.newMethodInvocation();
                getEntityMethodInvocation.setName(ast.newSimpleName("getEntity"));
                getEntityMethodInvocation.setExpression((Expression)ast.newSimpleName(accessBeanVariableName));
                MethodInvocation setRelatedEntityMethodInvocation = ast.newMethodInvocation();
                setRelatedEntityMethodInvocation.setName(ast.newSimpleName(relatedEntityInfo.getSetterName()));
                List arguments = setRelatedEntityMethodInvocation.arguments();
                arguments.add(getEntityMethodInvocation);
                newStatementList.add(ast.newExpressionStatement((Expression)setRelatedEntityMethodInvocation));
                ifStatement.setThenStatement((Statement)block);
                setRelatedEntityMethodInvocation = ast.newMethodInvocation();
                setRelatedEntityMethodInvocation.setName(ast.newSimpleName(relatedEntityInfo.getSetterName()));
                List nullArguments = setRelatedEntityMethodInvocation.arguments();
                nullArguments.add(ast.newNullLiteral());
                block = ast.newBlock();
                List elseStatements = block.statements();
                elseStatements.add(ast.newExpressionStatement((Expression)setRelatedEntityMethodInvocation));
                ifStatement.setElseStatement((Statement)block);
                this.replaceASTNode((ASTNode)expressionStatement, (ASTNode)ifStatement);
                visitChildren = false;
            }
            if (visitChildren) {
                visitChildren = super.visit(expressionStatement);
            }
            return visitChildren;
        }

        private FieldInfo getAssignedField(Assignment assignment) {
            FieldInfo fieldInfo = null;
            Expression leftHandSide = assignment.getLeftHandSide();
            switch (leftHandSide.getNodeType()) {
                case 42: {
                    SimpleName simpleName = (SimpleName)leftHandSide;
                    IBinding binding = simpleName.resolveBinding();
                    if (!(binding instanceof IVariableBinding) || !((IVariableBinding)binding).isField()) break;
                    fieldInfo = EntityClassGenerator.this.iEntityInfo.getFieldInfoByName(simpleName.getIdentifier());
                    break;
                }
                case 22: {
                    FieldAccess fieldAccess = (FieldAccess)leftHandSide;
                    if (fieldAccess.getExpression().getNodeType() != 52) break;
                    fieldInfo = EntityClassGenerator.this.iEntityInfo.getFieldInfoByName(fieldAccess.getName().getIdentifier());
                    break;
                }
                case 47: {
                    SuperFieldAccess superFieldAccess = (SuperFieldAccess)leftHandSide;
                    fieldInfo = EntityClassGenerator.this.iEntityInfo.getFieldInfoByName(superFieldAccess.getName().getIdentifier());
                }
            }
            return fieldInfo;
        }

        private void replaceFieldReference(ASTNode fieldReference, FieldInfo fieldInfo) {
            AST ast = fieldReference.getAST();
            if (fieldInfo.getRelatedEntityInfo() == null) {
                MethodInvocation getterMethodInvocation = ast.newMethodInvocation();
                getterMethodInvocation.setName(ast.newSimpleName(fieldInfo.getTargetGetterName()));
                if (fieldInfo.getColumnInfo() != null && EntityClassGenerator.CHAR.equals(fieldInfo.getColumnInfo().getTypeName()) && fieldInfo.getColumnInfo().getLength() != null && fieldInfo.getColumnInfo().getLength() > 1) {
                    MethodInvocation trimMethodInvocation = ast.newMethodInvocation();
                    trimMethodInvocation.setName(ast.newSimpleName(EntityClassGenerator.TRIM));
                    trimMethodInvocation.setExpression((Expression)getterMethodInvocation);
                    if (fieldInfo.getColumnInfo().getNullable()) {
                        InfixExpression infixExpression = ast.newInfixExpression();
                        infixExpression.setLeftOperand((Expression)ASTNode.copySubtree((AST)ast, (ASTNode)getterMethodInvocation));
                        infixExpression.setOperator(InfixExpression.Operator.EQUALS);
                        infixExpression.setRightOperand((Expression)ast.newNullLiteral());
                        ConditionalExpression conditionalExpression = ast.newConditionalExpression();
                        conditionalExpression.setExpression((Expression)infixExpression);
                        conditionalExpression.setThenExpression((Expression)ast.newNullLiteral());
                        conditionalExpression.setElseExpression((Expression)trimMethodInvocation);
                        this.replaceASTNode(fieldReference, (ASTNode)conditionalExpression);
                    } else {
                        this.replaceASTNode(fieldReference, (ASTNode)trimMethodInvocation);
                    }
                } else {
                    this.replaceASTNode(fieldReference, (ASTNode)getterMethodInvocation);
                }
            } else {
                RelatedEntityInfo relatedEntityInfo = fieldInfo.getRelatedEntityInfo();
                String relatedEntityGetterName = relatedEntityInfo.getGetterName();
                if (relatedEntityGetterName == null) {
                    relatedEntityGetterName = "get" + Character.toUpperCase(relatedEntityInfo.getFieldName().charAt(0)) + relatedEntityInfo.getFieldName().substring(1);
                }
                String referencedFieldGetterName = fieldInfo.getReferencedFieldInfo().getRelatedEntityInfo() == null ? fieldInfo.getReferencedFieldInfo().getTargetGetterName() : fieldInfo.getReferencedFieldInfo().getRelatedEntityInfo().getGetterName();
                ConditionalExpression conditionalExpression = ast.newConditionalExpression();
                MethodInvocation getterMethodInvocation = ast.newMethodInvocation();
                getterMethodInvocation.setName(ast.newSimpleName(relatedEntityGetterName));
                InfixExpression infixExpression = ast.newInfixExpression();
                infixExpression.setLeftOperand((Expression)getterMethodInvocation);
                infixExpression.setOperator(InfixExpression.Operator.EQUALS);
                infixExpression.setRightOperand((Expression)ast.newNullLiteral());
                conditionalExpression.setExpression((Expression)infixExpression);
                conditionalExpression.setThenExpression((Expression)ast.newNullLiteral());
                getterMethodInvocation = (MethodInvocation)ASTNode.copySubtree((AST)ast, (ASTNode)getterMethodInvocation);
                MethodInvocation fieldMethodInvocation = ast.newMethodInvocation();
                fieldMethodInvocation.setExpression((Expression)getterMethodInvocation);
                fieldMethodInvocation.setName(ast.newSimpleName(referencedFieldGetterName));
                if (fieldInfo.getReferencedFieldInfo().getRelatedEntityInfo() == null) {
                    ColumnInfo referencedColumnInfo = fieldInfo.getReferencedFieldInfo().getColumnInfo();
                    if (referencedColumnInfo != null && EntityClassGenerator.CHAR.equals(referencedColumnInfo.getTypeName()) && referencedColumnInfo.getLength() != null && referencedColumnInfo.getLength() > 1) {
                        MethodInvocation trimMethodInvocation = ast.newMethodInvocation();
                        trimMethodInvocation.setName(ast.newSimpleName(EntityClassGenerator.TRIM));
                        trimMethodInvocation.setExpression((Expression)fieldMethodInvocation);
                        conditionalExpression.setElseExpression((Expression)trimMethodInvocation);
                    } else {
                        conditionalExpression.setElseExpression((Expression)fieldMethodInvocation);
                    }
                } else {
                    MethodInvocation relatedFieldMethodInvocation = ast.newMethodInvocation();
                    relatedFieldMethodInvocation.setExpression((Expression)fieldMethodInvocation);
                    relatedFieldMethodInvocation.setName(ast.newSimpleName(fieldInfo.getReferencedFieldInfo().getReferencedFieldInfo().getTargetGetterName()));
                    conditionalExpression.setElseExpression((Expression)relatedFieldMethodInvocation);
                }
                ParenthesizedExpression parenthesizedExpression = ast.newParenthesizedExpression();
                parenthesizedExpression.setExpression((Expression)conditionalExpression);
                this.replaceASTNode(fieldReference, (ASTNode)parenthesizedExpression);
            }
        }

        @Override
        public boolean visit(CastExpression castExpression) {
            boolean visitChildren = true;
            visitChildren = AccessBeanUtil.isGetEntityCastExpression(EntityClassGenerator.this.iApplicationInfo, castExpression) ? AccessBeanUtil.portGetEntityCastExpression(EntityClassGenerator.this.iApplicationInfo, castExpression, this) : super.visit(castExpression);
            return visitChildren;
        }
    }
}

