/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.port.generators;

import com.ibm.commerce.jpa.port.generators.PortVisitor;
import com.ibm.commerce.jpa.port.info.ApplicationInfo;
import com.ibm.commerce.jpa.port.info.ClassInfo;
import com.ibm.commerce.jpa.port.info.EntityInfo;
import com.ibm.commerce.jpa.port.info.ModuleInfo;
import com.ibm.commerce.jpa.port.util.BackupUtil;
import com.ibm.commerce.jpa.port.util.ImportUtil;
import com.ibm.commerce.jpa.port.util.JavaUtil;
import com.ibm.commerce.jpa.port.util.TargetExceptionUtil;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;

public class EntityAccessHelperClassGenerator {
    private static final String COPYRIGHT_FIELD = "COPYRIGHT";
    private ASTParser iASTParser;
    private BackupUtil iBackupUtil;
    private EntityInfo iEntityInfo;
    private ModuleInfo iModuleInfo;
    private ApplicationInfo iApplicationInfo;
    private ClassInfo iEntityAccessHelperClassInfo;
    private TypeDeclaration iEntityAccessHelperTypeDeclaration;

    public EntityAccessHelperClassGenerator(ASTParser astParser, BackupUtil backupUtil, EntityInfo entityInfo) {
        this.iASTParser = astParser;
        this.iBackupUtil = backupUtil;
        this.iEntityInfo = entityInfo;
        this.iModuleInfo = entityInfo.getModuleInfo();
        this.iApplicationInfo = entityInfo.getModuleInfo().getApplicationInfo();
        this.iEntityAccessHelperClassInfo = entityInfo.getEntityAccessHelperClassInfo();
    }

    public void generate(IProgressMonitor progressMonitor) {
        try {
            progressMonitor.beginTask("generate entity access helper for " + this.iEntityInfo.getEjbName(), 1000);
            if (this.iEntityAccessHelperClassInfo != null) {
                try {
                    this.iASTParser.setSource(this.iEntityInfo.getEjbAccessHelperType().getCompilationUnit());
                    this.iASTParser.setResolveBindings(true);
                    CompilationUnit ejbAccessHelperCompilationUnit = (CompilationUnit)this.iASTParser.createAST((IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                    StringBuilder sb = new StringBuilder();
                    sb.append("package ");
                    sb.append(this.iEntityAccessHelperClassInfo.getPackageFragment().getElementName());
                    sb.append(";\r\n");
                    JavaUtil.appendCopyrightComment(sb);
                    List importDeclarations = ejbAccessHelperCompilationUnit.imports();
                    ImportUtil.appendImports(importDeclarations, sb);
                    sb.append("\r\npublic class ");
                    sb.append(this.iEntityAccessHelperClassInfo.getClassName());
                    sb.append(" extends ");
                    if (this.iEntityInfo.getSupertype() != null && this.iEntityInfo.getSupertype().getEntityAccessHelperClassInfo() != null) {
                        sb.append(this.iEntityInfo.getSupertype().getEntityAccessHelperClassInfo().getQualifiedClassName());
                    } else {
                        sb.append("com.ibm.commerce.security.AccessHelper");
                    }
                    sb.append(" {\r\n");
                    JavaUtil.appendCopyrightField(sb);
                    sb.append("\r\n\tpublic ");
                    sb.append(this.iEntityAccessHelperClassInfo.getClassName());
                    sb.append("(){\r\n\t}\r\n}");
                    String source = sb.toString();
                    Document document = new Document(source);
                    this.iASTParser.setProject(this.iModuleInfo.getJavaProject());
                    this.iASTParser.setResolveBindings(false);
                    this.iASTParser.setSource(document.get().toCharArray());
                    CompilationUnit entityAccessHelperCompilationUnit = (CompilationUnit)this.iASTParser.createAST((IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                    this.iEntityAccessHelperTypeDeclaration = (TypeDeclaration)entityAccessHelperCompilationUnit.types().get(0);
                    entityAccessHelperCompilationUnit.recordModifications();
                    this.portAccessHelperTypeDeclaration((TypeDeclaration)ejbAccessHelperCompilationUnit.types().get(0));
                    TextEdit edits = entityAccessHelperCompilationUnit.rewrite((IDocument)document, null);
                    edits.apply((IDocument)document);
                    source = document.get();
                    ICompilationUnit compilationUnit = this.iEntityAccessHelperClassInfo.getPackageFragment().createCompilationUnit(String.valueOf(this.iEntityAccessHelperClassInfo.getClassName()) + ".java", source, true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                    this.iBackupUtil.addGeneratedFile((IFile)compilationUnit.getResource(), (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                    this.iApplicationInfo.incrementGeneratedAssetCount();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
            progressMonitor.worked(500);
        }
        finally {
            progressMonitor.done();
        }
    }

    private void portAccessHelperTypeDeclaration(TypeDeclaration ejbAccessHelperTypeDeclaration) {
        List ejbBodyDeclarations = ejbAccessHelperTypeDeclaration.bodyDeclarations();
        for (BodyDeclaration ejbBodyDeclaration : ejbBodyDeclarations) {
            switch (ejbBodyDeclaration.getNodeType()) {
                case 23: {
                    this.portFieldDeclaration((FieldDeclaration)ejbBodyDeclaration);
                    break;
                }
                case 31: {
                    this.portMethodDeclaration((MethodDeclaration)ejbBodyDeclaration);
                }
            }
        }
    }

    private void portFieldDeclaration(FieldDeclaration fieldDeclaration) {
        List variableDeclarationFragments = fieldDeclaration.fragments();
        for (VariableDeclarationFragment variableDeclarationFragment : variableDeclarationFragments) {
            String fieldName = variableDeclarationFragment.getName().getIdentifier();
            if (fieldName.equals(COPYRIGHT_FIELD)) continue;
            fieldDeclaration.accept((ASTVisitor)new PortAccessHelperVisitor());
            FieldDeclaration entityFieldDeclaration = (FieldDeclaration)ASTNode.copySubtree((AST)this.iEntityAccessHelperTypeDeclaration.getAST(), (ASTNode)fieldDeclaration);
            int index = 0;
            List entityBodyDeclarations = this.iEntityAccessHelperTypeDeclaration.bodyDeclarations();
            for (BodyDeclaration bodyDeclaration : entityBodyDeclarations) {
                if (bodyDeclaration.getNodeType() == 31) break;
                ++index;
            }
            entityBodyDeclarations.add(index, entityFieldDeclaration);
        }
    }

    private void portMethodDeclaration(MethodDeclaration methodDeclaration) {
        if (!methodDeclaration.isConstructor()) {
            TargetExceptionUtil.getUnhandledTargetExceptions(this.iApplicationInfo, this.iModuleInfo.getJavaProject(), (ASTNode)methodDeclaration.getBody());
            methodDeclaration.accept((ASTVisitor)new PortAccessHelperVisitor());
            MethodDeclaration entityMethodDeclaration = (MethodDeclaration)ASTNode.copySubtree((AST)this.iEntityAccessHelperTypeDeclaration.getAST(), (ASTNode)methodDeclaration);
            List entityBodyDeclarations = this.iEntityAccessHelperTypeDeclaration.bodyDeclarations();
            entityBodyDeclarations.add(entityMethodDeclaration);
        }
    }

    private class PortAccessHelperVisitor
    extends PortVisitor {
        public PortAccessHelperVisitor() {
            super(EntityAccessHelperClassGenerator.this.iApplicationInfo, EntityAccessHelperClassGenerator.this.iModuleInfo.getJavaProject());
        }
    }
}

