/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.port.generators;

import com.ibm.commerce.jpa.logger.LoggerHelper;
import com.ibm.commerce.jpa.port.info.AccessBeanSubclassInfo;
import com.ibm.commerce.jpa.port.info.ProjectInfo;
import com.ibm.commerce.jpa.port.info.TargetExceptionInfo;
import com.ibm.commerce.jpa.port.util.TargetExceptionUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class AccessBeanSubclassInfoXmlGenerator {
    private static final Logger LOGGER = LoggerHelper.getLogger(AccessBeanSubclassInfoXmlGenerator.class);
    private ProjectInfo iProjectInfo;
    private IProject iProject;

    public AccessBeanSubclassInfoXmlGenerator(ProjectInfo projectInfo) {
        this.iProjectInfo = projectInfo;
        this.iProject = projectInfo.getProject();
    }

    public void generate(IProgressMonitor progressMonitor) {
        LOGGER.info("generate project info for " + this.iProject.getName());
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n");
        sb.append("<ProjectInfo>\r\n");
        Collection<AccessBeanSubclassInfo> accessBeanSubclasses = this.iProjectInfo.getAccessBeanSubclasses();
        for (AccessBeanSubclassInfo accessBeanSubclassInfo : accessBeanSubclasses) {
            sb.append("\t<AccessBeanSubclassInfo name=\"");
            sb.append(accessBeanSubclassInfo.getName());
            if (accessBeanSubclassInfo.getSuperclass() != null) {
                sb.append("\" superclassName=\"");
                sb.append(accessBeanSubclassInfo.getSuperclass().getName());
            }
            sb.append("\">\r\n");
            Collection<String> methodKeys = accessBeanSubclassInfo.getMethodKeys();
            for (String methodKey : methodKeys) {
                sb.append("\t\t<MethodInfo>\r\n");
                sb.append("\t\t\t<MethodKey><![CDATA[");
                sb.append(methodKey);
                sb.append("]]></MethodKey>\r\n");
                TargetExceptionInfo targetExceptionInfo = TargetExceptionUtil.getAccessBeanSubclassMethodUnhandledTargetExceptions(accessBeanSubclassInfo, methodKey);
                if (targetExceptionInfo != null) {
                    Collection<String> unhandledSourceExceptions;
                    Collection<String> unhandledTargetExceptions = targetExceptionInfo.getTargetExceptions();
                    if (unhandledTargetExceptions != null) {
                        for (String exception : unhandledTargetExceptions) {
                            sb.append("\t\t\t<TargetException name=\"");
                            sb.append(exception);
                            sb.append("\"/>\r\n");
                        }
                    }
                    if ((unhandledSourceExceptions = targetExceptionInfo.getSourceExceptions()) != null) {
                        for (String exception : unhandledSourceExceptions) {
                            sb.append("\t\t\t<SourceException name=\"");
                            sb.append(exception);
                            sb.append("\"/>\r\n");
                        }
                    }
                }
                sb.append("\t\t</MethodInfo>\r\n");
            }
            sb.append("\t</AccessBeanSubclassInfo>\r\n");
        }
        sb.append("</ProjectInfo>");
        IFile projectInfoXmlFile = this.iProject.getFile(".jpaAccessBeanSubclassInfo.xml");
        ByteArrayInputStream inputStream = new ByteArrayInputStream(sb.toString().getBytes());
        try {
            if (projectInfoXmlFile.exists()) {
                projectInfoXmlFile.setContents((InputStream)inputStream, true, false, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
            } else {
                projectInfoXmlFile.create((InputStream)inputStream, true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.iProjectInfo.getApplicationInfo().incrementGeneratedAssetCount();
    }
}

