/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.port;

import com.ibm.commerce.jpa.port.info.ApplicationInfo;
import com.ibm.commerce.jpa.port.util.BackupUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;

public class Restore3Job
extends Job {
    private static final int PARALLEL_JOBS = 4;
    private IWorkspace iWorkspace;
    private ApplicationInfo iApplicationInfo = new ApplicationInfo();
    private Collection<IProject> iBuildPendingProjects = Collections.synchronizedCollection(new HashSet());
    private IProgressMonitor iProgressGroup;

    public Restore3Job() {
        super("Restore EJBs");
        this.iWorkspace = ResourcesPlugin.getWorkspace();
        this.iProgressGroup = Job.getJobManager().createProgressGroup();
        this.setProgressGroup(this.iProgressGroup, 6000);
    }

    public IStatus run(IProgressMonitor progressMonitor) {
        IStatus status = Status.OK_STATUS;
        try {
            try {
                this.iProgressGroup.beginTask("Restore EJBs", 6000);
                progressMonitor.beginTask("Restore EJBs", 6000);
                this.restoreProjects(progressMonitor);
                this.buildProjects(progressMonitor);
            }
            catch (InterruptedException e) {
                status = Status.CANCEL_STATUS;
                progressMonitor.done();
                this.iProgressGroup.done();
            }
        }
        finally {
            progressMonitor.done();
            this.iProgressGroup.done();
        }
        return status;
    }

    private void restoreProjects(IProgressMonitor progressMonitor) throws InterruptedException {
        IWorkspaceRoot root = this.iWorkspace.getRoot();
        IProject[] projects = root.getProjects();
        HashSet<IProject> projectSet = new HashSet<IProject>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            projectSet.add(project);
            ++n2;
        }
        HashSet<RestoreProjectJob> restoreProjectJobs = new HashSet<RestoreProjectJob>();
        int i = 0;
        while (i < 4) {
            RestoreProjectJob restoreProjectJob = new RestoreProjectJob(this.iApplicationInfo, this.iBuildPendingProjects, projectSet);
            restoreProjectJob.setProgressGroup(this.iProgressGroup, 250);
            restoreProjectJob.schedule();
            restoreProjectJobs.add(restoreProjectJob);
            ++i;
        }
        for (RestoreProjectJob restoreProjectJob : restoreProjectJobs) {
            restoreProjectJob.join();
            progressMonitor.worked(250);
        }
    }

    private void buildProjects(IProgressMonitor progressMonitor) throws InterruptedException {
        if (!progressMonitor.isCanceled() && this.iBuildPendingProjects.size() > 0) {
            try {
                this.iWorkspace.build(6, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 5000));
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    private static class RestoreProjectJob
    extends Job {
        private ApplicationInfo iApplicationInfo;
        private Collection<IProject> iBuildPendingProjects;
        private Set<IProject> iProjects;

        public RestoreProjectJob(ApplicationInfo applicationInfo, Collection<IProject> buildPendingProjects, Set<IProject> projects) {
            super("Restore projects");
            this.iApplicationInfo = applicationInfo;
            this.iBuildPendingProjects = buildPendingProjects;
            this.iProjects = projects;
        }

        public IStatus run(IProgressMonitor progressMonitor) {
            IStatus status = Status.OK_STATUS;
            try {
                progressMonitor.beginTask("Restore projects", -1);
                IProject project = this.getProject();
                while (project != null) {
                    boolean restored = false;
                    if (!progressMonitor.isCanceled()) {
                        BackupUtil backupUtil = this.iApplicationInfo.getBackupUtil(project);
                        try {
                            restored = backupUtil.restore3((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1000));
                            if (restored) {
                                this.iBuildPendingProjects.add(project);
                            }
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                            status = Status.CANCEL_STATUS;
                        }
                    } else {
                        status = Status.CANCEL_STATUS;
                    }
                    if (status != Status.CANCEL_STATUS && !progressMonitor.isCanceled()) {
                        project = this.getProject();
                        continue;
                    }
                    project = null;
                    status = Status.CANCEL_STATUS;
                }
            }
            finally {
                progressMonitor.done();
            }
            return status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private IProject getProject() {
            IProject project = null;
            Set<IProject> set = this.iProjects;
            synchronized (set) {
                Iterator<IProject> iterator = this.iProjects.iterator();
                if (iterator.hasNext()) {
                    IProject currentProject;
                    project = currentProject = iterator.next();
                }
                if (project != null) {
                    this.iProjects.remove(project);
                }
            }
            return project;
        }
    }
}

