/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.port;

import com.ibm.commerce.jpa.logger.LoggerHelper;
import com.ibm.commerce.jpa.port.Activator;
import com.ibm.commerce.jpa.port.generators.ModuleGenerator;
import com.ibm.commerce.jpa.port.generators.PersistenceXmlGenerator;
import com.ibm.commerce.jpa.port.info.ApplicationInfo;
import com.ibm.commerce.jpa.port.info.EntityInfo;
import com.ibm.commerce.jpa.port.info.ModuleInfo;
import com.ibm.commerce.jpa.port.info.PersistenceUnitInfo;
import com.ibm.commerce.jpa.port.parsers.ModuleParser;
import com.ibm.commerce.jpa.port.parsers.PortConfigurationParser;
import com.ibm.commerce.jpa.port.resolvers.ApplicationResolver;
import com.ibm.commerce.jpa.port.util.BackupUtil;
import com.ibm.commerce.jpa.port.util.JPASeederUtilBase;
import com.ibm.commerce.jpa.port.util.ResolveImportsUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.osgi.framework.Bundle;

public class JPAGenerateJob
extends Job {
    private static final Logger LOGGER = LoggerHelper.getLogger(JPAGenerateJob.class);
    private static final int PARALLEL_JOBS = 4;
    private IWorkspace iWorkspace;
    private ApplicationInfo iApplicationInfo = new ApplicationInfo();
    private IProgressMonitor iProgressGroup;
    private Collection<IProject> iBuildPendingProjects = Collections.synchronizedCollection(new HashSet());

    public JPAGenerateJob() {
        super("Generate JPA Entities and Access Beans");
        this.iWorkspace = ResourcesPlugin.getWorkspace();
        this.iProgressGroup = Job.getJobManager().createProgressGroup();
        this.setProgressGroup(this.iProgressGroup, 43700);
    }

    public IStatus run(IProgressMonitor progressMonitor) {
        IStatus status = Status.OK_STATUS;
        try {
            try {
                this.iProgressGroup.beginTask("JPA port jobs", 43700);
                progressMonitor.beginTask("JPA Port", 43700);
                this.initializeApplicationInfo();
                this.restoreProjects(progressMonitor);
                this.buildProjects(progressMonitor);
                this.parseEJBProjects(progressMonitor);
                this.resolveApplication(progressMonitor);
                this.portEJBProjects(progressMonitor);
                this.iApplicationInfo.printSummary();
                this.iApplicationInfo = null;
                this.buildProjects(progressMonitor);
                this.resolveImports(progressMonitor);
                this.buildProjects(progressMonitor);
            }
            catch (InterruptedException e) {
                status = Status.CANCEL_STATUS;
                progressMonitor.done();
                this.iProgressGroup.done();
            }
        }
        finally {
            progressMonitor.done();
            this.iProgressGroup.done();
        }
        return status;
    }

    private void initializeApplicationInfo() {
        this.iApplicationInfo = new ApplicationInfo();
    }

    private void restoreProjects(IProgressMonitor progressMonitor) throws InterruptedException {
        IWorkspaceRoot root = this.iWorkspace.getRoot();
        IProject[] projects = root.getProjects();
        HashSet<IProject> projectSet = new HashSet<IProject>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            projectSet.add(project);
            ++n2;
        }
        HashSet<RestoreProjectJob> restoreProjectJobs = new HashSet<RestoreProjectJob>();
        int i = 0;
        while (i < 4) {
            RestoreProjectJob restoreProjectJob = new RestoreProjectJob(this.iApplicationInfo, this.iBuildPendingProjects, projectSet);
            restoreProjectJob.setProgressGroup(this.iProgressGroup, 250);
            restoreProjectJob.schedule();
            restoreProjectJobs.add(restoreProjectJob);
            ++i;
        }
        for (RestoreProjectJob restoreProjectJob : restoreProjectJobs) {
            restoreProjectJob.join();
            progressMonitor.worked(250);
        }
    }

    private void seedNewClasses(IProgressMonitor progressMonitor, String sourceFolderName) throws InterruptedException {
        if (!progressMonitor.isCanceled()) {
            SeedNewClassesJob seedNewClassesJob = new SeedNewClassesJob(this.iApplicationInfo, this.iBuildPendingProjects, sourceFolderName);
            seedNewClassesJob.setProgressGroup(this.iProgressGroup, 100);
            seedNewClassesJob.schedule();
            seedNewClassesJob.join();
            progressMonitor.worked(100);
        }
    }

    private void parseEJBProjects(IProgressMonitor progressMonitor) throws InterruptedException {
        if (!progressMonitor.isCanceled()) {
            IWorkspaceRoot root = this.iWorkspace.getRoot();
            IProject[] projects = root.getProjects();
            HashSet<ModuleInfo> modules = new HashSet<ModuleInfo>();
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (this.isEJBProject(project)) {
                    IJavaProject javaProject = JavaCore.create((IProject)project);
                    ModuleInfo moduleInfo = new ModuleInfo(this.iApplicationInfo, javaProject);
                    this.iApplicationInfo.addModule(moduleInfo);
                    modules.add(moduleInfo);
                }
                ++n2;
            }
            HashSet<ParseModuleJob> parseModuleJobs = new HashSet<ParseModuleJob>();
            int i = 0;
            while (i < 4) {
                ParseModuleJob parseModuleJob = new ParseModuleJob(this.iWorkspace, modules);
                parseModuleJob.setProgressGroup(this.iProgressGroup, 1250);
                parseModuleJob.schedule();
                parseModuleJobs.add(parseModuleJob);
                ++i;
            }
            for (ParseModuleJob parseModuleJob : parseModuleJobs) {
                parseModuleJob.join();
                progressMonitor.worked(1250);
            }
            StringBuffer errors = new StringBuffer("");
            for (ModuleInfo moduleInfo : this.iApplicationInfo.getModules()) {
                for (EntityInfo entity : moduleInfo.getEntities()) {
                    if (entity.getErrors() != null) {
                        errors.append(String.valueOf(entity.getErrors()) + System.lineSeparator());
                    }
                    if (entity.getAccessBeanInfo() != null && entity.getAccessBeanInfo().getErrors() != null) {
                        errors.append(String.valueOf(entity.getAccessBeanInfo().getErrors()) + System.lineSeparator());
                    }
                    if (entity.getTableInfo() == null || entity.getTableInfo().getErrors() == null) continue;
                    errors.append(String.valueOf(entity.getTableInfo().getErrors()) + System.lineSeparator());
                }
            }
            final String errorString = errors.toString();
            if (!errorString.isEmpty()) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)"Warning", (String)(String.valueOf(errorString) + System.lineSeparator() + "Job will still run to completion"));
                    }
                });
            }
        }
    }

    private void parseConfiguration(IProgressMonitor progressMonitor) throws InterruptedException {
        if (!progressMonitor.isCanceled()) {
            ParseConfigurationJob parseConfigurationJob = new ParseConfigurationJob(this.iApplicationInfo);
            parseConfigurationJob.setProgressGroup(this.iProgressGroup, 500);
            parseConfigurationJob.schedule();
            parseConfigurationJob.join();
            progressMonitor.worked(500);
        }
    }

    private void resolveApplication(IProgressMonitor progressMonitor) throws InterruptedException {
        if (!progressMonitor.isCanceled()) {
            ResolveApplicationJob resolveApplicationJob = new ResolveApplicationJob(this.iApplicationInfo);
            resolveApplicationJob.setProgressGroup(this.iProgressGroup, 1000);
            resolveApplicationJob.schedule();
            resolveApplicationJob.join();
            progressMonitor.worked(1000);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void portEJBProjects(IProgressMonitor progressMonitor) throws InterruptedException {
        if (!progressMonitor.isCanceled()) {
            void var3_4;
            HashSet portModuleJobs = new HashSet();
            boolean bl = false;
            while (var3_4 < 4) {
                Object portModuleJob = new PortModuleJob(this.iWorkspace, this.iApplicationInfo, this.iBuildPendingProjects);
                portModuleJob.setProgressGroup(this.iProgressGroup, 5000);
                portModuleJob.schedule();
                portModuleJobs.add(portModuleJob);
                ++var3_4;
            }
            for (PortModuleJob portModuleJob : portModuleJobs) {
                portModuleJob.join();
                progressMonitor.worked(5000);
            }
            Set<ModuleInfo> set = this.iApplicationInfo.getModules();
            for (ModuleInfo moduleInfo : set) {
                moduleInfo.getEntities().clear();
            }
        }
    }

    private void resolveImports(IProgressMonitor progressMonitor) throws InterruptedException {
        if (!progressMonitor.isCanceled()) {
            IWorkspaceRoot root = this.iWorkspace.getRoot();
            IProject[] projects = root.getProjects();
            HashSet<IProject> projectSet = new HashSet<IProject>();
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                projectSet.add(project);
                ++n2;
            }
            HashSet<ResolveImportsJob> resolveImportsJobs = new HashSet<ResolveImportsJob>();
            int i = 0;
            while (i < 4) {
                ResolveImportsJob resolveImportsJob = new ResolveImportsJob(projectSet, this.iBuildPendingProjects);
                resolveImportsJob.setProgressGroup(this.iProgressGroup, 250);
                resolveImportsJob.schedule();
                resolveImportsJobs.add(resolveImportsJob);
                ++i;
            }
            for (ResolveImportsJob resolveImportsJob : resolveImportsJobs) {
                resolveImportsJob.join();
                progressMonitor.worked(250);
            }
        }
    }

    private void buildProjects(IProgressMonitor progressMonitor) throws InterruptedException {
        if (!progressMonitor.isCanceled()) {
            HashSet<BuildProjectJob> buildProjectJobs = new HashSet<BuildProjectJob>();
            int i = 0;
            while (i < 4) {
                BuildProjectJob buildProjectJob = new BuildProjectJob(this.iBuildPendingProjects);
                buildProjectJob.setProgressGroup(this.iProgressGroup, 1250);
                buildProjectJob.schedule();
                buildProjectJobs.add(buildProjectJob);
                ++i;
            }
            for (BuildProjectJob buidProjectJob : buildProjectJobs) {
                buidProjectJob.join();
                progressMonitor.worked(1250);
            }
        }
    }

    private void generatePersistenceUnitXml(IProgressMonitor progressMonitor) throws InterruptedException {
        if (!progressMonitor.isCanceled()) {
            GeneratePersistenceXmlJob generatePersistenceXmlJob = new GeneratePersistenceXmlJob(this.iApplicationInfo.getPersistenceUnitInfo());
            generatePersistenceXmlJob.setProgressGroup(this.iProgressGroup, 100);
            generatePersistenceXmlJob.schedule();
            progressMonitor.worked(100);
            generatePersistenceXmlJob.join();
            this.iApplicationInfo.incrementGeneratedAssetCount();
        }
    }

    private boolean isEJBProject(IProject project) {
        boolean ejbProject = false;
        try {
            if (project.isOpen()) {
                IFile jpaModuleInfo;
                if (project.isNatureEnabled("org.eclipse.jdt.core.javanature") && project.isNatureEnabled("org.eclipse.wst.common.project.facet.core.nature")) {
                    IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
                    Set facets = facetedProject.getFixedProjectFacets();
                    for (IProjectFacet facet : facets) {
                        if (!facet.getId().equals("jst.ejb")) continue;
                        ejbProject = true;
                    }
                }
                if (!ejbProject && (jpaModuleInfo = project.getFile(".jpaModuleInfo.xml")).exists()) {
                    ejbProject = true;
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return ejbProject;
    }

    private static class BuildProjectJob
    extends Job {
        private Collection<IProject> iBuildPendingProjects;

        public BuildProjectJob(Collection<IProject> buildPendingProjects) {
            super("Build projects");
            this.iBuildPendingProjects = buildPendingProjects;
        }

        public IStatus run(IProgressMonitor progressMonitor) {
            IStatus status = Status.OK_STATUS;
            try {
                progressMonitor.beginTask("Build projects", -1);
                Object project = this.getProject();
                while (project != null) {
                    if (!progressMonitor.isCanceled() && status != Status.CANCEL_STATUS) {
                        try {
                            LOGGER.info("building " + project.getName());
                            project.build(10, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1000));
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                            status = Status.CANCEL_STATUS;
                        }
                    } else {
                        status = Status.CANCEL_STATUS;
                    }
                    project = !progressMonitor.isCanceled() && status != Status.CANCEL_STATUS ? this.getProject() : null;
                }
            }
            finally {
                progressMonitor.done();
                this.iBuildPendingProjects = null;
            }
            return status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private IProject getProject() {
            IProject project = null;
            Collection<IProject> collection = this.iBuildPendingProjects;
            synchronized (collection) {
                Iterator<IProject> iterator = this.iBuildPendingProjects.iterator();
                if (iterator.hasNext()) {
                    IProject currentProject;
                    project = currentProject = iterator.next();
                }
                if (project != null) {
                    this.iBuildPendingProjects.remove(project);
                }
            }
            return project;
        }
    }

    private static class GeneratePersistenceXmlJob
    extends Job {
        private PersistenceUnitInfo iPersistenceUnitInfo;

        public GeneratePersistenceXmlJob(PersistenceUnitInfo persistenceUnitInfo) {
            super("Generate persistence.xml");
            this.iPersistenceUnitInfo = persistenceUnitInfo;
        }

        public IStatus run(IProgressMonitor progressMonitor) {
            IStatus status = Status.OK_STATUS;
            try {
                progressMonitor.beginTask("Generate persistence.xml", -1);
                if (!progressMonitor.isCanceled()) {
                    PersistenceXmlGenerator persistenceXmlGenerator = new PersistenceXmlGenerator(this.iPersistenceUnitInfo);
                    persistenceXmlGenerator.generate(progressMonitor);
                } else {
                    status = Status.CANCEL_STATUS;
                }
            }
            finally {
                progressMonitor.done();
                this.iPersistenceUnitInfo = null;
            }
            return status;
        }
    }

    private static class ParseConfigurationJob
    extends Job {
        private ApplicationInfo iApplicationInfo;

        public ParseConfigurationJob(ApplicationInfo applicationInfo) {
            super("Parse configuration");
            this.iApplicationInfo = applicationInfo;
        }

        public IStatus run(IProgressMonitor progressMonitor) {
            IStatus status;
            block9: {
                status = Status.OK_STATUS;
                try {
                    progressMonitor.beginTask("Parse configuration", -1);
                    if (!progressMonitor.isCanceled()) {
                        try {
                            File configurationDirectory;
                            File[] configurationFiles;
                            Activator plugin = Activator.getDefault();
                            File pluginLocation = FileLocator.getBundleFile((Bundle)plugin.getBundle());
                            if (!pluginLocation.isDirectory() || (configurationFiles = (configurationDirectory = new File(pluginLocation, "configuration")).listFiles()) == null) break block9;
                            File[] fileArray = configurationFiles;
                            int n = configurationFiles.length;
                            int n2 = 0;
                            while (n2 < n) {
                                File configurationFile = fileArray[n2];
                                if (progressMonitor.isCanceled()) {
                                    status = Status.CANCEL_STATUS;
                                    break block9;
                                }
                                if (configurationFile.isFile() && configurationFile.getName().endsWith(".xml")) {
                                    PortConfigurationParser portConfigurationParser = new PortConfigurationParser(this.iApplicationInfo, configurationFile);
                                    portConfigurationParser.parse();
                                    progressMonitor.worked(100);
                                }
                                ++n2;
                            }
                            break block9;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        break block9;
                    }
                    status = Status.CANCEL_STATUS;
                }
                finally {
                    progressMonitor.done();
                    this.iApplicationInfo = null;
                }
            }
            return status;
        }
    }

    private static class ParseModuleJob
    extends Job {
        private IWorkspace iWorkspace;
        private Set<ModuleInfo> iModules;

        public ParseModuleJob(IWorkspace workspace, Set<ModuleInfo> modules) {
            super("Parse project");
            this.iWorkspace = workspace;
            this.iModules = modules;
        }

        public IStatus run(IProgressMonitor progressMonitor) {
            IStatus status = Status.OK_STATUS;
            try {
                progressMonitor.beginTask("Parse projects", -1);
                ModuleInfo moduleInfo = this.getModule();
                while (moduleInfo != null) {
                    if (!progressMonitor.isCanceled()) {
                        ModuleParser moduleParser = new ModuleParser(this.iWorkspace, moduleInfo);
                        moduleParser.parse((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1000));
                    } else {
                        status = Status.CANCEL_STATUS;
                    }
                    moduleInfo = this.getModule();
                }
            }
            finally {
                progressMonitor.done();
                this.iWorkspace = null;
                this.iModules = null;
            }
            return status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ModuleInfo getModule() {
            ModuleInfo module = null;
            Set<ModuleInfo> set = this.iModules;
            synchronized (set) {
                Iterator<ModuleInfo> iterator = this.iModules.iterator();
                if (iterator.hasNext()) {
                    ModuleInfo currentModule;
                    module = currentModule = iterator.next();
                }
                if (module != null) {
                    this.iModules.remove(module);
                }
            }
            return module;
        }
    }

    private static class PortModuleJob
    extends Job {
        private IWorkspace iWorkspace;
        private ApplicationInfo iApplicationInfo;
        private Collection<IProject> iBuildPendingProjects;

        public PortModuleJob(IWorkspace workspace, ApplicationInfo applicationInfo, Collection<IProject> buildPendingProjects) {
            super("Port modules");
            this.iWorkspace = workspace;
            this.iApplicationInfo = applicationInfo;
            this.iBuildPendingProjects = buildPendingProjects;
        }

        public IStatus run(IProgressMonitor progressMonitor) {
            IStatus status = Status.OK_STATUS;
            try {
                progressMonitor.beginTask("Port modules", -1);
                ModuleInfo module = this.getModule();
                while (module != null) {
                    if (module.getEntities().size() > 0) {
                        if (!progressMonitor.isCanceled()) {
                            ModuleGenerator moduleGenerator = new ModuleGenerator(this.iWorkspace, module);
                            status = moduleGenerator.generate((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1000));
                            this.iBuildPendingProjects.add(module.getJavaProject().getProject());
                        } else {
                            status = Status.CANCEL_STATUS;
                        }
                    }
                    module = this.getModule();
                }
            }
            finally {
                progressMonitor.done();
                this.iWorkspace = null;
                this.iApplicationInfo = null;
                this.iBuildPendingProjects = null;
            }
            return status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ModuleInfo getModule() {
            Set<ModuleInfo> modules;
            ModuleInfo module = null;
            Set<ModuleInfo> set = modules = this.iApplicationInfo.getModules();
            synchronized (set) {
                Iterator<ModuleInfo> iterator = modules.iterator();
                if (iterator.hasNext()) {
                    ModuleInfo currentModule;
                    module = currentModule = iterator.next();
                }
                if (module != null) {
                    modules.remove(module);
                }
            }
            return module;
        }
    }

    private static class ResolveApplicationJob
    extends Job {
        private ApplicationInfo iApplicationInfo;

        public ResolveApplicationJob(ApplicationInfo applicationInfo) {
            super("Resolve application");
            this.iApplicationInfo = applicationInfo;
        }

        public IStatus run(IProgressMonitor progressMonitor) {
            IStatus status = Status.OK_STATUS;
            try {
                progressMonitor.beginTask("Resolve application", -1);
                if (!progressMonitor.isCanceled()) {
                    ApplicationResolver applicationResolver = new ApplicationResolver(this.iApplicationInfo);
                    applicationResolver.resolve();
                    progressMonitor.worked(1000);
                } else {
                    status = Status.CANCEL_STATUS;
                }
            }
            finally {
                progressMonitor.done();
                this.iApplicationInfo = null;
            }
            return status;
        }
    }

    private static class ResolveImportsJob
    extends Job {
        private Collection<IProject> iProjects;
        private Collection<IProject> iBuildPendingProjects;
        private ASTParser iASTParser = ASTParser.newParser((int)3);

        public ResolveImportsJob(Collection<IProject> projects, Collection<IProject> buildPendingProjects) {
            super("Resolve imports");
            this.iProjects = projects;
            this.iBuildPendingProjects = buildPendingProjects;
        }

        public IStatus run(IProgressMonitor progressMonitor) {
            IStatus status = Status.OK_STATUS;
            try {
                progressMonitor.beginTask("Resolve imports", -1);
                IProject project = this.getProject();
                while (project != null) {
                    if (!progressMonitor.isCanceled()) {
                        IFile generatedFileList = project.getFile(".jpaGeneratedFileList");
                        if (generatedFileList.exists()) {
                            ResolveImportsUtil resolveImportsUtil = new ResolveImportsUtil(this.iASTParser, project, project.getFile(".jpaGeneratedFileList"));
                            try {
                                resolveImportsUtil.resolveImports((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1000));
                                this.iBuildPendingProjects.add(project);
                            }
                            catch (CoreException e) {
                                e.printStackTrace();
                                status = Status.CANCEL_STATUS;
                            }
                        }
                        project = this.getProject();
                        continue;
                    }
                    status = Status.CANCEL_STATUS;
                    break;
                }
            }
            finally {
                progressMonitor.done();
                this.iProjects = null;
                this.iBuildPendingProjects = null;
                this.iASTParser = null;
            }
            return status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private IProject getProject() {
            IProject project = null;
            Collection<IProject> collection = this.iProjects;
            synchronized (collection) {
                Iterator<IProject> iterator = this.iProjects.iterator();
                if (iterator.hasNext()) {
                    IProject currentProject;
                    project = currentProject = iterator.next();
                }
                if (project != null) {
                    this.iProjects.remove(project);
                }
            }
            return project;
        }
    }

    private static class RestoreProjectJob
    extends Job {
        private ApplicationInfo iApplicationInfo;
        private Collection<IProject> iBuildPendingProjects;
        private Set<IProject> iProjects;

        public RestoreProjectJob(ApplicationInfo applicationInfo, Collection<IProject> buildPendingProjects, Set<IProject> projects) {
            super("Restore projects");
            this.iApplicationInfo = applicationInfo;
            this.iBuildPendingProjects = buildPendingProjects;
            this.iProjects = projects;
        }

        public IStatus run(IProgressMonitor progressMonitor) {
            IStatus status = Status.OK_STATUS;
            try {
                progressMonitor.beginTask("Restore projects", -1);
                IProject project = this.getProject();
                while (project != null) {
                    boolean restored = false;
                    if (!progressMonitor.isCanceled()) {
                        BackupUtil backupUtil = this.iApplicationInfo.getBackupUtil(project);
                        try {
                            restored = backupUtil.restore((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1000));
                            if (restored) {
                                this.iBuildPendingProjects.add(project);
                            }
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                            status = Status.CANCEL_STATUS;
                        }
                    } else {
                        status = Status.CANCEL_STATUS;
                    }
                    if (status != Status.CANCEL_STATUS && !progressMonitor.isCanceled()) {
                        project = this.getProject();
                        continue;
                    }
                    project = null;
                    status = Status.CANCEL_STATUS;
                }
            }
            finally {
                progressMonitor.done();
                this.iApplicationInfo = null;
                this.iProjects = null;
            }
            return status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private IProject getProject() {
            IProject project = null;
            Set<IProject> set = this.iProjects;
            synchronized (set) {
                Iterator<IProject> iterator = this.iProjects.iterator();
                if (iterator.hasNext()) {
                    IProject currentProject;
                    project = currentProject = iterator.next();
                }
                if (project != null) {
                    this.iProjects.remove(project);
                }
            }
            return project;
        }
    }

    private static class SeedNewClassesJob
    extends Job {
        private ApplicationInfo iApplicationInfo;
        private Collection<IProject> iBuildPendingProjects;
        private String iSourceFolderName;

        public SeedNewClassesJob(ApplicationInfo applicationInfo, Collection<IProject> buildPendingProjects, String sourceFolderName) {
            super("Seed new classes");
            this.iApplicationInfo = applicationInfo;
            this.iBuildPendingProjects = buildPendingProjects;
            this.iSourceFolderName = sourceFolderName;
        }

        public IStatus run(IProgressMonitor progressMonitor) {
            LOGGER.info("Seed new classes");
            IStatus status = Status.OK_STATUS;
            try {
                progressMonitor.beginTask("Seed new classes", -1);
                if (!progressMonitor.isCanceled()) {
                    JPASeederUtilBase seederUtil = new JPASeederUtilBase(this.iApplicationInfo, this.iBuildPendingProjects, this.iSourceFolderName, true);
                    seederUtil.seedNewClasses(progressMonitor);
                } else {
                    status = Status.CANCEL_STATUS;
                }
            }
            finally {
                progressMonitor.done();
                this.iApplicationInfo = null;
                this.iBuildPendingProjects = null;
            }
            return status;
        }
    }
}

