/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.port;

import com.ibm.commerce.jpa.logger.LoggerHelper;
import com.ibm.commerce.jpa.port.generators.EntityReferenceSubclassesXmlGenerator;
import com.ibm.commerce.jpa.port.info.ApplicationInfo;
import com.ibm.commerce.jpa.port.info.ModuleInfo;
import com.ibm.commerce.jpa.port.info.ProjectInfo;
import com.ibm.commerce.jpa.port.parsers.ModuleInfoXmlParser;
import com.ibm.commerce.jpa.port.parsers.ProjectInfoXmlParser;
import com.ibm.commerce.jpa.port.search.EntityReferenceSubclassSearchUtil;
import com.ibm.commerce.jpa.port.util.BackupUtil;
import com.ibm.commerce.jpa.port.util.EntityReferenceUtil;
import com.ibm.commerce.jpa.port.util.JPASeederUtilBase;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class EntityReferenceSubclassSearchJob
extends Job {
    private static final Logger LOGGER = LoggerHelper.getLogger(EntityReferenceSubclassSearchJob.class);
    private static final int PARALLEL_JOBS = 4;
    private IWorkspace iWorkspace;
    private ApplicationInfo iApplicationInfo = new ApplicationInfo();
    private Collection<IProject> iBuildPendingProjects = Collections.synchronizedCollection(new HashSet());
    private IProgressMonitor iProgressGroup;

    public EntityReferenceSubclassSearchJob() {
        super("Entity Reference Subclass Search");
        this.iWorkspace = ResourcesPlugin.getWorkspace();
        this.iProgressGroup = Job.getJobManager().createProgressGroup();
        this.setProgressGroup(this.iProgressGroup, 37100);
    }

    public IStatus run(IProgressMonitor progressMonitor) {
        IStatus status = Status.OK_STATUS;
        try {
            try {
                this.iProgressGroup.beginTask("Entity Reference Subclass Search Jobs", 37100);
                progressMonitor.beginTask("JPA Port", 37100);
                this.initializeApplicationInfo();
                this.restoreProjects(progressMonitor);
                this.buildProjects(progressMonitor);
                this.parseModules(progressMonitor);
                this.parseProjects(progressMonitor);
                this.searchForReferenceSubclasses(progressMonitor);
                this.generateProjects(progressMonitor);
                this.iApplicationInfo.printSummary();
                this.iApplicationInfo = null;
            }
            catch (InterruptedException e) {
                status = Status.CANCEL_STATUS;
                progressMonitor.done();
                this.iProgressGroup.done();
            }
        }
        finally {
            progressMonitor.done();
            this.iProgressGroup.done();
        }
        return status;
    }

    private void initializeApplicationInfo() {
        this.iApplicationInfo = new ApplicationInfo();
    }

    private void restoreProjects(IProgressMonitor progressMonitor) throws InterruptedException {
        IWorkspaceRoot root = this.iWorkspace.getRoot();
        IProject[] projects = root.getProjects();
        HashSet<IProject> projectSet = new HashSet<IProject>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            projectSet.add(project);
            ++n2;
        }
        HashSet<RestoreProjectJob> restoreProjectJobs = new HashSet<RestoreProjectJob>();
        int i = 0;
        while (i < 4) {
            RestoreProjectJob restoreProjectJob = new RestoreProjectJob(this.iApplicationInfo, this.iBuildPendingProjects, projectSet);
            restoreProjectJob.setProgressGroup(this.iProgressGroup, 250);
            restoreProjectJob.schedule();
            restoreProjectJobs.add(restoreProjectJob);
            ++i;
        }
        for (RestoreProjectJob restoreProjectJob : restoreProjectJobs) {
            restoreProjectJob.join();
            progressMonitor.worked(250);
        }
    }

    private void seedNewClasses(IProgressMonitor progressMonitor, String sourceFolderName) throws InterruptedException {
        if (!progressMonitor.isCanceled()) {
            SeedNewClassesJob seedNewClassesJob = new SeedNewClassesJob(this.iApplicationInfo, this.iBuildPendingProjects, sourceFolderName);
            seedNewClassesJob.setProgressGroup(this.iProgressGroup, 100);
            seedNewClassesJob.schedule();
            seedNewClassesJob.join();
            progressMonitor.worked(100);
        }
    }

    private void parseModules(IProgressMonitor progressMonitor) throws InterruptedException {
        if (!progressMonitor.isCanceled()) {
            IWorkspaceRoot root = this.iWorkspace.getRoot();
            IProject[] projects = root.getProjects();
            HashSet<ModuleInfo> modules = new HashSet<ModuleInfo>();
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                IFile moduleInfoXmlFile = project.getFile(".jpaModuleInfo.xml");
                if (moduleInfoXmlFile.exists()) {
                    IJavaProject javaProject = JavaCore.create((IProject)project);
                    ModuleInfo moduleInfo = new ModuleInfo(this.iApplicationInfo, javaProject);
                    this.iApplicationInfo.addModule(moduleInfo);
                    modules.add(moduleInfo);
                }
                ++n2;
            }
            HashSet<ParseModuleJob> parseModuleJobs = new HashSet<ParseModuleJob>();
            int i = 0;
            while (i < 4) {
                ParseModuleJob parseModuleJob = new ParseModuleJob(modules);
                parseModuleJob.setProgressGroup(this.iProgressGroup, 1250);
                parseModuleJob.schedule();
                parseModuleJobs.add(parseModuleJob);
                ++i;
            }
            for (ParseModuleJob parseModuleJob : parseModuleJobs) {
                parseModuleJob.join();
                progressMonitor.worked(1250);
            }
        }
    }

    private void parseProjects(IProgressMonitor progressMonitor) throws InterruptedException {
        if (!progressMonitor.isCanceled()) {
            IWorkspaceRoot root = this.iWorkspace.getRoot();
            EntityReferenceUtil.loadPredefinedEntityReferences(this.iApplicationInfo, root);
            IProject[] projects = root.getProjects();
            HashSet<ProjectInfo> projectInfos = new HashSet<ProjectInfo>();
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                IFile accessBeanSubclassInfoXmlFile = project.getFile(".jpaAccessBeanSubclassInfo.xml");
                IFile entityReferencesXmlFile = project.getFile(".jpaEntityReferences.xml");
                if (accessBeanSubclassInfoXmlFile.exists() || entityReferencesXmlFile.exists()) {
                    ProjectInfo projectInfo = this.iApplicationInfo.getProjectInfo(project);
                    projectInfos.add(projectInfo);
                }
                ++n2;
            }
            HashSet<ParseProjectJob> parseProjectJobs = new HashSet<ParseProjectJob>();
            int i = 0;
            while (i < 4) {
                ParseProjectJob parseProjectJob = new ParseProjectJob(projectInfos);
                parseProjectJob.setProgressGroup(this.iProgressGroup, 1250);
                parseProjectJob.schedule();
                parseProjectJobs.add(parseProjectJob);
                ++i;
            }
            for (ParseProjectJob parseProjectJob : parseProjectJobs) {
                parseProjectJob.join();
                progressMonitor.worked(1250);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void searchForReferenceSubclasses(IProgressMonitor progressMonitor) throws InterruptedException {
        if (!progressMonitor.isCanceled()) {
            void var4_5;
            HashSet<ProjectInfo> projects = new HashSet<ProjectInfo>();
            projects.addAll(this.iApplicationInfo.getProjects());
            HashSet<SearchJob> searchJobs = new HashSet<SearchJob>();
            boolean bl = false;
            while (var4_5 < 4) {
                SearchJob searchJob = new SearchJob(projects);
                searchJob.setProgressGroup(this.iProgressGroup, 5000);
                searchJob.schedule();
                searchJobs.add(searchJob);
                ++var4_5;
            }
            for (Job job : searchJobs) {
                job.join();
                progressMonitor.worked(5000);
            }
        }
    }

    private void generateProjects(IProgressMonitor progressMonitor) throws InterruptedException {
        if (!progressMonitor.isCanceled()) {
            HashSet<GenerateProjectJob> generateProjectJobs = new HashSet<GenerateProjectJob>();
            int i = 0;
            while (i < 4) {
                GenerateProjectJob generateProjectJob = new GenerateProjectJob(this.iApplicationInfo.getProjects());
                generateProjectJob.setProgressGroup(this.iProgressGroup, 250);
                generateProjectJob.schedule();
                generateProjectJobs.add(generateProjectJob);
                ++i;
            }
            for (GenerateProjectJob generateProjectJob : generateProjectJobs) {
                generateProjectJob.join();
                progressMonitor.worked(250);
            }
        }
    }

    private void buildProjects(IProgressMonitor progressMonitor) throws InterruptedException {
        if (!progressMonitor.isCanceled()) {
            HashSet<BuildProjectJob> buildProjectJobs = new HashSet<BuildProjectJob>();
            int i = 0;
            while (i < 4) {
                BuildProjectJob buildProjectJob = new BuildProjectJob(this.iBuildPendingProjects);
                buildProjectJob.setProgressGroup(this.iProgressGroup, 1250);
                buildProjectJob.schedule();
                buildProjectJobs.add(buildProjectJob);
                ++i;
            }
            for (BuildProjectJob buidProjectJob : buildProjectJobs) {
                buidProjectJob.join();
                progressMonitor.worked(1250);
            }
        }
    }

    private static class BuildProjectJob
    extends Job {
        private Collection<IProject> iBuildPendingProjects;

        public BuildProjectJob(Collection<IProject> buildPendingProjects) {
            super("Build projects");
            this.iBuildPendingProjects = buildPendingProjects;
        }

        public IStatus run(IProgressMonitor progressMonitor) {
            IStatus status = Status.OK_STATUS;
            try {
                progressMonitor.beginTask("Build projects", -1);
                Object project = this.getProject();
                while (project != null) {
                    if (!progressMonitor.isCanceled() && status != Status.CANCEL_STATUS) {
                        try {
                            LOGGER.info("building " + project.getName());
                            project.build(10, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1000));
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                            status = Status.CANCEL_STATUS;
                        }
                    } else {
                        status = Status.CANCEL_STATUS;
                    }
                    project = !progressMonitor.isCanceled() && status != Status.CANCEL_STATUS ? this.getProject() : null;
                }
            }
            finally {
                progressMonitor.done();
                this.iBuildPendingProjects = null;
            }
            return status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private IProject getProject() {
            IProject project = null;
            Collection<IProject> collection = this.iBuildPendingProjects;
            synchronized (collection) {
                Iterator<IProject> iterator = this.iBuildPendingProjects.iterator();
                if (iterator.hasNext()) {
                    IProject currentProject;
                    project = currentProject = iterator.next();
                }
                if (project != null) {
                    this.iBuildPendingProjects.remove(project);
                }
            }
            return project;
        }
    }

    private static class GenerateProjectJob
    extends Job {
        private Collection<ProjectInfo> iProjects;

        public GenerateProjectJob(Collection<ProjectInfo> projects) {
            super("generate project info");
            this.iProjects = projects;
        }

        public IStatus run(IProgressMonitor progressMonitor) {
            IStatus status = Status.OK_STATUS;
            try {
                progressMonitor.beginTask("generate project info", -1);
                ProjectInfo projectInfo = this.getProjectInfo();
                while (projectInfo != null) {
                    EntityReferenceSubclassesXmlGenerator entityReferencesSubclassesXmlGenerator = new EntityReferenceSubclassesXmlGenerator(projectInfo);
                    entityReferencesSubclassesXmlGenerator.generate((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1000));
                    if (!progressMonitor.isCanceled()) {
                        projectInfo = this.getProjectInfo();
                        continue;
                    }
                    status = Status.CANCEL_STATUS;
                    projectInfo = null;
                }
            }
            finally {
                progressMonitor.done();
            }
            return status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ProjectInfo getProjectInfo() {
            ProjectInfo projectInfo = null;
            Collection<ProjectInfo> collection = this.iProjects;
            synchronized (collection) {
                Iterator<ProjectInfo> iterator = this.iProjects.iterator();
                if (iterator.hasNext()) {
                    ProjectInfo currentProjectInfo;
                    projectInfo = currentProjectInfo = iterator.next();
                }
                if (projectInfo != null) {
                    this.iProjects.remove(projectInfo);
                }
            }
            return projectInfo;
        }
    }

    private static class ParseModuleJob
    extends Job {
        private Set<ModuleInfo> iModules;

        public ParseModuleJob(Set<ModuleInfo> modules) {
            super("Parse modules");
            this.iModules = modules;
        }

        public IStatus run(IProgressMonitor progressMonitor) {
            IStatus status = Status.OK_STATUS;
            try {
                progressMonitor.beginTask("Parse modules", -1);
                ModuleInfo moduleInfo = this.getModule();
                while (moduleInfo != null) {
                    if (!progressMonitor.isCanceled()) {
                        ModuleInfoXmlParser moduleInfoXmlParser = new ModuleInfoXmlParser(moduleInfo);
                        moduleInfoXmlParser.parse((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1000));
                        moduleInfo = this.getModule();
                        continue;
                    }
                    status = Status.CANCEL_STATUS;
                    moduleInfo = null;
                }
            }
            finally {
                progressMonitor.done();
                this.iModules = null;
            }
            return status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ModuleInfo getModule() {
            ModuleInfo module = null;
            Set<ModuleInfo> set = this.iModules;
            synchronized (set) {
                Iterator<ModuleInfo> iterator = this.iModules.iterator();
                if (iterator.hasNext()) {
                    ModuleInfo currentModule;
                    module = currentModule = iterator.next();
                }
                if (module != null) {
                    this.iModules.remove(module);
                }
            }
            return module;
        }
    }

    private static class ParseProjectJob
    extends Job {
        private Set<ProjectInfo> iProjects;

        public ParseProjectJob(Set<ProjectInfo> projects) {
            super("Parse projects");
            this.iProjects = projects;
        }

        public IStatus run(IProgressMonitor progressMonitor) {
            IStatus status = Status.OK_STATUS;
            try {
                progressMonitor.beginTask("Parse projects", -1);
                ProjectInfo projectInfo = this.getProjectInfo();
                while (projectInfo != null) {
                    if (!progressMonitor.isCanceled()) {
                        ProjectInfoXmlParser projectInfoXmlParser = new ProjectInfoXmlParser(projectInfo);
                        projectInfoXmlParser.parse((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1000));
                        projectInfo = this.getProjectInfo();
                        continue;
                    }
                    status = Status.CANCEL_STATUS;
                    projectInfo = null;
                }
            }
            finally {
                progressMonitor.done();
                this.iProjects = null;
            }
            return status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ProjectInfo getProjectInfo() {
            ProjectInfo projectInfo = null;
            Set<ProjectInfo> set = this.iProjects;
            synchronized (set) {
                Iterator<ProjectInfo> iterator = this.iProjects.iterator();
                if (iterator.hasNext()) {
                    ProjectInfo currentProject;
                    projectInfo = currentProject = iterator.next();
                }
                if (projectInfo != null) {
                    this.iProjects.remove(projectInfo);
                }
            }
            return projectInfo;
        }
    }

    private static class RestoreProjectJob
    extends Job {
        private ApplicationInfo iApplicationInfo;
        private Collection<IProject> iBuildPendingProjects;
        private Set<IProject> iProjects;

        public RestoreProjectJob(ApplicationInfo applicationInfo, Collection<IProject> buildPendingProjects, Set<IProject> projects) {
            super("Restore projects");
            this.iApplicationInfo = applicationInfo;
            this.iBuildPendingProjects = buildPendingProjects;
            this.iProjects = projects;
        }

        public IStatus run(IProgressMonitor progressMonitor) {
            IStatus status = Status.OK_STATUS;
            try {
                progressMonitor.beginTask("Restore projects", -1);
                IProject project = this.getProject();
                while (project != null) {
                    boolean restored = false;
                    if (!progressMonitor.isCanceled()) {
                        BackupUtil backupUtil = this.iApplicationInfo.getBackupUtil(project);
                        try {
                            IFile entityReferenceSubclassesXmlFile;
                            restored = backupUtil.restore2((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1000));
                            if (restored) {
                                this.iBuildPendingProjects.add(project);
                            }
                            if ((entityReferenceSubclassesXmlFile = project.getFile(".jpaEntityReferenceSubclasses.xml")).exists()) {
                                entityReferenceSubclassesXmlFile.delete(true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 10));
                            }
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                            status = Status.CANCEL_STATUS;
                        }
                    } else {
                        status = Status.CANCEL_STATUS;
                    }
                    if (status != Status.CANCEL_STATUS && !progressMonitor.isCanceled()) {
                        project = this.getProject();
                        continue;
                    }
                    status = Status.CANCEL_STATUS;
                    project = null;
                }
            }
            finally {
                progressMonitor.done();
                this.iApplicationInfo = null;
                this.iProjects = null;
            }
            return status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private IProject getProject() {
            IProject project = null;
            Set<IProject> set = this.iProjects;
            synchronized (set) {
                Iterator<IProject> iterator = this.iProjects.iterator();
                if (iterator.hasNext()) {
                    IProject currentProject;
                    project = currentProject = iterator.next();
                }
                if (project != null) {
                    this.iProjects.remove(project);
                }
            }
            return project;
        }
    }

    private static class SearchJob
    extends Job {
        private Collection<ProjectInfo> iProjects;

        public SearchJob(Set<ProjectInfo> projects) {
            super("Search for entity reference subclasses");
            this.iProjects = projects;
        }

        public IStatus run(IProgressMonitor progressMonitor) {
            IStatus status = Status.OK_STATUS;
            try {
                progressMonitor.beginTask("Search for entity reference subclasses", -1);
                ProjectInfo projectInfo = this.getProjectInfo();
                while (projectInfo != null) {
                    if (progressMonitor.isCanceled()) {
                        status = Status.CANCEL_STATUS;
                        projectInfo = null;
                        break;
                    }
                    EntityReferenceSubclassSearchUtil searchUtil = new EntityReferenceSubclassSearchUtil(projectInfo);
                    searchUtil.search((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1000));
                    if (!progressMonitor.isCanceled()) {
                        projectInfo = this.getProjectInfo();
                        continue;
                    }
                    status = Status.CANCEL_STATUS;
                    projectInfo = null;
                }
            }
            finally {
                progressMonitor.done();
            }
            return status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ProjectInfo getProjectInfo() {
            ProjectInfo projectInfo = null;
            Collection<ProjectInfo> collection = this.iProjects;
            synchronized (collection) {
                Iterator<ProjectInfo> iterator = this.iProjects.iterator();
                if (iterator.hasNext()) {
                    ProjectInfo currentProjectInfo;
                    projectInfo = currentProjectInfo = iterator.next();
                }
                if (projectInfo != null) {
                    this.iProjects.remove(projectInfo);
                }
            }
            return projectInfo;
        }
    }

    private static class SeedNewClassesJob
    extends Job {
        private ApplicationInfo iApplicationInfo;
        private Collection<IProject> iBuildPendingProjects;
        private String iSourceFolderName;

        public SeedNewClassesJob(ApplicationInfo applicationInfo, Collection<IProject> buildPendingProjects, String sourceFolderName) {
            super("Seed new classes");
            this.iApplicationInfo = applicationInfo;
            this.iBuildPendingProjects = buildPendingProjects;
            this.iSourceFolderName = sourceFolderName;
        }

        public IStatus run(IProgressMonitor progressMonitor) {
            LOGGER.info("Seed new classes");
            IStatus status = Status.OK_STATUS;
            try {
                progressMonitor.beginTask("Seed new classes", -1);
                if (!progressMonitor.isCanceled()) {
                    JPASeederUtilBase seederUtil = new JPASeederUtilBase(this.iApplicationInfo, this.iBuildPendingProjects, this.iSourceFolderName, false);
                    seederUtil.seedNewClasses(progressMonitor);
                } else {
                    status = Status.CANCEL_STATUS;
                }
            }
            finally {
                progressMonitor.done();
                this.iApplicationInfo = null;
            }
            return status;
        }
    }
}

