/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.port;

import com.ibm.commerce.jpa.logger.LoggerHelper;
import com.ibm.commerce.jpa.port.info.ApplicationInfo;
import com.ibm.commerce.jpa.port.info.EntityInfo;
import com.ibm.commerce.jpa.port.info.ModuleInfo;
import com.ibm.commerce.jpa.port.parsers.ModuleInfoXmlParser;
import com.ibm.commerce.jpa.port.search.BinaryEntitySearchUtil;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class BinaryEntitySearchJob
extends Job {
    private static final Logger LOGGER = LoggerHelper.getLogger(BinaryEntitySearchJob.class);
    private static final int PARALLEL_JOBS = 6;
    private IWorkspace iWorkspace;
    private ApplicationInfo iApplicationInfo = new ApplicationInfo();
    private IProgressMonitor iProgressGroup;
    private Set<String> iBinaryReferences = new TreeSet<String>();

    public BinaryEntitySearchJob() {
        super("Entity Search");
        this.iWorkspace = ResourcesPlugin.getWorkspace();
        this.iProgressGroup = Job.getJobManager().createProgressGroup();
        this.setProgressGroup(this.iProgressGroup, 2500);
    }

    public IStatus run(IProgressMonitor progressMonitor) {
        IStatus status = Status.OK_STATUS;
        try {
            try {
                this.iProgressGroup.beginTask("Entity search jobs", 25000);
                progressMonitor.beginTask("Entity Search", 25000);
                this.initializeApplicationInfo();
                this.parseModules(progressMonitor);
                this.searchForReferences(progressMonitor);
                LOGGER.info("binary references:");
                for (String binaryReference : this.iBinaryReferences) {
                    LOGGER.info(binaryReference);
                }
                this.iApplicationInfo.printSummary();
            }
            catch (InterruptedException e) {
                status = Status.CANCEL_STATUS;
                progressMonitor.done();
                this.iProgressGroup.done();
            }
        }
        finally {
            progressMonitor.done();
            this.iProgressGroup.done();
        }
        return status;
    }

    private void initializeApplicationInfo() {
        this.iApplicationInfo = new ApplicationInfo();
    }

    private void parseModules(IProgressMonitor progressMonitor) throws InterruptedException {
        if (!progressMonitor.isCanceled()) {
            IWorkspaceRoot root = this.iWorkspace.getRoot();
            IProject[] projects = root.getProjects();
            HashSet<ModuleInfo> modules = new HashSet<ModuleInfo>();
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                IFile moduleInfoXmlFile = project.getFile(".jpaModuleInfo.xml");
                if (moduleInfoXmlFile.exists()) {
                    IJavaProject javaProject = JavaCore.create((IProject)project);
                    ModuleInfo moduleInfo = new ModuleInfo(this.iApplicationInfo, javaProject);
                    this.iApplicationInfo.addModule(moduleInfo);
                    modules.add(moduleInfo);
                }
                ++n2;
            }
            HashSet<ParseModuleJob> parseModuleJobs = new HashSet<ParseModuleJob>();
            int i = 0;
            while (i < 6) {
                ParseModuleJob parseModuleJob = new ParseModuleJob(modules);
                parseModuleJob.setProgressGroup(this.iProgressGroup, 833);
                parseModuleJob.schedule();
                parseModuleJobs.add(parseModuleJob);
                ++i;
            }
            for (ParseModuleJob parseEjbModuleJob : parseModuleJobs) {
                parseEjbModuleJob.join();
                progressMonitor.worked(833);
            }
        }
    }

    private void searchForReferences(IProgressMonitor progressMonitor) throws InterruptedException {
        if (!progressMonitor.isCanceled()) {
            HashSet<ModuleInfo> modules = new HashSet<ModuleInfo>();
            modules.addAll(this.iApplicationInfo.getModules());
            HashSet<EntityReferencesSearchJob> searchJobs = new HashSet<EntityReferencesSearchJob>();
            int i = 0;
            while (i < 6) {
                EntityReferencesSearchJob searchJob = new EntityReferencesSearchJob(this.iApplicationInfo, modules, this.iBinaryReferences);
                searchJob.setProgressGroup(this.iProgressGroup, 3333);
                searchJob.schedule();
                searchJobs.add(searchJob);
                ++i;
            }
            for (EntityReferencesSearchJob searchJob : searchJobs) {
                searchJob.join();
                progressMonitor.worked(3333);
            }
        }
    }

    private static class EntityReferencesSearchJob
    extends Job {
        private ApplicationInfo iApplicationInfo;
        private Set<ModuleInfo> iModules;
        private Set<String> iBinaryReferences;

        public EntityReferencesSearchJob(ApplicationInfo applicationInfo, Set<ModuleInfo> modules, Set<String> binaryReferences) {
            super("Search for entity references");
            this.iApplicationInfo = applicationInfo;
            this.iModules = modules;
            this.iBinaryReferences = binaryReferences;
        }

        public IStatus run(IProgressMonitor progressMonitor) {
            IStatus status = Status.OK_STATUS;
            try {
                BinaryEntitySearchUtil entitySearchUtil;
                progressMonitor.beginTask("Search for entity references", -1);
                ModuleInfo moduleInfo = this.getModuleInfo();
                HashSet<EntityInfo> entities = new HashSet<EntityInfo>();
                while (moduleInfo != null) {
                    entities.addAll(moduleInfo.getEntities());
                    if (!progressMonitor.isCanceled()) {
                        if (entities.size() > 50) {
                            entitySearchUtil = new BinaryEntitySearchUtil(this.iApplicationInfo, entities, this.iBinaryReferences);
                            entitySearchUtil.search((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1000));
                            entities = new HashSet();
                        }
                    } else {
                        status = Status.CANCEL_STATUS;
                        moduleInfo = null;
                        break;
                    }
                    if (!progressMonitor.isCanceled()) {
                        moduleInfo = this.getModuleInfo();
                        continue;
                    }
                    status = Status.CANCEL_STATUS;
                    moduleInfo = null;
                }
                if (entities.size() > 0 && status != Status.CANCEL_STATUS && !progressMonitor.isCanceled()) {
                    entitySearchUtil = new BinaryEntitySearchUtil(this.iApplicationInfo, entities, this.iBinaryReferences);
                    entitySearchUtil.search((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1000));
                }
            }
            finally {
                progressMonitor.done();
            }
            return status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ModuleInfo getModuleInfo() {
            ModuleInfo moduleInfo = null;
            Set<ModuleInfo> set = this.iModules;
            synchronized (set) {
                Iterator<ModuleInfo> iterator = this.iModules.iterator();
                if (iterator.hasNext()) {
                    ModuleInfo currentModuleInfo;
                    moduleInfo = currentModuleInfo = iterator.next();
                }
                if (moduleInfo != null) {
                    this.iModules.remove(moduleInfo);
                }
            }
            return moduleInfo;
        }
    }

    private static class ParseModuleJob
    extends Job {
        private Set<ModuleInfo> iModules;

        public ParseModuleJob(Set<ModuleInfo> modules) {
            super("Parse Ejb Module");
            this.iModules = modules;
        }

        public IStatus run(IProgressMonitor progressMonitor) {
            IStatus status = Status.OK_STATUS;
            try {
                progressMonitor.beginTask("Parse projects", -1);
                ModuleInfo moduleInfo = this.getModule();
                while (moduleInfo != null) {
                    if (!progressMonitor.isCanceled()) {
                        ModuleInfoXmlParser moduleInfoXmlParser = new ModuleInfoXmlParser(moduleInfo);
                        moduleInfoXmlParser.parse((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1000));
                    } else {
                        status = Status.CANCEL_STATUS;
                    }
                    moduleInfo = this.getModule();
                }
            }
            finally {
                progressMonitor.done();
            }
            return status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ModuleInfo getModule() {
            ModuleInfo module = null;
            Set<ModuleInfo> set = this.iModules;
            synchronized (set) {
                Iterator<ModuleInfo> iterator = this.iModules.iterator();
                if (iterator.hasNext()) {
                    ModuleInfo currentModule;
                    module = currentModule = iterator.next();
                }
                if (module != null) {
                    this.iModules.remove(module);
                }
            }
            return module;
        }
    }
}

