/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.port;

import com.ibm.commerce.jpa.port.generators.AccessBeanSubclassInfoXmlGenerator;
import com.ibm.commerce.jpa.port.info.ApplicationInfo;
import com.ibm.commerce.jpa.port.info.ModuleInfo;
import com.ibm.commerce.jpa.port.info.ProjectInfo;
import com.ibm.commerce.jpa.port.parsers.ModuleInfoXmlParser;
import com.ibm.commerce.jpa.port.parsers.ProjectParser;
import com.ibm.commerce.jpa.port.search.AccessBeanSubclassSearchUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class AccessBeanSubclassSearchJob
extends Job {
    private static final int PARALLEL_JOBS = 6;
    private IWorkspace iWorkspace;
    private ApplicationInfo iApplicationInfo = new ApplicationInfo();
    private IProgressMonitor iProgressGroup;

    public AccessBeanSubclassSearchJob() {
        super("Entity Search");
        this.iWorkspace = ResourcesPlugin.getWorkspace();
        this.iProgressGroup = Job.getJobManager().createProgressGroup();
        this.setProgressGroup(this.iProgressGroup, 31000);
    }

    public IStatus run(IProgressMonitor progressMonitor) {
        IStatus status = Status.OK_STATUS;
        try {
            try {
                this.iProgressGroup.beginTask("Entity search jobs", 31000);
                progressMonitor.beginTask("Entity Search", 31000);
                this.initializeApplicationInfo();
                this.parseModules(progressMonitor);
                this.searchForAccessBeanSubclasses(progressMonitor);
                this.parseProjects(progressMonitor);
                this.generateProjects(progressMonitor);
                this.iApplicationInfo.printSummary();
            }
            catch (InterruptedException e) {
                status = Status.CANCEL_STATUS;
                progressMonitor.done();
                this.iProgressGroup.done();
            }
        }
        finally {
            progressMonitor.done();
            this.iProgressGroup.done();
        }
        return status;
    }

    private void initializeApplicationInfo() {
        this.iApplicationInfo = new ApplicationInfo();
    }

    private void parseModules(IProgressMonitor progressMonitor) throws InterruptedException {
        if (!progressMonitor.isCanceled()) {
            IWorkspaceRoot root = this.iWorkspace.getRoot();
            IProject[] projects = root.getProjects();
            HashSet<ModuleInfo> modules = new HashSet<ModuleInfo>();
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                IFile moduleInfoXmlFile = project.getFile(".jpaModuleInfo.xml");
                if (moduleInfoXmlFile.exists()) {
                    IJavaProject javaProject = JavaCore.create((IProject)project);
                    ModuleInfo moduleInfo = new ModuleInfo(this.iApplicationInfo, javaProject);
                    this.iApplicationInfo.addModule(moduleInfo);
                    modules.add(moduleInfo);
                }
                ++n2;
            }
            HashSet<ParseModuleJob> parseModuleJobs = new HashSet<ParseModuleJob>();
            int i = 0;
            while (i < 6) {
                ParseModuleJob parseModuleJob = new ParseModuleJob(modules);
                parseModuleJob.setProgressGroup(this.iProgressGroup, 833);
                parseModuleJob.schedule();
                parseModuleJobs.add(parseModuleJob);
                ++i;
            }
            for (ParseModuleJob parseEjbModuleJob : parseModuleJobs) {
                parseEjbModuleJob.join();
                progressMonitor.worked(833);
            }
        }
    }

    private void searchForAccessBeanSubclasses(IProgressMonitor progressMonitor) throws InterruptedException {
        if (!progressMonitor.isCanceled()) {
            HashSet<ModuleInfo> modules = new HashSet<ModuleInfo>();
            modules.addAll(this.iApplicationInfo.getModules());
            HashSet<SearchJob> searchJobs = new HashSet<SearchJob>();
            int i = 0;
            while (i < 6) {
                SearchJob searchJob = new SearchJob(modules);
                searchJob.setProgressGroup(this.iProgressGroup, 3333);
                searchJob.schedule();
                searchJobs.add(searchJob);
                ++i;
            }
            for (SearchJob searchJob : searchJobs) {
                searchJob.join();
                progressMonitor.worked(3333);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void parseProjects(IProgressMonitor progressMonitor) throws InterruptedException {
        if (!progressMonitor.isCanceled()) {
            void var4_5;
            HashSet<ProjectInfo> projects = new HashSet<ProjectInfo>();
            projects.addAll(this.iApplicationInfo.getProjects());
            HashSet<ParseProjectJob> parseProjectJobs = new HashSet<ParseProjectJob>();
            boolean bl = false;
            while (var4_5 < 6) {
                ParseProjectJob parseProjectJob = new ParseProjectJob(projects);
                parseProjectJob.setProgressGroup(this.iProgressGroup, 833);
                parseProjectJob.schedule();
                parseProjectJobs.add(parseProjectJob);
                ++var4_5;
            }
            for (Job job : parseProjectJobs) {
                job.join();
                progressMonitor.worked(833);
            }
        }
    }

    private void generateProjects(IProgressMonitor progressMonitor) throws InterruptedException {
        if (!progressMonitor.isCanceled()) {
            Collection<ProjectInfo> projects = this.iApplicationInfo.getProjects();
            for (ProjectInfo projectInfo : projects) {
                if (progressMonitor.isCanceled()) continue;
                AccessBeanSubclassInfoXmlGenerator accessBeanSubclassInfoXmlGenerator = new AccessBeanSubclassInfoXmlGenerator(projectInfo);
                accessBeanSubclassInfoXmlGenerator.generate((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1000 / projects.size()));
            }
        }
    }

    private static class ParseModuleJob
    extends Job {
        private Set<ModuleInfo> iModules;

        public ParseModuleJob(Set<ModuleInfo> modules) {
            super("Parse Ejb Module");
            this.iModules = modules;
        }

        public IStatus run(IProgressMonitor progressMonitor) {
            IStatus status = Status.OK_STATUS;
            try {
                progressMonitor.beginTask("Parse projects", -1);
                ModuleInfo moduleInfo = this.getModule();
                while (moduleInfo != null) {
                    if (!progressMonitor.isCanceled()) {
                        ModuleInfoXmlParser moduleInfoXmlParser = new ModuleInfoXmlParser(moduleInfo);
                        moduleInfoXmlParser.parse((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1000));
                    } else {
                        status = Status.CANCEL_STATUS;
                    }
                    moduleInfo = this.getModule();
                }
            }
            finally {
                progressMonitor.done();
            }
            return status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ModuleInfo getModule() {
            ModuleInfo module = null;
            Set<ModuleInfo> set = this.iModules;
            synchronized (set) {
                Iterator<ModuleInfo> iterator = this.iModules.iterator();
                if (iterator.hasNext()) {
                    ModuleInfo currentModule;
                    module = currentModule = iterator.next();
                }
                if (module != null) {
                    this.iModules.remove(module);
                }
            }
            return module;
        }
    }

    private static class ParseProjectJob
    extends Job {
        private Collection<ProjectInfo> iProjects;

        public ParseProjectJob(Collection<ProjectInfo> projects) {
            super("parse project info");
            this.iProjects = projects;
        }

        public IStatus run(IProgressMonitor progressMonitor) {
            IStatus status = Status.OK_STATUS;
            try {
                progressMonitor.beginTask("parse project info", -1);
                ProjectInfo projectInfo = this.getProjectInfo();
                while (projectInfo != null) {
                    ProjectParser projectParser = new ProjectParser(projectInfo);
                    projectParser.parse((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1000));
                    if (!progressMonitor.isCanceled()) {
                        projectInfo = this.getProjectInfo();
                        continue;
                    }
                    status = Status.CANCEL_STATUS;
                    projectInfo = null;
                }
            }
            finally {
                progressMonitor.done();
                this.iProjects = null;
            }
            return status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ProjectInfo getProjectInfo() {
            ProjectInfo projectInfo = null;
            Collection<ProjectInfo> collection = this.iProjects;
            synchronized (collection) {
                Iterator<ProjectInfo> iterator = this.iProjects.iterator();
                if (iterator.hasNext()) {
                    ProjectInfo currentProjectInfo;
                    projectInfo = currentProjectInfo = iterator.next();
                }
                if (projectInfo != null) {
                    this.iProjects.remove(projectInfo);
                }
            }
            return projectInfo;
        }
    }

    private static class SearchJob
    extends Job {
        private Set<ModuleInfo> iModules;

        public SearchJob(Set<ModuleInfo> modules) {
            super("Search for access bean subclasses");
            this.iModules = modules;
        }

        public IStatus run(IProgressMonitor progressMonitor) {
            IStatus status = Status.OK_STATUS;
            try {
                progressMonitor.beginTask("Search for access bean subclasses", -1);
                ModuleInfo moduleInfo = this.getModuleInfo();
                while (moduleInfo != null) {
                    if (progressMonitor.isCanceled()) {
                        status = Status.CANCEL_STATUS;
                        moduleInfo = null;
                        break;
                    }
                    AccessBeanSubclassSearchUtil searchUtil = new AccessBeanSubclassSearchUtil(moduleInfo);
                    searchUtil.search((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1000));
                    if (!progressMonitor.isCanceled()) {
                        moduleInfo = this.getModuleInfo();
                        continue;
                    }
                    status = Status.CANCEL_STATUS;
                    moduleInfo = null;
                }
            }
            finally {
                progressMonitor.done();
            }
            return status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ModuleInfo getModuleInfo() {
            ModuleInfo moduleInfo = null;
            Set<ModuleInfo> set = this.iModules;
            synchronized (set) {
                Iterator<ModuleInfo> iterator = this.iModules.iterator();
                if (iterator.hasNext()) {
                    ModuleInfo currentModuleInfo;
                    moduleInfo = currentModuleInfo = iterator.next();
                }
                if (moduleInfo != null) {
                    this.iModules.remove(moduleInfo);
                }
            }
            return moduleInfo;
        }
    }
}

