BEGIN_SYMBOL_DEFINITIONS
<!-- WebSphere Commerce tables -->
COLS:CATENTRY=CATENTRY:*
COLS:CATENTDESC=CATENTDESC:*

<!-- MyCompany extension tables -->
COLS:XWARRANTY=XWARRANTY:*
COLS:XCAREINSTRUCTION=XCAREINSTRUCTION:*

END_SYMBOL_DEFINITIONS
BEGIN_ASSOCIATION_SQL_STATEMENT
	name=MyCompanyWarrantyCatalogEntry
	base_table=CATENTRY
	additional_entity_objects=true
	sql=
		SELECT 
		    CATENTRY.$COLS:CATENTRY$,
		    XWARRANTY.$COLS:XWARRANTY$
		FROM
		    CATENTRY
		      JOIN STORECENT ON STORECENT.CATENTRY_ID=CATENTRY.CATENTRY_ID 
		      LEFT OUTER JOIN XWARRANTY ON (CATENTRY.CATENTRY_ID = XWARRANTY.CATENTRY_ID) 
		WHERE
		    CATENTRY.CATENTRY_ID IN ($ENTITY_PKS$)
		    AND STORECENT.STOREENT_ID IN ($STOREPATH:catalog$) 
		    AND CATENTRY.MARKFORDELETE=0
END_ASSOCIATION_SQL_STATEMENT

BEGIN_XPATH_TO_SQL_STATEMENT
name=/CatalogEntry[CatalogEntryIdentifier[(UniqueID=)]]/Description+MyCompany_CatalogEntryDescription_Update
base_table=CATENTDESC 
sql=
SELECT 
    CATENTDESC.$COLS:CATENTDESC$,
    XCAREINSTRUCTION.$COLS:XCAREINSTRUCTION$
FROM
    CATENTDESC
      LEFT OUTER JOIN XCAREINSTRUCTION ON (CATENTDESC.CATENTRY_ID = XCAREINSTRUCTION.CATENTRY_ID AND XCAREINSTRUCTION.LANGUAGE_ID = CATENTDESC.LANGUAGE_ID)

WHERE
    CATENTDESC.CATENTRY_ID IN (?UniqueID?) 

END_XPATH_TO_SQL_STATEMENT 

BEGIN_PROFILE
	name=MyCompany_CatalogEntry_Update
	extends = IBM_Admin_CatalogEntryUpdate
	BEGIN_ENTITY
		associated_sql_statement=MyCompanyWarrantyCatalogEntry
	END_ENTITY
END_PROFILE