BEGIN_SYMBOL_DEFINITIONS
<!-- WebSphere Commerce tables -->
COLS:CATENTRY=CATENTRY:*
COLS:CATENTDESC=CATENTDESC:*

<!-- MyCompany extension tables -->
COLS:XWARRANTY=XWARRANTY:*
COLS:XCAREINSTRUCTION=XCAREINSTRUCTION:*

END_SYMBOL_DEFINITIONS

BEGIN_ASSOCIATION_SQL_STATEMENT
name=MyCompanyWarrantygetCatalogEntryDetailsByParentCatalogGroupId
base_table=CATENTRY
additional_entity_objects=true
sql=
SELECT
CATENTRY.$COLS:CATENTRY$,
CATENTDESC.$COLS:CATENTDESC$,
XWARRANTY.$COLS:XWARRANTY$,
XCAREINSTRUCTION.$COLS:XCAREINSTRUCTION$
FROM
CATENTRY
LEFT OUTER JOIN XWARRANTY ON (CATENTRY.CATENTRY_ID = XWARRANTY.CATENTRY_ID)
LEFT OUTER JOIN CATENTDESC ON (CATENTDESC.CATENTRY_ID = CATENTRY.CATENTRY_ID AND CATENTDESC.LANGUAGE_ID in ($CONTROL:LANGUAGES$))
LEFT OUTER JOIN XCAREINSTRUCTION ON (CATENTRY.CATENTRY_ID = XCAREINSTRUCTION.CATENTRY_ID AND XCAREINSTRUCTION.LANGUAGE_ID in ($CONTROL:LANGUAGES$))
WHERE
CATENTRY.CATENTRY_ID IN ($ENTITY_PKS$) AND
CATENTRY.MARKFORDELETE = 0
END_ASSOCIATION_SQL_STATEMENT

<!-- ========================================================================= -->
<!-- =============================PROFILE DEFINITIONS========================= -->
<!-- ========================================================================= -->

BEGIN_PROFILE
name=MyCompany_All
extends = IBM_Admin_Details
BEGIN_ENTITY
associated_sql_statement=MyCompanyWarrantygetCatalogEntryDetailsByParentCatalogGroupId
END_ENTITY
END_PROFILE