package com.ibm.commerce.sample.mediation.util;

//$SkipWCCopr$

/*
 *-------------------------------------------------------------------
 * Licensed Materials - Property of IBM
 *
 * WebSphere Commerce
 *
 * (c) Copyright International Business Machines Corporation. 2009
 *     All rights reserved.
 *
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 *-------------------------------------------------------------------
 */

//*---------------------------------------------------------------------
//* The sample contained herein is provided to you "AS IS".
//*
//* It is furnished by IBM as a simple example and has not been
//* thoroughly tested
//* under all conditions.  IBM, therefore, cannot guarantee its
//* reliability, serviceability or functionality.
//*
//* This sample may include the names of individuals, companies, brands
//* and products in order to illustrate concepts as completely as
//* possible.  All of these names
//* are fictitious and any similarity to the names and addresses used by
//* actual persons
//* or business enterprises is entirely coincidental.
//*---------------------------------------------------------------------

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.apache.xpath.NodeSet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import com.ibm.commerce.copyright.IBMCopyright;
import com.ibm.commerce.foundation.client.util.oagis.RelationalExpression;
import com.ibm.commerce.foundation.server.services.dataaccess.SelectionCriteria;

/**
 * Utility methods that can be exposed to XSL transformations in mediation modules.
 */
public class MediationUtil {
	
	/**
	 * The IBM copyright notice field.
	 */
	public static final String COPYRIGHT = IBMCopyright.SHORT_COPYRIGHT;
	
	private static final Document DOCUMENT;
	
	static {
		try {
			DOCUMENT = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
		}
		catch(ParserConfigurationException e) {
			throw new RuntimeException(e);
		}
	}
	
	/**
	 * Constructs a selection criteria from an XPath.
	 * A selection criteria can be used to extract the XPath key, access profile,
	 * control parameter values and XPath parameter values from an XPath. 
	 * @param xpath the XPath.
	 * @return the selection criteria.
	 */
	public static SelectionCriteria selectionCriteria(String xpath) {
		return new SelectionCriteria(xpath, null);
	}
	
	/**
	 * Returns the XPath key of the XPath.
	 * @param selectionCriteria a selection criteria constructed from the XPath.
	 * @return XPath key of the XPath.
	 * @see #selectionCriteria(String)
	 */
	public static String xpathKey(SelectionCriteria selectionCriteria) {
		return selectionCriteria.getXPathKey();
	}
	
	/**
	 * Returns the access profile of the XPath.
	 * @param selectionCriteria a selection criteria constructed from the XPath.
	 * @return access profile of the XPath.
	 * @see #selectionCriteria(String)
	 */
	public static String accessProfile(SelectionCriteria selectionCriteria) {
		return selectionCriteria.getAccessProfile();
	}
	
	/**
	 * Returns the values of a control parameter in the XPath.
	 * @param selectionCriteria a selection criteria constructed from the XPath.
	 * @param parameterName name of the control parameter.
	 * @return values of the control parameter as a {@link NodeList}. Each value is
	 * represented by an {@link Element} in the node list, with its text node being the
	 * value.
	 * @see #selectionCriteria(String)
	 */
	public static NodeList controlParameterValues(SelectionCriteria selectionCriteria, String parameterName) {
		NodeSet nodeSet = new NodeSet();
		Map relationalExpressionMap = selectionCriteria.getControlParameters();
		if(relationalExpressionMap != null) {
			RelationalExpression relationalExpression = (RelationalExpression)relationalExpressionMap.get(parameterName);
			if(relationalExpression != null) {
				List parameterValueList = relationalExpression.getValues();
				if(parameterValueList != null) {
					Iterator parameterValueIterator = parameterValueList.iterator();
					while(parameterValueIterator.hasNext()) {
						Element element = DOCUMENT.createElement(relationalExpression.getName());
						element.appendChild(DOCUMENT.createTextNode((String)parameterValueIterator.next()));
						nodeSet.addNode(element);
					}
				}
			}
		}
		return nodeSet;
	}
	
	/**
	 * Returns the values of an XPath parameter in the XPath.
	 * @param selectionCriteria a selection criteria constructed from the XPath.
	 * @param parameterName name of the XPath parameter.
	 * @return values of the XPath parameter as a {@link NodeList}. Each value is
	 * represented by an {@link Element} in the node list, with its text node being the
	 * value.
	 * @see #selectionCriteria(String)
	 */
	public static NodeList xpathParameterValues(SelectionCriteria selectionCriteria, String parameterName) {
		NodeSet nodeSet = new NodeSet();
		Map relationalExpressionMap = selectionCriteria.getXPathParameters();
		if(relationalExpressionMap != null) {
			RelationalExpression relationalExpression = (RelationalExpression)relationalExpressionMap.get(parameterName);
			if(relationalExpression != null) {
				List parameterValueList = relationalExpression.getValues();
				if(parameterValueList != null) {
					Iterator parameterValueIterator = parameterValueList.iterator();
					while(parameterValueIterator.hasNext()) {
						Element element = DOCUMENT.createElement(relationalExpression.getName());
						element.appendChild(DOCUMENT.createTextNode((String)parameterValueIterator.next()));
						nodeSet.addNode(element);
					}
				}
			}
		}
		return nodeSet;
	}
	
	/**
	 * Parses an XML string into a {@link Node}.
	 * @param xml the XML string.
	 * @return the node.
	 */
	public static Node parse(String xml) {
		try {
			DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
			documentBuilderFactory.setNamespaceAware(true);
			DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
			Document document = documentBuilder.parse(new InputSource(new StringReader(xml)));
			return document.getFirstChild();
		}
		catch(ParserConfigurationException e) {
			throw new RuntimeException(e);
		}
		catch(IOException e) {
			throw new RuntimeException(e);
		}
		catch(SAXException e) {
			throw new RuntimeException(e);
		}
	}
	
	/**
	 * Serializes a {@link Node} into an XML string.
	 * @param node the node.
	 * @return the XML string.
	 */
	public static String serialize(Node node) {
		try {
			StringWriter stringWriter = new StringWriter();
			Transformer transformer = TransformerFactory.newInstance().newTransformer();
			transformer.setOutputProperty(OutputKeys.OMIT_XML_DECLARATION, "yes");
			Source source = new DOMSource(node);
			Result result = new StreamResult(stringWriter);
			transformer.transform(source, result);
			return stringWriter.toString();
		}
		catch(TransformerException e) {
			throw new RuntimeException(e);
		}
	}
	
}
