<?xml version="1.0" encoding="UTF-8"?>

<!--
-------------------------------------------------------------------
 Licensed Materials - Property of IBM

 WebSphere Commerce

 (c) Copyright International Business Machines Corporation. 2009
     All rights reserved.

 US Government Users Restricted Rights - Use, duplication or
 disclosure restricted by GSA ADP Schedule Contract with IBM Corp.

-------------------------------------------------------------------

---------------------------------------------------------------------
 The sample contained herein is provided to you "AS IS".

 It is furnished by IBM as a simple example and has not been
 thoroughly tested
 under all conditions.  IBM, therefore, cannot guarantee its
 reliability, serviceability or functionality.

 This sample may include the names of individuals, companies, brands
 and products in order to illustrate concepts as completely as
 possible.  All of these names
 are fictitious and any similarity to the names and addresses used by
 actual persons
 or business enterprises is entirely coincidental.
---------------------------------------------------------------------
-->

<xsl:stylesheet
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:xsd="http://www.w3.org/2001/XMLSchema"
		xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
		xmlns:xalan="http://xml.apache.org/xalan"
		xmlns:datetime="http://exslt.org/dates-and-times"
		xmlns:oa="http://www.openapplications.org/oagis/9"
		xmlns:udt="http://www.openapplications.org/oagis/9/unqualifieddatatypes/1.1"
		xmlns:_wcf="http://www.ibm.com/xmlns/prod/commerce/9/foundation"
		xmlns:_sto="http://www.ibm.com/xmlns/prod/commerce/9/store"
		xmlns:_inv="http://www.ibm.com/xmlns/prod/commerce/9/inventory"
		xmlns:_ord="http://www.ibm.com/xmlns/prod/commerce/9/order"
		xmlns:test="http://test" exclude-result-prefixes="xalan test"
		version="1.0">
	<xsl:output method="xml" encoding="UTF-8" indent="yes" xalan:indent-amount="2" />
	<xsl:strip-space elements="*" />
	<xsl:template name="BodyToBody">
		<xsl:param name="body" />
		<xsl:variable name="order" select="$body/test:updateInventoryReservationsResponse/updateInventoryReservationsReturn" />
		<_inv:AcknowledgeInventoryRequirement>
			<oa:ApplicationArea>
				<oa:CreationDateTime xsi:type="udt:DateTimeType"><xsl:value-of select="datetime:dateTime()" /></oa:CreationDateTime>
			</oa:ApplicationArea>
			<_inv:DataArea>
				<oa:Acknowledge />
				<_inv:InventoryRequirement>
					<_ord:OrderIdentifier>
						<_wcf:UniqueID><xsl:value-of select="$order/orderId" /></_wcf:UniqueID>
					</_ord:OrderIdentifier>
					<xsl:for-each select="$order/orderItems/OrderItem">
						<_ord:OrderItem>
							<_ord:OrderItemIdentifier>
								<_wcf:UniqueID><xsl:value-of select="orderItemId" /></_wcf:UniqueID>
							</_ord:OrderItemIdentifier>
							<_ord:OrderItemStatus>
								<_ord:Status><xsl:value-of select="status" /></_ord:Status>
								<xsl:choose>
									<xsl:when test="inventoryStatus='A'">
										<_ord:InventoryStatus>Allocated</_ord:InventoryStatus>
									</xsl:when>
									<xsl:when test="inventoryStatus='B'">
										<_ord:InventoryStatus>Backordered</_ord:InventoryStatus>
									</xsl:when>
									<xsl:otherwise>
										<_ord:InventoryStatus>Unallocated</_ord:InventoryStatus>
									</xsl:otherwise>
								</xsl:choose>
							</_ord:OrderItemStatus>
							<_ord:OrderItemFulfillmentInfo>
								<xsl:if test="availableDate[not(@xsi:nil='true')]">
									<_ord:AvailableDate><xsl:value-of select="availableDate" /></_ord:AvailableDate>
								</xsl:if>
								<xsl:if test="shipDate[not(@xsi:nil='true')]">
									<_ord:ExpectedShipDate><xsl:value-of select="shipDate" /></_ord:ExpectedShipDate>
								</xsl:if>
							</_ord:OrderItemFulfillmentInfo>
							<xsl:if test="fulfillmentCenterId[not(@xsi:nil='true')]">
								<_ord:FulfillmentCenter>
									<_ord:FulfillmentCenterIdentifier>
										<_wcf:UniqueID><xsl:value-of select="attribute/Attribute[name='wcFulfillmentCenterId']/value" /></_wcf:UniqueID>
										<_wcf:Name><xsl:value-of select="fulfillmentCenterId" /></_wcf:Name>
									</_ord:FulfillmentCenterIdentifier>
								</_ord:FulfillmentCenter>
							</xsl:if>
						</_ord:OrderItem>
					</xsl:for-each>
				</_inv:InventoryRequirement>
			</_inv:DataArea>
		</_inv:AcknowledgeInventoryRequirement>
	</xsl:template>
</xsl:stylesheet>
