<?xml version="1.0" encoding="UTF-8"?>

<!--
-------------------------------------------------------------------
 Licensed Materials - Property of IBM

 WebSphere Commerce

 (c) Copyright International Business Machines Corporation. 2009
     All rights reserved.

 US Government Users Restricted Rights - Use, duplication or
 disclosure restricted by GSA ADP Schedule Contract with IBM Corp.

-------------------------------------------------------------------

---------------------------------------------------------------------
 The sample contained herein is provided to you "AS IS".

 It is furnished by IBM as a simple example and has not been
 thoroughly tested
 under all conditions.  IBM, therefore, cannot guarantee its
 reliability, serviceability or functionality.

 This sample may include the names of individuals, companies, brands
 and products in order to illustrate concepts as completely as
 possible.  All of these names
 are fictitious and any similarity to the names and addresses used by
 actual persons
 or business enterprises is entirely coincidental.
---------------------------------------------------------------------
-->

<xsl:stylesheet
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:xsd="http://www.w3.org/2001/XMLSchema"
		xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
		xmlns:xalan="http://xml.apache.org/xalan"
		xmlns:datetime="http://exslt.org/dates-and-times"
		xmlns:mediationUtil="com.ibm.commerce.sample.mediation.util.MediationUtil"
		xmlns:oa="http://www.openapplications.org/oagis/9"
		xmlns:udt="http://www.openapplications.org/oagis/9/unqualifieddatatypes/1.1"
		xmlns:_wcf="http://www.ibm.com/xmlns/prod/commerce/9/foundation"
		xmlns:_sto="http://www.ibm.com/xmlns/prod/commerce/9/store"
		xmlns:_inv="http://www.ibm.com/xmlns/prod/commerce/9/inventory"
		xmlns:_ord="http://www.ibm.com/xmlns/prod/commerce/9/order"
		xmlns:test="http://test" exclude-result-prefixes="xalan test"
		version="1.0">
	<xsl:output method="xml" encoding="UTF-8" indent="yes" xalan:indent-amount="2" />
	<xsl:strip-space elements="*" />
	<xsl:template name="BodyToBody">
		<xsl:param name="body" />
		<_inv:ShowInventoryAvailability>
			<oa:ApplicationArea>
				<oa:CreationDateTime xsi:type="udt:DateTimeType"><xsl:value-of select="datetime:dateTime()" /></oa:CreationDateTime>
			</oa:ApplicationArea>
			<_inv:DataArea>
				<xsl:for-each select="$body/test:getInventoryResponse/getInventoryReturn/Inventory">
					<_inv:InventoryAvailability>
						<_inv:InventoryAvailabilityIdentifier>
							<_inv:ExternalIdentifier>
								<_inv:CatalogEntryIdentifier>
									<_wcf:ExternalIdentifier>
										<_wcf:PartNumber><xsl:value-of select="sku" /></_wcf:PartNumber>
									</_wcf:ExternalIdentifier>
								</_inv:CatalogEntryIdentifier>
								<xsl:choose>
									<xsl:when test="substring-before(fulfillmentCenterId, ' Home') and not(substring-after(fulfillmentCenterId, ' Home'))">
										<_inv:OnlineStoreIdentifier>
											<_wcf:ExternalIdentifier>
												<_wcf:NameIdentifier><xsl:value-of select="substring-before(fulfillmentCenterId, ' Home')" /></_wcf:NameIdentifier>
											</_wcf:ExternalIdentifier>
										</_inv:OnlineStoreIdentifier>
									</xsl:when>
									<xsl:otherwise>
										<_inv:PhysicalStoreIdentifier>
											<_wcf:ExternalIdentifier><xsl:value-of select="fulfillmentCenterId" /></_wcf:ExternalIdentifier>
										</_inv:PhysicalStoreIdentifier>
									</xsl:otherwise>
								</xsl:choose>
							</_inv:ExternalIdentifier>
						</_inv:InventoryAvailabilityIdentifier>
						<xsl:choose>
							<xsl:when test="quantityOnHand/value&gt;0">
								<_inv:InventoryStatus>Available</_inv:InventoryStatus>
							</xsl:when>
							<xsl:when test="count(expectedInventory/ExpectedInventory)&gt;0">
								<_inv:InventoryStatus>Backorderable</_inv:InventoryStatus>
							</xsl:when>
							<xsl:otherwise>
								<_inv:InventoryStatus>Unavailable</_inv:InventoryStatus>
							</xsl:otherwise>
						</xsl:choose>
						<_inv:AvailableQuantity>
							<xsl:attribute name="uom"><xsl:value-of select="quantityOnHand/uom" /></xsl:attribute>
							<xsl:value-of select="quantityOnHand/value" />
						</_inv:AvailableQuantity>
						<xsl:if test="quantityOnHand/value=0 and count(expectedInventory/ExpectedInventory)&gt;0">
							<_inv:AvailabilityDateTime><xsl:value-of select="expectedInventory/ExpectedInventory[1]/availableDate" /></_inv:AvailabilityDateTime>
						</xsl:if>
					</_inv:InventoryAvailability>
				</xsl:for-each>
			</_inv:DataArea>
		</_inv:ShowInventoryAvailability>
	</xsl:template>
</xsl:stylesheet>
